(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    395451,      16220]*)
(*NotebookOutlinePosition[    396536,      16255]*)
(*  CellTagsIndexPosition[    396492,      16251]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Quantum Mechanical Interference in a Simple Quantum \
Computation\
\>", "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Colin P. Williams ", "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  Editable->False,
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Copyright Notice", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with \"Explorations in \
Quantum Computing\" by Colin P. Williams and Scott H. Clearwater, TELOS, \
Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to \
copy and distribute this Notebook freely for any non-commercial activity \
provided you include this copyright notice at the beginning of all such \
copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on \"Explorations in Quantum Computing\" check out the TELOS \
web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To \
order call 1-800-777-4643.

All other rights reserved.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to use this Notebook", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This Notebook contains code for analyzing the effects of quantum \
mechanical interference on the outcome of a quantum computation (see \
\"Explorations in Quantum Computing\", Chapter 3).  The computation in \
question is the generation of a random bit using first a classical method and \
then a quantum method. The code allows you to calculate, and compare, the \
overall probability of obtaining the answer \"0\" using each method. In \
general, you will find that the quantum probability can be the same as, \
greater than or less than the classical probability of returning the answer \
\"0\".

You are encouraged to work through the Notebook, executing commands labelled \
as \"Try me!\" as you go.  To execute a such a command, position your cursor \
over the cell containing the command, click the mouse to select the cell and \
type the SHIFT and RETURN keys simultaneously.

The following functions are available:\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Pclassical\t\t(* probability of classical method returning a 0   *)
Pquantum\t\t(* probability of quantum method returning a 0     *)
ComparisonPlot  (* plot of Pclassical and Pquantum versus phi      *)
PhaseDiagram\t(* plot of co-variation of Pclassical and Pquantum *)\
\>", 
  "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell["\<\
To learn how to use any of these commands enter ?Pclassical, \
?Pquantum etc.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to Generate a Bit?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
We begin by introducing the computation that we want to analyze. \
Let us suppose that we want our computer to pick a random bit i.e. to pick \
either a 0 or a 1. This is equivalent of course to all sorts of other binary \
selection problems.  We will do this as a two stage process: first we will \
pick the method (Method A or Method B) that will be used to generate the bit \
and then we will run the method we selected and record the result.  Let us \
say that we pick Method A with probability p and we pick Method B with \
probability (1-p).  Then, if we run Method A, let us assume that a \"0\" bit \
is returned with probability p0A, and a \"1\" is returned with probability \
p1A = 1-p0A. Likewise, if we run Method B,  let us assume that a \"0\" bit is \
returned with probability p0B, and a \"1\" is returned with probability p1B = \
1-p0B.

What is the classical probability of this scheme returning a \"0\"? The \
answer is simply\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["p p0A + (1 - p) p0B", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
because we first pick Method A with probability p and then obtain a \
\"0\" with probability p0A else we pick Method B with probability (1-p) and \
then obtain a \"0\" with probability p0B.

Now quantum mechanically, things are a little different. To pick the method \
to be used we can imagine creating the state |psi> defined as\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["|psi> = Sqrt[p] ket[0] + Sqrt[1-p] ket[1]", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
If we measure |psi> in the 0/1 basis, we obtain a \"0\" with \
probability p and a \"1\" with probability 1-p because, quantum mechanically, \
the probabilities are given by the square of the absolute values of the \
(normalized) amplitudes).  We can use a measurement of the state |psi> to \
mimic the selection of Method A or Method B as follows:   if we measure |psi> \
and obtain a \"0\" we will say we picked Method A and if we measure |psi> and \
obtain \"1\" we will say we picked Method B. Notice, that so far we have \
simply made a quantum analog of the first part of the classical algorithm and \
the qunatum and classical probabilities of picking Method A or Method B \
agree.

As probabilities are always real numbers between 0 and 1,  we can also \
introduce a new variable, phi, which you can think of as angle, defined so \
that p = Cos[phi]^2. Thus for any value of the probability p, there are \
corresponding values of phi, all of which give the same value of Cos[phi]^2.  \
Using phi, the state |psi> can be rewritten as:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["|psi> = Cos[phi] ket[0] + Sin[phi] ket[1].", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Here is a plot showing how p and phi are related.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Plot[ProbabilityToAngle[p], {p, 0, 1},
     Frame->True,
     GridLines->Automatic,
     FrameLabel->{\"p\", \"phi\"}];\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.374766 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -9 -9 ]
[.21429 -0.0125 9 0 ]
[.40476 -0.0125 -9 -9 ]
[.40476 -0.0125 9 0 ]
[.59524 -0.0125 -9 -9 ]
[.59524 -0.0125 9 0 ]
[.78571 -0.0125 -9 -9 ]
[.78571 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -5 -21 ]
[.5 -0.0125 5 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .10841 -24 -4.5 ]
[-0.0125 .10841 0 4.5 ]
[-0.0125 .2021 -18 -4.5 ]
[-0.0125 .2021 0 4.5 ]
[-0.0125 .29579 -24 -4.5 ]
[-0.0125 .29579 0 4.5 ]
[-0.0125 .38948 -6 -4.5 ]
[-0.0125 .38948 0 4.5 ]
[-0.0125 .48317 -24 -4.5 ]
[-0.0125 .48317 0 4.5 ]
[-0.0125 .57686 -18 -4.5 ]
[-0.0125 .57686 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -36 -11 ]
[-0.01875 .30902 -24 11 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .61803 L
s
.40476 0 m
.40476 .61803 L
s
.59524 0 m
.59524 .61803 L
s
.78571 0 m
.78571 .61803 L
s
0 .10841 m
1 .10841 L
s
0 .2021 m
1 .2021 L
s
0 .29579 m
1 .29579 L
s
0 .38948 m
1 .38948 L
s
0 .48317 m
1 .48317 L
s
0 .57686 m
1 .57686 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0.2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(0.4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(0.6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(0.8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -66 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .10841 m
.00625 .10841 L
s
[(0.25)] -0.0125 .10841 1 0 Mshowa
0 .2021 m
.00625 .2021 L
s
[(0.5)] -0.0125 .2021 1 0 Mshowa
0 .29579 m
.00625 .29579 L
s
[(0.75)] -0.0125 .29579 1 0 Mshowa
0 .38948 m
.00625 .38948 L
s
[(1)] -0.0125 .38948 1 0 Mshowa
0 .48317 m
.00625 .48317 L
s
[(1.25)] -0.0125 .48317 1 0 Mshowa
0 .57686 m
.00625 .57686 L
s
[(1.5)] -0.0125 .57686 1 0 Mshowa
.125 Mabswid
0 .03345 m
.00375 .03345 L
s
0 .05219 m
.00375 .05219 L
s
0 .07093 m
.00375 .07093 L
s
0 .08967 m
.00375 .08967 L
s
0 .12714 m
.00375 .12714 L
s
0 .14588 m
.00375 .14588 L
s
0 .16462 m
.00375 .16462 L
s
0 .18336 m
.00375 .18336 L
s
0 .22084 m
.00375 .22084 L
s
0 .23957 m
.00375 .23957 L
s
0 .25831 m
.00375 .25831 L
s
0 .27705 m
.00375 .27705 L
s
0 .31453 m
.00375 .31453 L
s
0 .33327 m
.00375 .33327 L
s
0 .352 m
.00375 .352 L
s
0 .37074 m
.00375 .37074 L
s
0 .40822 m
.00375 .40822 L
s
0 .42696 m
.00375 .42696 L
s
0 .4457 m
.00375 .4457 L
s
0 .46443 m
.00375 .46443 L
s
0 .50191 m
.00375 .50191 L
s
0 .52065 m
.00375 .52065 L
s
0 .53939 m
.00375 .53939 L
s
0 .55813 m
.00375 .55813 L
s
0 .5956 m
.00375 .5956 L
s
0 .61434 m
.00375 .61434 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -102 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
72 10 translate
90 rotate
-72 -10 translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(phi) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .10841 m
1 .10841 L
s
.99375 .2021 m
1 .2021 L
s
.99375 .29579 m
1 .29579 L
s
.99375 .38948 m
1 .38948 L
s
.99375 .48317 m
1 .48317 L
s
.99375 .57686 m
1 .57686 L
s
.125 Mabswid
.99625 .03345 m
1 .03345 L
s
.99625 .05219 m
1 .05219 L
s
.99625 .07093 m
1 .07093 L
s
.99625 .08967 m
1 .08967 L
s
.99625 .12714 m
1 .12714 L
s
.99625 .14588 m
1 .14588 L
s
.99625 .16462 m
1 .16462 L
s
.99625 .18336 m
1 .18336 L
s
.99625 .22084 m
1 .22084 L
s
.99625 .23957 m
1 .23957 L
s
.99625 .25831 m
1 .25831 L
s
.99625 .27705 m
1 .27705 L
s
.99625 .31453 m
1 .31453 L
s
.99625 .33327 m
1 .33327 L
s
.99625 .352 m
1 .352 L
s
.99625 .37074 m
1 .37074 L
s
.99625 .40822 m
1 .40822 L
s
.99625 .42696 m
1 .42696 L
s
.99625 .4457 m
1 .4457 L
s
.99625 .46443 m
1 .46443 L
s
.99625 .50191 m
1 .50191 L
s
.99625 .52065 m
1 .52065 L
s
.99625 .53939 m
1 .53939 L
s
.99625 .55813 m
1 .55813 L
s
.99625 .5956 m
1 .5956 L
s
.99625 .61434 m
1 .61434 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .59023 L
.02605 .58519 L
.02846 .5772 L
.03279 .56696 L
.04262 .55056 L
.05281 .53766 L
.06244 .52739 L
.10458 .49265 L
.14299 .46789 L
.18386 .4451 L
.22321 .42528 L
.26105 .40756 L
.30133 .3897 L
.34011 .37322 L
.38133 .35625 L
.42104 .34027 L
.45923 .32512 L
.49988 .3091 L
.53901 .29369 L
.58059 .27719 L
.62066 .26105 L
.65921 .24518 L
.70021 .22774 L
.7397 .21021 L
.77767 .1924 L
.81809 .17198 L
.857 .15023 L
.89836 .12336 L
.91906 .10745 L
.93821 .09006 L
.95662 .06862 L
.96592 .05369 L
.96847 .0485 L
.97122 .04181 L
.97248 .03811 L
.97381 .03345 L
.97495 .02825 L
.97619 .01479 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00RWoo1000Igoo002;Ool00`00Oomoo`1WOol008]oo`@006Ioo`00Rgoo00D007ooOomoo`0006Eo
o`00Rgoo00D007ooOomoo`0006Eoo`00Rgoo00D007ooOomoo`0006Eoo`00RWoo1@00IWoo003eOol0
0?Eoo`00mGoo003eOol00?Eoo`00:goo0P007goo0P0017oo0P000goo100067oo0P0017oo0P0017oo
0`0067oo0P0017oo0P0017oo0P006Goo0P0017oo0P0017oo0P007Woo0`001Goo000ZOol01000Oomo
o`007Goo00@007ooOol000=oo`8000Aoo`03001oogoo01Moo`04001oogoo0003Ool20005Ool00`00
Oomoo`0FOol01000Oomoo`000goo0P000goo00@007ooOol001Moo`04001oogoo0003Ool20003Ool0
1000Oomoo`007Woo00<007ooOol017oo000ZOol01000Oomoo`007Goo00@007ooOol000Yoo`03001o
ogoo01Ioo`04001oogoo0008Ool4000GOol01000Oomoo`0027oo00@007ooOol001Moo`04001oogoo
0008Ool01000Oomoo`007Woo00<007ooOol017oo000ZOol01000Oomoo`007Goo00@007ooOol000]o
o`03001oogoo01Eoo`04001oogoo0008Ool00`00Ool0000HOol01000Oomoo`0027oo0`0067oo00@0
07ooOol000Uoo`8001moo`03001oogoo00Aoo`00:Woo00@007ooOol001eoo`04001oogoo0008Ool0
1000Oomoo`005goo00@007ooOol000Qoo`03001oo`0001Qoo`04001oogoo0008Ool00`00Oomoo`0H
Ool01000Oomoo`0027oo00@007ooOol001ioo`03001oogoo00Aoo`00:goo0P007goo0P002Woo0P00
6Goo0P002Woo0P006Goo0P002Woo0`0067oo0P002Woo0P007Woo0P001Woo003eOol00?Eoo`00mGoo
000WOoo=0001Ool0025oo`8000Aoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`05001oogooOol00001Ool0021oo`04001o
ogoo0003Ool00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
Oomoo`0XOol10001Ool0021oo`04001oogoo0003Ool3000YOol00`0?Oomoo`0TOol00`0?Oomoo`0T
Ool00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`00Oomoo`020001Ool0021oo`04001oogoo0003Ool0
0`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol0
1@00Oomoogoo00000Goo000POol01000Oomoo`000goo00<007ooOol0:Goo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol097oo00<03gooOol08goo00<007ooOol00Woo0@000Goo000QOol20004
Ool00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0S
Ool00`00Oomoo`02Ool10001Ool002Moo`8002Yoo`0300moogoo02Aoo`0300moogoo02Aoo`0300mo
ogoo02Aoo`0300moogoo02=oo`03001oogoo009oo`40005oo`009goo00<007ooOol0:Goo00<03goo
Ool097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol08goo00<007ooOol00Woo0@000Goo
000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomo
o`0SOol00`00Oomoo`02Ool10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo
02Aoo`0300moogoo02Aoo`0300moogoo029oo`03001oogoo00=oo`40005oo`009goo0P00:Woo00<0
3gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol08Goo00<007ooOol017oo0@00
0Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
Oomoo`0QOol00`00Oomoo`04Ool10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Aoo`0300mo
ogoo02Aoo`0300moogoo02Aoo`0300moogoo021oo`03001oogoo00Eoo`40005oo`009goo00<007oo
Ool0:Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol087oo00<007oo
Ool01Goo0@000Goo000WOol2000ZOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol0
0`0?Oomoo`0POol00`00Oomoo`05Ool10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Aoo`03
00moogoo02Aoo`0300moogoo02Aoo`0300moogoo01moo`03001oogoo00Ioo`40005oo`009goo00<0
07ooOol0:Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol07Woo00<0
07ooOol01goo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
Oomoo`0TOol00`0?Oomoo`0MOol00`00Oomoo`08Ool10001Ool002Moo`8002Yoo`0300moogoo02Ao
o`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo01]oo`8000]oo`40005oo`003goo0P0017oo
0P000goo10000Woo0`0017oo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol097oo00<03goo
Ool097oo00<03gooOol06Woo00<007ooOol02goo0@000Goo000>Ool01000Oomoo`000goo0P0017oo
00<007ooOol01Goo00D007ooOomoo`0002]oo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo
02Aoo`0300moogoo01Uoo`03001oogoo00aoo`40005oo`003Woo00@007ooOol000Yoo`03001oogoo
00Aoo`04001oogooOol3002h00l2000>00l20001Ool000ioo`04001oogoo000;Ool00`00Oomoo`03
0004Ool00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomo
o`0FOol00`00Oomoo`0?Ool10001Ool000ioo`04001oogoo0008Ool01000Oomoo`000Woo00<007oo
Ool017oo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03goo
Ool05Goo00<007ooOol047oo0@000Goo000?Ool2000:Ool20003Ool40003Ool00`00Oomoo`0YOol0
0`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0COol2000COol10001Ool0
02Moo`8002Yoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo019oo`03
001oogoo01=oo`40005oo`009goo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol047oo0P005Woo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0T
Ool00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0?Ool00`00Oomoo`0FOol10001Ool002Mo
o`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo00eo
o`8001Uoo`40005oo`009goo0P00:Woo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo
00<03gooOol037oo00<007ooOol06Goo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol0
0`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0:Ool2000LOol10001Ool002Moo`03001oogoo
02Uoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo00Qoo`8001ioo`40
005oo`009goo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<0
3gooOol01Woo0P0087oo0@000Goo000WOol2000ZOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
Oomoo`0TOol00`0?Oomoo`04Ool2000ROol10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Ao
o`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo009oo`8002Aoo`40005oo`009goo00<007oo
Ool0:Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol00P009Woo0@00
0Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
0000000XOol10001Ool002Moo`8002Yoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02=o
o`8002Yoo`40005oo`005Goo0P0017oo0P000goo0`0017oo00<007ooOol0:Goo00<03gooOol097oo
00<03gooOol097oo00<03gooOol08Goo0P0000=oo`0?Ool0:Goo0@000Goo000DOol01000Oomoo`00
0goo0P001Woo00D007ooOomoo`0002]oo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo01mo
o`8000=oo`0300moogoo02Qoo`40005oo`0057oo00@007ooOol000]oo`04001oogooOol3002G00l2
000_00l20001Ool001Aoo`04001oogoo0008Ool30004Ool00`00Oomoo`0YOol00`0?Oomoo`0TOol0
0`0?Oomoo`0TOol00`0?Oomoo`0KOol20007Ool00`0?Oomoo`0XOol10001Ool001Aoo`04001oogoo
0008Ool00`00Oomoo`04Ool00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomo
o`0IOol20009Ool00`0?Oomoo`0XOol10001Ool001Eoo`8000Uoo`@000=oo`03001oogoo02Uoo`03
00moogoo02Aoo`0300moogoo02Aoo`0300moogoo01Moo`8000]oo`0300moogoo02Qoo`40005oo`00
9goo0P00:Woo00<03gooOol097oo00<03gooOol097oo00<03gooOol05Goo0P003Goo00<03gooOol0
:7oo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0C
Ool2000?Ool00`0?Oomoo`0XOol10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Aoo`0300mo
ogoo02Aoo`0300moogoo015oo`80015oo`0300moogoo02Qoo`40005oo`009goo00<007ooOol0:Goo
00<03gooOol097oo00<03gooOol097oo00<03gooOol03Woo0`004goo00<03gooOol0:7oo0@000Goo
000WOol2000ZOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0;Ool3000FOol00`0?Oomo
o`0XOol10001Ool002Moo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo
00Uoo`8001Uoo`0300moogoo02Qoo`40005oo`009goo00<007ooOol0:Goo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol01Woo0`006goo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0Y
Ool00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`03Ool3000NOol00`0?Oomoo`0XOol10001
Ool000Uoo`@001Yoo`8002Yoo`0300moogoo02Aoo`0300moogoo02Aoo`0400moogooOol2000QOol0
0`0?Oomoo`0XOol10001Ool000Yoo`03001oogoo01Yoo`03001oogoo02Uoo`0300moogoo02Aoo`03
00moogoo02Aoo`0400moo`00000SOol00`0?Oomoo`0XOol10001Ool000Yoo`@001Uoo`03001oogoo
02Uoo`0300moogoo02Aoo`0300moogoo02Aoo`8002Eoo`0300moogoo02Qoo`40005oo`002Woo00D0
07ooOomoo`0001Qoo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo029oo`80000300moogoo
02Aoo`0300moogoo02Qoo`40005oo`002Woo00D007ooOomoo`0001Qoo`8002Yoo`0300moogoo02Ao
o`0300moogoo021oo`80009oo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`002Woo00D007oo
Oomoo`0001Qoo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo01eoo`<000Aoo`0300moogoo
02Aoo`0300moogoo02Qoo`40005oo`002Goo1@0000=oo`00000017oo0P0017oo00<007ooOol00Woo
0`0017oo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol06Woo0`001goo00<03gooOol097oo
00<03gooOol0:7oo0@000Goo000>Ool01000Oomoo`000goo0P0017oo00<007ooOol01Goo00D007oo
Oomoo`0002]oo`0300moogoo02Aoo`0300moogoo01Moo`<000Yoo`0300moogoo02Aoo`0300moogoo
02Qoo`40005oo`002Woo0P0000=oo`0000000Woo00<007ooOol027oo00<007ooOol017oo00@007oo
Oomoo`<006L03`<005h03`80005oo`002Woo00<007ooOol00P000Woo00<007ooOol027oo00@007oo
Oomoo`<000Aoo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo015oo`<0011oo`0300moogoo
02Aoo`0300moogoo02Qoo`40005oo`002Woo00<007ooOol00P000Woo00<007ooOol02Goo00@007oo
Ool000Ioo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo00moo`8001=oo`0300moogoo02Ao
o`0300moogoo02Qoo`40005oo`002Woo00D007ooOol007oo008000Uoo`@0009oo`@000=oo`8002Yo
o`0300moogoo02Aoo`0300moogoo00eoo`8001Eoo`0300moogoo02Aoo`0300moogoo02Qoo`40005o
o`002Woo10006Goo00<007ooOol0:Goo00<03gooOol097oo00<03gooOol02goo0P005goo00<03goo
Ool097oo00<03gooOol0:7oo0@000Goo000:Ool00`00Oomoo`0JOol00`00Oomoo`0YOol00`0?Oomo
o`0TOol00`0?Oomoo`09Ool2000IOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool000Uoo`H0
01Qoo`03001oogoo02Uoo`0300moogoo02Aoo`0300moogoo00Moo`8001]oo`0300moogoo02Aoo`03
00moogoo02Qoo`40005oo`0037oo00<007ooOol067oo0P00:Woo00<03gooOol097oo00<03gooOol0
17oo0`007Goo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000<Ool00`00Oomoo`0HOol00`00
Oomoo`0YOol00`0?Oomoo`0TOol0100?Oomoogoo0`0087oo00<03gooOol097oo00<03gooOol0:7oo
0@000Goo000<Ool00`00Oomoo`0HOol00`00Oomoo`0YOol00`0?Oomoo`0TOol0100?Ool000008goo
00<03gooOol097oo00<03gooOol0:7oo0@000Goo000;Ool2000JOol00`00Oomoo`0YOol00`0?Oomo
o`0SOol3000UOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`8002Yoo`0300moogoo
021oo`<00003Ool03goo02Eoo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`0037oo00<007oo
Ool067oo00<007ooOol0:Goo00<03gooOol07Woo0P0017oo00<03gooOol097oo00<03gooOol097oo
00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0KOol30006Ool00`0?Oomo
o`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`03001oogoo02Uoo`0300moogoo
01Qoo`<000Uoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`009goo0P00
:Woo00<03gooOol05Woo0P0037oo00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@00
0Goo000WOol00`00Oomoo`0YOol00`0?Oomoo`0DOol2000>Ool00`0?Oomoo`0TOol00`0?Oomoo`0T
Ool00`0?Oomoo`0XOol10001Ool0021oo`<000Aoo`03001oogoo02Uoo`0300moogoo019oo`80011o
o`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`008Goo00<007ooOol00goo
00<007ooOol0:Goo00<03gooOol047oo0P004Woo00<03gooOol097oo00<03gooOol097oo00<03goo
Ool0:7oo0@000Goo000QOol00`00Oomoo`03Ool3000j00l2002<00l20001Ool0025oo`03001oogoo
00=oo`03001oogoo02Uoo`0300moogoo00]oo`<001Ioo`0300moogoo02Aoo`0300moogoo02Aoo`03
00moogoo02Qoo`40005oo`008Goo00<007ooOol00goo00<007ooOol0:Goo00<03gooOol027oo0`00
6Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000POol20005Ool00`00
Oomoo`0YOol00`0?Oomoo`06Ool2000LOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0X
Ool10001Ool002Moo`8002Yoo`0300moogoo00Aoo`8001ioo`0300moogoo02Aoo`0300moogoo02Ao
o`0300moogoo02Qoo`40005oo`009goo00<007ooOol0:Goo00<03gooOol00Woo0P0087oo00<03goo
Ool097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0YOol00`0?Oomo
o`02000ROol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`8002Yo
o`0300l0000002Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`009goo
00<007ooOol0:7oo0P009Woo00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo
000WOol00`00Oomoo`0VOol200000goo00moo`0UOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?
Oomoo`0XOol10001Ool002Moo`03001oogoo02Aoo`8000=oo`0300moogoo02Aoo`0300moogoo02Ao
o`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`009goo0P008goo0P001Goo00<03gooOol097oo
00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0QOol0
0`00Oomoo`05Ool00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol1
0001Ool002Moo`03001oogoo01moo`8000Qoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo
02Aoo`0300moogoo02Qoo`40005oo`009goo00<007ooOol07Goo0P002Woo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol2000MOol00`00Oomoo`0:
Ool00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Mo
o`03001oogoo01Yoo`8000eoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300mo
ogoo02Qoo`40005oo`003Woo0`0017oo0P000goo10000Woo0`0017oo00<007ooOol06Goo00<007oo
Ool03Goo00<03gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo
000?Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`05Ool01@00Oomoogoo00006Goo0P0047oo00<0
3gooOol097oo00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000?Ool00`00
Oomoo`0:Ool00`00Oomoo`04Ool01000Oomoogoo0`005@0?0P00/@0?0P000Goo000?Ool00`00Oomo
o`0;Ool00`00Oomoo`030004Ool00`00Oomoo`0DOol00`00Oomoo`0BOol00`0?Oomoo`0TOol00`0?
Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool000moo`03001oogoo00Qoo`04001o
ogoo0002Ool00`00Oomoo`04Ool00`00Oomoo`0BOol2000EOol00`0?Oomoo`0TOol00`0?Oomoo`0T
Ool00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool000ioo`8000]oo`8000=oo`@000=oo`03001o
ogoo015oo`03001oogoo01Eoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300mo
ogoo02Qoo`40005oo`009goo0P004Goo00<007ooOol05Woo00<03gooOol097oo00<03gooOol097oo
00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0>Ool2000IOol00`0?Oomo
o`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`03001oogoo
00eoo`03001oogoo01Uoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo
02Qoo`40005oo`009goo0P003Goo00<007ooOol06Woo00<03gooOol097oo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0;Ool00`00Oomoo`0KOol00`0?
Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`03001o
ogoo00Yoo`03001oogoo01aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300mo
ogoo02Qoo`40005oo`009goo00<007ooOol02Goo00<007ooOol07Goo00<03gooOol097oo00<03goo
Ool097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol20009Ool00`00Oomoo`0NOol0
0`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`03
001oogoo00Qoo`03001oogoo01ioo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`03
00moogoo02Qoo`40005oo`009goo00<007ooOol01goo00<007ooOol07goo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`06Ool00`00
Oomoo`0POol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001
Ool002Moo`8000Moo`03001oogoo021oo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Ao
o`0300moogoo02Qoo`40005oo`009goo00<007ooOol01Goo00<007ooOol08Goo00<03gooOol097oo
00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000DOol30004Ool20003Ool3
0004Ool00`00Oomoo`04Ool00`00Oomoo`0ROol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomo
o`0TOol00`0?Oomoo`0XOol10001Ool001Eoo`03001oogoo00=oo`8000Ioo`05001oogooOol00006
Ool00`00Oomoo`0ROol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0X
Ool10001Ool001Eoo`03001oogoo00]oo`04001oogooOol3000300l00`0000l03`3200l20001Ool0
01Eoo`03001oogoo00Qoo`<000Aoo`03001oogoo00=oo`03001oogoo02=oo`0300moogoo02Aoo`03
00moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Qoo`40005oo`005Goo00<007ooOol027oo00<0
07ooOol017oo00<007ooOol00goo00<007ooOol08goo00<03gooOol097oo00<03gooOol097oo00<0
3gooOol097oo00<03gooOol0:7oo0@000Goo000DOol2000:Ool40003Ool00`00Oomoo`02Ool00`00
Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001
Ool002Moo`8000=oo`03001oogoo02Aoo`0300moogoo02Aoo`0300moogoo02Aoo`0300moogoo02Ao
o`0300moogoo02Qoo`40005oo`009goo00<007ooOol00Woo00<007ooOol097oo00<03gooOol097oo
00<03gooOol097oo00<03gooOol097oo00<03gooOol0:7oo0@000Goo000WOol00`00Oomoo`0YOol0
0`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0TOol00`0?Oomoo`0XOol10001Ool002Moo`03
001oogoo009oo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03
001oogoo02Aoo`05001oogooOol00001Ool002Moold0005oo`00\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-0.229944, -0.349474, 
  0.00514587, 0.013077}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Next we create states |A> and |B> that can mimic the second stage \
of the bit generation algorithm. Suppose we define:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
|A> = Sqrt[p0A] ket[0] + Sqrt[1-p0A] ket[1]
    = w0A ket[0] + w1A ket[1]\
\>", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
|B> = -Sqrt[p0B] ket[0] + Sqrt[1-p0B] ket[1]
    = w0B ket[0] + w1B ket[1]\
\>", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
Again, if we measure state |A> we obtain a \"0\" with probability \
p0A, if we measure |B> we obtain a 0 with probability p0B. The minus sign \
introduced in |B> has no ill-effect on the probability because we square the \
absolute value of the amplitude to get the probability, plus or minus \
Sqrt[p0B] is equally acceptable.  So if you look at |B> in isolation, it too \
gives the same probability of returning a \"0\" as does the classical Method \
B. However,  quantum mechanically, you cannot really treat |A> and |B> in \
isolation. A quantum computer pursues BOTH computational paths simultaneously \
and THEN determines the final outcome from the interference between ALL these \
paths.  Thus, in the quantum mechanical scheme for picking a bit the minus \
sign will turn out to be important when we consider the interaction between \
the state |B> and the state |A>, because you always ADD amplitudes before \
calculating probabilities.

To combine both parts of the quantum  selection algorithm, the selection of \
Method A or Method B and the ensuing measurement of states |A> or |B>, we do \
the following. First add the amplitudes of all pathways leading to the \"0\" \
outcome and then compute probabilities, from the square modulus of the net \
amplitude of the \"0\" outcome.  Thus to obtain a \"0\", Method A is selected \
with amplitude Sqrt[p]=Cos[phi], and Method B is selected with amplitude \
Sqrt[1-p] = Sin[phi]. So overall, the relative contribution of the two \
methods to the \"0\" answer is:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Abs[Cos[phi] w0A + Sin[phi] w0B]^2", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
However we are not quite done because, in addition, we need to \
renormalize the state because we know we can only get a \"0\" or a \"1\" as \
the final answer. The true (renormalized) probability of the quantum method \
yielding a \"0\" is then:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Abs[(Cos[phi] w0A + Sin[phi] w0B)/norm]^2", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["where norm is given by:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
norm = Sqrt[Abs[Cos[phi] w0A + Sin[phi] w0B]^2 + 
            Abs[Cos[phi] w1A + Sin[phi] w1B]^2]\
\>", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
Thus we arrive at the formulae for the classical and quantum \
probabilities of obtaining the \"0\" outcome. The classical answer, \
Pclassical = p p0A + (1 - o) p0B,  can be re-written using our \"phi\" \
variable defined via p = Cos[phi]^2. Thus we have,\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Pclassical = Cos[phi]^2 p0A + Sin[phi]^2 p0B

Pquantum   = Abs[(Cos[phi] w0A + Sin[phi] w0B)/norm]^2\
\>", "Input",
  CellFrame->True,
  AspectRatioFixed->True],

Cell["where", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
norm = Sqrt[Abs[Cos[phi] w0A + Sin[phi] w0B]^2 + 
            Abs[Cos[phi] w1A + Sin[phi] w1B]^2]

w0A  =  Sqrt[p0A]
w0B  = -Sqrt[p0B]
w1A  =  Sqrt[1-p0A]
w1B  =  Sqrt[1-p0B].\
\>", "Input",
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Quantum Mechanical Interference Between Alternative Computational \
Pathways\
\>", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The state of the memory register of a quantum computer can be \
thought of as recording the results of several parallel computations at once. \
 However, unlike a conventional parallel computer, in a quantum computer the \
parallel computations interfere with one another.  As a result the final \
answer that a quantum computer arrives at, recorded in the final state of the \
quantum memory register,  can be different from what one would expect \
classically. 

Here is a simple example that illustrates the difference between a quantum \
computer and a classical computer.  \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Classical Probability, Pclassical", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Classically, our computer picks method A or B to generate the bit. \
For example, each method may consist of tossing a different coin. \
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?Pclassical", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("Pclassical[phi, p0A, p0B] gives the probability of a classical  \
computer picking a 0 using either Method A or Method B."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Pclassical[phi, 3/4, 1/4] // Simplify", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/4\ \((2 + Cos[2\ phi])\)\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantum probability, Pquantum", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?Pquantum", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("Pquantum[phi, p0A, p0B] gives the probability of a quantum  computer \
picking a 0 using both Method A or Method B in quantum  parallel. Note that \
both computational pathways are pursued. The  final answer is arrived as as \
the outcome from the interference  between these computational pathways."\)], 
  "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Using the same values for p0A and p0B as above we see that the \
analytic form for the quantum probability of obtaining a \"0\" outcome can be \
the greater than, less than or equal to the classical probability for \
obtaining a \"0\" outcome.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Pquantum[phi, 3/4, 1/4] // Simplify", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/4\ \((2 + Cos[2\ phi] - \@3\ Sin[2\ phi])\)\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
We can compare the quantum (light) and classical (dark) \
probabilities, for a given value of phi, directly using the ComparisonPlot \
function:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?ComparisonPlot", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("ComparisonPlot[p0A, p0B] creates a plot that allows you to compare  \
Pclassical (dark) and Pquantum (light) as the angle phi changes  from 0 to 2 \
Pi."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComparisonPlot[3/4, 1/4];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147126 0.588606 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17539 -0.0125 -3 -9 ]
[.17539 -0.0125 3 0 ]
[.32696 -0.0125 -3 -9 ]
[.32696 -0.0125 3 0 ]
[.47854 -0.0125 -3 -9 ]
[.47854 -0.0125 3 0 ]
[.63011 -0.0125 -3 -9 ]
[.63011 -0.0125 3 0 ]
[.78169 -0.0125 -3 -9 ]
[.78169 -0.0125 3 0 ]
[.93327 -0.0125 -3 -9 ]
[.93327 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -11 -21 ]
[.5 -0.0125 11 -9 ]
[-0.0125 .01471 -6 -4.5 ]
[-0.0125 .01471 0 4.5 ]
[-0.0125 .13243 -18 -4.5 ]
[-0.0125 .13243 0 4.5 ]
[-0.0125 .25016 -18 -4.5 ]
[-0.0125 .25016 0 4.5 ]
[-0.0125 .36788 -18 -4.5 ]
[-0.0125 .36788 0 4.5 ]
[-0.0125 .4856 -18 -4.5 ]
[-0.0125 .4856 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -50.0625 ]
[-0.01875 .30902 -18 50.0625 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[1.0125 .30902 0 -53 ]
[1.0125 .30902 12 53 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.17539 0 m
.17539 .61803 L
s
.32696 0 m
.32696 .61803 L
s
.47854 0 m
.47854 .61803 L
s
.63011 0 m
.63011 .61803 L
s
.78169 0 m
.78169 .61803 L
s
.93327 0 m
.93327 .61803 L
s
0 .13243 m
1 .13243 L
s
0 .25016 m
1 .25016 L
s
0 .36788 m
1 .36788 L
s
0 .4856 m
1 .4856 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17539 0 m
.17539 .00625 L
s
[(1)] .17539 -0.0125 0 1 Mshowa
.32696 0 m
.32696 .00625 L
s
[(2)] .32696 -0.0125 0 1 Mshowa
.47854 0 m
.47854 .00625 L
s
[(3)] .47854 -0.0125 0 1 Mshowa
.63011 0 m
.63011 .00625 L
s
[(4)] .63011 -0.0125 0 1 Mshowa
.78169 0 m
.78169 .00625 L
s
[(5)] .78169 -0.0125 0 1 Mshowa
.93327 0 m
.93327 .00625 L
s
[(6)] .93327 -0.0125 0 1 Mshowa
.125 Mabswid
.05412 0 m
.05412 .00375 L
s
.08444 0 m
.08444 .00375 L
s
.11476 0 m
.11476 .00375 L
s
.14507 0 m
.14507 .00375 L
s
.2057 0 m
.2057 .00375 L
s
.23602 0 m
.23602 .00375 L
s
.26633 0 m
.26633 .00375 L
s
.29665 0 m
.29665 .00375 L
s
.35728 0 m
.35728 .00375 L
s
.38759 0 m
.38759 .00375 L
s
.41791 0 m
.41791 .00375 L
s
.44822 0 m
.44822 .00375 L
s
.50885 0 m
.50885 .00375 L
s
.53917 0 m
.53917 .00375 L
s
.56948 0 m
.56948 .00375 L
s
.5998 0 m
.5998 .00375 L
s
.66043 0 m
.66043 .00375 L
s
.69074 0 m
.69074 .00375 L
s
.72106 0 m
.72106 .00375 L
s
.75137 0 m
.75137 .00375 L
s
.81201 0 m
.81201 .00375 L
s
.84232 0 m
.84232 .00375 L
s
.87264 0 m
.87264 .00375 L
s
.90295 0 m
.90295 .00375 L
s
.96358 0 m
.96358 .00375 L
s
.9939 0 m
.9939 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -72 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(phi) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 .01471 m
.00625 .01471 L
s
[(0)] -0.0125 .01471 1 0 Mshowa
0 .13243 m
.00625 .13243 L
s
[(0.2)] -0.0125 .13243 1 0 Mshowa
0 .25016 m
.00625 .25016 L
s
[(0.4)] -0.0125 .25016 1 0 Mshowa
0 .36788 m
.00625 .36788 L
s
[(0.6)] -0.0125 .36788 1 0 Mshowa
0 .4856 m
.00625 .4856 L
s
[(0.8)] -0.0125 .4856 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04414 m
.00375 .04414 L
s
0 .07357 m
.00375 .07357 L
s
0 .103 m
.00375 .103 L
s
0 .16186 m
.00375 .16186 L
s
0 .19129 m
.00375 .19129 L
s
0 .22072 m
.00375 .22072 L
s
0 .27959 m
.00375 .27959 L
s
0 .30902 m
.00375 .30902 L
s
0 .33845 m
.00375 .33845 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .45617 m
.00375 .45617 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -135.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
111.062 10 translate
90 rotate
-111.062 -10 translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pquantum) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
117.125000 13.000000 moveto
(H) show
123.125000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(light) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
153.125000 13.000000 moveto
(L) show
159.125000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.02381 .61178 m
.02381 .61803 L
s
.17539 .61178 m
.17539 .61803 L
s
.32696 .61178 m
.32696 .61803 L
s
.47854 .61178 m
.47854 .61803 L
s
.63011 .61178 m
.63011 .61803 L
s
.78169 .61178 m
.78169 .61803 L
s
.93327 .61178 m
.93327 .61803 L
s
.125 Mabswid
.05412 .61428 m
.05412 .61803 L
s
.08444 .61428 m
.08444 .61803 L
s
.11476 .61428 m
.11476 .61803 L
s
.14507 .61428 m
.14507 .61803 L
s
.2057 .61428 m
.2057 .61803 L
s
.23602 .61428 m
.23602 .61803 L
s
.26633 .61428 m
.26633 .61803 L
s
.29665 .61428 m
.29665 .61803 L
s
.35728 .61428 m
.35728 .61803 L
s
.38759 .61428 m
.38759 .61803 L
s
.41791 .61428 m
.41791 .61803 L
s
.44822 .61428 m
.44822 .61803 L
s
.50885 .61428 m
.50885 .61803 L
s
.53917 .61428 m
.53917 .61803 L
s
.56948 .61428 m
.56948 .61803 L
s
.5998 .61428 m
.5998 .61803 L
s
.66043 .61428 m
.66043 .61803 L
s
.69074 .61428 m
.69074 .61803 L
s
.72106 .61428 m
.72106 .61803 L
s
.75137 .61428 m
.75137 .61803 L
s
.81201 .61428 m
.81201 .61803 L
s
.84232 .61428 m
.84232 .61803 L
s
.87264 .61428 m
.87264 .61803 L
s
.90295 .61428 m
.90295 .61803 L
s
.96358 .61428 m
.96358 .61803 L
s
.9939 .61428 m
.9939 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01471 m
1 .01471 L
s
.99375 .13243 m
1 .13243 L
s
.99375 .25016 m
1 .25016 L
s
.99375 .36788 m
1 .36788 L
s
.99375 .4856 m
1 .4856 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04414 m
1 .04414 L
s
.99625 .07357 m
1 .07357 L
s
.99625 .103 m
1 .103 L
s
.99625 .16186 m
1 .16186 L
s
.99625 .19129 m
1 .19129 L
s
.99625 .22072 m
1 .22072 L
s
.99625 .27959 m
1 .27959 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .45617 m
1 .45617 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
1.0125 .30902 -108 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
114 10 translate
90 rotate
-114 -10 translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pclassical) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
129.000000 13.000000 moveto
(H) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(dark) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
159.000000 13.000000 moveto
(L) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.8 g
.02 w
.02381 .45617 m
.06244 .31308 L
.10458 .15716 L
.12507 .09536 L
.13506 .0706 L
.14415 .05167 L
.1536 .0359 L
.16254 .0249 L
.16744 .02053 L
.17197 .01757 L
.17434 .01644 L
.17694 .01552 L
.17825 .01518 L
.17897 .01504 L
.17966 .01493 L
.1803 .01484 L
.18099 .01477 L
.18221 .01472 L
.18285 .01472 L
.18354 .01474 L
.18476 .01484 L
.18608 .01503 L
.18682 .01518 L
.18752 .01535 L
.18994 .01611 L
.19253 .01726 L
.19504 .01871 L
.19742 .02037 L
.20188 .02424 L
.21193 .03656 L
.22285 .05538 L
.24263 .10247 L
.26364 .16772 L
.30139 .30823 L
.34159 .45724 L
.36007 .51423 L
.37054 .54132 L
.38028 .56257 L
.38997 .57955 L
.39493 .58656 L
.40032 .59281 L
.40328 .59563 L
.406 .59785 L
.40856 .59959 L
.41137 .60112 L
.41259 .60166 L
.41389 .60216 L
.41502 .60251 L
.41625 .60283 L
.41697 .60297 L
Mistroke
.41764 .60309 L
.41895 .60325 L
.42014 .60331 L
.42142 .6033 L
.42266 .60321 L
.42337 .60313 L
.42403 .60302 L
.42536 .60275 L
.42679 .60235 L
.42938 .60136 L
.43173 .60017 L
.43745 .5961 L
.44287 .59075 L
.45254 .57762 L
.46305 .55842 L
.48286 .50956 L
.50389 .44291 L
.54169 .30123 L
.58194 .15328 L
.60046 .0975 L
.61094 .07131 L
.62068 .05103 L
.6304 .03504 L
.63537 .02858 L
.64076 .02294 L
.64373 .02046 L
.64646 .01856 L
.64902 .01713 L
.65038 .0165 L
.65183 .01593 L
.65315 .01551 L
.65436 .0152 L
.65557 .01497 L
.65671 .01482 L
.658 .01473 L
.65918 .01472 L
.66049 .01479 L
.66115 .01486 L
.66188 .01497 L
.66309 .0152 L
.66422 .01548 L
.66678 .01637 L
.66928 .01756 L
.67195 .01918 L
.67679 .02303 L
.6812 .02755 L
.69192 .04248 L
.70205 .06149 L
.72203 .11155 L
.74048 .16996 L
Mistroke
.77985 .31706 L
.81771 .45699 L
.83876 .52109 L
.85801 .56556 L
.86753 .5816 L
.87255 .58835 L
.87791 .5942 L
.88055 .59656 L
.88305 .59847 L
.88548 .60003 L
.88771 .60119 L
.88983 .60207 L
.89208 .60274 L
.89325 .60299 L
.89433 .60316 L
.89553 .60328 L
.89681 .60332 L
.89803 .60328 L
.89872 .60323 L
.89937 .60315 L
.90068 .60294 L
.90142 .60278 L
.9021 .60261 L
.90448 .60182 L
.90699 .60068 L
.90973 .59906 L
.91228 .59722 L
.91806 .59184 L
.92779 .57909 L
.93819 .56057 L
.95774 .51327 L
.97619 .45617 L
Mfstroke
0 g
.02381 .45617 m
.02499 .45615 L
.02605 .4561 L
.02729 .45601 L
.02846 .45589 L
.03053 .45559 L
.03279 .45514 L
.03527 .45449 L
.0379 .45363 L
.04262 .45166 L
.05205 .44607 L
.06244 .43746 L
.0842 .41187 L
.10458 .38022 L
.14335 .30806 L
.18458 .23204 L
.20517 .20121 L
.21519 .18894 L
.22428 .17962 L
.2338 .17186 L
.24277 .16653 L
.2477 .16444 L
.25224 .16306 L
.25461 .16255 L
.25597 .16231 L
.25722 .16215 L
.25853 .16201 L
.25925 .16195 L
.25994 .16191 L
.26115 .16187 L
.26184 .16186 L
.26248 .16187 L
.26365 .1619 L
.26489 .16198 L
.26595 .16207 L
.26711 .16221 L
.2697 .16264 L
.2721 .16319 L
.27647 .16457 L
.28114 .16658 L
.28669 .16967 L
.29194 .17327 L
.30174 .18173 L
.32176 .20542 L
.34021 .23367 L
.37961 .30642 L
.4175 .37726 L
.43858 .41043 L
.45784 .43398 L
.46737 .44274 L
Mistroke
.4724 .44652 L
.47776 .44988 L
.48291 .45244 L
.48757 .45419 L
.48982 .45484 L
.49225 .4554 L
.49337 .45561 L
.49455 .45579 L
.49565 .45593 L
.49666 .45602 L
.49789 .45611 L
.49854 .45614 L
.49922 .45616 L
.50037 .45617 L
.50164 .45613 L
.50276 .45607 L
.50398 .45596 L
.50512 .45583 L
.50617 .45568 L
.50854 .45523 L
.51113 .45458 L
.51634 .45276 L
.52094 .45058 L
.52585 .44769 L
.53469 .44102 L
.54496 .43103 L
.55607 .41769 L
.57624 .38779 L
.61721 .31258 L
.65666 .23894 L
.6765 .20784 L
.6946 .18544 L
.70461 .176 L
.71409 .16918 L
.71929 .16637 L
.7241 .16437 L
.72661 .16355 L
.72938 .16284 L
.73077 .16255 L
.73228 .1623 L
.73369 .16211 L
.735 .16199 L
.73627 .16191 L
.73747 .16187 L
.73855 .16187 L
.73973 .1619 L
.741 .16197 L
.74165 .16203 L
.74236 .1621 L
.74362 .16226 L
Mistroke
.74478 .16244 L
.74705 .16289 L
.74949 .16352 L
.7539 .16505 L
.75897 .16741 L
.76451 .17071 L
.77459 .1786 L
.79428 .20048 L
.81525 .23176 L
.85686 .30846 L
.89694 .38279 L
.91533 .41122 L
.92577 .42479 L
.93551 .43548 L
.94506 .44393 L
.94997 .44745 L
.9553 .45061 L
.95822 .45205 L
.96091 .45319 L
.96344 .45409 L
.96623 .4549 L
.96872 .45545 L
.97106 .45583 L
.97235 .45598 L
.97353 .45608 L
.97483 .45614 L
.97548 .45616 L
.97619 .45617 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol00?Eo
o`00mGoo001jOol4001gOol007]oo`03001oogoo07Moo`00Ngoo10000Woo0P0000Aoo`00001oo`D0
06Uoo`00Ngoo00L007ooOomoo`00Ool00002Ool00`00Oomoo`02Ool00`00Oomoo`1YOol007]oo`07
001oogooOol007oo00000Woo00<007ooOol00Woo00<007ooOol0JGoo001kOol01`00Oomoogoo001o
o`00009oo`03001oogoo009oo`03001oogoo06Uoo`00NWoo1@000Woo10000goo0P00Jgoo0021Ool0
0`00Oomoo`1aOol0081oo`8000Moo`03001oogoo06Uoo`00mGoo003eOol00?Eoo`009Goo0P006goo
0`006Woo10006Woo0`0077oo0`006Goo0`0077oo0P0077oo000TOol01000Oomoo`006goo00<007oo
Ool06Woo00<007ooOol07Goo00<007ooOol06Woo00<007ooOol06goo00<007ooOol067oo00@007oo
Ool001]oo`0097oo00@007ooOol001]oo`03001oogoo01]oo`03001oogoo01aoo`03001oogoo01Qo
o`@001aoo`03001oogoo01Qoo`04001oogoo000KOol002Aoo`04001oogoo000KOol00`00Oomoo`0L
Ool00`00Oomoo`0IOol2000KOol00`00Ool0000JOol3000KOol3000LOol002Aoo`04001oogoo000K
Ool00`00Oomoo`0IOol01000Oomoo`007Goo00<007ooOol067oo00<007oo00006Woo00<007ooOol0
6goo00<007ooOol077oo000UOol2000KOol2000LOol2000KOol3000LOol2000JOol4000KOol3000K
Ool00?Eoo`00mGoo003eOol00?Eoo`008Gooa@003goo000KOol20004Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool2000?Ool001Yoo`04001oogoo0003Ool00`00Oomoo`0NOol7IcTH
Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?OomW>@06IcTDOol00`0?Oomoo`0KOol00`0?Oomo
o`0:Ool00`00Oomoo`0=Ool001Yoo`04001oogoo0003Ool2000NOol9IcTGOol00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?IcUW>@08IcTBOol00`0?Oomoo`0KOol00`0?Oomoo`09Ool2000?Ool001Yo
o`04001oogoo0003Ool00`00Oomoo`0LOol;IcTFOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol<IcTA
Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0=Ool001Yoo`04001oogoo0003Ool00`00
Oomoo`0KOol5IcT00`0?OomW>@05IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol5IcT2Ool5IcTA
Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0=Ool001]oo`8000Aoo`03001oogoo01Yo
o`EW>@03Ool03goo009oo`EW>AAoo`0300moogoo01]oo`0300moogoo01Yoo`AW>@Ioo`AW>A1oo`03
00moogoo01]oo`0300moogoo00Yoo`03001oogoo00eoo`008Goo00<007ooOol06Woo16Li0Woo00<0
3gooOol00Woo16Li57oo00<03gooOol06goo00<03gooOol06Woo16Li1Woo1FLi3goo00<03gooOol0
6goo00<03gooOol02Woo00<007ooOol03Goo000QOol00`00Oomoo`0IOol4IcT3Ool00`0?Oomoo`03
Ool4IcTCOol00`0?Oomoo`0KOol00`0?Oomoo`0IOol4IcT8Ool4IcT?Ool00`0?Oomoo`0KOol00`0?
Oomoo`0:Ool00`00Oomoo`0=Ool0025oo`8001Uoo`EW>@=oo`0300moogoo00=oo`AW>A=oo`0300mo
ogoo01]oo`0300moogoo01Qoo`EW>@Uoo`AW>@ioo`0300moogoo01]oo`0300moogoo00Uoo`8000mo
o`008Goo00<007ooOol067oo16Li17oo00<03gooOol017oo16Li4Woo00<03gooOol06goo00<03goo
Ool067oo16Li2Woo16Li3Woo00<03gooOol06goo00<03gooOol02Woo00<007ooOol02Goo0`000Goo
000QOol00`00Oomoo`0HOol3IcT5Ool00`0?Oomoo`04Ool4IcTBOol00`0?Oomoo`0KOol00`0?Oomo
o`0GOol4IcT00`0?Oomoo`09Ool4IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0:
Ool10001Ool1Ool0025oo`03001oogoo01Moo`AW>@Eoo`0300moogoo00Eoo`AW>A5oo`0300moogoo
01]oo`0300moogoo01Moo`AW>@0300moogoo00Uoo`AW>@eoo`0300moogoo01]oo`0300moogoo00Yo
o`03001oogoo00Yoo`<000002Goo0`005Goo00<007ooOol05goo16Li1Goo00<03gooOol01Goo16Li
4Goo00<03gooOol06goo00<03gooOol05Woo16Li00=oo`0?Ool02goo16Li37oo00<03gooOol06goo
00<03gooOol02Woo00<007ooOol02Woo0@000Goo0Goo000:Ool00`00Oomoo`0DOol2000HOol3IcT6
Ool00`0?Oomoo`06Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0FOol4IcT00goo00moo`0;Ool4
IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`09Ool2000<Ool10001Ool1Ool000Yoo`<001Aoo`03001o
ogoo01Ioo`AW>@Ioo`0300moogoo00Ioo`AW>A1oo`0300moogoo01]oo`0300moogoo01Eoo`AW>@9o
o`0300moogoo00]oo`=W>@aoo`0300moogoo01]oo`0300moogoo00Yoo`03001oogoo00Uoo`@00000
2Woo00@007ooOol001=oo`03001oogoo01Ioo`AW>@Ioo`0300moogoo00Moo`=W>A1oo`0300moogoo
01]oo`0300moogoo01Eoo`AW>@9oo`0300moogoo00]oo`AW>@]oo`0300moogoo01]oo`0300moogoo
00Yoo`03001oogoo00]oo`8000002Woo00<007oo00000`004Goo00<007ooOol05Woo0fLi1goo00<0
3gooOol01goo16Li3goo00<03gooOol06goo00<03gooOol05Goo0fLi0goo00<03gooOol02goo16Li
2goo00<03gooOol06goo00<03gooOol02Woo00<007ooOol02Woo0@000Goo0Goo0009Ool400000goo
001oo`0AOol00`00Oomoo`0EOol4IcT7Ool00`0?Oomoo`07Ool4IcT?Ool00`0?Oomoo`0KOol00`0?
Oomoo`0DOol4IcT3Ool00`0?Oomoo`0<Ool4IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00
Oomoo`0:Ool10001Ool1Ool000]oo`@0019oo`03001oogoo01Eoo`AW>@Moo`0300moogoo00Qoo`AW
>@ioo`0300moogoo01]oo`0300moogoo01Aoo`AW>@=oo`0300moogoo00aoo`AW>@Yoo`0300moogoo
01]oo`0300moogoo00Yoo`03001oogoo00Yoo`40005oo`5oo`002Woo00D007ooOomoo`00019oo`80
01Eoo`AW>@Qoo`0300moogoo00Qoo`AW>@ioo`0300moogoo01]oo`0300moogoo01=oo`AW>@Aoo`03
00moogoo00eoo`=W>@Yoo`0300moogoo01]oo`0300moogoo00Uoo`8000eoo`8000002Woo00D007oo
Oomoo`00019oo`03001oogoo01Aoo`AW>@Qoo`0300moogoo00Uoo`=W>@ioo`0300moogoo01]oo`03
00moogoo01=oo`AW>@Aoo`0300moogoo00eoo`AW>@Uoo`0300moogoo01]oo`0300moogoo00Yoo`03
001oogoo00eoo`002Woo00D007ooOomoo`00019oo`03001oogoo01Aoo`=W>@Uoo`0300moogoo00Uo
o`AW>@eoo`0300moogoo01]oo`0300moogoo01=oo`=W>@Eoo`0300moogoo00eoo`AW>@Uoo`0300mo
ogoo01]oo`0300moogoo00Yoo`03001oogoo00Yoo`<000002goo1@004Goo00<007ooOol04goo16Li
2Goo00<03gooOol02Goo16Li3Goo00<03gooOol06goo00<03gooOol04Woo16Li1Goo00<03gooOol0
3Woo0fLi2Goo00<03gooOol06goo00<03gooOol02Woo00<007ooOol037oo0@00000?Ool20004Ool2
0003Ool40003Ool00`00Oomoo`0COol4IcT9Ool00`0?Oomoo`0:Ool3IcT=Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0BOol4IcT5Ool00`0?Oomoo`0>Ool4IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool0
0`00Oomoo`0<Ool1000000Yoo`D0009oo`04001oogooOol20004Ool00`00Oomoo`03Ool00`00Oomo
o`0COol3IcT:Ool00`0?Oomoo`0:Ool4IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0BOol3IcT6Ool0
0`0?Oomoo`0>Ool4IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0<Ool1000000Yo
o`03001oogoo0080009oo`03001oogoo00Qoo`03001oogoo009oo`8001<03`AW>AL03`AW>Ch03`AW
>AP03`=W>C803`8000ioo`4000002Woo00<007ooOol00P000Woo00<007ooOol02Goo00D007ooOomo
o`0001Aoo`AW>@Yoo`0300moogoo00]oo`=W>@aoo`0300moogoo01]oo`0300moogoo015oo`AW>@Io
o`0300moogoo00moo`AW>@Moo`0300moogoo01]oo`0300moogoo00Yoo`03001oogoo00aoo`400000
2Woo00<007ooOol00P000Woo00<007ooOol01Woo00@007ooOol000=oo`03001oogoo019oo`=W>@]o
o`0300moogoo00]oo`AW>@]oo`0300moogoo01]oo`0300moogoo015oo`=W>@Moo`0300moogoo00mo
o`AW>@Moo`0300moogoo01]oo`0300moogoo00Yoo`03001oogoo00Yoo`<000002Goo0P0000Aoo`00
001oo`8000Yoo`8000Aoo`03001oogoo015oo`AW>@]oo`0300moogoo00]oo`AW>@]oo`0300moogoo
01]oo`0300moogoo011oo`AW>@Moo`0300moogoo011oo`=W>@Moo`0300moogoo01]oo`0300moogoo
00Yoo`03001oogoo00Yoo`40005oo`5oo`008Goo00<007ooOol04Goo16Li2goo00<03gooOol037oo
0fLi2goo00<03gooOol06goo00<03gooOol047oo16Li1goo00<03gooOol047oo0fLi1goo00<03goo
Ool06goo00<03gooOol02Woo00<007ooOol02Woo0`00000:Ool5000BOol00`00Oomoo`0AOol3IcT<
Ool00`0?Oomoo`0:Ool80008Ool00`0?Oomoo`0KOol00`0?Oomoo`0@Ool3IcT8Ool00`0?Oomoo`0=
Ool:0003Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0=Ool000Yoo`04001oogoo000C
Ool2000BOol3IcT<Ool00`0?Oomoo`08Ool<0006Ool00`0?Oomoo`0KOol00`0?Oomoo`0?Ool4IcT8
Ool00`0?Oomoo`0;Ool>00000goo00moo`0LOol00`0?Oomoo`09Ool2000=Ool2000000Yoo`@001=o
o`03001oogoo011oo`AW>@aoo`0300moogoo00Iooa0000Aoo`0300moogoo01]oo`0300moogoo00mo
o`AW>@Qoo`0300moogoo00Yooa00000300moogoo01]oo`0300moogoo00Yoo`03001oogoo00eoo`00
3Goo00<007ooOol04Goo00<007ooOol047oo16Li37oo00<03gooOol01Goo1`0000AoofLiIcUW>@L0
00=oo`0300moogoo01]oo`0300moogoo00moo`=W>@Uoo`0300moogoo00Uoo`H0009oo`=W>@03Ool0
000000@001eoo`0300moogoo00Yoo`03001oogoo00Yoo`<000002goo0`004goo00<007ooOol047oo
0fLi3Goo00<03gooOol017oo1P000goo16Li00=oo`0000000`000goo00<03gooOol06goo00<03goo
Ool03Woo16Li2Goo00<03gooOol027oo1@0017oo16Li0Woo1@0077oo00<03gooOol02Woo00<007oo
Ool03Goo000QOol00`00Oomoo`0?Ool4IcT=Ool00`0?Oomoo`03Ool50005Ool4IcT3Ool40002Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0>Ool4IcT9Ool00`0?Oomoo`08Ool40005Ool4IcT3Ool5000KOol0
0`0?Oomoo`0:Ool00`00Oomoo`0:Ool3000000Yoo`800003Ool00000019oo`80011oo`AW>@eoo`03
00moogoo009oo`D000Moo`=W>@=oo`D00003Ool03goo01aoo`0300moogoo00ioo`=W>@Yoo`0300mo
ogoo00Moo`@000Moo`=W>@Aoo`D001Yoo`0300moogoo00Uoo`8000aoo`40005oo`5oo`002Woo00@0
07ooOol001=oo`03001oogoo00moo`=W>@ioo`0400moogooOol50008Ool3IcT4Ool500000`0?Oomo
o`0KOol00`0?Oomoo`0>Ool3IcT:Ool00`0?Oomoo`06Ool50007Ool4IcT4Ool5000IOol00`0?Oomo
o`0:Ool00`00Oomoo`0:Ool3000000Yoo`04001oogoo000COol00`00Oomoo`0>Ool4IcT>Ool0100?
Oomoogoo10002Goo16Li17oo1@007Goo00<03gooOol03Goo16Li2Woo00<03gooOol01Woo100027oo
16Li17oo00<03`0000000P006Goo00<03gooOol02Woo00<007ooOol03Goo000:Ool01000Oomoo`00
4goo00<007ooOol03Woo16Li3Woo00<03gooOol010002Woo16Li1Goo10007Goo00<03gooOol03Goo
16Li2Woo00<03gooOol01Goo10002Woo0fLi17oo00<03goo00000`0067oo00<03gooOol02Woo00<0
07ooOol02Woo0`000009Ool5000COol00`00Oomoo`0>Ool3IcT?Ool00`0?Ool00004000;Ool3IcT6
Ool4000LOol00`0?Oomoo`0=Ool3IcT;Ool00`0?Oomoo`05Ool4000:Ool3IcT4Ool00`0?Ool00004
000GOol00`0?Oomoo`0:Ool00`00Oomoo`0=Ool0025oo`03001oogoo00ioo`=W>@moo`0300moo`00
00<000aoo`=W>@Ioo`D001]oo`0300moogoo00eoo`=W>@]oo`0300moogoo00Aoo`@000]oo`AW>@=o
o`0300moogoo00@001Moo`0300moogoo00Yoo`03001oogoo00Yoo`<000002goo0`004goo0P003Woo
16Li3goo00<03`0000000P003Goo16Li1Woo10006goo00<03gooOol037oo16Li2goo00<03gooOol0
0goo1@002goo16Li0goo00@03gooOomoo`@001Ioo`0300moogoo00Uoo`8000aoo`40005oo`5oo`00
2goo00@007ooOol0019oo`03001oogoo00eoo`AW>@moo`D000eoo`AW>@Moo`@001Yoo`0300moogoo
00aoo`AW>@]oo`0300moogoo00=oo`@000eoo`=W>@=oo`0400moogooOol5000EOol00`0?Oomoo`0:
Ool00`00Oomoo`0:Ool3000000]oo`03001oogoo01=oo`03001oogoo00eoo`=W>A1oo`@000moo`=W
>@Moo`D001Uoo`0300moogoo00aoo`=W>@aoo`0300moogoo009oo`@000ioo`=W>@=oo`0300moogoo
009oo`@001Eoo`0300moogoo00Yoo`03001oogoo00eoo`002goo00<007ooOol04goo00<007ooOol0
37oo16Li3goo100047oo16Li1Woo00<03`0000000P006Goo00<03gooOol02goo16Li37oo00@03goo
Oomoo`D000ioo`AW>@9oo`0300moogoo00=oo`@001Aoo`0300moogoo00Yoo`03001oogoo00Yoo`<0
00002Woo100000=oo`00000017oo0P0017oo0`000goo00<007ooOol037oo16Li3goo100047oo16Li
1Woo00<03goo00000`0067oo00<03gooOol02goo16Li37oo00@03gooOomoo`@000moo`AW>@9oo`03
00moogoo00=oo`@001Aoo`0300moogoo00Yoo`03001oogoo00aoo`4000002goo00@007ooOol0009o
o`04001oogooOol20005Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool3IcT?Ool4000BOol3IcT6Ool0
0`0?Ool00003000HOol00`0?Oomoo`0;Ool3IcT=Ool00`0?Oomoo`04000AOol3IcT2Ool00`0?Oomo
o`04Ool4000COol00`0?Oomoo`0:Ool00`00Oomoo`0<Ool1000000Yoo`D0009oo`03001oogoo00Io
o`@000=oo`8000`03`AW>@l03`@001803`=W>@T03`@002D03`=W>A003`@001403`AW>@P03`@001l0
3`8000ioo`4000002Woo00<007ooOol00P000Woo00<007ooOol01Woo00<007oo000017oo00<007oo
Ool02goo16Li3Woo10004goo16Li1Goo00<03gooOol01@005Woo00<03gooOol02Woo16Li3Goo00<0
3goo00000`004Woo16Li00=oo`0?Ool01Woo10004Woo00<03gooOol02Woo00<007ooOol02goo0P00
000:Ool00`00Oomoo`020002Ool00`00Oomoo`06Ool00`00Ool00004Ool00`00Oomoo`0;Ool3IcT?
Ool4000COol4IcT5Ool0100?Oomoogoo10005Woo00<03gooOol02Woo16Li3Goo00<03`0000000`00
4goo0fLi00=oo`0?Ool01Woo10004Woo00<03gooOol02Woo00<007ooOol03Goo000:Ool01@00Oomo
o`00Ool00P002Woo0P0017oo00<007ooOol02goo0fLi3Woo100000<03gooOol04Woo0fLi1Goo00<0
3gooOol00Woo10005Goo00<03gooOol02Woo0fLi3Woo00<03`0000000P0057oo0fLi00=oo`0?Ool0
1goo10004Goo00<03gooOol02Woo00<007ooOol02goo0P000009Ool200000goo0000000COol00`00
Oomoo`0:Ool4IcT=Ool500000`0?Oomoo`0BOol3IcT5Ool00`0?Oomoo`02Ool4000EOol00`0?Oomo
o`0:Ool3IcT>Ool4000EOol4IcT00`0?Oomoo`06Ool5000@Ool00`0?Oomoo`0:Ool00`00Oomoo`0:
Ool10001Ool1Ool0025oo`03001oogoo00Yoo`AW>@eoo`@00003Ool03goo01=oo`AW>@Aoo`0300mo
ogoo00=oo`@001Aoo`0300moogoo00Uoo`AW>@ioo`@001Eoo`AW>@0300moogoo00Moo`@0011oo`03
00moogoo00Yoo`03001oogoo00Yoo`40005oo`5oo`002Woo00D007oo001oo`00019oo`8000]oo`=W
>@eoo`@0009oo`0300moogoo019oo`AW>@Aoo`0300moogoo00=oo`@001Aoo`0300moogoo00Uoo`AW
>@eoo`@001Moo`=W>@0300moogoo00Qoo`@000moo`0300moogoo00Uoo`8000aoo`40005oo`5oo`00
2Woo00D007oo001oo`00019oo`03001oogoo00Uoo`AW>@eoo`@0009oo`0300moogoo01=oo`=W>@Ao
o`0300moogoo00Aoo`@001=oo`0300moogoo00Uoo`=W>@ioo`@001Moo`=W>@0300moogoo00Qoo`@0
00moo`0300moogoo00Yoo`03001oogoo00]oo`8000002Woo00D007oo001oo`00019oo`03001oogoo
00Uoo`AW>@aoo`@000=oo`0300moogoo01=oo`=W>@Aoo`0300moogoo00Aoo`D0019oo`0300moogoo
00Qoo`AW>@eoo`@001Qoo`AW>@]oo`@000ioo`0300moogoo00Yoo`03001oogoo00eoo`002Woo00D0
07oo001oo`00019oo`03001oogoo00Uoo`=W>@eoo`@000=oo`0300moogoo01=oo`AW>@=oo`0300mo
ogoo00Eoo`@0019oo`0300moogoo00Qoo`AW>@aoo`D001Qoo`AW>@]oo`@000ioo`0300moogoo00Yo
o`03001oogoo00Yoo`<000002Goo1P004Woo00<007ooOol027oo16Li37oo100017oo00<03gooOol0
4goo16Li0goo00<03gooOol01Woo10004Goo00<03gooOol027oo0fLi3Goo10006Woo0fLi37oo1000
3Goo00<03gooOol02Woo00<007ooOol02Woo0@000Goo0Goo000QOol20009Ool4IcT<Ool40004Ool0
0`0?Oomoo`0DOol3IcT3Ool00`0?Oomoo`06Ool4000AOol00`0?Oomoo`08Ool3IcT<Ool400000`0?
Oomoo`0HOol4IcT;Ool4000=Ool00`0?Oomoo`09Ool2000<Ool30000025oo`03001oogoo00Qoo`=W
>@aoo`@000Eoo`0300moogoo01Aoo`=W>@=oo`0300moogoo00Moo`@0011oo`0300moogoo00Moo`AW
>@aoo`@0000300moogoo01Qoo`AW>@aoo`@000aoo`0300moogoo00Yoo`03001oogoo00eoo`008Goo
00<007ooOol027oo0fLi37oo10001Goo00<03gooOol057oo16Li0Woo00<03gooOol01goo100047oo
00<03gooOol01goo16Li2goo100000=oo`0?Ool06Woo0fLi37oo100037oo00<03gooOol02Woo00<0
07ooOol02goo0P00000QOol00`00Oomoo`07Ool4IcT;Ool40006Ool00`0?Oomoo`0DOol4IcT2Ool0
0`0?Oomoo`08Ool4000?Ool00`0?Oomoo`07Ool3IcT<Ool400000goo00moo`0JOol3IcT=Ool4000;
Ool00`0?Oomoo`0:Ool00`00Oomoo`0=Ool0025oo`03001oogoo00Moo`AW>@]oo`@000Ioo`0300mo
ogoo01Eoo`=W>@9oo`0300moogoo00Qoo`@000moo`0300moogoo00Moo`=W>@]oo`@0009oo`0300mo
ogoo01Uoo`AW>@aoo`@000]oo`0300moogoo00Yoo`03001oogoo00Yoo`<000003Goo00<007ooOol0
4Goo00<007ooOol01goo0fLi2goo10001goo00<03gooOol05Goo16Li00=oo`0?Ool02Woo10003Woo
00<03gooOol01Woo16Li2goo10000Woo00<03gooOol06Goo16Li3Goo10002Woo00<03gooOol02Woo
00<007ooOol037oo0@00000<Ool00`00Oomoo`0BOol20008Ool3IcT;Ool40007Ool00`0?Oomoo`0E
Ool4IcT00goo00moo`0:Ool4000>Ool00`0?Oomoo`06Ool4IcT:Ool40003Ool00`0?Oomoo`0JOol3
IcT=Ool4000:Ool00`0?Oomoo`09Ool2000>Ool1000000]oo`03001oogoo01=oo`03001oogoo00Io
o`AW>@Yoo`@000Qoo`0300moogoo01Ioo`=W>@03Ool03goo00]oo`@000eoo`0300moogoo00Ioo`=W
>@]oo`@000=oo`0300moogoo01Yoo`=W>@ioo`@000Uoo`0300moogoo00Yoo`03001oogoo00aoo`40
00002goo00<007ooOol04goo00<007ooOol01Woo16Li2Woo100027oo00<03gooOol05Woo0fLi00=o
o`0?Ool02goo10003Goo00<03gooOol01Woo0fLi2Woo100017oo00<03gooOol06Woo16Li3Goo1@00
27oo00<03gooOol02Woo00<007ooOol037oo0@00000;Ool00`00Oomoo`0COol00`00Oomoo`06Ool3
IcT:Ool40009Ool00`0?Oomoo`0FOol4IcT00`0?Oomoo`0;Ool4000<Ool00`0?Oomoo`05Ool4IcT9
Ool50004Ool00`0?Oomoo`0JOol4IcT>Ool40008Ool00`0?Oomoo`0:Ool00`00Oomoo`0<Ool10000
00]oo`04001oogooOol20004Ool20004Ool20004Ool00`00Oomoo`06Ool3IcT:Ool40009Ool00`0?
Oomoo`0FOol4IcT00`0?Oomoo`0;Ool4000<Ool00`0?Oomoo`05Ool4IcT9Ool40005Ool00`0?Oomo
o`0JOol0100?IcUW>FLi3goo10001goo00<03gooOol02Woo00<007ooOol02Woo0`00000<Ool00`00
Ool00002Ool01000Oomoogoo0P000goo00@007ooOol000=oo`03001oogoo00Eoo`AW>@Uoo`@000Yo
o`0300moogoo01Moo`=W>@0300moogoo00aoo`@000]oo`0300moogoo00Eoo`=W>@Uoo`@000Ioo`03
00moogoo01Yoo`0400mW>FLiIcT?Ool40007Ool00`0?Oomoo`0:Ool00`00Oomoo`0=Ool000eoo`80
009oo`03001oogoo00Ioo`04001oogoo0003Ool2000600l4IcT900l4000T00l3IcT?00l4000C00l3
IcT900l4000T00l4IcT?00l4000B00l2000?Ool000Yoo`D0009oo`03001oogoo00Ioo`<000Aoo`03
001oogoo00Eoo`=W>@Uoo`@000]oo`0300moogoo01Moo`AW>@moo`@000Yoo`0300moogoo00Aoo`AW
>@Qoo`@000Moo`0300moogoo01Yoo`0300mW>FLi009W>@moo`@000Ioo`0300moogoo00Yoo`03001o
ogoo00eoo`0037oo00<007oo00000Woo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo
0fLi2Goo10002goo00<03gooOol05goo16Li3goo10002Woo00<03gooOol017oo16Li27oo10001goo
00<03gooOol06Woo00<03gooIcT00VLi47oo10001Goo00<03gooOol02Woo00<007ooOol03Goo000<
Ool00`00Oomoo`02000:Ool30003Ool00`00Oomoo`04Ool4IcT8Ool4000<Ool00`0?Oomoo`0HOol3
IcT@Ool40009Ool00`0?Oomoo`04Ool3IcT8Ool40008Ool00`0?Oomoo`0JOol00`0?OomW>@03IcT?
Ool40005Ool00`0?Oomoo`0:Ool00`00Oomoo`0<Ool1000000aoo`03001oogoo019oo`03001oogoo
00Aoo`AW>@Qoo`@000aoo`0300moogoo01Qoo`AW>@moo`D000Qoo`0300moogoo00Aoo`=W>@Qoo`@0
00Qoo`0300moogoo01Yoo`0300moofLi00=W>A1oo`@000Aoo`0300moogoo00Yoo`03001oogoo00]o
o`40005oo`0037oo00<007ooOol04Woo00<007ooOol017oo0fLi27oo10003Goo00<03gooOol067oo
16Li47oo100027oo00<03gooOol00goo16Li1goo10002Goo00<03gooOol06Woo00<03gooOol00fLi
47oo1@000goo00<03gooOol02Woo00<007ooOol02goo0@000Goo000<Ool00`00Oomoo`0BOol20005
Ool3IcT7Ool5000=Ool00`0?Oomoo`0IOol3IcTAOol40007Ool00`0?Oomoo`03Ool4IcT6Ool50009
Ool00`0?Oomoo`0JOol00`0?Oomoo`03IcTAOol40003Ool00`0?Oomoo`09Ool2000=Ool10001Ool0
00Yoo`D0019oo`03001oogoo00=oo`AW>@Moo`@000ioo`0300moogoo01Uoo`=W>A5oo`D000Ioo`03
00moogoo00=oo`=W>@Moo`@000Yoo`0300moogoo01Yoo`0300moogoo00AW>A5oo`@0009oo`0300mo
ogoo00Yoo`03001oogoo00]oo`40005oo`0037oo00<007ooOol04Woo00<007ooOol00goo16Li1Woo
10003goo00<03gooOol06Goo16Li4Goo10001Woo00<03gooOol00goo0fLi1Woo10002goo00<03goo
Ool06Woo00<03gooOol016Li4Goo1@0000=oo`0?Ool02goo00<007ooOol037oo0@00000<Ool00`00
Oomoo`0BOol00`00Oomoo`03Ool3IcT6Ool5000?Ool00`0?Oomoo`0IOol4IcTBOol40005Ool00`0?
Oomoo`02Ool4IcT5Ool5000;Ool00`0?Oomoo`0JOol0100?Oomoogoo0fLi4Woo1@0000<03gooOol0
2Woo00<007ooOol03Goo000<Ool00`00Oomoo`0BOol00`00Oomoo`03Ool3IcT5Ool5000@Ool00`0?
Oomoo`0JOol3IcTBOol50004Ool00`0?Oomoo`02Ool4IcT4Ool5000<Ool00`0?Oomoo`0JOol0100?
Oomoogoo0fLi4goo1@0037oo00<007ooOol02goo0P00000;Ool3000COol20003Ool4IcT4Ool5000A
Ool00`0?Oomoo`0JOol3IcTCOol50003Ool00`0?Oomoo`02Ool3IcT4Ool5000=Ool00`0?Oomoo`0J
Ool0100?Oomoogoo16Li4goo10002goo0P0037oo0@000Goo0Goo000>Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool4IcT3Ool5000BOol00`0?Oomoo`0JOol4IcTCOol50002Ool00`0?Oomoo`02Ool3IcT3
Ool5000>Ool00`0?Oomoo`0JOol0100?Oomoogoo16Li57oo10002goo00<007ooOol02Woo0@000Goo
0Goo000;Ool4000BOol00`00Oomoo`02Ool3IcT2Ool6000COol00`0?Oomoo`0JOol4IcTDOol50000
0goo00moo`02Ool4IcT2Ool5000?Ool00`0?Oomoo`0JOol00`0?Oomoo`02Ool3IcTDOol5000:Ool0
0`00Oomoo`0:Ool10001Ool1Ool000Yoo`05001oogooOol0000BOol00`00Oomoo`02Ool3IcT00goo
00000004000DOol00`0?Oomoo`0JOol0100?IcUW>FLi5Goo1P000goo16Li00=oo`0000000`0047oo
00<03gooOol06Woo00<03gooOol00Woo0fLi5Goo1@002Goo00<007ooOol02goo0P00000:Ool01@00
Oomoogoo00004Woo00@007ooOomoo`AW>@H001Eoo`0300moogoo01Yoo`0300mW>FLi009W>AEoo`H0
009oo`=W>@H0015oo`0300moogoo01Yoo`0300moogoo009oo`AW>AEoo`L000Ioo`03001oogoo00eo
o`002Woo00D007ooOomoo`00019oo`04001oogooOol8000GOol00`0?Oomoo`0JOol00`0?IcUW>@02
IcTFOol?000BOol00`0?Oomoo`0JOol00`0?Oomoo`02Ool4IcTEOol00`0?000000070003Ool00`00
Oomoo`0:Ool3000000]oo`D0015oo`80009oo`L001Qoo`0300moogoo01Yoo`0300moofLi009W>AQo
o``001=oo`0300moogoo01Yoo`0300moogoo00=oo`=W>AEoo`0300moo`0000L0009oo`8000aoo`40
005oo`5oo`008Goo00@007ooOomoo`H001Uoo`0300moogoo01Yoo`0300moofLi00=W>AQoo`T001Eo
o`0300moogoo01Yoo`0300moogoo00=oo`=W>AEoo`0400moogooOol60003Ool00`00Oomoo`0:Ool3
000000Yoo`800003Ool00000019oo`03001oogoo021oo`0300moogoo01Yoo`0300moofLi00=W>AQo
o`0300moogoo00=W>AQoo`0300moogoo01Yoo`0300moogoo00=oo`AW>AAoo`0300moogoo00=oo`AW
>@=oo`03001oogoo00eoo`002Woo00@007ooOol001=oo`03001oogoo021oo`0300moogoo01Yoo`03
00moogoo00=W>AQoo`0300moofLi00=W>AQoo`0300moogoo01Yoo`0300moogoo00=oo`AW>AAoo`03
00moogoo00=oo`AW>@=oo`03001oogoo00]oo`8000002Woo00D007ooOol007oo008000Aoo`8000Ao
o`8000Aoo`03001oogoo021oo`0300moogoo01Yoo`0300moogoo00AW>AMoo`0300moofLi00=W>AQo
o`0300moogoo01Yoo`0300moogoo00Aoo`=W>AAoo`0300moogoo00=oo`=W>@Aoo`03001oogoo00eo
o`002Woo00<007ooOol00P000Woo00@007ooOomoo`8000=oo`04001oogoo0003Ool00`00Oomoo`0P
Ool00`0?Oomoo`0JOol00`0?Oomoo`04IcTGOol00`0?OomW>@02IcTIOol00`0?Oomoo`0JOol00`0?
Oomoo`04Ool4IcTCOol00`0?Oomoo`02Ool4IcT4Ool00`00Oomoo`0:Ool3000000Yoo`D0009oo`03
001oogoo00Ioo`04001oogoo0003Ool2001200l3IcTH00l4IcTm00l4IcTH00l4IcT300l2000=Ool1
0001Ool000Yoo`05001oogooOol00002Ool00`00Oomoo`07Ool20004Ool00`00Oomoo`0POol00`0?
Oomoo`0JOol0100?Oomoogoo16Li5Woo00<03fLiIcT00VLi6Goo00<03gooOol06Woo00<03gooOol0
1Goo0fLi4goo00<03gooOol00Woo0fLi1Goo00<007ooOol02goo0@000Goo0009Ool60002Ool00`00
Oomoo`06Ool01000Oomoo`000goo00<007ooOol087oo00<03gooOol06Woo00@03gooOomoo`AW>AIo
o`0400mW>FLiIcTJOol00`0?Oomoo`0JOol00`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`02Ool3IcT5
Ool00`00Oomoo`0;Ool2000000]oo`03001oogoo00<000Yoo`8000Aoo`03001oogoo021oo`0300mo
ogoo01Yoo`0300moogoo009oo`=W>AIoo`AW>AYoo`0300moogoo01Yoo`0300moogoo00Eoo`AW>A9o
o`0400moogooOol4IcT5Ool00`00Oomoo`0:Ool20001Ool000]oo`03001oogoo01=oo`03001oogoo
021oo`0300moogoo01Yoo`0300moogoo009oo`AW>AEoo`AW>AYoo`0300moogoo01Yoo`0300moogoo
00Ioo`=W>A9oo`0400moogooOol4IcT5Ool00`00Oomoo`0=Ool000]oo`03001oogoo01=oo`03001o
ogoo021oo`0300moogoo01Yoo`0300moogoo009oo`AW>AEoo`=W>A]oo`0300moogoo01Yoo`0300mo
ogoo00Ioo`AW>A5oo`0400moogooOol3IcT6Ool00`00Oomoo`0:Ool10001Ool1000000Yoo`@001=o
o`80025oo`0300moogoo01Yoo`0300moogoo00=oo`=W>AAoo`AW>A]oo`0300moogoo01Yoo`0300mo
ogoo00Ioo`AW>A5oo`0300moogoo00AW>@Eoo`8000aoo`40005oo`4000002goo00<007ooOol04goo
00<007ooOol087oo00<03gooOol06Woo00<03gooOol00goo16Li4goo16Li6goo00<03gooOol06Woo
00<03gooOol01goo0fLi4Goo00<03gooOol016Li1Woo00<007ooOol02Woo0`00000;Ool2000DOol0
0`00Oomoo`0POol00`0?Oomoo`0JOol00`0?Oomoo`03Ool4IcTBOol4IcTLOol00`0?Oomoo`0JOol0
0`0?Oomoo`07Ool4IcT@Ool00`0?Oomoo`03IcT7Ool00`00Oomoo`0:Ool10001Ool1000000aoo`03
001oogoo019oo`03001oogoo021oo`0300moogoo01Yoo`0300moogoo00Aoo`=W>A9oo`AW>Aaoo`03
00moogoo01Yoo`0300moogoo00Moo`AW>A1oo`0300moofLi00=W>@Moo`03001oogoo00Yoo`40005o
o`40000037oo00<007ooOol04Woo00<007ooOol087oo00<03gooOol06Woo00<03gooOol017oo16Li
4Goo0fLi7Goo00<03gooOol06Woo00<03gooOol027oo16Li3goo00<03gooIcT00fLi1goo00<007oo
Ool02Woo0P000Goo000<Ool00`00Oomoo`0BOol00`00Oomoo`0POol00`0?Oomoo`0JOol00`0?Oomo
o`04Ool4IcT@Ool4IcTMOol00`0?Oomoo`0JOol00`0?Oomoo`08Ool4IcT?Ool00`0?IcUW>@02IcT8
Ool00`00Oomoo`09Ool20001Ool1000000]oo`03001oogoo01=oo`80025oo`0300moogoo01Yoo`03
00moogoo00Eoo`AW>@moo`AW>Aeoo`0300moogoo01Yoo`0300moogoo00Uoo`=W>@moo`0300mW>FLi
009W>@Moo`8000ioo`4000002Woo00<007ooOol057oo00<007ooOol087oo00<03gooOol06Woo00<0
3gooOol01Goo16Li3Woo16Li00<03gooOol06goo00<03gooOol06Woo00<03gooOol02Goo16Li3Woo
00@03fLiIcUW>@Uoo`03001oogoo00aoo`4000008Goo00<007ooOol087oo00<03gooOol06Woo00<0
3gooOol01Woo16Li3Goo16Li00<03gooOol06goo00<03gooOol06Woo00<03gooOol02Goo16Li3Woo
16Li2Goo00<007ooOol037oo0@00000QOol00`00Oomoo`0POol00`0?Oomoo`0JOol00`0?Oomoo`06
Ool4IcT<Ool4IcT00goo00moo`0LOol00`0?Oomoo`0JOol00`0?Oomoo`0:Ool4IcT=Ool4IcT9Ool0
0`00Oomoo`0;Ool10001Ool0025oo`03001oogoo021oo`0300moogoo01Yoo`0300moogoo00Moo`AW
>@]oo`AW>@03Ool03goo01aoo`0300moogoo01Yoo`0300moogoo00Yoo`AW>@aoo`AW>@Yoo`03001o
ogoo00Yoo`40005oo`5oo`008Goo0P008Goo00<03gooOol06Woo00<03gooOol01goo1FLi2Goo16Li
0Woo00<03gooOol06goo00<03gooOol06Woo00<03gooOol02goo16Li2Woo1FLi2Goo0P003goo000Q
Ool00`00Oomoo`0POol00`0?Oomoo`0JOol00`0?Oomoo`08Ool4IcT9Ool4IcT2Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0JOol00`0?Oomoo`0;Ool5IcT9Ool4IcT;Ool00`00Oomoo`0=Ool0025oo`03001o
ogoo021oo`0300moogoo01Yoo`0300moogoo00Uoo`AW>@Moo`AW>@=oo`0300moogoo01]oo`0300mo
ogoo01Yoo`0300moogoo00aoo`EW>@Moo`AW>@aoo`03001oogoo00eoo`008Goo00<007ooOol087oo
00<03gooOol06Woo00<03gooOol02Goo1FLi1Goo1FLi0goo00<03gooOol06goo00<03gooOol06Woo
00<03gooOol03Goo1FLi1Goo1FLi37oo00<007ooOol03Goo000JOol30004Ool00`00Oomoo`0POol0
0`0?Oomoo`0JOol00`0?Oomoo`0:Ool5IcT2Ool6IcT4Ool00`0?Oomoo`0KOol00`0?Oomoo`0JOol0
0`0?Oomoo`0>Ool6IcT00gooIcUW>@04IcT00`0?Oomoo`0:Ool00`00Oomoo`0=Ool001]oo`03001o
ogoo00=oo`03001oogoo021oo`0300moogoo01Yoo`0300moogoo00]oo`]W>@Eoo`0300moogoo01]o
o`0300moogoo01Yoo`0300moogoo00moo`]W>@03Ool03goo00]oo`03001oogoo00eoo`006goo00<0
07ooOol00goo0P008Goo00<03gooOol06Woo00<03gooOol02goo2VLi1Woo00<03gooOol06goo00<0
3gooOol06Woo00<03gooOol047oo2FLi0Woo00<03gooOol02Goo0P003goo000KOol00`00Oomoo`03
Ool00`00Oomoo`0POol00`0?Oomoo`0JOol00`0?Oomoo`0=Ool6IcT8Ool00`0?Oomoo`0KOol00`0?
Oomoo`0JOol00`0?Oomoo`0AOol7IcT3Ool00`0?Oomoo`0:Ool00`00Oomoo`0=Ool001]oo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8000moo`006Woo0P001Goo
a@003goo003eOol00?Eoo`00mGoo0000\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.29125, -0.24518, 0.0336811, 
  0.00867346}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
To see how Pclassical and Pquantum co-vary, use PhaseDiagram.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?PhaseDiagram", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("PhaseDiagram[p0A, p0B] displays corresponding pairs of values  for \
Pclassical and Pquantum. The line at 45 degrees indicates where  both \
probabilities are equal. In the region above this line  Pquantum > Pclassical \
and in the region below the 45 degree line  Pquantum < Pclassical."\)], 
  "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PhaseDiagram[3/4, 1/4];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -9 -9 ]
[.21429 -0.0125 9 0 ]
[.40476 -0.0125 -9 -9 ]
[.40476 -0.0125 9 0 ]
[.59524 -0.0125 -9 -9 ]
[.59524 -0.0125 9 0 ]
[.78571 -0.0125 -9 -9 ]
[.78571 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -32 -21 ]
[.5 -0.0125 32 -9 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .21429 -18 -4.5 ]
[-0.0125 .21429 0 4.5 ]
[-0.0125 .40476 -18 -4.5 ]
[-0.0125 .40476 0 4.5 ]
[-0.0125 .59524 -18 -4.5 ]
[-0.0125 .59524 0 4.5 ]
[-0.0125 .78571 -18 -4.5 ]
[-0.0125 .78571 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .5 -30 -26.0625 ]
[-0.01875 .5 -18 26.0625 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0.2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(0.4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(0.6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(0.8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -93 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pclassical) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .21429 m
.00625 .21429 L
s
[(0.2)] -0.0125 .21429 1 0 Mshowa
0 .40476 m
.00625 .40476 L
s
[(0.4)] -0.0125 .40476 1 0 Mshowa
0 .59524 m
.00625 .59524 L
s
[(0.6)] -0.0125 .59524 1 0 Mshowa
0 .78571 m
.00625 .78571 L
s
[(0.8)] -0.0125 .78571 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(1)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .07143 m
.00375 .07143 L
s
0 .11905 m
.00375 .11905 L
s
0 .16667 m
.00375 .16667 L
s
0 .2619 m
.00375 .2619 L
s
0 .30952 m
.00375 .30952 L
s
0 .35714 m
.00375 .35714 L
s
0 .45238 m
.00375 .45238 L
s
0 .5 m
.00375 .5 L
s
0 .54762 m
.00375 .54762 L
s
0 .64286 m
.00375 .64286 L
s
0 .69048 m
.00375 .69048 L
s
0 .7381 m
.00375 .7381 L
s
0 .83333 m
.00375 .83333 L
s
0 .88095 m
.00375 .88095 L
s
0 .92857 m
.00375 .92857 L
s
.25 Mabswid
0 0 m
0 1 L
s
gsave
-0.01875 .5 -111.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
87.0625 10 translate
90 rotate
-87.0625 -10 translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.000000 moveto
 558.000000 16.000000 lineto
 558.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.000000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pquantum) show
111.125000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.07143 .99625 m
.07143 1 L
s
.11905 .99625 m
.11905 1 L
s
.16667 .99625 m
.16667 1 L
s
.2619 .99625 m
.2619 1 L
s
.30952 .99625 m
.30952 1 L
s
.35714 .99625 m
.35714 1 L
s
.45238 .99625 m
.45238 1 L
s
.5 .99625 m
.5 1 L
s
.54762 .99625 m
.54762 1 L
s
.64286 .99625 m
.64286 1 L
s
.69048 .99625 m
.69048 1 L
s
.7381 .99625 m
.7381 1 L
s
.83333 .99625 m
.83333 1 L
s
.88095 .99625 m
.88095 1 L
s
.92857 .99625 m
.92857 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .21429 m
1 .21429 L
s
.99375 .40476 m
1 .40476 L
s
.99375 .59524 m
1 .59524 L
s
.99375 .78571 m
1 .78571 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .07143 m
1 .07143 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .16667 m
1 .16667 L
s
.99625 .2619 m
1 .2619 L
s
.99625 .30952 m
1 .30952 L
s
.99625 .35714 m
1 .35714 L
s
.99625 .45238 m
1 .45238 L
s
.99625 .5 m
1 .5 L
s
.99625 .54762 m
1 .54762 L
s
.99625 .64286 m
1 .64286 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .7381 m
1 .7381 L
s
.99625 .83333 m
1 .83333 L
s
.99625 .88095 m
1 .88095 L
s
.99625 .92857 m
1 .92857 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.008 w
.7381 .7381 Mdot
.73805 .7298 Mdot
.7379 .72141 Mdot
.73767 .71294 Mdot
.73733 .70438 Mdot
.73691 .69574 Mdot
.73638 .68701 Mdot
.73577 .67822 Mdot
.73505 .66935 Mdot
.73425 .66042 Mdot
.73335 .65142 Mdot
.73236 .64236 Mdot
.73127 .63324 Mdot
.73009 .62407 Mdot
.72882 .61486 Mdot
.72746 .60559 Mdot
.72601 .59628 Mdot
.72447 .58694 Mdot
.72283 .57756 Mdot
.72111 .56815 Mdot
.7193 .55871 Mdot
.7174 .54924 Mdot
.71542 .53976 Mdot
.71335 .53026 Mdot
.71119 .52075 Mdot
.70895 .51124 Mdot
.70662 .50171 Mdot
.70422 .49219 Mdot
.70173 .48267 Mdot
.69916 .47316 Mdot
.69651 .46365 Mdot
.69378 .45417 Mdot
.69098 .4447 Mdot
.68809 .43525 Mdot
.68514 .42583 Mdot
.68211 .41643 Mdot
.679 .40708 Mdot
.67583 .39775 Mdot
.67258 .38847 Mdot
.66927 .37924 Mdot
.66588 .37005 Mdot
.66243 .36091 Mdot
.65892 .35183 Mdot
.65534 .34281 Mdot
.6517 .33386 Mdot
.648 .32496 Mdot
.64424 .31614 Mdot
.64043 .30739 Mdot
.63655 .29872 Mdot
.63262 .29013 Mdot
.62864 .28163 Mdot
.62461 .27321 Mdot
.62053 .26488 Mdot
.6164 .25664 Mdot
.61222 .24851 Mdot
.608 .24047 Mdot
.60373 .23254 Mdot
.59943 .22471 Mdot
.59508 .217 Mdot
.5907 .2094 Mdot
.58628 .20191 Mdot
.58182 .19454 Mdot
.57733 .1873 Mdot
.57281 .18018 Mdot
.56827 .17319 Mdot
.56369 .16633 Mdot
.55909 .1596 Mdot
.55446 .15301 Mdot
.54982 .14655 Mdot
.54515 .14024 Mdot
.54047 .13408 Mdot
.53577 .12805 Mdot
.53105 .12218 Mdot
.52633 .11646 Mdot
.52159 .11089 Mdot
.51684 .10548 Mdot
.51209 .10023 Mdot
.50733 .09513 Mdot
.50257 .0902 Mdot
.49781 .08543 Mdot
.49305 .08083 Mdot
.48829 .0764 Mdot
.48354 .07213 Mdot
.47879 .06804 Mdot
.47405 .06411 Mdot
.46932 .06037 Mdot
.46461 .0568 Mdot
.45991 .0534 Mdot
.45522 .05019 Mdot
.45055 .04715 Mdot
.4459 .0443 Mdot
.44128 .04162 Mdot
.43668 .03914 Mdot
.4321 .03683 Mdot
.42755 .03471 Mdot
.42303 .03278 Mdot
.41854 .03103 Mdot
.41408 .02947 Mdot
.40965 .0281 Mdot
.40527 .02692 Mdot
.40092 .02593 Mdot
.39661 .02513 Mdot
.39234 .02451 Mdot
.38811 .02409 Mdot
.38393 .02386 Mdot
.3798 .02382 Mdot
.37571 .02397 Mdot
.37168 .0243 Mdot
.36769 .02483 Mdot
.36376 .02555 Mdot
.35988 .02646 Mdot
.35606 .02756 Mdot
.35229 .02885 Mdot
.34859 .03032 Mdot
.34495 .03199 Mdot
.34136 .03384 Mdot
.33784 .03588 Mdot
.33439 .0381 Mdot
.331 .04051 Mdot
.32768 .0431 Mdot
.32443 .04587 Mdot
.32125 .04883 Mdot
.31814 .05197 Mdot
.3151 .05528 Mdot
.31214 .05878 Mdot
.30925 .06245 Mdot
.30644 .06629 Mdot
.30371 .07031 Mdot
.30105 .0745 Mdot
.29847 .07886 Mdot
.29598 .08339 Mdot
.29357 .08809 Mdot
.29123 .09295 Mdot
.28899 .09797 Mdot
.28682 .10315 Mdot
.28474 .1085 Mdot
.28275 .114 Mdot
.28085 .11965 Mdot
.27903 .12546 Mdot
.2773 .13141 Mdot
.27566 .13751 Mdot
.27411 .14376 Mdot
.27265 .15015 Mdot
.27128 .15668 Mdot
.27 .16335 Mdot
.26882 .17015 Mdot
.26773 .17709 Mdot
.26673 .18415 Mdot
.26582 .19134 Mdot
.26501 .19866 Mdot
.26429 .20609 Mdot
.26366 .21364 Mdot
.26313 .22131 Mdot
.2627 .22909 Mdot
.26236 .23697 Mdot
.26211 .24496 Mdot
.26196 .25306 Mdot
.26191 .26125 Mdot
.26195 .26954 Mdot
.26208 .27792 Mdot
.26231 .28638 Mdot
.26264 .29494 Mdot
.26306 .30357 Mdot
.26357 .31229 Mdot
.26418 .32108 Mdot
.26489 .32994 Mdot
.26568 .33887 Mdot
.26658 .34786 Mdot
.26756 .35692 Mdot
.26864 .36603 Mdot
.26981 .37519 Mdot
.27107 .38441 Mdot
.27243 .39367 Mdot
.27387 .40297 Mdot
.27541 .41232 Mdot
.27703 .42169 Mdot
.27875 .4311 Mdot
.28055 .44054 Mdot
.28244 .45 Mdot
.28442 .45948 Mdot
.28649 .46898 Mdot
.28864 .47849 Mdot
.29087 .48801 Mdot
.29319 .49753 Mdot
.29559 .50705 Mdot
.29807 .51657 Mdot
.30063 .52609 Mdot
.30328 .53559 Mdot
.306 .54508 Mdot
.3088 .55455 Mdot
.31167 .564 Mdot
.31463 .57342 Mdot
.31765 .58282 Mdot
.32075 .59218 Mdot
.32392 .6015 Mdot
.32716 .61079 Mdot
.33047 .62003 Mdot
.33385 .62922 Mdot
.33729 .63836 Mdot
.3408 .64744 Mdot
.34437 .65647 Mdot
.34801 .66543 Mdot
.3517 .67433 Mdot
.35546 .68316 Mdot
.35927 .69191 Mdot
.36314 .70059 Mdot
.36706 .70919 Mdot
.37104 .7177 Mdot
.37507 .72613 Mdot
.37914 .73446 Mdot
.38327 .7427 Mdot
.38744 .75085 Mdot
.39166 .75889 Mdot
.39592 .76683 Mdot
.40023 .77467 Mdot
.40457 .78239 Mdot
.40895 .79 Mdot
.41337 .7975 Mdot
.41782 .80488 Mdot
.42231 .81213 Mdot
.42683 .81926 Mdot
.43137 .82626 Mdot
.43594 .83313 Mdot
.44054 .83987 Mdot
.44517 .84647 Mdot
.44981 .85294 Mdot
.45448 .85926 Mdot
.45916 .86544 Mdot
.46386 .87147 Mdot
.46857 .87736 Mdot
.4733 .88309 Mdot
.47803 .88867 Mdot
.48278 .89409 Mdot
.48753 .89936 Mdot
.49229 .90447 Mdot
.49705 .90941 Mdot
.50181 .91419 Mdot
.50657 .91881 Mdot
.51133 .92326 Mdot
.51609 .92754 Mdot
.52083 .93164 Mdot
.52557 .93558 Mdot
.5303 .93934 Mdot
.53502 .94293 Mdot
.53972 .94633 Mdot
.54441 .94956 Mdot
.54908 .95261 Mdot
.55373 .95548 Mdot
.55835 .95817 Mdot
.56296 .96067 Mdot
.56754 .96299 Mdot
.57209 .96513 Mdot
.57661 .96707 Mdot
.58111 .96884 Mdot
.58557 .97041 Mdot
.58999 .97179 Mdot
.59439 .97299 Mdot
.59874 .974 Mdot
.60305 .97482 Mdot
.60732 .97544 Mdot
.61155 .97588 Mdot
.61574 .97613 Mdot
.61987 .97619 Mdot
.62396 .97605 Mdot
.628 .97573 Mdot
.63199 .97522 Mdot
.63593 .97451 Mdot
.63981 .97362 Mdot
.64364 .97253 Mdot
.64741 .97126 Mdot
.65112 .9698 Mdot
.65477 .96815 Mdot
.65835 .96632 Mdot
.66188 .96429 Mdot
.66534 .96208 Mdot
.66873 .95969 Mdot
.67206 .95711 Mdot
.67531 .95435 Mdot
.6785 .95141 Mdot
.68162 .94829 Mdot
.68466 .94499 Mdot
.68763 .94151 Mdot
.69052 .93785 Mdot
.69334 .93402 Mdot
.69608 .93002 Mdot
.69874 .92584 Mdot
.70132 .92149 Mdot
.70383 .91698 Mdot
.70625 .91229 Mdot
.70858 .90745 Mdot
.71084 .90244 Mdot
.71301 .89727 Mdot
.71509 .89194 Mdot
.71709 .88645 Mdot
.719 .88081 Mdot
.72083 .87501 Mdot
.72256 .86907 Mdot
.72421 .86298 Mdot
.72577 .85674 Mdot
.72724 .85036 Mdot
.72861 .84384 Mdot
.7299 .83718 Mdot
.73109 .83039 Mdot
.73219 .82347 Mdot
.7332 .81641 Mdot
.73411 .80923 Mdot
.73493 .80193 Mdot
.73566 .79451 Mdot
.73629 .78696 Mdot
.73683 .77931 Mdot
.73727 .77154 Mdot
.73762 .76366 Mdot
.73787 .75568 Mdot
.73803 .74759 Mdot
.73809 .73941 Mdot
.73806 .73113 Mdot
.73793 .72276 Mdot
.73771 .71429 Mdot
.73739 .70575 Mdot
.73698 .69712 Mdot
.73647 .68841 Mdot
.73587 .67962 Mdot
.73517 .67077 Mdot
.73438 .66185 Mdot
.7335 .65286 Mdot
.73252 .64381 Mdot
.73145 .6347 Mdot
.73029 .62554 Mdot
.72903 .61633 Mdot
.72768 .60707 Mdot
.72625 .59777 Mdot
.72472 .58843 Mdot
.7231 .57905 Mdot
.72139 .56965 Mdot
.71959 .56021 Mdot
.71771 .55075 Mdot
.71574 .54127 Mdot
.71368 .53178 Mdot
.71154 .52227 Mdot
.70931 .51275 Mdot
.707 .50323 Mdot
.70461 .49371 Mdot
.70213 .48419 Mdot
.69957 .47467 Mdot
.69694 .46517 Mdot
.69422 .45568 Mdot
.69143 .4462 Mdot
.68856 .43675 Mdot
.68561 .42733 Mdot
.68259 .41793 Mdot
.6795 .40856 Mdot
.67634 .39924 Mdot
.6731 .38995 Mdot
.6698 .38071 Mdot
.66643 .37151 Mdot
.66299 .36237 Mdot
.65948 .35328 Mdot
.65592 .34425 Mdot
.65229 .33528 Mdot
.6486 .32638 Mdot
.64485 .31754 Mdot
.64104 .30878 Mdot
.63717 .3001 Mdot
.63325 .2915 Mdot
.62928 .28298 Mdot
.62526 .27454 Mdot
.62118 .2662 Mdot
.61706 .25795 Mdot
.61289 .2498 Mdot
.60867 .24174 Mdot
.60442 .2338 Mdot
.60012 .22595 Mdot
.59578 .21822 Mdot
.5914 .2106 Mdot
.58698 .20309 Mdot
.58253 .19571 Mdot
.57805 .18844 Mdot
.57354 .1813 Mdot
.56899 .17429 Mdot
.56442 .16741 Mdot
.55982 .16066 Mdot
.5552 .15405 Mdot
.55056 .14757 Mdot
.5459 .14124 Mdot
.54122 .13505 Mdot
.53652 .129 Mdot
.53181 .12311 Mdot
.52708 .11736 Mdot
.52234 .11177 Mdot
.5176 .10633 Mdot
.51285 .10105 Mdot
.50809 .09593 Mdot
.50333 .09098 Mdot
.49857 .08618 Mdot
.49381 .08155 Mdot
.48905 .07709 Mdot
.48429 .0728 Mdot
.47954 .06868 Mdot
.4748 .06473 Mdot
.47007 .06095 Mdot
.46536 .05735 Mdot
.46065 .05393 Mdot
.45596 .05069 Mdot
.45129 .04762 Mdot
.44664 .04474 Mdot
.44201 .04204 Mdot
.43741 .03952 Mdot
.43283 .03719 Mdot
.42827 .03504 Mdot
.42374 .03307 Mdot
.41925 .0313 Mdot
.41479 .02971 Mdot
.41036 .02831 Mdot
.40596 .0271 Mdot
.40161 .02607 Mdot
.39729 .02524 Mdot
.39302 .0246 Mdot
.38878 .02415 Mdot
.3846 .02388 Mdot
.38045 .02381 Mdot
.37636 .02393 Mdot
.37232 .02424 Mdot
.36832 .02474 Mdot
.36438 .02543 Mdot
.36049 .0263 Mdot
.35666 .02737 Mdot
.35289 .02863 Mdot
.34918 .03008 Mdot
.34552 .03171 Mdot
.34193 .03353 Mdot
.3384 .03554 Mdot
.33494 .03773 Mdot
.33154 .04011 Mdot
.32821 .04267 Mdot
.32494 .04542 Mdot
.32175 .04835 Mdot
.31863 .05145 Mdot
.31558 .05474 Mdot
.31261 .05821 Mdot
.30971 .06185 Mdot
.30688 .06567 Mdot
.30414 .06966 Mdot
.30147 .07382 Mdot
.29888 .07815 Mdot
.29637 .08266 Mdot
.29394 .08733 Mdot
.2916 .09216 Mdot
.28934 .09716 Mdot
.28716 .10232 Mdot
.28507 .10763 Mdot
.28306 .11311 Mdot
.28115 .11874 Mdot
.27931 .12452 Mdot
.27757 .13045 Mdot
.27592 .13653 Mdot
.27435 .14276 Mdot
.27288 .14913 Mdot
.27149 .15563 Mdot
.2702 .16228 Mdot
.269 .16906 Mdot
.26789 .17598 Mdot
.26688 .18302 Mdot
.26596 .19019 Mdot
.26513 .19748 Mdot
.2644 .2049 Mdot
.26376 .21243 Mdot
.26321 .22008 Mdot
.26276 .22784 Mdot
.2624 .23571 Mdot
.26214 .24368 Mdot
.26198 .25176 Mdot
.26191 .25994 Mdot
.26193 .26821 Mdot
.26205 .27657 Mdot
.26227 .28503 Mdot
.26258 .29357 Mdot
.26298 .30219 Mdot
.26348 .3109 Mdot
.26408 .31967 Mdot
.26477 .32852 Mdot
.26555 .33744 Mdot
.26643 .34643 Mdot
.2674 .35547 Mdot
.26846 .36457 Mdot
.26962 .37373 Mdot
.27087 .38294 Mdot
.27221 .39219 Mdot
.27364 .40149 Mdot
.27516 .41083 Mdot
.27677 .4202 Mdot
.27847 .4296 Mdot
.28026 .43904 Mdot
.28214 .44849 Mdot
.2841 .45797 Mdot
.28615 .46747 Mdot
.28829 .47697 Mdot
.29051 .48649 Mdot
.29281 .49601 Mdot
.2952 .50553 Mdot
.29767 .51506 Mdot
.30022 .52457 Mdot
.30285 .53408 Mdot
.30556 .54357 Mdot
.30835 .55304 Mdot
.31121 .5625 Mdot
.31415 .57193 Mdot
.31716 .58132 Mdot
.32025 .59069 Mdot
.32341 .60002 Mdot
.32664 .60931 Mdot
.32994 .61856 Mdot
.3333 .62776 Mdot
.33674 .63691 Mdot
.34023 .646 Mdot
.3438 .65504 Mdot
.34742 .66401 Mdot
.35111 .67292 Mdot
.35485 .68176 Mdot
.35866 .69052 Mdot
.36252 .69921 Mdot
.36643 .70782 Mdot
.3704 .71635 Mdot
.37442 .72479 Mdot
.37849 .73314 Mdot
.38261 .7414 Mdot
.38678 .74956 Mdot
.39099 .75762 Mdot
.39524 .76558 Mdot
.39954 .77343 Mdot
.40388 .78117 Mdot
.40825 .7888 Mdot
.41267 .79631 Mdot
.41711 .80371 Mdot
.42159 .81098 Mdot
.4261 .81813 Mdot
.43065 .82516 Mdot
.43521 .83205 Mdot
.43981 .83881 Mdot
.44443 .84543 Mdot
.44907 .85192 Mdot
.45373 .85826 Mdot
.45841 .86446 Mdot
.46311 .87052 Mdot
.46782 .87643 Mdot
.47254 .88219 Mdot
.47728 .88779 Mdot
.48202 .89324 Mdot
.48677 .89853 Mdot
.49153 .90366 Mdot
.49629 .90864 Mdot
.50105 .91344 Mdot
.50582 .91809 Mdot
.51057 .92256 Mdot
.51533 .92687 Mdot
.52008 .931 Mdot
.52482 .93496 Mdot
.52955 .93875 Mdot
.53427 .94237 Mdot
.53897 .9458 Mdot
.54366 .94906 Mdot
.54833 .95214 Mdot
.55299 .95504 Mdot
.55762 .95775 Mdot
.56223 .96029 Mdot
.56681 .96264 Mdot
.57137 .9648 Mdot
.5759 .96678 Mdot
.58039 .96857 Mdot
.58486 .97017 Mdot
.58929 .97159 Mdot
.59369 .97281 Mdot
.59805 .97385 Mdot
.60237 .9747 Mdot
.60665 .97536 Mdot
.61088 .97583 Mdot
.61507 .9761 Mdot
.61922 .97619 Mdot
.62332 .97609 Mdot
.62736 .97579 Mdot
.63136 .97531 Mdot
.63531 .97464 Mdot
.6392 .97377 Mdot
.64303 .97272 Mdot
.64681 .97148 Mdot
.65053 .97005 Mdot
.65419 .96843 Mdot
.65779 .96662 Mdot
.66132 .96463 Mdot
.66479 .96245 Mdot
.66819 .96008 Mdot
.67153 .95754 Mdot
.6748 .95481 Mdot
.678 .95189 Mdot
.68112 .9488 Mdot
.68418 .94553 Mdot
.68716 .94208 Mdot
.69007 .93845 Mdot
.6929 .93464 Mdot
.69565 .93067 Mdot
.69832 .92652 Mdot
.70092 .9222 Mdot
.70343 .91771 Mdot
.70587 .91305 Mdot
.70822 .90823 Mdot
.71048 .90325 Mdot
.71267 .8981 Mdot
.71477 .89279 Mdot
.71678 .88733 Mdot
.71871 .88172 Mdot
.72054 .87595 Mdot
.72229 .87003 Mdot
.72396 .86396 Mdot
.72553 .85774 Mdot
.72701 .85139 Mdot
.7284 .84489 Mdot
.7297 .83825 Mdot
.73091 .83148 Mdot
.73202 .82458 Mdot
.73304 .81755 Mdot
.73397 .81039 Mdot
.73481 .8031 Mdot
.73555 .7957 Mdot
.7362 .78817 Mdot
.73675 .78053 Mdot
.73721 .77278 Mdot
.73757 .76492 Mdot
.73784 .75696 Mdot
.73801 .74889 Mdot
.73809 .74072 Mdot
.5 Mabswid
[ .01 .01 ] 0 setdash
.02381 .02381 m
.06244 .06244 L
.10458 .10458 L
.14415 .14415 L
.18221 .18221 L
.22272 .22272 L
.26171 .26171 L
.30316 .30316 L
.34309 .34309 L
.3815 .3815 L
.42237 .42237 L
.46172 .46172 L
.49955 .49955 L
.53984 .53984 L
.57861 .57861 L
.61984 .61984 L
.65954 .65954 L
.69774 .69774 L
.73838 .73838 L
.77751 .77751 L
.81909 .81909 L
.85916 .85916 L
.89771 .89771 L
.93871 .93871 L
.97619 .97619 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{196, 196},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000340000a1000`40O003h00Oa7oo0034Ool00<Ao
o`00a7oo0034Ool00<Aoo`00a7oo0034Ool00<Aoo`00Dgoo0`001Goo0`000Woo1@0000=oo`000000
0`0000=oo`0000000P000Woo10000Woo1@000Woo0`000Woo1@0000=oo`0000000`00=Goo001DOol0
0`00Oomoo`03Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Ool00002Ool00`00Oomoo`02Ool0
0`00Oomoo`0eOol005Aoo`<000=oo`03001oogoo00Eoo`04001oogooOol40002Ool40002Ool40004
Ool01@00Oomoogoo00001Goo100017oo00<007ooOol0=Goo001DOol01000Oomoo`000Woo00D007oo
Oomoo`0000=oo`03001oogoo00Aoo`04001oogoo0005Ool00`00Oomoo`05Ool01@00Oomoogoo0000
0goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0=Goo001DOol01000Oomoo`000goo1000
0goo00<007ooOol00Woo0`000Woo10000Woo10000goo0P0017oo10000Woo0`0017oo00<007ooOol0
=Goo001COol4000;Ool00`00Oomoo`0WOol00`00Oomoo`0eOol0061oo`<001Moo`03001oogoo00eo
o`<003Moo`00a7oo0034Ool00<Aoo`008goo0P005goo0P0017oo0P000goo100047oo0P0017oo0P00
17oo0`0047oo0P0017oo0P0017oo0P004Goo0P0017oo0P0017oo0P005Woo0`0017oo000ROol01000
Oomoo`005Goo00@007ooOol000=oo`8000Aoo`03001oogoo00moo`04001oogoo0003Ool20005Ool0
0`00Oomoo`0>Ool01000Oomoo`000goo0P000goo00@007ooOol000moo`04001oogoo0003Ool20003
Ool01000Oomoo`005Woo00<007ooOol00goo000ROol01000Oomoo`005Goo00@007ooOol000Yoo`03
001oogoo00ioo`04001oogoo0008Ool4000?Ool01000Oomoo`0027oo00@007ooOol000moo`04001o
ogoo0008Ool01000Oomoo`005Woo00<007ooOol00goo000ROol01000Oomoo`005Goo00@007ooOol0
00]oo`03001oogoo00eoo`04001oogoo0008Ool00`00Ool0000@Ool01000Oomoo`0027oo0`0047oo
00@007ooOol000Uoo`8001Moo`03001oogoo00=oo`008Woo00@007ooOol001Eoo`04001oogoo0008
Ool01000Oomoo`003goo00@007ooOol000Qoo`03001oo`00011oo`04001oogoo0008Ool00`00Oomo
o`0@Ool01000Oomoo`0027oo00@007ooOol001Ioo`03001oogoo00=oo`008goo0P005goo0P002Woo
0P004Goo0P002Woo0P004Goo0P002Woo0`0047oo0P002Woo0P005Woo0P001Goo0034Ool00<Aoo`00
a7oo000QOonR0001Ool0025oo`04001oogoo0007Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool01000Oomoo`000Goo000KOol20004Ool00`00Oomoo`2NOol10001
Ool001Yoo`04001oogoo0003Ool00`00Oomoo`2NOol10001Ool001Yoo`04001oogoo0003Ool20000
0goo0000000fOol6001OOol20001Ool001Yoo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomo
o`0`Ool30005Ool4001MOol10001Ool001Yoo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomo
o`0]Ool2000<Ool2001KOol10001Ool001]oo`8000Aoo`03001oogoo00=oo`03001oogoo02]oo`<0
00moo`8005Uoo`40005oo`008Goo00<007ooOol017oo00<007ooOol0:Goo0P004goo00<007ooOol0
EWoo0@000Goo000QOol00`00Oomoo`05Ool00`00Oomoo`0WOol2000EOol2001FOol10001Ool0025o
o`03001oogoo00Ioo`03001oogoo02Eoo`8001Qoo`03001oogoo05=oo`40005oo`008Goo00<007oo
Ool01goo00<007ooOol097oo00<007ooOol067oo0P00Dgoo0@000Goo000QOol00`00Oomoo`08Ool0
0`00Oomoo`0ROol2000KOol2001BOol10001Ool0025oo`03001oogoo00Yoo`03001oogoo021oo`03
001oogoo01]oo`80055oo`40005oo`008Goo00<007ooOol02goo00<007ooOol07Woo00<007ooOol0
7Goo0P00D7oo0@000Goo000QOol00`00Oomoo`0/Ool00`00Oomoo`0OOol00`00Oomoo`1=Ool10001
Ool0025oo`03001oogoo00aoo`03001oogoo01aoo`03001oogoo025oo`03001oogoo04aoo`40005o
o`008Goo00<007ooOol03Goo00<007ooOol06goo00<007ooOol08Goo0P00CGoo0@000Goo000QOol0
0`00Oomoo`0>Ool00`00Oomoo`0IOol2000TOol2001<Ool10001Ool0025oo`03001oogoo00moo`03
001oogoo01Qoo`03001oogoo02Eoo`03001oogoo04Uoo`40005oo`008Goo00<007ooOol047oo0P00
67oo00<007ooOol09Goo00<007ooOol0BGoo0@000Goo000QOol00`00Oomoo`0BOol00`00Oomoo`0E
Ool00`00Oomoo`0VOol00`00Oomoo`18Ool10001Ool0025oo`03001oogoo01=oo`03001oogoo01=o
o`03001oogoo02Qoo`03001oogoo04Moo`40005oo`008Goo00<007ooOol04goo00<007ooOol04goo
00<007ooOol0:Goo00<007ooOol0AWoo0@000Goo000QOol00`00Oomoo`0DOol00`00Oomoo`0BOol0
0`00Oomoo`0YOol20017Ool10001Ool0025oo`03001oogoo01Eoo`03001oogoo015oo`03001oogoo
02Yoo`03001oogoo04Eoo`40005oo`008Goo00<007ooOol05Woo00<007ooOol03goo00<007ooOol0
;7oo00<007ooOol0A7oo0@000Goo000QOol00`00Oomoo`0GOol00`00Oomoo`0>Ool00`00Oomoo`0]
Ool00`00Oomoo`13Ool10001Ool0025oo`03001oogoo01Qoo`03001oogoo00eoo`03001oogoo02eo
o`03001oogoo04=oo`40005oo`008Goo00<007ooOol06Woo00<007ooOol02goo00<007ooOol0;Goo
00<007ooOol0@goo0@000Goo000QOol00`00Oomoo`0JOol2000<Ool00`00Oomoo`0^Ool00`00Oomo
o`12Ool10001Ool0025oo`03001oogoo02Moo`03001oogoo031oo`03001oogoo045oo`40005oo`00
8Goo00<007ooOol077oo00<007ooOol027oo00<007ooOol0<Goo00<007ooOol0@7oo0@000Goo000?
Ool20004Ool20003Ool40003Ool00`00Oomoo`0MOol00`00Oomoo`07Ool00`00Oomoo`0aOol00`00
Oomoo`10Ool10001Ool000ioo`04001oogoo0003Ool20004Ool00`00Oomoo`03Ool00`00Oomoo`0N
Ool00`00Oomoo`06Ool00`00Oomoo`0bOol00`00Oomoo`0oOol10001Ool000ioo`04001oogoo000:
Ool00`00Oomoo`02Ool2000POol00`00Oomoo`05Ool00`00Oomoo`1cOol20001Ool000ioo`04001o
ogoo000;Ool01@00Oomoogoo00008Woo0P001Goo00<007ooOol0<goo00<007ooOol0?Woo0@000Goo
000>Ool01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo029oo`03001oogoo009oo`03001o
ogoo03=oo`8003moo`40005oo`003goo0P002Woo0P0017oo00<007ooOol08goo00<007ooOol0>7oo
00<007ooOol0?Goo0@000Goo000QOol00`00Oomoo`0SOol01@00Oomoogoo0000=goo00<007ooOol0
?7oo0@000Goo000QOol00`00Oomoo`0TOol01000Oomoo`00=goo00<007ooOol0?7oo0@000Goo000Q
Ool00`00Oomoo`0UOol00`00Ool0000gOol2000mOol10001Ool0025oo`03001oogoo02Ioo`8003Qo
o`03001oogoo03]oo`40005oo`008Goo00<007ooOol09goo00<007ooOol0=goo00<007ooOol0>Woo
0@000Goo000QOol00`00Oomoo`0WOol2001eOol10001Ool0025oo`03001oogoo02Moo`04001oogoo
000fOol2000kOol10001Ool0025oo`03001oogoo02]oo`03001oogoo03Aoo`03001oogoo03Uoo`40
005oo`008Goo00<007ooOol09goo00<007ooOol0>Goo00<007ooOol0>7oo0@000Goo000QOol00`00
Oomoo`0WOol00`00Oomoo`02Ool00`00Oomoo`0dOol00`00Oomoo`0hOol10001Ool0025oo`03001o
ogoo02Moo`03001oogoo00=oo`03001oogoo03=oo`8003Uoo`40005oo`008Goo00<007ooOol09goo
00<007ooOol017oo00<007ooOol0<goo00<007ooOol0=goo0@000Goo000QOol00`00Oomoo`0WOol0
0`00Oomoo`05Ool00`00Oomoo`1/Ool10001Ool0025oo`03001oogoo02Moo`03001oogoo00Ioo`80
03=oo`03001oogoo03Ioo`40005oo`008Goo00<007ooOol0<Woo00<007ooOol0<7oo00<007ooOol0
=Woo0@000Goo000QOol00`00Oomoo`0WOol00`00Oomoo`09Ool00`00Oomoo`0`Ool00`00Oomoo`0e
Ool10001Ool0025oo`03001oogoo02Moo`03001oogoo00Uoo`03001oogoo031oo`03001oogoo03Eo
o`40005oo`008Goo00<007ooOol0:7oo00<007ooOol02Goo00<007ooOol0;goo0P00=Woo0@000Goo
000QOol00`00Oomoo`0XOol00`00Oomoo`0:Ool00`00Oomoo`0_Ool00`00Oomoo`0dOol10001Ool0
00Uoo`<001Eoo`03001oogoo02Qoo`03001oogoo00]oo`03001oogoo02ioo`03001oogoo03Aoo`40
005oo`002Woo00<007ooOol057oo00<007ooOol0:7oo00<007ooOol037oo00<007ooOol0;Woo00<0
07ooOol0<goo0@000Goo000:Ool3000DOol00`00Oomoo`0XOol00`00Oomoo`0=Ool00`00Oomoo`0]
Ool00`00Oomoo`0cOol10001Ool000Yoo`04001oogoo000COol00`00Oomoo`0XOol00`00Oomoo`0?
Ool00`00Oomoo`0[Ool00`00Oomoo`0cOol10001Ool000Yoo`03001oo`0000<0015oo`03001oogoo
02Qoo`03001oogoo00moo`03001oogoo02aoo`03001oogoo039oo`40005oo`002Goo100000=oo`00
Ool04Goo00<007ooOol0:7oo00<007ooOol047oo00<007ooOol0:goo00<007ooOol0<Woo0@000Goo
000;Ool60004Ool20004Ool30003Ool00`00Oomoo`0XOol2000BOol00`00Oomoo`0ZOol00`00Oomo
o`0bOol10001Ool000Yoo`05001oogooOol00002Ool01000Oomoogoo0P001Goo00<007ooOol00Woo
00<007ooOol0:Goo00<007ooOol04Goo00<007ooOol0:Woo00<007ooOol0<Goo0@000Goo000:Ool0
1@00Oomoogoo00000Woo00<007ooOol01Woo10000goo0P00:Woo00<007ooOol04Woo00<007ooOol0
:Goo00<007ooOol0<7oo0P000Goo000:Ool01@00Oomoogoo00000Woo00<007ooOol01Woo00<007oo
000017oo00<007ooOol0:Goo00<007ooOol04goo00<007ooOol0:7oo00<007ooOol0<Goo0@000Goo
000;Ool500000goo001oo`07Ool00`00Ool00004Ool00`00Oomoo`0YOol00`00Oomoo`0DOol00`00
Oomoo`0XOol00`00Oomoo`0`Ool10001Ool000moo`8000Yoo`8000Aoo`03001oogoo02Uoo`03001o
ogoo01Eoo`8002Qoo`03001oogoo031oo`40005oo`002Woo1@004Woo00<007ooOol0:Goo0P0067oo
00<007ooOol09Goo00<007ooOol0<7oo0@000Goo000:Ool01000Oomoo`004goo00<007ooOol0:Woo
00<007ooOol05Woo00<007ooOol09Woo00<007ooOol0;goo0@000Goo000:Ool01000Oomoo`004goo
00<007ooOol0:Woo00<007ooOol05goo00<007ooOol09Goo00<007ooOol0;goo0@000Goo000:Ool0
1000Oomoo`004goo00<007ooOol0:Woo00<007ooOol067oo00<007ooOol097oo00<007ooOol0;goo
0@000Goo0009Ool200000goo0000000COol00`00Oomoo`16Ool00`00Oomoo`0TOol00`00Oomoo`0^
Ool10001Ool0025oo`03001oogoo02Yoo`03001oogoo01Yoo`03001oogoo02=oo`03001oogoo02io
o`40005oo`002Woo1@004Woo00<007ooOol0:goo00<007ooOol06Woo00<007ooOol08Woo00<007oo
Ool0;Woo0@000Goo000:Ool01000Oomoo`004goo00<007ooOol0BWoo00<007ooOol08Goo00<007oo
Ool0;Goo0@000Goo000:Ool4000COol00`00Oomoo`0[Ool00`00Oomoo`0LOol00`00Oomoo`1AOol1
0001Ool000eoo`03001oogoo015oo`03001oogoo02]oo`03001oogoo01eoo`03001oogoo021oo`03
001oogoo02eoo`40005oo`002goo0`004goo00<007ooOol0C7oo00<007ooOol07goo00<007ooOol0
;Goo0@000Goo000QOol00`00Oomoo`0/Ool00`00Oomoo`0NOol00`00Oomoo`1>Ool10001Ool000Yo
o`800003Ool00000019oo`03001oogoo02aoo`03001oogoo01moo`03001oogoo01ioo`03001oogoo
02aoo`40005oo`002Woo00@007ooOol001=oo`03001oogoo04moo`03001oogoo01eoo`03001oogoo
02aoo`40005oo`002Woo00@007ooOol001=oo`03001oogoo02eoo`03001oogoo021oo`8004aoo`40
005oo`002Woo00@007ooOol001=oo`03001oogoo02eoo`03001oogoo029oo`03001oogoo01]oo`03
001oogoo02]oo`40005oo`002Goo1@004goo00<007ooOol0;Goo00<007ooOol0@7oo00<007ooOol0
:goo0@000Goo000QOol00`00Oomoo`0]Ool00`00Oomoo`0SOol00`00Oomoo`18Ool10001Ool000]o
o`<001=oo`03001oogoo02ioo`03001oogoo02=oo`03001oogoo01Uoo`03001oogoo02]oo`40005o
o`002goo00@007ooOol0019oo`03001oogoo02ioo`03001oogoo02Aoo`03001oogoo01Uoo`03001o
ogoo02Yoo`40005oo`002goo00<007ooOol04goo00<007ooOol0;Woo00<007ooOol09Goo00<007oo
Ool067oo00<007ooOol0:Woo0@000Goo000;Ool00`00Oomoo`0COol00`00Oomoo`0_Ool00`00Oomo
o`0UOol00`00Oomoo`0GOol00`00Oomoo`0ZOol10001Ool000Yoo`@001=oo`03001oogoo02moo`03
001oogoo02Ioo`03001oogoo01Ioo`03001oogoo02Yoo`40005oo`002goo00<007ooOol04goo00<0
07ooOol0;goo00<007ooOol0:7oo00<007ooOol057oo00<007ooOol0:Woo0@000Goo000:Ool5000B
Ool00`00Oomoo`0`Ool00`00Oomoo`0WOol00`00Oomoo`0DOol00`00Oomoo`0ZOol10001Ool000Yo
o`05001oogoo001oo`020004Ool20004Ool20004Ool00`00Oomoo`0`Ool00`00Oomoo`0XOol00`00
Oomoo`0DOol00`00Oomoo`0YOol10001Ool000Yoo`03001oogoo0080009oo`04001oogooOol20003
Ool01000Oomoo`000goo00<007ooOol0<7oo00<007ooOol0:Goo00<007ooOol04goo00<007ooOol0
:Goo0@000Goo000:Ool00`00Oomoo`020002Ool00`00Oomoo`06Ool01000Oomoo`000goo0P00<Woo
00<007ooOol0:Goo00<007ooOol04Woo00<007ooOol0:7oo0P000Goo0009Ool2000017oo00000000
0Woo00<007ooOol01Woo0`0017oo00<007ooOol0<Goo00<007ooOol0:Woo00<007ooOol04Goo00<0
07ooOol0:Goo0@000Goo000>Ool01000Oomoo`0027oo00<007ooOol017oo00<007ooOol0<Goo00<0
07ooOol0:goo00<007ooOol047oo00<007ooOol0:Goo0@000Goo000:Ool01000Ool007oo0`002Woo
0`000goo00<007ooOol0<Woo00<007ooOol0:goo00<007ooOol03goo00<007ooOol0:Goo0@000Goo
000:Ool01@00Ool007oo00004Woo00<007ooOol0<Woo00<007ooOol0;7oo0P0047oo00<007ooOol0
:7oo0@000Goo000:Ool01@00Ool007oo00004Woo00<007ooOol0<Woo00<007ooOol0?Woo00<007oo
Ool0:7oo0@000Goo000:Ool01@00Ool007oo00004Woo00<007ooOol0<goo00<007ooOol0;Goo00<0
07ooOol03Goo00<007ooOol0:7oo0@000Goo0009Ool6000BOol00`00Oomoo`0cOol00`00Oomoo`0^
Ool00`00Oomoo`0<Ool00`00Oomoo`0XOol10001Ool0025oo`03001oogoo03=oo`80031oo`03001o
ogoo00]oo`03001oogoo02Qoo`40005oo`008Goo00<007ooOol0=7oo00<007ooOol0;goo00<007oo
Ool02Woo00<007ooOol0:7oo0@000Goo000QOol00`00Oomoo`0dOol00`00Oomoo`0`Ool00`00Oomo
o`09Ool00`00Oomoo`0XOol10001Ool0025oo`03001oogoo03Eoo`03001oogoo031oo`03001oogoo
00Qoo`03001oogoo02Qoo`40005oo`008Goo00<007ooOol0=Goo00<007ooOol0<Woo00<007ooOol0
1Woo00<007ooOol0:7oo0@000Goo000QOol00`00Oomoo`0eOol00`00Oomoo`0bOol00`00Oomoo`06
Ool2000YOol10001Ool0025oo`03001oogoo03Ioo`03001oogoo039oo`03001oogoo031oo`40005o
o`008Goo00<007ooOol0=Woo0P00=7oo00<007ooOol01Goo00<007ooOol09goo0@000Goo000QOol0
0`00Oomoo`1]Ool00`00Oomoo`04Ool00`00Oomoo`0WOol10001Ool0025oo`03001oogoo03Moo`03
001oogoo03Aoo`03001oogoo00=oo`03001oogoo02Moo`40005oo`008Goo00<007ooOol0>7oo00<0
07ooOol0=7oo00<007ooOol00Woo00<007ooOol09goo0@000Goo000QOol00`00Oomoo`0hOol00`00
Oomoo`0eOol20002Ool00`00Oomoo`0WOol10001Ool0025oo`03001oogoo03Qoo`03001oogoo03Mo
o`03001oo`0002Uoo`40005oo`008Goo00<007ooOol0>Goo00<007ooOol0HWoo0@000Goo000QOol0
0`00Oomoo`0jOol00`00Oomoo`0fOol2000YOol10001Ool0025oo`03001oogoo03Yoo`03001oogoo
03Moo`03001oogoo02Moo`40005oo`008Goo00<007ooOol0>Woo00<007ooOol0=goo0P00:7oo0@00
0Goo000QOol00`00Oomoo`0kOol00`00Oomoo`0fOol00`00Ool0000WOol10001Ool0025oo`03001o
ogoo03aoo`03001oogoo03Eoo`03001oogoo008002Eoo`40005oo`008Goo00<007ooOol0?7oo00<0
07ooOol0=Goo00<007ooOol00Woo00<007ooOol08Woo0@000Goo000?Ool20004Ool20004Ool20004
Ool00`00Oomoo`1dOol00`00Oomoo`03Ool00`00Oomoo`0QOol10001Ool000ioo`04001oogoo0003
Ool20003Ool01000Oomoo`000goo00<007ooOol0?Goo00<007ooOol0>Woo00<007ooOol08Goo0@00
0Goo000>Ool01000Oomoo`0027oo00@007ooOol000=oo`8003moo`03001oogoo03=oo`03001oogoo
00Aoo`03001oogoo01moo`80005oo`003Woo00@007ooOol000Uoo`8000Aoo`03001oogoo03ioo`80
03Aoo`03001oogoo00Eoo`03001oogoo01moo`40005oo`003Woo00@007ooOol000Qoo`04001oogoo
0003Ool00`00Oomoo`0oOol00`00Oomoo`0aOol00`00Oomoo`07Ool00`00Oomoo`0NOol10001Ool0
00moo`8000Yoo`8000Aoo`03001oogoo041oo`03001oogoo031oo`03001oogoo00Qoo`03001oogoo
01eoo`40005oo`008Goo00<007ooOol0@7oo00<007ooOol0<7oo00<007ooOol02Goo00<007ooOol0
77oo0@000Goo000QOol00`00Oomoo`11Ool00`00Oomoo`0_Ool00`00Oomoo`0;Ool00`00Oomoo`0J
Ool10001Ool0025oo`03001oogoo045oo`03001oogoo02moo`03001oogoo00]oo`8001]oo`40005o
o`008Goo00<007ooOol0@Woo00<007ooOol0;Woo00<007ooOol0:7oo0@000Goo000QOol00`00Oomo
o`13Ool00`00Oomoo`0]Ool00`00Oomoo`0=Ool00`00Oomoo`0HOol10001Ool0025oo`03001oogoo
04Aoo`03001oogoo02aoo`03001oogoo00ioo`03001oogoo01Moo`40005oo`008Goo00<007ooOol0
A7oo00<007ooOol0:goo00<007ooOol047oo00<007ooOol05Woo0@000Goo000QOol00`00Oomoo`15
Ool00`00Oomoo`0ZOol00`00Oomoo`0AOol00`00Oomoo`0EOol10001Ool0025oo`03001oogoo04Io
o`03001oogoo02Uoo`03001oogoo019oo`8001Eoo`40005oo`008Goo00<007ooOol0Agoo00<007oo
Ool0:7oo00<007ooOol057oo00<007ooOol04Woo0@000Goo000QOol00`00Oomoo`17Ool00`00Oomo
o`0WOol00`00Oomoo`0FOol00`00Oomoo`0AOol10001Ool0025oo`03001oogoo04Qoo`03001oogoo
02Ioo`03001oogoo01Ioo`03001oogoo015oo`40005oo`008Goo00<007ooOol0BGoo00<007ooOol0
9Goo00<007ooOol05goo00<007ooOol047oo0@000Goo000QOol00`00Oomoo`1:Ool00`00Oomoo`0S
Ool00`00Oomoo`0IOol00`00Oomoo`0?Ool10001Ool0025oo`03001oogoo04Yoo`8002Aoo`03001o
ogoo01Yoo`03001oogoo00ioo`40005oo`008Goo00<007ooOol0Bgoo00<007ooOol08Goo0P007Goo
00<007ooOol03Goo0@000Goo000QOol00`00Oomoo`1<Ool2000QOol00`00Oomoo`0MOol00`00Oomo
o`0<Ool10001Ool0025oo`03001oogoo04eoo`80021oo`03001oogoo01moo`03001oogoo00Yoo`40
005oo`008Goo00<007ooOol0CWoo00<007ooOol07Goo00<007ooOol08Goo00<007ooOol02Goo0@00
0Goo000QOol00`00Oomoo`1?Ool2000LOol2000_Ool10001Ool0025oo`03001oogoo051oo`8001]o
o`03001oogoo02=oo`03001oogoo00Qoo`40005oo`008Goo00<007ooOol0DGoo0P006Goo0P009Woo
00<007ooOol01goo0@000Goo000QOol00`00Oomoo`1COol2000FOol2000XOol00`00Oomoo`06Ool1
0001Ool0025oo`03001oogoo05Aoo`8001Aoo`8002Yoo`03001oogoo00Eoo`40005oo`008Goo00<0
07ooOol0EGoo0`004Goo0P00;7oo0P001Goo0@000Goo000JOol30004Ool00`00Oomoo`1GOol2000?
Ool2000_Ool00`00Oomoo`02Ool10001Ool001]oo`03001oogoo00=oo`03001oogoo05Uoo`<000Yo
o`80039oo`05001oogooOol00001Ool001]oo`03001oogoo00=oo`8005eoo`X003Eoo`04001oo`00
0001Ool001]oo`03001oogoo00=oo`03001oogoo09ioo`40005oo`006goo00<007ooOol00goo00<0
07ooOol0WWoo0@000Goo000JOol20005Ool01000Oomoo`001goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00@007ooOol0005oo`008GooXP000Goo0034Ool00<Ao
o`00a7oo0034Ool00<Aoo`00\
\>"],
  ImageRangeCache->{{{0, 195}, {195, 0}} -> {-0.239331, -0.205162, 
  0.00648793, 0.00648793}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The more extreme cases can be quite illuminating.  For example, we \
can set the probability of Method A returning a \"0\" to be 0 (p0A=0) and the \
probability of Method B returning a \"0\" to be 0.4 (p0B=0.4). The quantum \
probability can often far exceed the classical probability.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["PhaseDiagram[0, .4];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.02381 .02381 Mdot
.02385 .02385 Mdot
.02396 .02396 Mdot
.02415 .02414 Mdot
.02442 .02438 Mdot
.02476 .02469 Mdot
.02518 .02506 Mdot
.02567 .02549 Mdot
.02624 .02598 Mdot
.02689 .02651 Mdot
.02761 .0271 Mdot
.0284 .02774 Mdot
.02927 .02842 Mdot
.03021 .02915 Mdot
.03123 .02992 Mdot
.03232 .03073 Mdot
.03348 .03158 Mdot
.03471 .03247 Mdot
.03602 .0334 Mdot
.0374 .03436 Mdot
.03885 .03536 Mdot
.04036 .03639 Mdot
.04195 .03745 Mdot
.04361 .03854 Mdot
.04533 .03966 Mdot
.04713 .04081 Mdot
.04899 .04199 Mdot
.05091 .04319 Mdot
.0529 .04442 Mdot
.05496 .04568 Mdot
.05708 .04696 Mdot
.05926 .04826 Mdot
.06151 .04958 Mdot
.06381 .05093 Mdot
.06618 .0523 Mdot
.0686 .05369 Mdot
.07108 .0551 Mdot
.07363 .05653 Mdot
.07622 .05798 Mdot
.07887 .05946 Mdot
.08158 .06094 Mdot
.08434 .06245 Mdot
.08715 .06398 Mdot
.09001 .06552 Mdot
.09292 .06709 Mdot
.09588 .06867 Mdot
.09889 .07026 Mdot
.10195 .07188 Mdot
.10504 .07351 Mdot
.10819 .07516 Mdot
.11137 .07682 Mdot
.1146 .0785 Mdot
.11786 .0802 Mdot
.12117 .08191 Mdot
.12451 .08364 Mdot
.12789 .08538 Mdot
.1313 .08714 Mdot
.13474 .08892 Mdot
.13822 .09071 Mdot
.14173 .09252 Mdot
.14527 .09434 Mdot
.14883 .09618 Mdot
.15242 .09804 Mdot
.15603 .09991 Mdot
.15967 .1018 Mdot
.16333 .1037 Mdot
.16701 .10562 Mdot
.17071 .10756 Mdot
.17443 .10951 Mdot
.17816 .11148 Mdot
.18191 .11347 Mdot
.18567 .11547 Mdot
.18944 .11749 Mdot
.19322 .11953 Mdot
.19701 .12159 Mdot
.20081 .12366 Mdot
.20461 .12575 Mdot
.20842 .12786 Mdot
.21223 .12999 Mdot
.21604 .13213 Mdot
.21985 .1343 Mdot
.22365 .13648 Mdot
.22746 .13869 Mdot
.23125 .14091 Mdot
.23505 .14315 Mdot
.23883 .14542 Mdot
.2426 .1477 Mdot
.24636 .15001 Mdot
.25011 .15233 Mdot
.25384 .15468 Mdot
.25756 .15705 Mdot
.26126 .15945 Mdot
.26495 .16186 Mdot
.26861 .1643 Mdot
.27225 .16677 Mdot
.27586 .16925 Mdot
.27946 .17177 Mdot
.28302 .17431 Mdot
.28656 .17687 Mdot
.29007 .17946 Mdot
.29355 .18208 Mdot
.297 .18472 Mdot
.30041 .1874 Mdot
.30379 .1901 Mdot
.30714 .19283 Mdot
.31045 .19559 Mdot
.31372 .19838 Mdot
.31695 .2012 Mdot
.32013 .20406 Mdot
.32328 .20694 Mdot
.32638 .20986 Mdot
.32944 .21282 Mdot
.33245 .21581 Mdot
.33541 .21883 Mdot
.33833 .22189 Mdot
.3412 .22499 Mdot
.34401 .22813 Mdot
.34677 .2313 Mdot
.34948 .23452 Mdot
.35214 .23777 Mdot
.35474 .24107 Mdot
.35729 .24441 Mdot
.35977 .24779 Mdot
.3622 .25122 Mdot
.36457 .2547 Mdot
.36688 .25822 Mdot
.36913 .26179 Mdot
.37132 .26541 Mdot
.37345 .26908 Mdot
.37551 .2728 Mdot
.3775 .27657 Mdot
.37943 .2804 Mdot
.3813 .28429 Mdot
.3831 .28823 Mdot
.38483 .29223 Mdot
.38649 .29629 Mdot
.38808 .30041 Mdot
.38961 .30459 Mdot
.39106 .30884 Mdot
.39244 .31316 Mdot
.39376 .31754 Mdot
.395 .32199 Mdot
.39616 .32652 Mdot
.39726 .33111 Mdot
.39828 .33579 Mdot
.39923 .34053 Mdot
.4001 .34536 Mdot
.4009 .35027 Mdot
.40163 .35526 Mdot
.40228 .36034 Mdot
.40286 .3655 Mdot
.40336 .37076 Mdot
.40378 .3761 Mdot
.40413 .38154 Mdot
.4044 .38708 Mdot
.4046 .39272 Mdot
.40472 .39845 Mdot
.40476 .40429 Mdot
.40473 .41024 Mdot
.40462 .4163 Mdot
.40444 .42246 Mdot
.40418 .42874 Mdot
.40384 .43514 Mdot
.40343 .44166 Mdot
.40294 .44831 Mdot
.40238 .45507 Mdot
.40174 .46197 Mdot
.40103 .469 Mdot
.40024 .47616 Mdot
.39937 .48346 Mdot
.39844 .49089 Mdot
.39743 .49847 Mdot
.39634 .5062 Mdot
.39519 .51407 Mdot
.39396 .5221 Mdot
.39266 .53027 Mdot
.39129 .5386 Mdot
.38984 .54709 Mdot
.38833 .55574 Mdot
.38675 .56455 Mdot
.3851 .57353 Mdot
.38338 .58266 Mdot
.38159 .59197 Mdot
.37974 .60143 Mdot
.37781 .61107 Mdot
.37583 .62087 Mdot
.37378 .63083 Mdot
.37166 .64096 Mdot
.36949 .65124 Mdot
.36725 .66169 Mdot
.36495 .67229 Mdot
.36259 .68304 Mdot
.36017 .69393 Mdot
.35769 .70495 Mdot
.35515 .71611 Mdot
.35256 .72738 Mdot
.34991 .73876 Mdot
.34721 .75023 Mdot
.34445 .76177 Mdot
.34165 .77338 Mdot
.33879 .78503 Mdot
.33588 .7967 Mdot
.33293 .80836 Mdot
.32992 .81998 Mdot
.32687 .83155 Mdot
.32378 .84302 Mdot
.32064 .85436 Mdot
.31746 .86552 Mdot
.31423 .87647 Mdot
.31097 .88717 Mdot
.30767 .89754 Mdot
.30433 .90756 Mdot
.30096 .91715 Mdot
.29755 .92627 Mdot
.2941 .93483 Mdot
.29063 .94279 Mdot
.28712 .95008 Mdot
.28359 .95661 Mdot
.28003 .96233 Mdot
.27644 .96716 Mdot
.27283 .97103 Mdot
.26919 .97387 Mdot
.26553 .97561 Mdot
.26185 .97619 Mdot
.25815 .97555 Mdot
.25444 .97364 Mdot
.25071 .97041 Mdot
.24696 .96583 Mdot
.2432 .95986 Mdot
.23943 .95248 Mdot
.23565 .94369 Mdot
.23186 .93349 Mdot
.22806 .92189 Mdot
.22426 .90893 Mdot
.22045 .89465 Mdot
.21665 .8791 Mdot
.21284 .86234 Mdot
.20903 .84445 Mdot
.20522 .82552 Mdot
.20142 .80563 Mdot
.19762 .78488 Mdot
.19383 .76339 Mdot
.19004 .74126 Mdot
.18627 .7186 Mdot
.18251 .69553 Mdot
.17876 .67215 Mdot
.17502 .64857 Mdot
.1713 .62489 Mdot
.1676 .60123 Mdot
.16392 .57765 Mdot
.16025 .55427 Mdot
.15661 .53115 Mdot
.15299 .50837 Mdot
.1494 .48599 Mdot
.14583 .46407 Mdot
.14229 .44267 Mdot
.13878 .42181 Mdot
.1353 .40154 Mdot
.13185 .38188 Mdot
.12843 .36286 Mdot
.12504 .3445 Mdot
.1217 .3268 Mdot
.11839 .30977 Mdot
.11511 .29341 Mdot
.11188 .27772 Mdot
.10869 .26269 Mdot
.10554 .24832 Mdot
.10244 .23459 Mdot
.09937 .2215 Mdot
.09636 .20902 Mdot
.09339 .19715 Mdot
.09047 .18586 Mdot
.0876 .17514 Mdot
.08478 .16496 Mdot
.08202 .15531 Mdot
.0793 .14617 Mdot
.07664 .13753 Mdot
.07403 .12935 Mdot
.07149 .12163 Mdot
.06899 .11434 Mdot
.06656 .10746 Mdot
.06418 .10099 Mdot
.06187 .09489 Mdot
.05961 .08916 Mdot
.05742 .08377 Mdot
.05529 .07871 Mdot
.05323 .07397 Mdot
.05123 .06953 Mdot
.04929 .06538 Mdot
.04742 .0615 Mdot
.04562 .05787 Mdot
.04388 .0545 Mdot
.04221 .05136 Mdot
.04061 .04845 Mdot
.03908 .04575 Mdot
.03762 .04325 Mdot
.03623 .04095 Mdot
.03492 .03883 Mdot
.03367 .03689 Mdot
.0325 .03511 Mdot
.0314 .03349 Mdot
.03037 .03202 Mdot
.02941 .0307 Mdot
.02853 .02951 Mdot
.02773 .02845 Mdot
.027 .02752 Mdot
.02634 .0267 Mdot
.02576 .026 Mdot
.02525 .0254 Mdot
.02482 .02491 Mdot
.02447 .02451 Mdot
.02419 .02421 Mdot
.02399 .02399 Mdot
.02386 .02386 Mdot
.02381 .02381 Mdot
.02384 .02384 Mdot
.02394 .02394 Mdot
.02412 .0241 Mdot
.02437 .02434 Mdot
.0247 .02464 Mdot
.02511 .025 Mdot
.02559 .02542 Mdot
.02615 .02589 Mdot
.02678 .02642 Mdot
.02749 .027 Mdot
.02827 .02763 Mdot
.02913 .02831 Mdot
.03006 .02903 Mdot
.03106 .02979 Mdot
.03214 .0306 Mdot
.03329 .03145 Mdot
.03451 .03233 Mdot
.03581 .03325 Mdot
.03717 .03421 Mdot
.03861 .0352 Mdot
.04012 .03622 Mdot
.04169 .03728 Mdot
.04334 .03837 Mdot
.04505 .03948 Mdot
.04684 .04063 Mdot
.04869 .0418 Mdot
.0506 .043 Mdot
.05258 .04422 Mdot
.05463 .04548 Mdot
.05674 .04675 Mdot
.05891 .04805 Mdot
.06114 .04937 Mdot
.06344 .05071 Mdot
.0658 .05208 Mdot
.06821 .05347 Mdot
.07069 .05488 Mdot
.07322 .0563 Mdot
.0758 .05775 Mdot
.07845 .05922 Mdot
.08115 .06071 Mdot
.0839 .06221 Mdot
.0867 .06374 Mdot
.08955 .06528 Mdot
.09246 .06684 Mdot
.09541 .06841 Mdot
.09841 .07001 Mdot
.10146 .07162 Mdot
.10455 .07325 Mdot
.10768 .07489 Mdot
.11086 .07655 Mdot
.11408 .07823 Mdot
.11734 .07992 Mdot
.12064 .08163 Mdot
.12397 .08336 Mdot
.12735 .0851 Mdot
.13075 .08686 Mdot
.13419 .08863 Mdot
.13767 .09042 Mdot
.14117 .09223 Mdot
.1447 .09405 Mdot
.14826 .09589 Mdot
.15185 .09774 Mdot
.15546 .09961 Mdot
.15909 .1015 Mdot
.16275 .1034 Mdot
.16643 .10532 Mdot
.17012 .10725 Mdot
.17384 .1092 Mdot
.17757 .11117 Mdot
.18131 .11315 Mdot
.18507 .11515 Mdot
.18884 .11717 Mdot
.19262 .11921 Mdot
.19641 .12126 Mdot
.20021 .12333 Mdot
.20401 .12542 Mdot
.20781 .12752 Mdot
.21162 .12965 Mdot
.21543 .13179 Mdot
.21924 .13395 Mdot
.22305 .13613 Mdot
.22685 .13833 Mdot
.23065 .14055 Mdot
.23444 .14279 Mdot
.23823 .14505 Mdot
.242 .14734 Mdot
.24576 .14964 Mdot
.24951 .15196 Mdot
.25325 .15431 Mdot
.25697 .15667 Mdot
.26068 .15906 Mdot
.26436 .16148 Mdot
.26803 .16391 Mdot
.27167 .16637 Mdot
.27529 .16886 Mdot
.27889 .17136 Mdot
.28246 .1739 Mdot
.286 .17646 Mdot
.28952 .17905 Mdot
.293 .18166 Mdot
.29645 .1843 Mdot
.29987 .18697 Mdot
.30326 .18966 Mdot
.30661 .19239 Mdot
.30992 .19515 Mdot
.3132 .19793 Mdot
.31643 .20075 Mdot
.31963 .2036 Mdot
.32278 .20648 Mdot
.32589 .2094 Mdot
.32895 .21234 Mdot
.33197 .21533 Mdot
.33495 .21835 Mdot
.33787 .2214 Mdot
.34074 .22449 Mdot
.34357 .22762 Mdot
.34634 .23079 Mdot
.34906 .234 Mdot
.35172 .23725 Mdot
.35433 .24054 Mdot
.35689 .24387 Mdot
.35938 .24725 Mdot
.36182 .25067 Mdot
.3642 .25414 Mdot
.36652 .25765 Mdot
.36878 .26122 Mdot
.37098 .26483 Mdot
.37311 .26849 Mdot
.37518 .2722 Mdot
.37719 .27597 Mdot
.37913 .27979 Mdot
.38101 .28366 Mdot
.38281 .2876 Mdot
.38456 .29159 Mdot
.38623 .29564 Mdot
.38783 .29975 Mdot
.38937 .30392 Mdot
.39083 .30816 Mdot
.39223 .31246 Mdot
.39355 .31684 Mdot
.3948 .32128 Mdot
.39598 .32579 Mdot
.39709 .33038 Mdot
.39812 .33504 Mdot
.39908 .33977 Mdot
.39997 .34459 Mdot
.40078 .34948 Mdot
.40152 .35446 Mdot
.40218 .35953 Mdot
.40277 .36468 Mdot
.40328 .36992 Mdot
.40372 .37525 Mdot
.40408 .38067 Mdot
.40436 .38619 Mdot
.40457 .39181 Mdot
.4047 .39753 Mdot
.40476 .40336 Mdot
.40474 .40928 Mdot
.40464 .41532 Mdot
.40447 .42147 Mdot
.40422 .42774 Mdot
.4039 .43412 Mdot
.4035 .44062 Mdot
.40302 .44724 Mdot
.40247 .45399 Mdot
.40185 .46086 Mdot
.40114 .46787 Mdot
.40037 .47501 Mdot
.39952 .48228 Mdot
.39859 .4897 Mdot
.39759 .49726 Mdot
.39652 .50496 Mdot
.39538 .51281 Mdot
.39416 .52081 Mdot
.39287 .52896 Mdot
.39151 .53727 Mdot
.39008 .54573 Mdot
.38858 .55435 Mdot
.38701 .56314 Mdot
.38536 .57209 Mdot
.38366 .5812 Mdot
.38188 .59047 Mdot
.38003 .59991 Mdot
.37812 .60952 Mdot
.37615 .61929 Mdot
.37411 .62923 Mdot
.372 .63933 Mdot
.36984 .64959 Mdot
.36761 .66002 Mdot
.36532 .67059 Mdot
.36297 .68131 Mdot
.36055 .69218 Mdot
.35809 .70319 Mdot
.35556 .71432 Mdot
.35298 .72558 Mdot
.35034 .73694 Mdot
.34764 .74839 Mdot
.3449 .75993 Mdot
.3421 .77153 Mdot
.33925 .78317 Mdot
.33635 .79484 Mdot
.3334 .8065 Mdot
.3304 .81814 Mdot
.32736 .82971 Mdot
.32427 .8412 Mdot
.32114 .85256 Mdot
.31797 .86376 Mdot
.31475 .87475 Mdot
.31149 .88548 Mdot
.3082 .89591 Mdot
.30486 .90599 Mdot
.3015 .91566 Mdot
.29809 .92485 Mdot
.29465 .93351 Mdot
.29118 .94157 Mdot
.28768 .94896 Mdot
.28415 .95562 Mdot
.2806 .96148 Mdot
.27701 .96645 Mdot
.2734 .97048 Mdot
.26977 .97348 Mdot
.26611 .97541 Mdot
.26244 .97618 Mdot
.25874 .97574 Mdot
.25503 .97404 Mdot
.2513 .97102 Mdot
.24756 .96665 Mdot
.2438 .9609 Mdot
.24003 .95375 Mdot
.23625 .94518 Mdot
.23246 .9352 Mdot
.22867 .92383 Mdot
.22487 .91109 Mdot
.22106 .89701 Mdot
.21725 .88166 Mdot
.21344 .86509 Mdot
.20963 .84737 Mdot
.20583 .8286 Mdot
.20202 .80885 Mdot
.19822 .78824 Mdot
.19443 .76686 Mdot
.19065 .74483 Mdot
.18687 .72224 Mdot
.18311 .69923 Mdot
.17936 .67589 Mdot
.17562 .65233 Mdot
.1719 .62867 Mdot
.16819 .60499 Mdot
.1645 .5814 Mdot
.16084 .55798 Mdot
.15719 .53481 Mdot
.15357 .51197 Mdot
.14997 .48953 Mdot
.1464 .46753 Mdot
.14285 .44604 Mdot
.13934 .42509 Mdot
.13585 .40473 Mdot
.13239 .38497 Mdot
.12897 .36585 Mdot
.12558 .34738 Mdot
.12223 .32957 Mdot
.11891 .31243 Mdot
.11563 .29597 Mdot
.11239 .28017 Mdot
.1092 .26504 Mdot
.10604 .25057 Mdot
.10293 .23674 Mdot
.09986 .22354 Mdot
.09684 .21097 Mdot
.09386 .199 Mdot
.09093 .18762 Mdot
.08806 .17681 Mdot
.08523 .16654 Mdot
.08245 .15681 Mdot
.07973 .1476 Mdot
.07706 .13887 Mdot
.07445 .13062 Mdot
.07189 .12283 Mdot
.06939 .11547 Mdot
.06694 .10853 Mdot
.06456 .10199 Mdot
.06223 .09584 Mdot
.05997 .09005 Mdot
.05777 .0846 Mdot
.05563 .0795 Mdot
.05355 .07471 Mdot
.05154 .07022 Mdot
.04959 .06602 Mdot
.04771 .0621 Mdot
.0459 .05843 Mdot
.04415 .05502 Mdot
.04247 .05185 Mdot
.04086 .0489 Mdot
.03932 .04617 Mdot
.03785 .04364 Mdot
.03645 .04131 Mdot
.03512 .03916 Mdot
.03386 .03719 Mdot
.03268 .03538 Mdot
.03157 .03374 Mdot
.03053 .03225 Mdot
.02956 .0309 Mdot
.02867 .02969 Mdot
.02785 .02861 Mdot
.02711 .02766 Mdot
.02644 .02683 Mdot
.02585 .02611 Mdot
.02533 .02549 Mdot
.02489 .02498 Mdot
.02452 .02457 Mdot
.02423 .02425 Mdot
.02401 .02402 Mdot
.02388 .02388 Mdot
.02381 .02381 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{196, 196},
  ImageMargins->{{35, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000340000a1000`40O003h00Oa7oo0034Ool00<Ao
o`00a7oo001DOol30004Ool20002Ool70002Ool30002Ool300000goo000000030002Ool2000017oo
000000000Woo1000@7oo001EOol00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol00`000goo
0P000goo0P000goo00D007ooOomoo`00009oo`@000=oo`03001oogoo041oo`00EGoo0`000Woo00@0
07ooOol0009oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`03Ool01@00Oomoogoo0000
0Woo00@007ooOol000=oo`03001oogoo041oo`00EGoo00<007oo00000goo0`000Woo00<007ooOol0
0`000Woo0`000Woo0`000Woo0P0017oo1P000goo00<007ooOol0@7oo001DOol40008Ool00`00Oomo
o`0NOol00`00Oomoo`10Ool005moo`80019oo`03001oogoo00Yoo`80049oo`00a7oo0034Ool00<Ao
o`00a7oo0034Ool00<Aoo`00a7oo0034Ool001]oo`03001oogoo01Qoo`03001oogoo009oo`04001o
ogooOol3000DOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0BOol00`00Oomoo`02Ool0
0`00Oomoo`02Ool2000EOol00`00Oomoo`02Ool01000Oomoogoo0`005goo0`001goo000JOol00`00
Ool0000HOol00`00Ool00008Ool00`00Oomoo`0BOol00`00Ool00007Ool3000COol00`00Ool00007
Ool00`00Ool0000DOol00`00Ool00007Ool00`00Ool0000HOol00`00Oomoo`06Ool001Yoo`03001o
o`0001Qoo`03001oo`0000Uoo`03001oogoo015oo`03001oo`0000Moo`03001oo`0001=oo`03001o
o`0000Moo`<001Aoo`03001oo`0000Qoo`03001oogoo01Moo`03001oogoo00Ioo`006Woo00<007oo
000067oo00<007oo00002Goo00<007ooOol04Goo00<007oo000027oo0P004goo00<007oo00001goo
00<007ooOol057oo00<007oo00001goo00<007oo000067oo00<007ooOol01Woo000KOol00`00Oomo
o`0HOol00`00Oomoo`06Ool3000DOol00`00Oomoo`08Ool00`00Oomoo`0BOol00`00Oomoo`07Ool2
000EOol00`00Oomoo`06Ool3000GOol20008Ool00<Aoo`00a7oo0034Ool00<Aoo`005gooZP000goo
000GOol01@00Oomoogoo00007goo00<007ooOol07Goo00<007ooOol07Woo00<007ooOol07Goo00<0
07ooOol07Goo00D007ooOomoo`0000=oo`005goo00<007ooOol0YWoo00<007ooOol00Goo000BOol0
0`00Oomoo`02Ool00`00Oomoo`2VOol00`00Oomoo`01Ool0015oo`03001oo`0000=oo`80009oo`80
0:9oo`8000=oo`004Goo00<007oo00000goo00<007ooOol00Woo0P00XWoo00<007ooOol00Goo000A
Ool00`00Ool00003Ool00`00Oomoo`03Ool3002POol00`00Oomoo`01Ool0019oo`03001oogoo009o
o`03001oogoo00=oo`04001oo`00002OOol00`00Oomoo`01Ool001Moo`03001oogoo00Aoo`03001o
o`00008009eoo`03001oogoo005oo`005goo00<007ooOol017oo0`0000=oo`000000W7oo00<007oo
Ool00Goo000GOol20006Ool00`00Ool00002Ool2002IOol20003Ool001Moo`03001oogoo00Eoo`03
001oogoo0080009oo`8009Qoo`03001oogoo005oo`005goo00<007ooOol01Woo00D007ooOomoo`00
00=oo`8009Ioo`03001oogoo005oo`005goo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol0
0Woo0P00U7oo00<007ooOol00Goo000GOol00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool3002BOol00`00Oomoo`01Ool001Moo`03001oogoo00Moo`03001oogoo00Yoo`80091oo`03001o
ogoo005oo`005goo00<007ooOol027oo00<007ooOol00Woo00<007ooOol01Goo0`00SWoo00<007oo
Ool00Goo000GOol20009Ool00`00Oomoo`03Ool00`00Oomoo`06Ool3002;Ool20003Ool001Moo`03
001oogoo00Qoo`03001oogoo00Aoo`8000Qoo`8008]oo`03001oogoo005oo`005goo00<007ooOol0
2Goo00<007ooOol01Goo00<007ooOol01goo0P00RGoo00<007ooOol00Goo000GOol00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`08Ool20027Ool00`00Oomoo`01Ool001Moo`03001oogoo00Uo
o`03001oogoo00Ioo`03001oogoo00Yoo`8008Eoo`03001oogoo005oo`005goo00<007ooOol02Woo
00<007ooOol01Woo00<007ooOol02goo0P00Pgoo00<007ooOol00Goo000GOol2000;Ool00`00Oomo
o`07Ool00`00Oomoo`0<Ool20020Ool20003Ool001Moo`03001oogoo00Yoo`03001oogoo00Qoo`03
001oogoo00aoo`80081oo`03001oogoo005oo`005goo00<007ooOol02goo00<007ooOol02Goo00<0
07ooOol037oo0P00OWoo00<007ooOol00Goo000GOol00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00
Oomoo`0=Ool2001lOol00`00Oomoo`01Ool001Moo`03001oogoo02Uoo`8007]oo`03001oogoo005o
o`005goo00<007ooOol02goo00<007ooOol02goo00<007ooOol03Woo0`00NGoo00<007ooOol00Goo
000GOol2000=Ool00`00Oomoo`0;Ool00`00Oomoo`0?Ool2001gOol20003Ool001Moo`03001oogoo
00aoo`03001oogoo00aoo`80011oo`<007Ioo`03001oogoo005oo`005goo00<007ooOol037oo00<0
07ooOol03Woo00<007ooOol03goo0P00MGoo00<007ooOol00Goo000GOol00`00Oomoo`0NOol00`00
Oomoo`0?Ool2001dOol00`00Oomoo`01Ool001Moo`03001oogoo00eoo`03001oogoo00ioo`03001o
ogoo011oo`8007=oo`03001oogoo005oo`005goo00<007ooOol07goo00<007ooOol047oo0P00LWoo
00<007ooOol00Goo0009Ool00`00Oomoo`02Ool01000Oomoogoo0`000Woo00<007ooOol03Goo00<0
07ooOol047oo00<007ooOol04Goo00<007ooOol0Kgoo00<007ooOol00Goo0008Ool00`00Ool00008
Ool01000Oomoogoo0P008Woo00<007ooOol04Goo00<007ooOol0KGoo0P000goo0008Ool00`00Ool0
0009Ool01000Oomoo`0047oo00<007ooOol04Woo00<007ooOol047oo00<007ooOol0KGoo00<007oo
Ool00Goo0008Ool00`00Ool00009Ool01000Oomoo`009Woo00<007ooOol047oo00<007ooOol0K7oo
00<007ooOol00Goo0009Ool00`00Oomoo`06Ool30002Ool00`00Oomoo`0>Ool00`00Oomoo`0DOol0
0`00Oomoo`0?Ool2001]Ool00`00Oomoo`01Ool001Moo`03001oogoo00ioo`03001oogoo01Aoo`03
001oogoo011oo`8006aoo`03001oogoo005oo`005goo00<007ooOol09Woo00<007ooOol047oo0P00
Jgoo00<007ooOol00Goo000GOol2000@Ool00`00Oomoo`0EOol2000AOol00`00Oomoo`1XOol20003
Ool001Moo`03001oogoo02Uoo`03001oogoo00moo`03001oogoo06Qoo`03001oogoo005oo`005goo
00<007ooOol03goo00<007ooOol067oo00<007ooOol03Woo0P00JGoo00<007ooOol00Goo000GOol0
0`00Oomoo`0[Ool00`00Oomoo`0>Ool00`00Oomoo`1WOol00`00Oomoo`01Ool001Moo`03001oogoo
03aoo`8006Qoo`03001oogoo005oo`005goo00<007ooOol047oo00<007ooOol06Goo00<007ooOol0
3Woo00<007ooOol0IWoo00<007ooOol00Goo000GOol00`00Oomoo`0]Ool00`00Oomoo`0=Ool2001W
Ool00`00Oomoo`01Ool001Moo`80015oo`03001oogoo01aoo`03001oogoo00aoo`03001oogoo06Ao
o`8000=oo`005goo00<007ooOol04Goo00<007ooOol077oo00<007ooOol02goo0P00IWoo00<007oo
Ool00Goo000GOol00`00Oomoo`0aOol00`00Oomoo`0;Ool00`00Oomoo`1TOol00`00Oomoo`01Ool0
01Moo`03001oogoo015oo`03001oogoo01eoo`03001oogoo00]oo`03001oogoo06Aoo`03001oogoo
005oo`005goo00<007ooOol0<Woo00<007ooOol02Woo00<007ooOol0I7oo00<007ooOol00Goo000G
Ool00`00Oomoo`0cOol00`00Oomoo`0:Ool00`00Oomoo`1SOol00`00Oomoo`01Ool001Moo`8001=o
o`03001oogoo01moo`03001oogoo00Uoo`03001oogoo069oo`8000=oo`005goo00<007ooOol0=Woo
00<007ooOol01goo00<007ooOol0Hgoo00<007ooOol00Goo000GOol00`00Oomoo`0gOol00`00Oomo
o`06Ool00`00Oomoo`1SOol00`00Oomoo`01Ool001Moo`03001oogoo019oo`03001oogoo02aoo`03
001oogoo069oo`03001oogoo005oo`005goo00<007ooOol0>7oo00<007ooOol01Woo00<007ooOol0
HWoo00<007ooOol00Goo000GOol00`00Oomoo`0iOol00`00Oomoo`05Ool00`00Oomoo`1ROol00`00
Oomoo`01Ool001Moo`03001oogoo01=oo`03001oogoo02Aoo`8000Eoo`03001oogoo069oo`03001o
ogoo005oo`005goo0P00?Goo00<007ooOol00Woo00<007ooOol0HGoo0P000goo000GOol00`00Oomo
o`0mOol01@00Oomoogoo0000I7oo00<007ooOol00Goo000GOol00`00Oomoo`0COol00`00Oomoo`0W
Ool01@00Oomoogoo0000I7oo00<007ooOol00Goo000GOol00`00Oomoo`0COol00`00Oomoo`0XOol0
1000Oomoo`00I7oo00<007ooOol00Goo0002Ool3000BOol00`00Oomoo`0oOol00`00Ool0001TOol0
0`00Oomoo`01Ool000=oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`04001oogoo
0012Ool2001TOol00`00Oomoo`01Ool000=oo`<0009oo`03001oo`0000Moo`<0009oo`8001Eoo`03
001oogoo02Yoo`80069oo`8000=oo`000goo00<007oo00000`0000=oo`00Ool01Woo00<007oo0000
0Woo00<007ooOol0@Goo00<007oo0000HWoo00<007ooOol00Goo0002Ool5000017oo001oo`0027oo
0P000Woo00<007ooOol0@Goo00@007ooOol0065oo`03001oogoo005oo`0017oo0`000Woo00<007oo
Ool027oo00@007ooOol001Ioo`8002]oo`04001oogoo001QOol00`00Oomoo`01Ool000=oo`04001o
ogoo000@Ool00`00Oomoo`11Ool01@00Oomoogoo0000H7oo00<007ooOol00Goo0003Ool01000Oomo
o`0047oo00<007ooOol0@Goo00<007ooOol00Woo0P00GWoo00<007ooOol00Goo0004Ool3000@Ool2
000FOol00`00Oomoo`0YOol00`00Oomoo`04Ool00`00Oomoo`1JOol20003Ool001Moo`03001oogoo
01Eoo`03001oogoo02Uoo`03001oogoo00Eoo`03001oogoo05Yoo`03001oogoo005oo`000goo0`00
4Goo00<007ooOol0@Goo00<007ooOol01Woo00<007ooOol0FGoo00<007ooOol00Goo0003Ool00`00
Ool0000AOol00`00Oomoo`11Ool00`00Oomoo`1ROol00`00Oomoo`01Ool000=oo`03001oo`00015o
o`03001oogoo01Ioo`03001oogoo02Qoo`03001oogoo00Moo`03001oogoo05Qoo`03001oogoo005o
o`000Woo0P0000=oo`00Ool047oo00<007ooOol05Woo00<007ooOol0:7oo00<007ooOol027oo00<0
07ooOol0Egoo00<007ooOol00Goo000GOol00`00Oomoo`11Ool00`00Oomoo`0:Ool00`00Oomoo`1E
Ool00`00Oomoo`01Ool000=oo`<0015oo`80045oo`03001oogoo00aoo`03001oogoo05=oo`8000=o
o`000goo0`004Goo00<007ooOol05Woo00<007ooOol09goo00<007ooOol03Goo00<007ooOol0Dgoo
00<007ooOol00Goo0005Ool00`00Oomoo`0?Ool00`00Oomoo`10Ool00`00Oomoo`0=Ool00`00Oomo
o`1COol00`00Oomoo`01Ool000=oo`<0015oo`03001oogoo041oo`03001oogoo00ioo`03001oogoo
059oo`03001oogoo005oo`000goo00<007oo00004Goo00<007ooOol0@7oo00<007ooOol03goo00<0
07ooOol0DGoo00<007ooOol00Goo0003Ool00`00Ool0000AOol00`00Oomoo`0GOol00`00Oomoo`0V
Ool00`00Oomoo`0@Ool00`00Oomoo`1@Ool00`00Oomoo`01Ool000=oo`03001oo`00015oo`8005Io
o`03001oogoo04eoo`8000=oo`000Woo10004Goo00<007ooOol0@7oo00<007ooOol04goo00<007oo
Ool0CGoo00<007ooOol00Goo000GOol00`00Oomoo`0GOol00`00Oomoo`0UOol00`00Oomoo`1TOol0
0`00Oomoo`01Ool000=oo`<0015oo`03001oogoo01Qoo`03001oogoo02Aoo`03001oogoo01Eoo`03
001oogoo04aoo`03001oogoo005oo`000goo00<007ooOol04Goo00<007ooOol0?goo00<007ooOol0
5Woo00<007ooOol0Bgoo00<007ooOol00Goo0003Ool00`00Oomoo`0AOol00`00Oomoo`0oOol00`00
Oomoo`0GOol2001;Ool00`00Oomoo`01Ool0009oo`@0015oo`03001oogoo01Qoo`03001oogoo02Ao
o`03001oogoo01Uoo`03001oogoo04Qoo`03001oogoo005oo`000goo00<007ooOol04Goo0P006Goo
00<007ooOol097oo00<007ooOol06Woo00<007ooOol0AWoo0P000goo0003Ool3000AOol00`00Oomo
o`0nOol00`00Oomoo`0KOol00`00Oomoo`17Ool00`00Oomoo`01Ool000=oo`03001oo`00015oo`03
001oogoo03ioo`03001oogoo01aoo`03001oogoo04Ioo`03001oogoo005oo`000goo00<007oo0000
4Goo00<007ooOol06Goo00<007ooOol08Woo00<007ooOol07Goo0P00AWoo00<007ooOol00Goo0002
Ool200000goo001oo`0@Ool00`00Oomoo`0IOol00`00Oomoo`0ROol00`00Oomoo`0NOol00`00Oomo
o`14Ool00`00Oomoo`01Ool000Uoo`03001oogoo009oo`03001oogoo009oo`80009oo`03001oogoo
03eoo`03001oogoo025oo`03001oogoo049oo`03001oogoo005oo`000Woo00T007oo001oo`00Ool0
07oo00001goo00<007oo00000Woo0P00?Woo00<007ooOol08Woo00<007ooOol0@7oo0P000goo0002
Ool02@00Ool007oo001oo`00Ool00007Ool30002Ool00`00Oomoo`0IOol00`00Oomoo`0QOol00`00
Oomoo`1VOol00`00Oomoo`01Ool0009oo`09001oo`00Ool007oo001oo`0000Moo`03001oogoo009o
o`03001oogoo01Uoo`03001oogoo04Moo`03001oogoo041oo`03001oogoo005oo`000Woo1@000Woo
00<007ooOol01goo0P000Woo00<007ooOol0?Goo00<007ooOol097oo00<007ooOol0?goo00<007oo
Ool00Goo000GOol00`00Oomoo`0mOol00`00Oomoo`0UOol2000oOol00`00Oomoo`01Ool001Moo`03
001oogoo01Yoo`03001oogoo01moo`03001oogoo02Qoo`03001oogoo03aoo`03001oogoo005oo`00
5goo0P006goo00<007ooOol07goo00<007ooOol0:Goo00<007ooOol0>Woo0P000goo000GOol00`00
Oomoo`1YOol00`00Oomoo`0jOol00`00Oomoo`01Ool001Moo`03001oogoo03aoo`03001oogoo06Mo
o`03001oogoo005oo`005goo00<007ooOol06goo00<007ooOol07Goo00<007ooOol0;7oo00<007oo
Ool0>Goo00<007ooOol00Goo000GOol00`00Oomoo`0KOol00`00Oomoo`0MOol00`00Oomoo`0]Ool0
0`00Oomoo`0hOol00`00Oomoo`01Ool001Moo`03001oogoo03]oo`03001oogoo02ioo`8003Qoo`03
001oogoo005oo`005goo00<007ooOol0KWoo00<007ooOol0=Goo00<007ooOol00Goo000GOol2000L
Ool00`00Oomoo`0MOol00`00Oomoo`0aOol00`00Oomoo`0cOol20003Ool001Moo`03001oogoo01]o
o`03001oogoo055oo`03001oogoo03Aoo`03001oogoo005oo`005goo00<007ooOol0>Woo00<007oo
Ool0<goo00<007ooOol0<goo00<007ooOol00Goo000GOol00`00Oomoo`1aOol00`00Oomoo`0bOol0
0`00Oomoo`01Ool001Moo`03001oogoo01aoo`03001oogoo01]oo`03001oogoo03Eoo`03001oogoo
035oo`03001oogoo005oo`005goo00<007ooOol077oo00<007ooOol06Woo00<007ooOol0>7oo00<0
07ooOol0;goo00<007ooOol00Goo000GOol2000jOol00`00Oomoo`0iOol00`00Oomoo`0]Ool20003
Ool001Moo`03001oogoo03Uoo`03001oogoo06Yoo`03001oogoo005oo`005goo00<007ooOol077oo
00<007ooOol06Woo00<007ooOol0>Woo00<007ooOol0;Goo00<007ooOol00Goo000GOol00`00Oomo
o`0MOol00`00Oomoo`0IOol00`00Oomoo`0kOol00`00Oomoo`0/Ool00`00Oomoo`01Ool001Moo`03
001oogoo07Qoo`8002aoo`03001oogoo005oo`005goo00<007ooOol0>7oo00<007ooOol0?goo00<0
07ooOol0:Goo00<007ooOol00Goo000GOol00`00Oomoo`0MOol00`00Oomoo`1KOol00`00Oomoo`0X
Ool00`00Oomoo`01Ool001Moo`8003Uoo`03001oogoo041oo`03001oogoo02Moo`8000=oo`005goo
00<007ooOol0O7oo00<007ooOol09goo00<007ooOol00Goo000GOol00`00Oomoo`0gOol00`00Oomo
o`13Ool00`00Oomoo`0VOol00`00Oomoo`01Ool001Moo`03001oogoo01ioo`03001oogoo05eoo`03
001oogoo02Eoo`03001oogoo005oo`005goo00<007ooOol0=goo00<007ooOol0AWoo00<007ooOol0
8goo00<007ooOol00Goo0009Ool00`00Oomoo`02Ool01000Oomoogoo0`000Woo00<007ooOol0P7oo
0P0097oo00<007ooOol00Goo0008Ool00`00Ool00007Ool00`00Ool00002Ool2000OOol00`00Oomo
o`0EOol00`00Oomoo`19Ool00`00Oomoo`0POol20003Ool000Qoo`03001oo`0000Qoo`05001oogoo
Ool0000QOol00`00Oomoo`1POol00`00Oomoo`0QOol00`00Oomoo`01Ool000Qoo`03001oo`0000Mo
o`03001oo`00009oo`03001oogoo03Ioo`03001oogoo04Yoo`03001oogoo021oo`03001oogoo005o
o`002Goo00<007ooOol01Woo0`000Woo00<007ooOol0Q7oo0P0087oo00<007ooOol00Goo000GOol0
0`00Oomoo`0OOol00`00Oomoo`0COol00`00Oomoo`1>Ool00`00Oomoo`0MOol00`00Oomoo`01Ool0
01Moo`03001oogoo08Moo`03001oogoo01aoo`03001oogoo005oo`005goo00<007ooOol0=Goo00<0
07ooOol0Cgoo0P007Goo00<007ooOol00Goo000GOol2000QOol00`00Oomoo`22Ool20003Ool001Mo
o`03001oogoo021oo`03001oogoo015oo`03001oogoo059oo`03001oogoo01Yoo`03001oogoo005o
o`005goo00<007ooOol0RWoo00<007ooOol06Goo00<007ooOol00Goo000GOol00`00Oomoo`0POol0
0`00Oomoo`0AOol00`00Oomoo`1EOol00`00Oomoo`0GOol00`00Oomoo`01Ool001Moo`03001oogoo
021oo`03001oogoo06Yoo`03001oogoo01Ioo`03001oogoo005oo`005goo00<007ooOol0<goo00<0
07ooOol0F7oo00<007ooOol05Goo00<007ooOol00Goo000GOol2000ROol00`00Oomoo`0?Ool00`00
Oomoo`1HOol00`00Oomoo`0DOol20003Ool001Moo`03001oogoo025oo`03001oogoo00moo`03001o
ogoo05Uoo`03001oogoo01Aoo`03001oogoo005oo`005goo00<007ooOol0<Woo00<007ooOol0Fgoo
00<007ooOol04goo00<007ooOol00Goo000GOol00`00Oomoo`0ROol00`00Oomoo`0=Ool00`00Oomo
o`1LOol00`00Oomoo`0BOol00`00Oomoo`01Ool001Moo`03001oogoo039oo`03001oogoo05ioo`03
001oogoo011oo`03001oogoo005oo`005goo00<007ooOol0U7oo00<007ooOol03goo00<007ooOol0
0Goo000GOol2000SOol00`00Oomoo`0<Ool00`00Oomoo`1aOol20003Ool001Moo`03001oogoo09Eo
o`03001oogoo00ioo`03001oogoo005oo`005goo00<007ooOol08goo00<007ooOol02Woo00<007oo
Ool0Hgoo00<007ooOol03Goo00<007ooOol00Goo000GOol00`00Oomoo`0`Ool00`00Oomoo`1TOol2
000=Ool00`00Oomoo`01Ool001Moo`03001oogoo02Aoo`03001oogoo079oo`03001oogoo00Yoo`03
001oogoo005oo`005goo00<007ooOol097oo00<007ooOol027oo00<007ooOol0J7oo00<007ooOol0
2Goo00<007ooOol00Goo000GOol00`00Oomoo`0TOol00`00Oomoo`08Ool00`00Oomoo`1XOol00`00
Oomoo`09Ool00`00Oomoo`01Ool001Moo`8002Eoo`03001oogoo07Aoo`03001oogoo00Moo`8000=o
o`005goo00<007ooOol09Goo00<007ooOol01Woo00<007ooOol0Jgoo00<007ooOol01goo00<007oo
Ool00Goo000GOol00`00Oomoo`0UOol00`00Oomoo`06Ool00`00Oomoo`1/Ool00`00Oomoo`06Ool0
0`00Oomoo`01Ool001Moo`03001oogoo02Ioo`03001oogoo00Aoo`03001oogoo06moo`03001oogoo
00Aoo`03001oogoo005oo`005goo00<007ooOol09Woo00<007ooOol00goo00<007ooOol0LGoo00<0
07ooOol00goo00<007ooOol00Goo000AOol30003Ool00`00Oomoo`0WOol01000Oomoogoo0P00NGoo
00<007ooOol00Goo000BOol00`00Oomoo`02Ool2000XOol5001eOol20002Ool20003Ool0019oo`03
001oogoo009oo`03001oogoo0:Ioo`03001oogoo005oo`004Woo00<007ooOol00Woo00<007ooOol0
YWoo00<007ooOol00Goo000AOol20004Ool01@00Oomoogoo00007goo00<007ooOol07Goo00<007oo
Ool07Woo00<007ooOol07Goo00<007ooOol07Goo00D007ooOomoo`0000=oo`005gooZP000goo0000
\
\>"],
  ImageRangeCache->{{{0, 195}, {195, 0}} -> {-0.172544, -0.187897, 
  0.00622539, 0.00622539}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComparisonPlot[0, .4];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147151 0.588653 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13245 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25018 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36791 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .48564 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60337 1 0 0 Minner Mrotsboxa
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13245 m
1 .13245 L
s
P
p
0 0 .5 r
.001 w
0 .25018 m
1 .25018 L
s
P
p
0 0 .5 r
.001 w
0 .36791 m
1 .36791 L
s
P
p
0 0 .5 r
.001 w
0 .48564 m
1 .48564 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13245 m
.00625 .13245 L
s
P
[(0.2)] -0.0125 .13245 1 0 0 Minner Mrotshowa
p
.002 w
0 .25018 m
.00625 .25018 L
s
P
[(0.4)] -0.0125 .25018 1 0 0 Minner Mrotshowa
p
.002 w
0 .36791 m
.00625 .36791 L
s
P
[(0.6)] -0.0125 .36791 1 0 0 Minner Mrotshowa
p
.002 w
0 .48564 m
.00625 .48564 L
s
P
[(0.8)] -0.0125 .48564 1 0 0 Minner Mrotshowa
p
.002 w
0 .60337 m
.00625 .60337 L
s
P
[(1)] -0.0125 .60337 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .06181 m
.00375 .06181 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .1089 m
.00375 .1089 L
s
P
p
.001 w
0 .15599 m
.00375 .15599 L
s
P
p
.001 w
0 .17954 m
.00375 .17954 L
s
P
p
.001 w
0 .20308 m
.00375 .20308 L
s
P
p
.001 w
0 .22663 m
.00375 .22663 L
s
P
p
.001 w
0 .27372 m
.00375 .27372 L
s
P
p
.001 w
0 .29727 m
.00375 .29727 L
s
P
p
.001 w
0 .32081 m
.00375 .32081 L
s
P
p
.001 w
0 .34436 m
.00375 .34436 L
s
P
p
.001 w
0 .39145 m
.00375 .39145 L
s
P
p
.001 w
0 .415 m
.00375 .415 L
s
P
p
.001 w
0 .43855 m
.00375 .43855 L
s
P
p
.001 w
0 .46209 m
.00375 .46209 L
s
P
p
.001 w
0 .50918 m
.00375 .50918 L
s
P
p
.001 w
0 .53273 m
.00375 .53273 L
s
P
p
.001 w
0 .55628 m
.00375 .55628 L
s
P
p
.001 w
0 .57982 m
.00375 .57982 L
s
P
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13245 m
1 .13245 L
s
P
p
.002 w
.99375 .25018 m
1 .25018 L
s
P
p
.002 w
.99375 .36791 m
1 .36791 L
s
P
p
.002 w
.99375 .48564 m
1 .48564 L
s
P
p
.002 w
.99375 .60337 m
1 .60337 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .06181 m
1 .06181 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .1089 m
1 .1089 L
s
P
p
.001 w
.99625 .15599 m
1 .15599 L
s
P
p
.001 w
.99625 .17954 m
1 .17954 L
s
P
p
.001 w
.99625 .20308 m
1 .20308 L
s
P
p
.001 w
.99625 .22663 m
1 .22663 L
s
P
p
.001 w
.99625 .27372 m
1 .27372 L
s
P
p
.001 w
.99625 .29727 m
1 .29727 L
s
P
p
.001 w
.99625 .32081 m
1 .32081 L
s
P
p
.001 w
.99625 .34436 m
1 .34436 L
s
P
p
.001 w
.99625 .39145 m
1 .39145 L
s
P
p
.001 w
.99625 .415 m
1 .415 L
s
P
p
.001 w
.99625 .43855 m
1 .43855 L
s
P
p
.001 w
.99625 .46209 m
1 .46209 L
s
P
p
.001 w
.99625 .50918 m
1 .50918 L
s
P
p
.001 w
.99625 .53273 m
1 .53273 L
s
P
p
.001 w
.99625 .55628 m
1 .55628 L
s
P
p
.001 w
.99625 .57982 m
1 .57982 L
s
P
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .01472 m
.02505 .01473 L
.02629 .01478 L
.02753 .01485 L
.02877 .01496 L
.03001 .01509 L
.03125 .01524 L
.03373 .01563 L
.03869 .01668 L
.04365 .01806 L
.05357 .02163 L
.06349 .02608 L
.10317 .04995 L
.14286 .08106 L
.18254 .12041 L
.20238 .14457 L
.22222 .17307 L
.24206 .20751 L
.2619 .25018 L
.28175 .3042 L
.30159 .37327 L
.32143 .45909 L
.34127 .55119 L
.34623 .57092 L
.34871 .57957 L
.35119 .58716 L
.35367 .59352 L
.35491 .59618 L
.35615 .59846 L
.35739 .60033 L
.35863 .60178 L
.35987 .60277 L
.36111 .60329 L
.36235 .60332 L
.36359 .60283 L
.36483 .60182 L
.36607 .60026 L
.36855 .59545 L
.36979 .59219 L
.37103 .58834 L
.37599 .56712 L
.38095 .53703 L
.39087 .45588 L
.40079 .36126 L
.41071 .27029 L
.42063 .19354 L
.43056 .13421 L
.43552 .11075 L
.44048 .09096 L
.44544 .07443 L
Mistroke
.4504 .06075 L
.45536 .04955 L
.46032 .04046 L
.46528 .03318 L
.47024 .02745 L
.4752 .02303 L
.48016 .01973 L
.48264 .01845 L
.48512 .01738 L
.4876 .01651 L
.49008 .01584 L
.49132 .01556 L
.49256 .01533 L
.4938 .01514 L
.49504 .01498 L
.49628 .01486 L
.49752 .01478 L
.49876 .01473 L
.5 .01472 L
.50124 .01473 L
.50248 .01478 L
.50372 .01485 L
.50496 .01496 L
.5062 .01509 L
.50744 .01524 L
.50992 .01563 L
.51488 .01668 L
.51984 .01806 L
.52976 .02163 L
.53968 .02608 L
.57937 .04995 L
.61905 .08106 L
.65873 .12041 L
.67857 .14457 L
.69841 .17307 L
.71825 .20751 L
.7381 .25018 L
.75794 .3042 L
.77778 .37327 L
.79762 .45909 L
.80754 .50606 L
.81746 .55119 L
.82242 .57092 L
.8249 .57957 L
.82738 .58716 L
.82986 .59352 L
.83234 .59846 L
.83358 .60033 L
.83482 .60178 L
.83606 .60277 L
Mistroke
.8373 .60329 L
.83854 .60332 L
.83978 .60283 L
.84102 .60182 L
.84226 .60026 L
.8435 .59814 L
.84474 .59545 L
.84722 .58834 L
.8497 .57889 L
.85218 .56712 L
.85714 .53703 L
.86706 .45588 L
.87698 .36126 L
.8869 .27029 L
.89683 .19354 L
.90675 .13421 L
.91171 .11075 L
.91667 .09096 L
.92659 .06075 L
.93155 .04955 L
.93651 .04046 L
.94147 .03318 L
.94643 .02745 L
.95139 .02303 L
.95635 .01973 L
.95883 .01845 L
.96131 .01738 L
.96379 .01651 L
.96627 .01584 L
.96751 .01556 L
.96875 .01533 L
.96999 .01514 L
.97123 .01498 L
.97247 .01486 L
.97371 .01478 L
.97495 .01473 L
.97619 .01472 L
Mfstroke
P
P
p
p
.02 w
.02381 .01472 m
.02505 .01473 L
.02629 .01478 L
.02753 .01486 L
.02877 .01497 L
.03001 .01511 L
.03125 .01528 L
.03373 .01572 L
.03621 .01629 L
.03869 .01698 L
.04365 .01873 L
.05357 .02368 L
.06349 .03049 L
.08333 .0492 L
.10317 .07358 L
.14286 .13245 L
.18254 .19131 L
.20238 .21569 L
.2123 .22585 L
.22222 .2344 L
.23214 .24121 L
.2371 .24393 L
.24206 .24616 L
.24702 .24791 L
.2495 .2486 L
.25198 .24917 L
.25446 .24961 L
.2557 .24978 L
.25694 .24992 L
.25818 .25003 L
.25942 .25011 L
.26066 .25016 L
.2619 .25018 L
.26314 .25016 L
.26438 .25011 L
.26562 .25003 L
.26687 .24992 L
.26935 .24961 L
.27183 .24917 L
.27431 .2486 L
.27679 .24791 L
.28175 .24616 L
.29167 .24121 L
.30159 .2344 L
.32143 .21569 L
.34127 .19131 L
.38095 .13245 L
.42063 .07358 L
.44048 .0492 L
.4504 .03904 L
Mistroke
.46032 .03049 L
.47024 .02368 L
.48016 .01873 L
.48512 .01698 L
.4876 .01629 L
.49008 .01572 L
.49256 .01528 L
.4938 .01511 L
.49504 .01497 L
.49628 .01486 L
.49752 .01478 L
.49876 .01473 L
.5 .01472 L
.50124 .01473 L
.50248 .01478 L
.50372 .01486 L
.50496 .01497 L
.5062 .01511 L
.50744 .01528 L
.50992 .01572 L
.5124 .01629 L
.51488 .01698 L
.51984 .01873 L
.52976 .02368 L
.53968 .03049 L
.55952 .0492 L
.57937 .07358 L
.61905 .13245 L
.65873 .19131 L
.67857 .21569 L
.68849 .22585 L
.69841 .2344 L
.70833 .24121 L
.71329 .24393 L
.71825 .24616 L
.72321 .24791 L
.72569 .2486 L
.72817 .24917 L
.73065 .24961 L
.73189 .24978 L
.73313 .24992 L
.73437 .25003 L
.73562 .25011 L
.73686 .25016 L
.7381 .25018 L
.73934 .25016 L
.74058 .25011 L
.74182 .25003 L
.74306 .24992 L
.74554 .24961 L
Mistroke
.74802 .24917 L
.7505 .2486 L
.75298 .24791 L
.75794 .24616 L
.76786 .24121 L
.77778 .2344 L
.79762 .21569 L
.81746 .19131 L
.85714 .13245 L
.89683 .07358 L
.91667 .0492 L
.93651 .03049 L
.94643 .02368 L
.95139 .02096 L
.95635 .01873 L
.96131 .01698 L
.96379 .01629 L
.96627 .01572 L
.96875 .01528 L
.96999 .01511 L
.97123 .01497 L
.97247 .01486 L
.97371 .01478 L
.97495 .01473 L
.97619 .01472 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol007Mo
o`<007]oo`00N7oo00<007ooOol0NWoo001hOol30002Ool01000Ool007oo1@00Kgoo001hOol02000
Oomoo`00Ool007oo0003Ool00`00Oomoo`1_Ool007Qoo`08001oogoo001oo`00Ool000=oo`03001o
ogoo06moo`00Mgoo10000Woo0`000Woo0P00LGoo001mOol00`00Oomoo`1eOol007aoo`8000Eoo`03
001oogoo06moo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol001moo`03001o
ogoo01Yoo`<001]oo`<001aoo`<001eoo`03001oogoo01Uoo`<001aoo`8001moo`007Woo00<007oo
000077oo00<007ooOol06goo00<007ooOol07Goo00<007ooOol06Goo0`007Goo00<007ooOol06Goo
00<007oo00007goo000NOol00`00Ool0000LOol00`00Oomoo`0LOol00`00Oomoo`0KOol00`00Oomo
o`0JOol00`00Ool0000KOol3000KOol3000OOol001ioo`03001oo`0001aoo`03001oogoo01aoo`03
001oogoo01aoo`03001oogoo01Yoo`8001]oo`03001oogoo01]oo`03001oogoo01moo`007goo00<0
07ooOol06Woo0P0077oo0`0077oo0`007Goo00<007ooOol06Goo0`0077oo0P007goo003eOol00?Eo
o`00mGoo003eOol001]oolP0019oo`006goo00<007ooOol00Woo00<007ooOol06goo00<007ooOol0
6goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol0
2goo00<007ooOol047oo000FOol00`00Oomoo`02Ool01000Oomoogoo20005goo00<03gooOol06goo
00<03gooOol06Goo3@004goo00<03gooOol06goo00<03gooOol06goo00@03gooOomoo`L000=oo`03
001oogoo011oo`005Goo00<007oo00000goo0P000Woo2@0000=W>GooOol04goo00<03gooOol06goo
00<03gooOol067oo3`0000=W>GooOol03goo00<03gooOol06goo00<03gooOol06goo00<03goo0000
200000Aoo`000000019oo`005Goo00<007oo00000goo00@007ooOomoo`X0009W>A=oo`0300moogoo
01]oo`0300moogoo01Mooa40009W>@moo`0300moogoo01]oo`0300moogoo01]oo`0300l0000000P0
00=oo`03001oogoo011oo`005Goo00<007oo00000goo00<007ooOol01goo1@000VLi4Woo00<03goo
Ool06goo00<03gooOol05Goo1P000VLi1goo1P0000=W>GooOol037oo00<03gooOol06goo00<03goo
Ool06Woo1`0000=W>GooOol01Goo00<007ooOol047oo000FOol00`00Oomoo`02Ool00`00Oomoo`08
Ool50003IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0DOol600000fLi00moo`08Ool60002IcT<Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0IOol600000fLiOomoo`07Ool00`00Oomoo`0@Ool001]oo`8000Yo
o`D000=W>@moo`0300moogoo01]oo`0300moogoo01=oo`H00003IcUoo`0?00Yoo`H000=W>@Yoo`03
00moogoo01]oo`0300moogoo01Qoo`H00003IcUoogoo00Moo`80019oo`006goo00<007ooOol02Woo
1@000fLi3Woo00<03gooOol06goo00<03gooOol04Woo1@000fLi00=oo`0?Ool02goo1@000fLi2Goo
00<03gooOol06goo00<03gooOol05goo1@000fLi2Woo00<007ooOol047oo000KOol00`00Oomoo`0;
Ool40005IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0BOol40003IcT2Ool00`0?Oomoo`0;Ool40005
IcT7Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol40003IcT;Ool00`00Oomoo`0@Ool001]oo`03001o
ogoo00aoo`@000EW>@]oo`0300moogoo01]oo`0300moogoo015oo`@000AW>@9oo`0300moogoo00ao
o`@000EW>@Ioo`0300moogoo01]oo`0300moogoo01Ioo`@000AW>@]oo`03001oogoo011oo`006goo
00<007ooOol037oo1@001FLi2Woo00<03gooOol06goo00<03gooOol047oo1@000fLi0goo00<03goo
Ool037oo1@001FLi1Goo00<03gooOol06goo00<03gooOol05Goo1@000fLi37oo00<007ooOol047oo
000KOol2000>Ool50006IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0?Ool50004IcT3Ool00`0?Oomo
o`0=Ool50006IcT3Ool00`0?Oomoo`0KOol00`0?Oomoo`0DOol50004IcT;Ool2000BOol001]oo`03
001oogoo00ioo`D000IW>@Moo`0300moogoo01]oo`0300moogoo00ioo`D000AW>@Aoo`0300moogoo
00ioo`D000IW>@9oo`0300moogoo01]oo`0300moogoo01=oo`D000AW>@eoo`03001oogoo011oo`00
6goo00<007ooOol03goo100000=oofLiIcT016Li1Woo00<03gooOol06goo00<03gooOol03Woo1000
00=oofLiIcT00VLi17oo00<03gooOol03goo100000=oofLiIcT016Li00=oo`0?Ool077oo00<03goo
Ool04goo100000=oofLiIcT00VLi3Goo00<007ooOol047oo000KOol00`00Oomoo`0@Ool40002Ool5
IcT5Ool00`0?Oomoo`0KOol00`0?Oomoo`0=Ool40002Ool3IcT5Ool00`0?Oomoo`0@Ool40002Ool5
IcT00`0?Oomoo`0KOol00`0?Oomoo`0BOol40002Ool3IcT00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
01]oo`03001oogoo011oo`D0009oo`EW>@Aoo`0300moogoo01]oo`0300moogoo00eoo`@00003OomW
>FLi009W>@Eoo`0300moogoo011oo`D0009oo`EW>Aeoo`0300moogoo015oo`D00003OomW>FLi009W
>@0300moogoo00]oo`03001oogoo011oo`006goo0P004Woo10000goo1FLi0goo00<03gooOol06goo
00<03gooOol037oo10000Woo16Li1Goo00<03gooOol04Goo10000goo1FLi77oo00<03gooOol04Goo
10000Woo16Li00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0BOol40003Ool5IcT2Ool00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool50002Ool3IcT6Ool00`0?Oomoo`0BOol40003Ool5IcTKOol00`0?
Oomoo`0@Ool40003Ool3IcT00goo00moo`0<Ool00`00Oomoo`0@Ool001]oo`03001oogoo019oo`D0
00=oo`EW>@03Ool03goo01aoo`0300moogoo00]oo`@000=oo`=W>@Ioo`0300moogoo019oo`D000=o
o`EW>AYoo`0300moogoo00moo`D000=oo`=W>@03Ool03goo00aoo`03001oogoo011oo`006goo00<0
07ooOol04goo100017oo1FLi00<03gooOol06goo00<03gooOol02Woo10000goo16Li1Woo00<03goo
Ool04goo100017oo1FLi6Goo00<03gooOol03goo10000goo16Li00=oo`0?Ool037oo00<007ooOol0
47oo000KOol2000EOol40004Ool5IcTMOol00`0?Oomoo`0:Ool40003Ool4IcT6Ool00`0?Oomoo`0D
Ool40003Ool00`0?IcUW>@03IcTHOol00`0?Oomoo`0>Ool40004Ool4IcT00goo00moo`0;Ool2000B
Ool001]oo`03001oogoo01Aoo`D000Aoo`EW>Aaoo`0300moogoo00Uoo`@000Aoo`=W>@Moo`0300mo
ogoo01Aoo`D0009oo`0300moofLi00AW>AMoo`0300moogoo00eoo`D000Aoo`=W>@9oo`0300moogoo
00]oo`03001oogoo00Aoo`<000Uoo`006goo00<007ooOol05Goo10001Goo1FLi6goo00<03gooOol0
27oo1@0017oo0fLi1goo00<03gooOol05Goo10000Woo00<03gooOol01FLi5Woo00<03gooOol03Goo
10001Goo0fLi0Woo00<03gooOol02goo00<007ooOol01Goo00<007ooOol027oo0005Ool3000COol0
0`00Oomoo`0FOol40005Ool5IcTJOol00`0?Oomoo`08Ool40004Ool4IcT7Ool00`0?Oomoo`0FOol4
00000goo00moo`02Ool5IcTEOol00`0?Oomoo`0<Ool40005Ool4IcT2Ool00`0?Oomoo`0;Ool00`00
Oomoo`05Ool30008Ool000Ioo`03001oogoo00=oo`03001oogoo009oo`04001oogooOol30003Ool0
0`00Oomoo`0FOol50005Ool5IcTIOol00`0?Oomoo`07Ool40005Ool4IcT7Ool00`0?Oomoo`0FOol5
00000`0?Oomoo`02Ool5IcTDOol00`0?Oomoo`0;Ool50005Ool4IcT2Ool00`0?Oomoo`0;Ool00`00
Oomoo`05Ool00`00Ool00008Ool000Ioo`<0009oo`03001oo`0000Qoo`03001oogoo009oo`8001P0
3`@000H03`EW>B803`@000D03`=W>B803`@000H03`EW>B403`@000H03`=W>@l03`<000Ioo`@000Qo
o`001Woo00<007oo00000`0000=oo`00Ool027oo00D007ooOomoo`0001Yoo`@000Aoo`0300moofLi
00AW>AMoo`0300moogoo00Ioo`@000Ioo`=W>@Qoo`0300moogoo01Qoo`@000Ioo`EW>A9oo`0300mo
ogoo00Yoo`@000Moo`=W>@=oo`0300moogoo00]oo`03001oogoo00Eoo`04001oogoo0007Ool000Eo
o`D00004Ool007oo0009Ool01@00Oomoogoo00006Woo1@000goo00<03gooOol016Li5goo00<03goo
Ool01Goo1@001Woo0fLi27oo00<03gooOol067oo1@001Woo16Li4Woo00<03gooOol02Goo1@001goo
0fLi0goo00<03gooOol02goo00<007ooOol01Goo00@007ooOol000Moo`001goo0`000Woo00<007oo
Ool01Woo0`000goo00<007ooOol06Goo10000goo00@03gooOomoo`AW>AIoo`0300moogoo00Eoo`@0
00Ioo`AW>@Qoo`0300moogoo01Uoo`@000Moo`AW>A5oo`0300moogoo00Uoo`@000Moo`AW>@=oo`03
00moogoo00]oo`03001oogoo00Ioo`<000Moo`001Woo00@007ooOol0015oo`03001oogoo01Yoo`@0
009oo`0400moogooOol5IcTEOol00`0?Oomoo`04Ool40007Ool4IcT8Ool00`0?Oomoo`0JOol40006
Ool5IcT@Ool00`0?Oomoo`08Ool40008Ool4IcT3Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool000Io
o`04001oogoo000AOol2000KOol500000goo00moo`03Ool4IcTEOol00`0?Oomoo`03Ool50007Ool3
IcT9Ool00`0?Oomoo`0JOol50006Ool4IcT@Ool00`0?Oomoo`07Ool50008Ool3IcT4Ool00`0?Oomo
o`0:Ool20007Ool40007Ool000Moo`<0015oo`03001oogoo01]oo`@00003Ool03goo00Aoo`AW>AAo
o`0300moogoo00=oo`@000Qoo`=W>@Uoo`0300moogoo01]oo`@000Moo`AW>@moo`0300moogoo00Mo
o`@000Uoo`=W>@Aoo`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`006goo00<007oo
Ool077oo100000<03gooOol00goo1FLi4goo00<03gooOol00Woo10002Goo0fLi2Goo00<03gooOol0
6goo00<03`0000000P001Woo1FLi3Woo00<03gooOol01Woo10002Woo0fLi17oo00<03gooOol02goo
00<007ooOol01Woo00<007ooOol01goo0006Ool3000BOol00`00Oomoo`0LOol50006Ool4IcTCOol0
100?Oomoogoo1@002Goo0fLi2Goo00<03gooOol06goo00<03`0000000`001Woo16Li3Woo00<03goo
Ool01Goo1@002Woo0fLi17oo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0006Ool0
0`00Ool0000BOol2000NOol40007Ool4IcTBOol0100?Oomoogoo10002Goo16Li2Goo00<03gooOol0
6goo00<03goo00000`001goo16Li3Goo00<03gooOol01Goo10002Woo16Li17oo00<03gooOol02Woo
0P0027oo00<007ooOol01goo0006Ool00`00Ool0000BOol00`00Oomoo`0NOol40006Ool4IcTBOol0
0`0?Oomoo`04000:Ool4IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`040006Ool4IcT=Ool00`0?Oomo
o`04Ool4000;Ool4IcT4Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Eoo`800003Ool0
07oo015oo`03001oogoo01ioo`D000Ioo`AW>A5oo`0300moo`0000@000Yoo`=W>@Yoo`0300moogoo
01]oo`0300moogoo00D000Ioo`AW>@aoo`0300moogoo00=oo`D000]oo`=W>@Eoo`0300moogoo00]o
o`03001oogoo00Eoo`<000Qoo`001Woo0`004Woo00<007ooOol07goo10001Woo1FLi47oo00<03goo
00000`002goo0fLi2Woo00<03gooOol06goo00@03gooOomoo`@000Ioo`EW>@]oo`0300moogoo00=o
o`@000aoo`=W>@Eoo`0300moogoo00]oo`03001oogoo00Moo`03001oogoo00Ioo`001Woo0`004Woo
00<007ooOol087oo10001Woo16Li47oo00<03`0000000P0037oo0fLi2Woo00<03gooOol06goo00<0
3gooOol00Woo10001Woo16Li2goo00<03gooOol00Woo10003Goo0fLi1Goo00<03gooOol02goo00<0
07ooOol01Goo0`0027oo0008Ool00`00Oomoo`0@Ool2000QOol50006Ool4IcT?Ool5000<Ool3IcT:
Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool50006Ool4IcT:Ool0100?Oomoogoo1@003Goo0fLi1Goo
00<03gooOol02Woo0P004Woo0006Ool3000BOol00`00Oomoo`0POol00`0?000000030005Ool4IcT>
Ool5000=Ool3IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`03Ool50005Ool4IcT:Ool00`0?Oomoo`05
000>Ool3IcT5Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool001]oo`03001oogoo021oo`03
00moo`0000@000Eoo`AW>@]oo`H000eoo`AW>@Yoo`0300moogoo01]oo`0300moogoo00Aoo`D000Eo
o`AW>@Uoo`0300l0000000@000ioo`AW>@Eoo`0300moogoo00]oo`03001oogoo00Ioo`8000Qoo`00
1Woo00<007oo00004Woo00<007ooOol087oo00<03gooOol01@0017oo16Li2Woo1P003Woo16Li2Woo
00<03gooOol06goo00<03gooOol01Goo1@0017oo16Li2Goo1P003goo16Li1Goo00<03gooOol02goo
00<007ooOol01Goo00<007ooOol027oo0006Ool00`00Ool0000BOol00`00Oomoo`0POol0100?Oomo
ogoo1P000goo16Li27oo1P003goo0fLi2goo00<03gooOol06goo00<03gooOol01Woo1P000goo0fLi
27oo1P0047oo0fLi1Woo00<03gooOol02goo00<007ooOol01Goo0`0027oo0006Ool00`00Ool0000B
Ool2000QOol00`0?Oomoo`02Ool60002Ool4IcT7Ool500000goo00moo`0>Ool3IcT;Ool00`0?Oomo
o`0KOol00`0?Oomoo`07Ool60002Ool4IcT6Ool5000BOol3IcT6Ool00`0?Oomoo`0:Ool2000BOol0
00Eoo`@0019oo`03001oogoo021oo`0300moogoo00=oo`H0009oo`AW>@Eoo`D0009oo`0300moogoo
00eoo`=W>@]oo`0300moogoo01]oo`0300moogoo00Qoo`H00003OomW>FLi009W>@Eoo`D001=oo`=W
>@Ioo`0300moogoo00]oo`03001oogoo00Eoo`<000Qoo`006goo00<007ooOol087oo00<03gooOol0
1Goo1P0016Li0goo1P000goo00<03gooOol03Goo0fLi2goo00<03gooOol06goo00<03gooOol02Woo
1P000fLi0goo1P0057oo0fLi1Woo00<03gooOol02goo00<007ooOol01Woo0P0027oo0006Ool30003
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo00008Woo00<03gooOol01Woo4@0017oo
00<03gooOol03Goo0fLi2goo00<03gooOol06goo00<03gooOol02goo400000<03gooOol04Woo0fLi
1Woo00<03gooOol02goo00<007ooOol01Goo00<007ooOol027oo0006Ool00`00Oomoo`02Ool00`00
Ool00007Ool30003Ool2000[00l?000D00l4IcTh00l>000E00l4IcTB00l30007Ool30008Ool000Io
o`03001oogoo009oo`03001oo`0000Moo`03001oo`0000=oo`03001oogoo021oo`0300moogoo00Uo
o`/000Moo`0300moogoo00aoo`AW>@]oo`0300moogoo01]oo`0300moogoo00ioo`X000=oo`0300mo
ogoo015oo`AW>@Ioo`0300moogoo00]oo`03001oogoo00Aoo`D000Moo`001Goo10000Woo00<007oo
000027oo0P000goo00<007ooOol087oo00<03gooOol03Goo16Li2Woo00<03gooOol037oo0fLi37oo
00<03gooOol06goo00<03gooOol04Goo16Li1Woo00<03gooOol04Goo0fLi1goo00<03gooOol02goo
00<007ooOol01Woo00<007ooOol01goo0006Ool00`00Oomoo`03Ool00`00Oomoo`08Ool01@00Oomo
ogoo00008Woo00<03gooOol03Woo0fLi2Woo00<03gooOol037oo0fLi37oo00<03gooOol06goo00<0
3gooOol04Woo0fLi1Woo00<03gooOol04Goo0fLi1goo00<03gooOol02goo00<007ooOol01Woo00<0
07ooOol01goo0006Ool3000BOol00`00Oomoo`0POol00`0?Oomoo`0>Ool4IcT9Ool00`0?Oomoo`0<
Ool3IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0BOol4IcT5Ool00`0?Oomoo`0AOol3IcT7Ool00`0?
Oomoo`0;Ool00`00Oomoo`05Ool20009Ool000Ioo`03001oo`00019oo`80025oo`0300moogoo00io
o`AW>@Uoo`0300moogoo00aoo`=W>@aoo`0300moogoo01]oo`0300moogoo019oo`AW>@Eoo`0300mo
ogoo015oo`=W>@Moo`0300moogoo00Yoo`80019oo`001Woo00<007oo00004Woo00<007ooOol087oo
00<03gooOol03goo0fLi2Goo00<03gooOol037oo0fLi37oo00<03gooOol06goo00<03gooOol04goo
0fLi1Goo00<03gooOol04Goo0fLi1goo00<03gooOol02goo00<007ooOol01Woo0P0027oo0005Ool2
00000goo001oo`0AOol00`00Oomoo`0POol00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`0<Ool3IcT<
Ool00`0?Oomoo`0KOol00`0?Oomoo`0COol4IcT4Ool00`0?Oomoo`0AOol3IcT7Ool00`0?Oomoo`0;
Ool00`00Oomoo`05Ool01000Oomoo`001goo000KOol00`00Oomoo`0POol00`0?Oomoo`0?Ool4IcT8
Ool00`0?Oomoo`0<Ool3IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0COol4IcT4Ool00`0?Oomoo`0@
Ool4IcT7Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo0005Ool01@00Ool007oo
00004Goo00<007ooOol087oo00<03gooOol047oo0fLi27oo00<03gooOol037oo0fLi37oo00<03goo
Ool06goo00<03gooOol057oo0fLi17oo00<03gooOol047oo16Li1goo00<03gooOol02goo00<007oo
Ool01Woo0`001goo0005Ool01@00Ool007oo00004Goo0P008Goo00<03gooOol047oo16Li1goo00<0
3gooOol037oo0fLi37oo00<03gooOol06goo00<03gooOol057oo16Li0goo00<03gooOol047oo0fLi
27oo00<03gooOol02Woo0P004Woo0005Ool01@00Ool007oo00004Goo00<007ooOol087oo00<03goo
Ool047oo16Li1goo00<03gooOol037oo0fLi37oo00<03gooOol06goo00<03gooOol057oo16Li0goo
00<03gooOol047oo0fLi27oo00<03gooOol02goo00<007ooOol01Goo0`0027oo0005Ool5000AOol0
0`00Oomoo`0POol00`0?Oomoo`0AOol3IcT7Ool00`0?Oomoo`0<Ool3IcT<Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0EOol3IcT3Ool00`0?Oomoo`0@Ool3IcT8Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool3
0008Ool001]oo`03001oogoo021oo`0300moogoo015oo`AW>@Ioo`0300moogoo00]oo`AW>@aoo`03
00moogoo01]oo`0300moogoo01Eoo`AW>@9oo`0300moogoo011oo`=W>@Qoo`0300moogoo00]oo`03
001oogoo00Moo`03001oogoo00Ioo`006goo0P008Goo00<03gooOol04Goo16Li1Woo00<03gooOol0
2goo16Li37oo00<03gooOol06goo00<03gooOol05Goo16Li0Woo00<03gooOol047oo0fLi27oo00<0
3gooOol02Woo0P001goo0`0027oo000KOol00`00Oomoo`0POol00`0?Oomoo`0BOol3IcT6Ool00`0?
Oomoo`0;Ool3IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0FOol3IcT2Ool00`0?Oomoo`0@Ool3IcT8
Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo019oo`AW>@Eo
o`0300moogoo00]oo`=W>@eoo`0300moogoo01]oo`0300moogoo01Ioo`AW>@03Ool03goo015oo`=W
>@Qoo`0300moogoo00]oo`03001oogoo00Eoo`@000Moo`0027oo00<007ooOol047oo00<007ooOol0
87oo00<03gooOol04Woo16Li1Goo00<03gooOol02goo0fLi3Goo00<03gooOol06goo00<03gooOol0
5Woo16Li00=oo`0?Ool047oo16Li27oo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo
0007Ool00`00Oomoo`0AOol00`00Oomoo`0POol00`0?Oomoo`0COol3IcT5Ool00`0?Oomoo`0;Ool3
IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol3IcT00goo00moo`0@Ool4IcT8Ool00`0?Oomoo`0;
Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Moo`03001oogoo015oo`80025oo`0300moogoo01=o
o`=W>@Eoo`0300moogoo00]oo`=W>@eoo`0300moogoo01]oo`0300moogoo01Moo`=W>@03Ool03goo
011oo`=W>@Uoo`0300moogoo00Yoo`8000Qoo`03001oogoo00Moo`001goo00<007ooOol04Goo00<0
07ooOol087oo00<03gooOol04goo16Li17oo00<03gooOol02goo0fLi3Goo00<03gooOol06goo00<0
3gooOol05goo16Li00<03gooOol03goo0fLi2Goo00<03gooOol02goo00<007ooOol01Woo00<007oo
Ool01goo0007Ool00`00Oomoo`0AOol00`00Oomoo`0POol00`0?Oomoo`0COol4IcT4Ool00`0?Oomo
o`0;Ool3IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol4IcT00`0?Oomoo`0?Ool3IcT9Ool00`0?
Oomoo`0;Ool00`00Oomoo`05Ool20009Ool000Qoo`03001oogoo011oo`03001oogoo021oo`0300mo
ogoo01Aoo`=W>@Aoo`0300moogoo00]oo`=W>@eoo`0300moogoo01]oo`0300moogoo01Qoo`=W>@03
00moogoo00moo`=W>@Uoo`0300moogoo00]oo`03001oogoo011oo`001Woo10000Woo00<007ooOol0
0Woo00<007ooOol00Woo0P000goo00<007ooOol087oo00<03gooOol057oo16Li0goo00<03gooOol0
2goo0fLi3Goo00<03gooOol06goo00<03gooOol067oo16Li4Goo0fLi2Goo00<03gooOol02goo00<0
07ooOol047oo0007Ool01`00Oomoogoo001oo`0000Moo`03001oo`0000=oo`8003P03`AW>A403`=W
>DH03`AW>A403`=W>AD03`<000Uoo`03001oogoo00Ioo`001goo00L007ooOomoo`00Ool00007Ool3
0003Ool00`00Oomoo`0POol00`0?Oomoo`0EOol3IcT3Ool00`0?Oomoo`0;Ool3IcT=Ool00`0?Oomo
o`0KOol00`0?Oomoo`0IOol3IcTAOol3IcT9Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`07Ool000Moo`07001oogooOol007oo00001goo00<007ooOol00goo00<007ooOol087oo00<03goo
Ool05Goo0fLi0goo00<03gooOol02goo0fLi3Goo00<03gooOol06goo00<03gooOol06Goo0fLi4Goo
0fLi2Goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0007Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool20003Ool00`00Oomoo`0POol00`0?Oomoo`0EOol4IcT2Ool00`0?Oomoo`0:Ool4
IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0IOol4IcT?Ool4IcT9Ool00`0?Oomoo`0;Ool00`00Oomo
o`06Ool00`00Oomoo`07Ool000Eoo`D0015oo`80025oo`0300moogoo01Eoo`AW>@9oo`0300moogoo
00Yoo`AW>@eoo`0300moogoo01]oo`0300moogoo01Uoo`AW>@moo`AW>@Uoo`0300moogoo00Yoo`80
00Qoo`03001oogoo00Moo`001goo00<007ooOol04Goo00<007ooOol087oo00<03gooOol05Woo0fLi
0Woo00<03gooOol02Woo0fLi3Woo00<03gooOol06goo00<03gooOol06Woo0fLi3goo0fLi2Woo00<0
3gooOol02goo00<007ooOol01goo00<007ooOol01Woo0007Ool00`00Oomoo`0AOol00`00Oomoo`0P
Ool00`0?Oomoo`0FOol3IcT2Ool00`0?Oomoo`0:Ool3IcT>Ool00`0?Oomoo`0KOol00`0?Oomoo`0J
Ool3IcT?Ool3IcT:Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool30007Ool000Ioo`@0015oo`03001o
ogoo021oo`0300moogoo01Ioo`AW>@03Ool03goo00]oo`=W>@ioo`0300moogoo01]oo`0300moogoo
01Yoo`AW>@ioo`=W>@Yoo`0300moogoo00]oo`03001oogoo00Eoo`04001oogoo0007Ool000Uoo`03
001oogoo00moo`03001oogoo021oo`0300moogoo01Ioo`AW>@03Ool03goo00]oo`=W>@ioo`0300mo
ogoo01]oo`0300moogoo01Yoo`AW>@ioo`=W>@Yoo`0300moogoo00]oo`03001oogoo00Eoo`04001o
ogoo0007Ool000Moo`<0015oo`80025oo`0300moogoo01Moo`=W>@03Ool03goo00]oo`=W>@ioo`03
00moogoo01]oo`0300moogoo01]oo`=W>@ioo`=W>@Yoo`0300moogoo00Yoo`8000Qoo`<000Moo`00
1Woo00@007ooOol0015oo`03001oogoo021oo`0300moogoo01Moo`=W>@03Ool03goo00]oo`=W>@io
o`0300moogoo01]oo`0300moogoo01]oo`=W>@ioo`=W>@Yoo`0300moogoo00]oo`03001oogoo00Qo
o`03001oogoo00Eoo`001Woo00@007ooOol0015oo`03001oogoo021oo`0300moogoo01Moo`=W>@03
Ool03goo00]oo`=W>@ioo`0300moogoo01]oo`0300moogoo01]oo`=W>@ioo`=W>@Yoo`0300moogoo
00]oo`03001oogoo00Eoo`@000Moo`001goo0`004Goo00<007ooOol087oo00<03gooOol05goo16Li
00<03gooOol02Goo16Li3Woo00<03gooOol06goo00<03gooOol06goo16Li37oo16Li2Woo00<03goo
Ool02goo00<007ooOol01Goo0`0027oo0006Ool00`00Ool0000BOol00`00Oomoo`0POol00`0?Oomo
o`0GOol4IcT00`0?Oomoo`09Ool4IcT>Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol4IcT<Ool4IcT:
Ool00`0?Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`06Ool000Ioo`03001oo`00019oo`80025o
o`0300moogoo01Qoo`=W>@0300moogoo00Uoo`=W>@moo`0300moogoo01]oo`0300moogoo01]oo`04
00mW>FLiIcT<Ool3IcT;Ool00`0?Oomoo`0:Ool20007Ool30008Ool000Ioo`03001oo`00019oo`03
001oogoo021oo`0300moogoo01Qoo`=W>@0300moogoo00Uoo`=W>@moo`0300moogoo01]oo`0300mo
ogoo01]oo`0400mW>FLiIcT<Ool3IcT;Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool000Ioo`<0019o
o`03001oogoo021oo`0300moogoo01Qoo`AW>@]oo`=W>@moo`0300moogoo01]oo`0300moogoo01]o
o`0300mW>FLi009W>@]oo`=W>@]oo`0300moogoo00]oo`03001oogoo00Aoo`@000Qoo`001Woo00<0
07ooOol04Woo00<007ooOol087oo00<03gooOol067oo16Li2goo0fLi3goo00<03gooOol06goo00<0
3gooOol06goo00<03fLiIcT00VLi2goo0fLi2goo00<03gooOol02goo00<007ooOol01Goo00<007oo
Ool027oo0005Ool4000BOol2000QOol00`0?Oomoo`0IOol3IcT;Ool3IcT?Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?OomW>@02IcT;Ool3IcT;Ool00`0?Oomoo`0:Ool20007Ool00`00Oomoo`08
Ool000Ioo`03001oogoo019oo`03001oogoo021oo`0300moogoo01Uoo`=W>@]oo`=W>@moo`0300mo
ogoo01]oo`0300moogoo01]oo`0300moofLi009W>@]oo`=W>@]oo`0300moogoo00]oo`03001oogoo
00Aoo`@000Qoo`001Woo00<007ooOol04Woo00<007ooOol087oo00<03gooOol06Goo16Li2Woo0fLi
3goo00<03gooOol06goo00<03gooOol06goo00<03gooIcT00fLi2Woo0fLi2goo00<03gooOol02goo
00<007ooOol047oo0005Ool4000BOol00`00Oomoo`0POol00`0?Oomoo`0IOol4IcT9Ool4IcT?Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?OomW>@03IcT9Ool4IcT;Ool00`0?Oomoo`0;Ool00`00
Oomoo`05Ool01000Ool000001goo0006Ool20004Ool00`00Oomoo`02Ool01000Oomoogoo0`000goo
00<007ooOol087oo00<03gooOol06Woo0fLi2Goo16Li3goo00<03gooOol06goo00<03gooOol06goo
00<03gooOol00fLi2Goo16Li2goo00<03gooOol02goo00<007ooOol01Goo10001goo0008Ool01P00
Oomoo`00Ool000Moo`03001oo`0000=oo`8003h03`=W>@T03`=W>Dl03`=W>@T03`=W>AP03`<000Mo
o`<000Qoo`0027oo00H007ooOol007oo0008Ool00`00Oomoo`02Ool00`00Oomoo`0POol00`0?Oomo
o`0JOol3IcT9Ool3IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`03IcT9Ool3IcT<
Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool40007Ool000Qoo`06001oogoo001oo`001goo00<007oo
00000goo00<007ooOol087oo00<03gooOol06Woo16Li27oo0fLi47oo00<03gooOol06goo00<03goo
Ool06goo00<03gooOol016Li27oo0fLi37oo00<03gooOol02goo00<007ooOol01Goo00<007oo0000
27oo0008Ool01@00Oomoogoo000027oo0`000goo00<007ooOol087oo00<03gooOol06Woo16Li27oo
0fLi47oo00<03gooOol06goo00<03gooOol06goo00<03gooOol016Li27oo0fLi37oo00<03gooOol0
2goo00<007ooOol017oo0P0000=oo`00Ool01goo0007Ool00`00Oomoo`0AOol00`00Oomoo`0POol0
0`0?Oomoo`0KOol3IcT8Ool3IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0100?Oomoogoo0fLi
27oo0fLi37oo00<03gooOol02goo00<007ooOol01goo00<007ooOol01Woo000KOol2000QOol00`0?
Oomoo`0KOol3IcT8Ool3IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0100?Oomoogoo0fLi27oo
0fLi37oo00<03gooOol02Woo0P002Goo00<007ooOol01Woo000KOol00`00Oomoo`0POol00`0?Oomo
o`0KOol4IcT6Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0100?Oomoogoo16Li1Woo16Li
37oo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo000KOol00`00Oomoo`0POol00`0?
Oomoo`0KOol4IcT6Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0100?Oomoogoo16Li1Woo
16Li37oo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol0
100?IcUW>FLi1Woo0fLi4Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol00Woo0fLi1Woo
0fLi3Goo00<03gooOol02goo00<007ooOol047oo000KOol2000QOol00`0?Oomoo`0KOol0100?IcUW
>FLi1Woo0fLi4Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol00Woo0fLi1Woo0fLi3Goo
00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol0100?IcUW>FLi1Woo
0fLi4Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol00Woo0fLi1Woo0fLi3Goo00<03goo
Ool02goo00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol00`0?IcUW>@02IcT5
Ool3IcTAOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`02Ool4IcT5Ool3IcT=Ool00`0?
Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo01]oo`0300mW>FLi009W
>@Eoo`=W>A5oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo009oo`AW>@Eoo`=W>@eoo`03
00moogoo00]oo`03001oogoo011oo`006goo00<007ooOol087oo00<03gooOol06goo00<03gooIcT0
0VLi17oo16Li4Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol00goo0fLi17oo16Li3Goo
00<03gooOol02goo00<007ooOol047oo000KOol2000QOol00`0?Oomoo`0KOol00`0?OomW>@02IcT4
Ool4IcTAOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`03Ool3IcT4Ool4IcT=Ool00`0?
Oomoo`0:Ool2000BOol001]oo`03001oogoo021oo`0300moogoo01]oo`0300moofLi00=W>@=oo`=W
>A9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00=oo`AW>@=oo`=W>@ioo`0300moogoo
00]oo`03001oogoo011oo`006goo00<007ooOol087oo00<03gooOol06goo00<03gooIcT00fLi0goo
0fLi4Woo00<03gooOol06goo00<03gooOol06goo00<03gooOol00goo16Li0goo0fLi3Woo00<03goo
Ool02goo00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol00`0?Oomoo`03IcT3
Ool3IcTBOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`04Ool3IcT3Ool3IcT>Ool00`0?
Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo01]oo`0300moogoo00=W
>@9oo`AW>A9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Aoo`AW>@9oo`=W>@ioo`03
00moogoo00]oo`03001oogoo011oo`006goo0P008Goo00<03gooOol06goo00<03gooOol016Li00=o
ofLiIcT00VLi4Woo00<03gooOol06goo00<03gooOol06goo00<03gooOol017oo16Li0Woo0fLi3Woo
00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol00`0?Oomoo`08IcTC
Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool3IcT00gooIcUW>@02IcT>Ool00`0?
Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo01]oo`0400moogooOol7
IcTCOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool8IcT>Ool00`0?Oomoo`0;Ool0
0`00Oomoo`0@Ool001Eoo`<000=oo`03001oogoo021oo`0300moogoo01]oo`0400moogooOol7IcTC
Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool7IcT?Ool00`0?Oomoo`0;Ool00`00
Oomoo`0@Ool001Ioo`03001oogoo009oo`80025oo`0300moogoo01]oo`0400moogooOol6IcTDOol0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`06Ool6IcT?Ool00`0?Oomoo`09Ool3000BOol0
01Ioo`03001oogoo009oo`03001oogoo021oo`0300moogoo01]oo`0300moogoo009oo`EW>AAoo`03
00moogoo01]oo`0300moogoo01]oo`0300moogoo00Ioo`EW>A1oo`0300moogoo00]oo`03001oogoo
011oo`005Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol06goo00<007ooOol06goo00<0
07ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol02goo00<0
07ooOol047oo000EOol20004Ooo8000BOol00?Eoo`00\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.06731, -0.248812, 0.0332182, 
  0.00855357}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me! p0A=0.35, p0B=0.8", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
You can work out the probability formulae for fixed p0A and p0B but \
variable phi. This helps to determine the regime in which one exceeds the \
other.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Pquantum[phi, 7/20, 4/5] // Simplify", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(-23\) + 9\ Cos[2\ phi] + 8\ \@7\ Sin[2\ phi]\)\/\(\(-40\) + 
        4\ \((2\ \@7 - \@13)\)\ Sin[2\ phi]\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pclassical[phi, 7/20, 4/5] // Simplify", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/40\ \((23 - 9\ Cos[2\ phi])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PhaseDiagram[7/20, 4/5];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.35714 .35714 Mdot
.35719 .3482 Mdot
.35731 .33929 Mdot
.35753 .33041 Mdot
.35783 .32157 Mdot
.35821 .31277 Mdot
.35868 .30401 Mdot
.35924 .2953 Mdot
.35988 .28665 Mdot
.3606 .27806 Mdot
.36141 .26952 Mdot
.36231 .26106 Mdot
.36328 .25267 Mdot
.36435 .24435 Mdot
.36549 .23611 Mdot
.36671 .22796 Mdot
.36802 .21989 Mdot
.36941 .21192 Mdot
.37088 .20405 Mdot
.37243 .19629 Mdot
.37406 .18863 Mdot
.37577 .18109 Mdot
.37755 .17366 Mdot
.37942 .16636 Mdot
.38136 .15918 Mdot
.38338 .15214 Mdot
.38547 .14524 Mdot
.38763 .13847 Mdot
.38987 .13186 Mdot
.39219 .12539 Mdot
.39457 .11909 Mdot
.39703 .11294 Mdot
.39955 .10697 Mdot
.40214 .10116 Mdot
.40481 .09553 Mdot
.40753 .09008 Mdot
.41033 .08481 Mdot
.41319 .07973 Mdot
.41611 .07485 Mdot
.41909 .07017 Mdot
.42213 .06569 Mdot
.42524 .06141 Mdot
.4284 .05735 Mdot
.43162 .0535 Mdot
.4349 .04987 Mdot
.43823 .04646 Mdot
.44161 .04328 Mdot
.44505 .04032 Mdot
.44853 .0376 Mdot
.45207 .03512 Mdot
.45565 .03287 Mdot
.45928 .03087 Mdot
.46295 .02911 Mdot
.46667 .0276 Mdot
.47043 .02634 Mdot
.47423 .02533 Mdot
.47807 .02458 Mdot
.48194 .02408 Mdot
.48586 .02383 Mdot
.4898 .02385 Mdot
.49378 .02413 Mdot
.49779 .02466 Mdot
.50183 .02546 Mdot
.5059 .02652 Mdot
.50999 .02785 Mdot
.51411 .02943 Mdot
.51825 .03128 Mdot
.52241 .03339 Mdot
.52659 .03577 Mdot
.53079 .0384 Mdot
.53501 .04129 Mdot
.53924 .04444 Mdot
.54348 .04785 Mdot
.54774 .05151 Mdot
.552 .05543 Mdot
.55627 .0596 Mdot
.56055 .06402 Mdot
.56483 .06868 Mdot
.56912 .07358 Mdot
.5734 .07873 Mdot
.57769 .08411 Mdot
.58197 .08972 Mdot
.58625 .09557 Mdot
.59052 .10164 Mdot
.59478 .10793 Mdot
.59904 .11444 Mdot
.60328 .12116 Mdot
.60751 .12809 Mdot
.61173 .13522 Mdot
.61593 .14255 Mdot
.62011 .15007 Mdot
.62428 .15778 Mdot
.62842 .16568 Mdot
.63254 .17375 Mdot
.63664 .18199 Mdot
.6407 .19039 Mdot
.64475 .19896 Mdot
.64876 .20767 Mdot
.65274 .21654 Mdot
.65669 .22555 Mdot
.6606 .23469 Mdot
.66448 .24396 Mdot
.66832 .25335 Mdot
.67213 .26286 Mdot
.67589 .27248 Mdot
.67961 .2822 Mdot
.68329 .29201 Mdot
.68692 .30192 Mdot
.69051 .31191 Mdot
.69405 .32198 Mdot
.69754 .33212 Mdot
.70098 .34232 Mdot
.70436 .35258 Mdot
.7077 .36289 Mdot
.71098 .37325 Mdot
.7142 .38364 Mdot
.71737 .39407 Mdot
.72048 .40452 Mdot
.72353 .41499 Mdot
.72652 .42548 Mdot
.72944 .43598 Mdot
.7323 .44648 Mdot
.7351 .45697 Mdot
.73784 .46745 Mdot
.7405 .47793 Mdot
.7431 .48838 Mdot
.74563 .4988 Mdot
.74809 .50919 Mdot
.75048 .51955 Mdot
.7528 .52986 Mdot
.75505 .54013 Mdot
.75722 .55035 Mdot
.75932 .56051 Mdot
.76134 .57062 Mdot
.76329 .58065 Mdot
.76516 .59062 Mdot
.76695 .60051 Mdot
.76867 .61033 Mdot
.7703 .62007 Mdot
.77186 .62971 Mdot
.77333 .63928 Mdot
.77473 .64874 Mdot
.77604 .65811 Mdot
.77727 .66738 Mdot
.77842 .67655 Mdot
.77949 .68562 Mdot
.78047 .69457 Mdot
.78137 .70341 Mdot
.78219 .71214 Mdot
.78292 .72075 Mdot
.78357 .72924 Mdot
.78413 .7376 Mdot
.78461 .74585 Mdot
.785 .75396 Mdot
.78531 .76195 Mdot
.78553 .7698 Mdot
.78566 .77753 Mdot
.78571 .78512 Mdot
.78568 .79257 Mdot
.78556 .79988 Mdot
.78535 .80706 Mdot
.78506 .81409 Mdot
.78468 .82099 Mdot
.78421 .82774 Mdot
.78367 .83434 Mdot
.78303 .8408 Mdot
.78231 .84711 Mdot
.78151 .85328 Mdot
.78062 .8593 Mdot
.77965 .86517 Mdot
.7786 .87089 Mdot
.77746 .87646 Mdot
.77624 .88187 Mdot
.77494 .88714 Mdot
.77356 .89226 Mdot
.7721 .89722 Mdot
.77055 .90203 Mdot
.76893 .90669 Mdot
.76723 .9112 Mdot
.76545 .91556 Mdot
.76359 .91976 Mdot
.76166 .92381 Mdot
.75965 .9277 Mdot
.75756 .93144 Mdot
.7554 .93503 Mdot
.75316 .93847 Mdot
.75086 .94176 Mdot
.74848 .94489 Mdot
.74603 .94787 Mdot
.74351 .9507 Mdot
.74092 .95338 Mdot
.73827 .95591 Mdot
.73554 .95828 Mdot
.73275 .96051 Mdot
.7299 .96258 Mdot
.72699 .96451 Mdot
.72401 .96629 Mdot
.72097 .96792 Mdot
.71787 .9694 Mdot
.71471 .97073 Mdot
.7115 .97192 Mdot
.70822 .97296 Mdot
.7049 .97385 Mdot
.70152 .9746 Mdot
.69809 .9752 Mdot
.69461 .97566 Mdot
.69107 .97598 Mdot
.68749 .97615 Mdot
.68387 .97619 Mdot
.6802 .97608 Mdot
.67648 .97582 Mdot
.67273 .97543 Mdot
.66893 .9749 Mdot
.6651 .97424 Mdot
.66122 .97343 Mdot
.65731 .97248 Mdot
.65337 .9714 Mdot
.64939 .97019 Mdot
.64539 .96884 Mdot
.64135 .96735 Mdot
.63729 .96573 Mdot
.63319 .96398 Mdot
.62908 .96209 Mdot
.62494 .96008 Mdot
.62078 .95793 Mdot
.6166 .95565 Mdot
.6124 .95325 Mdot
.60819 .95071 Mdot
.60396 .94805 Mdot
.59971 .94526 Mdot
.59546 .94235 Mdot
.5912 .93931 Mdot
.58693 .93615 Mdot
.58265 .93286 Mdot
.57837 .92945 Mdot
.57408 .92592 Mdot
.5698 .92226 Mdot
.56551 .91849 Mdot
.56123 .9146 Mdot
.55695 .91059 Mdot
.55268 .90646 Mdot
.54841 .90221 Mdot
.54416 .89785 Mdot
.53991 .89337 Mdot
.53568 .88878 Mdot
.53146 .88408 Mdot
.52726 .87926 Mdot
.52307 .87433 Mdot
.51891 .86929 Mdot
.51477 .86415 Mdot
.51064 .85889 Mdot
.50655 .85352 Mdot
.50248 .84805 Mdot
.49843 .84247 Mdot
.49442 .83679 Mdot
.49043 .83101 Mdot
.48648 .82512 Mdot
.48256 .81913 Mdot
.47868 .81304 Mdot
.47484 .80685 Mdot
.47103 .80056 Mdot
.46727 .79417 Mdot
.46354 .78769 Mdot
.45986 .78111 Mdot
.45622 .77444 Mdot
.45263 .76768 Mdot
.44909 .76083 Mdot
.4456 .75388 Mdot
.44215 .74685 Mdot
.43876 .73973 Mdot
.43542 .73253 Mdot
.43214 .72524 Mdot
.42891 .71786 Mdot
.42574 .71041 Mdot
.42262 .70287 Mdot
.41957 .69526 Mdot
.41658 .68757 Mdot
.41365 .6798 Mdot
.41078 .67197 Mdot
.40797 .66405 Mdot
.40524 .65607 Mdot
.40256 .64802 Mdot
.39996 .63991 Mdot
.39742 .63173 Mdot
.39496 .62348 Mdot
.39256 .61518 Mdot
.39024 .60681 Mdot
.38799 .59839 Mdot
.38581 .58992 Mdot
.3837 .58139 Mdot
.38167 .57281 Mdot
.37972 .56418 Mdot
.37784 .55551 Mdot
.37605 .54679 Mdot
.37433 .53804 Mdot
.37268 .52924 Mdot
.37112 .52041 Mdot
.36964 .51154 Mdot
.36824 .50265 Mdot
.36692 .49372 Mdot
.36568 .48477 Mdot
.36452 .4758 Mdot
.36345 .46681 Mdot
.36246 .45781 Mdot
.36155 .44879 Mdot
.36073 .43976 Mdot
.35999 .43072 Mdot
.35934 .42168 Mdot
.35877 .41263 Mdot
.35828 .4036 Mdot
.35788 .39456 Mdot
.35757 .38554 Mdot
.35734 .37653 Mdot
.3572 .36754 Mdot
.35714 .35857 Mdot
.35717 .34962 Mdot
.35729 .34071 Mdot
.35749 .33182 Mdot
.35777 .32297 Mdot
.35815 .31416 Mdot
.3586 .3054 Mdot
.35915 .29669 Mdot
.35977 .28803 Mdot
.36048 .27942 Mdot
.36128 .27088 Mdot
.36216 .2624 Mdot
.36312 .254 Mdot
.36417 .24567 Mdot
.3653 .23742 Mdot
.36651 .22925 Mdot
.36781 .22117 Mdot
.36918 .21319 Mdot
.37064 .2053 Mdot
.37218 .19752 Mdot
.37379 .18984 Mdot
.37549 .18228 Mdot
.37726 .17484 Mdot
.37912 .16751 Mdot
.38104 .16032 Mdot
.38305 .15325 Mdot
.38513 .14633 Mdot
.38728 .13954 Mdot
.38951 .1329 Mdot
.39181 .12641 Mdot
.39419 .12008 Mdot
.39663 .11391 Mdot
.39914 .10791 Mdot
.40173 .10207 Mdot
.40438 .09641 Mdot
.40709 .09093 Mdot
.40988 .08564 Mdot
.41273 .08053 Mdot
.41564 .07562 Mdot
.41861 .0709 Mdot
.42165 .06639 Mdot
.42474 .06208 Mdot
.42789 .05798 Mdot
.4311 .0541 Mdot
.43437 .05043 Mdot
.43769 .04699 Mdot
.44107 .04377 Mdot
.44449 .04078 Mdot
.44797 .03802 Mdot
.4515 .0355 Mdot
.45508 .03322 Mdot
.4587 .03117 Mdot
.46236 .02938 Mdot
.46608 .02783 Mdot
.46983 .02653 Mdot
.47362 .02548 Mdot
.47745 .02468 Mdot
.48132 .02414 Mdot
.48523 .02386 Mdot
.48917 .02383 Mdot
.49314 .02407 Mdot
.49715 .02456 Mdot
.50118 .02532 Mdot
.50525 .02634 Mdot
.50934 .02762 Mdot
.51345 .02916 Mdot
.51759 .03097 Mdot
.52175 .03304 Mdot
.52592 .03537 Mdot
.53012 .03796 Mdot
.53433 .04081 Mdot
.53856 .04392 Mdot
.5428 .04729 Mdot
.54706 .05091 Mdot
.55132 .05479 Mdot
.55559 .05892 Mdot
.55987 .0633 Mdot
.56415 .06792 Mdot
.56843 .07279 Mdot
.57272 .07789 Mdot
.577 .08324 Mdot
.58129 .08882 Mdot
.58557 .09462 Mdot
.58984 .10066 Mdot
.5941 .10691 Mdot
.59836 .11339 Mdot
.60261 .12007 Mdot
.60684 .12697 Mdot
.61106 .13407 Mdot
.61526 .14137 Mdot
.61945 .14886 Mdot
.62362 .15654 Mdot
.62776 .16441 Mdot
.63189 .17245 Mdot
.63599 .18066 Mdot
.64006 .18904 Mdot
.6441 .19758 Mdot
.64812 .20628 Mdot
.65211 .21512 Mdot
.65606 .2241 Mdot
.65998 .23322 Mdot
.66387 .24247 Mdot
.66771 .25185 Mdot
.67152 .26134 Mdot
.67529 .27094 Mdot
.67902 .28064 Mdot
.6827 .29044 Mdot
.68634 .30034 Mdot
.68994 .31032 Mdot
.69349 .32037 Mdot
.69698 .3305 Mdot
.70043 .34069 Mdot
.70383 .35094 Mdot
.70717 .36124 Mdot
.71046 .37159 Mdot
.71369 .38198 Mdot
.71687 .39241 Mdot
.71999 .40285 Mdot
.72305 .41333 Mdot
.72604 .42381 Mdot
.72898 .43431 Mdot
.73185 .4448 Mdot
.73466 .4553 Mdot
.73741 .46579 Mdot
.74008 .47626 Mdot
.74269 .48671 Mdot
.74523 .49714 Mdot
.74771 .50754 Mdot
.75011 .5179 Mdot
.75244 .52822 Mdot
.75469 .5385 Mdot
.75688 .54873 Mdot
.75899 .5589 Mdot
.76102 .56901 Mdot
.76298 .57906 Mdot
.76487 .58904 Mdot
.76667 .59894 Mdot
.7684 .60877 Mdot
.77005 .61852 Mdot
.77161 .62818 Mdot
.7731 .63776 Mdot
.77451 .64724 Mdot
.77584 .65663 Mdot
.77708 .66591 Mdot
.77825 .6751 Mdot
.77933 .68418 Mdot
.78032 .69315 Mdot
.78124 .70201 Mdot
.78207 .71075 Mdot
.78281 .71938 Mdot
.78347 .72789 Mdot
.78405 .73628 Mdot
.78454 .74454 Mdot
.78494 .75268 Mdot
.78526 .76068 Mdot
.7855 .76856 Mdot
.78565 .77631 Mdot
.78571 .78392 Mdot
.78569 .79139 Mdot
.78558 .79873 Mdot
.78539 .80592 Mdot
.78511 .81298 Mdot
.78474 .8199 Mdot
.78429 .82667 Mdot
.78376 .8333 Mdot
.78314 .83978 Mdot
.78243 .84612 Mdot
.78164 .85231 Mdot
.78077 .85835 Mdot
.77981 .86424 Mdot
.77877 .86998 Mdot
.77765 .87558 Mdot
.77644 .88102 Mdot
.77516 .88631 Mdot
.77379 .89145 Mdot
.77234 .89644 Mdot
.77081 .90128 Mdot
.7692 .90596 Mdot
.76751 .91049 Mdot
.76574 .91487 Mdot
.76389 .9191 Mdot
.76197 .92317 Mdot
.75997 .92709 Mdot
.7579 .93086 Mdot
.75575 .93447 Mdot
.75353 .93793 Mdot
.75123 .94124 Mdot
.74886 .9444 Mdot
.74642 .94741 Mdot
.74392 .95026 Mdot
.74134 .95296 Mdot
.73869 .95551 Mdot
.73598 .95791 Mdot
.7332 .96016 Mdot
.73036 .96226 Mdot
.72745 .96421 Mdot
.72449 .96601 Mdot
.72146 .96767 Mdot
.71837 .96917 Mdot
.71522 .97053 Mdot
.71201 .97174 Mdot
.70875 .9728 Mdot
.70543 .97372 Mdot
.70206 .97449 Mdot
.69864 .97512 Mdot
.69516 .9756 Mdot
.69164 .97594 Mdot
.68807 .97614 Mdot
.68445 .97619 Mdot
.68079 .9761 Mdot
.67708 .97587 Mdot
.67333 .97551 Mdot
.66954 .975 Mdot
.66571 .97435 Mdot
.66184 .97357 Mdot
.65794 .97264 Mdot
.654 .97159 Mdot
.65003 .97039 Mdot
.64603 .96906 Mdot
.642 .9676 Mdot
.63793 .966 Mdot
.63385 .96427 Mdot
.62974 .9624 Mdot
.6256 .96041 Mdot
.62144 .95828 Mdot
.61727 .95602 Mdot
.61307 .95364 Mdot
.60886 .95113 Mdot
.60463 .94848 Mdot
.60039 .94572 Mdot
.59614 .94282 Mdot
.59188 .9398 Mdot
.58761 .93666 Mdot
.58333 .93339 Mdot
.57905 .93 Mdot
.57477 .92649 Mdot
.57048 .92285 Mdot
.5662 .9191 Mdot
.56191 .91523 Mdot
.55763 .91123 Mdot
.55336 .90712 Mdot
.54909 .9029 Mdot
.54483 .89855 Mdot
.54059 .8941 Mdot
.53635 .88952 Mdot
.53213 .88484 Mdot
.52793 .88004 Mdot
.52374 .87513 Mdot
.51957 .8701 Mdot
.51542 .86497 Mdot
.5113 .85973 Mdot
.5072 .85439 Mdot
.50312 .84893 Mdot
.49907 .84337 Mdot
.49505 .8377 Mdot
.49107 .83193 Mdot
.48711 .82606 Mdot
.48319 .82009 Mdot
.4793 .81401 Mdot
.47545 .80784 Mdot
.47164 .80157 Mdot
.46786 .7952 Mdot
.46413 .78873 Mdot
.46044 .78217 Mdot
.4568 .77551 Mdot
.4532 .76876 Mdot
.44965 .76192 Mdot
.44615 .75499 Mdot
.4427 .74798 Mdot
.4393 .74087 Mdot
.43595 .73368 Mdot
.43266 .7264 Mdot
.42942 .71904 Mdot
.42624 .7116 Mdot
.42312 .70408 Mdot
.42005 .69648 Mdot
.41705 .6888 Mdot
.41411 .68105 Mdot
.41123 .67322 Mdot
.40842 .66532 Mdot
.40567 .65735 Mdot
.40298 .64931 Mdot
.40037 .6412 Mdot
.39782 .63303 Mdot
.39535 .6248 Mdot
.39294 .6165 Mdot
.3906 .60815 Mdot
.38834 .59974 Mdot
.38615 .59127 Mdot
.38403 .58275 Mdot
.38199 .57418 Mdot
.38003 .56556 Mdot
.37814 .55689 Mdot
.37633 .54818 Mdot
.37459 .53943 Mdot
.37294 .53064 Mdot
.37136 .52182 Mdot
.36987 .51296 Mdot
.36845 .50407 Mdot
.36712 .49515 Mdot
.36587 .4862 Mdot
.3647 .47723 Mdot
.36361 .46825 Mdot
.36261 .45924 Mdot
.36169 .45022 Mdot
.36085 .44119 Mdot
.3601 .43216 Mdot
.35943 .42312 Mdot
.35885 .41407 Mdot
.35835 .40503 Mdot
.35794 .396 Mdot
.35761 .38698 Mdot
.35737 .37797 Mdot
.35722 .36897 Mdot
.35715 .36 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{198, 198},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQ000`40O003h00OaWoo0036Ool00<Io
o`00aWoo001EOol30004Ool20002Ool70002Ool30002Ool300000goo000000030002Ool2000017oo
000000000Woo1000@Goo001FOol00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol00`000goo
0P000goo0P000goo00D007ooOomoo`00009oo`@000=oo`03001oogoo045oo`00EWoo0`000Woo00@0
07ooOol0009oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`03Ool01@00Oomoogoo0000
0Woo00@007ooOol000=oo`03001oogoo045oo`00EWoo00<007oo00000goo0`000Woo00<007ooOol0
0`000Woo0`000Woo0`000Woo0P0017oo1P000goo00<007ooOol0@Goo001EOol40008Ool00`00Oomo
o`0NOol00`00Oomoo`11Ool0061oo`80019oo`03001oogoo00Yoo`8004=oo`00aWoo0036Ool00<Io
o`00aWoo0036Ool00<Ioo`00aWoo0036Ool001]oo`03001oogoo01Uoo`03001oogoo009oo`04001o
ogooOol3000DOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0COol00`00Oomoo`02Ool0
0`00Oomoo`02Ool2000DOol00`00Oomoo`02Ool01000Oomoogoo0`0067oo0`001goo000JOol00`00
Ool0000IOol00`00Ool00008Ool00`00Oomoo`0BOol00`00Ool00007Ool3000DOol00`00Ool00007
Ool00`00Ool0000COol00`00Ool00007Ool00`00Ool0000IOol00`00Oomoo`06Ool001Yoo`03001o
o`0001Uoo`03001oo`0000Uoo`03001oogoo015oo`03001oo`0000Moo`03001oo`0001Aoo`03001o
o`0000Moo`<001=oo`03001oo`0000Qoo`03001oogoo01Qoo`03001oogoo00Ioo`006Woo00<007oo
00006Goo00<007oo00002Goo00<007ooOol04Goo00<007oo000027oo0P0057oo00<007oo00001goo
00<007ooOol04goo00<007oo00001goo00<007oo00006Goo00<007ooOol01Woo000KOol00`00Oomo
o`0IOol00`00Oomoo`06Ool3000DOol00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`07Ool2
000DOol00`00Oomoo`06Ool3000HOol20008Ool00<Ioo`00aWoo0036Ool00<Ioo`005goo[0000goo
000GOol01@00Oomoogoo000087oo00<007ooOol07Goo00<007ooOol07Woo00<007ooOol07Goo00<0
07ooOol07Woo00D007ooOomoo`0000=oo`005goo00<007ooOol0Z7oo00<007ooOol00Goo000BOol0
0`00Oomoo`02Ool00`00Oomoo`2XOol00`00Oomoo`01Ool0015oo`03001oo`0000=oo`80009oo`03
001oogoo04Uoo`L005=oo`8000=oo`004Goo00<007oo00000goo00<007ooOol00Woo00<007ooOol0
AWoo0`001Woo0`00DGoo00<007ooOol00Goo000AOol00`00Ool00003Ool00`00Oomoo`04Ool00`00
Oomoo`13Ool00`00Oomoo`0:Ool2001?Ool00`00Oomoo`01Ool0019oo`03001oogoo009oo`03001o
ogoo00Eoo`03001oogoo041oo`8000ioo`8004ioo`03001oogoo005oo`005goo00<007ooOol0Agoo
0P004Goo00<007ooOol0Bgoo00<007ooOol00Goo000GOol00`00Oomoo`06Ool00`00Oomoo`0nOol0
0`00Oomoo`0AOol00`00Oomoo`1:Ool00`00Oomoo`01Ool001Moo`8000Qoo`03001oogoo03aoo`03
001oogoo01=oo`03001oogoo04Qoo`8000=oo`005goo00<007ooOol027oo0P00>goo00<007ooOol0
5Goo00<007ooOol0B7oo00<007ooOol00Goo000GOol00`00Oomoo`0:Ool00`00Oomoo`0hOol00`00
Oomoo`0EOol20019Ool00`00Oomoo`01Ool001Moo`03001oogoo00]oo`03001oogoo03Ioo`03001o
ogoo01Qoo`03001oogoo04Ioo`03001oogoo005oo`005goo00<007ooOol02goo00<007ooOol0=Goo
0P006goo00<007ooOol0AGoo00<007ooOol00Goo000GOol00`00Oomoo`0<Ool00`00Oomoo`0dOol0
0`00Oomoo`0JOol00`00Oomoo`15Ool00`00Oomoo`01Ool001Moo`03001oogoo00eoo`8003=oo`03
001oogoo01aoo`03001oogoo04Aoo`03001oogoo005oo`005goo0P0047oo00<007ooOol0<7oo00<0
07ooOol07Goo00<007ooOol0@Woo0P000goo000GOol00`00Oomoo`0@Ool00`00Oomoo`0^Ool00`00
Oomoo`0NOol20014Ool00`00Oomoo`01Ool001Moo`03001oogoo015oo`03001oogoo02eoo`03001o
ogoo01moo`03001oogoo049oo`03001oogoo005oo`005goo00<007ooOol0@7oo00<007ooOol08Goo
00<007ooOol0@Goo00<007ooOol00Goo000GOol00`00Oomoo`0BOol00`00Oomoo`0[Ool00`00Oomo
o`0ROol00`00Oomoo`10Ool00`00Oomoo`01Ool001Moo`03001oogoo01=oo`03001oogoo02Yoo`03
001oogoo029oo`03001oogoo041oo`03001oogoo005oo`005goo0P005Woo00<007ooOol09goo00<0
07ooOol08goo00<007ooOol0?goo0P000goo000GOol00`00Oomoo`0FOol00`00Oomoo`0VOol00`00
Oomoo`0TOol00`00Oomoo`0oOol00`00Oomoo`01Ool001Moo`03001oogoo01Moo`03001oogoo02Eo
o`03001oogoo02Eoo`03001oogoo03ioo`03001oogoo005oo`005goo00<007ooOol05goo00<007oo
Ool097oo0P00J7oo00<007ooOol00Goo000GOol00`00Oomoo`0HOol00`00Oomoo`0SOol00`00Oomo
o`0WOol00`00Oomoo`0mOol00`00Oomoo`01Ool001Moo`03001oogoo01Uoo`8002=oo`03001oogoo
02Moo`03001oogoo03eoo`03001oogoo005oo`005goo00<007ooOol06goo00<007ooOol087oo00<0
07ooOol0:7oo00<007ooOol0?7oo00<007ooOol00Goo000GOol2000MOol00`00Oomoo`0NOol00`00
Oomoo`1WOol20003Ool001Moo`03001oogoo01aoo`03001oogoo01ioo`03001oogoo02Yoo`03001o
ogoo03]oo`03001oogoo005oo`005goo00<007ooOol07Goo00<007ooOol07Goo00<007ooOol0:Woo
00<007ooOol0>goo00<007ooOol00Goo000GOol00`00Oomoo`0NOol00`00Oomoo`0LOol00`00Oomo
o`1XOol00`00Oomoo`01Ool001Moo`03001oogoo01moo`03001oogoo04Uoo`03001oogoo03Yoo`03
001oogoo005oo`002Goo00<007ooOol00Woo00@007ooOomoo`<0009oo`03001oogoo025oo`03001o
ogoo01Qoo`03001oogoo02eoo`03001oogoo03Uoo`03001oogoo005oo`0027oo00<007oo000027oo
00@007ooOomoo`8002=oo`03001oogoo01Moo`03001oogoo06Qoo`8000=oo`0027oo00<007oo0000
2Goo00@007ooOol003ioo`03001oogoo02eoo`03001oogoo03Uoo`03001oogoo005oo`0027oo00<0
07oo00002Goo00@007ooOol002Eoo`03001oogoo01Ioo`03001oogoo02ioo`03001oogoo03Qoo`03
001oogoo005oo`002Goo00<007ooOol01Woo0`000Woo00<007ooOol097oo00<007ooOol05Goo00<0
07ooOol0JGoo00<007ooOol00Goo000GOol00`00Oomoo`0UOol2000DOol00`00Oomoo`0`Ool00`00
Oomoo`0gOol00`00Oomoo`01Ool001Moo`03001oogoo02Moo`03001oogoo015oo`03001oogoo031o
o`03001oogoo03Moo`03001oogoo005oo`005goo00<007ooOol0:7oo00<007ooOol047oo00<007oo
Ool0JWoo00<007ooOol00Goo000GOol2000YOol00`00Oomoo`0@Ool00`00Oomoo`0aOol00`00Oomo
o`0eOol20003Ool001Moo`03001oogoo02Uoo`03001oogoo00moo`03001oogoo039oo`03001oogoo
03Eoo`03001oogoo005oo`005goo00<007ooOol0:Woo00<007ooOol03Woo00<007ooOol0<Woo00<0
07ooOol0=Goo00<007ooOol00Goo000GOol00`00Oomoo`0[Ool00`00Oomoo`0=Ool00`00Oomoo`0b
Ool00`00Oomoo`0eOol00`00Oomoo`01Ool001Moo`03001oogoo02eoo`03001oogoo00]oo`03001o
ogoo06Yoo`03001oogoo005oo`005goo00<007ooOol0;Woo00<007ooOol0@7oo00<007ooOol0=7oo
00<007ooOol00Goo000GOol2000kOol2000fOol00`00Oomoo`0bOol20003Ool001Moo`03001oogoo
02moo`03001oogoo00Qoo`03001oogoo03Eoo`03001oogoo03=oo`03001oogoo005oo`005goo00<0
07ooOol0<7oo00<007ooOol0?goo00<007ooOol0<goo00<007ooOol00Goo000GOol00`00Oomoo`0a
Ool20007Ool00`00Oomoo`1[Ool00`00Oomoo`01Ool001Moo`03001oogoo03=oo`03001oogoo00Ao
o`03001oogoo03Ioo`03001oogoo039oo`03001oogoo005oo`005goo00<007ooOol0=7oo00<007oo
Ool0?7oo00<007ooOol0<Woo00<007ooOol00Goo000GOol00`00Oomoo`0dOol00`00Oomoo`03Ool0
0`00Oomoo`0gOol00`00Oomoo`0aOol00`00Oomoo`01Ool001Moo`8003Ioo`03001oogoo009oo`03
001oogoo03Moo`03001oogoo031oo`8000=oo`005goo00<007ooOol0=Woo00<007ooOol0Kgoo00<0
07ooOol00Goo000GOol00`00Oomoo`0gOol200000goo001oo`0iOol00`00Oomoo`0`Ool00`00Oomo
o`01Ool001Moo`03001oogoo03Uoo`8006eoo`03001oogoo005oo`005goo00<007ooOol0>Woo00<0
07ooOol0>7oo00<007ooOol0<7oo00<007ooOol00Goo000GOol00`00Oomoo`0jOol00`00Oomoo`0i
Ool00`00Oomoo`0_Ool00`00Oomoo`01Ool001Moo`8003aoo`03001oogoo03Qoo`03001oogoo02io
o`8000=oo`005goo00<007ooOol0>Woo00<007oo0000>Goo00<007ooOol0;goo00<007ooOol00Goo
000GOol00`00Oomoo`0jOol01@00Oomoogoo0000JGoo00<007ooOol00Goo000GOol00`00Oomoo`0n
Ool2000gOol00`00Oomoo`0^Ool00`00Oomoo`01Ool001Moo`03001oogoo03Yoo`03001oogoo00=o
o`03001oogoo06Eoo`03001oogoo005oo`000Woo0`004Woo00<007ooOol0>Woo00<007ooOol00goo
00<007ooOol0=7oo0P00;goo00<007ooOol00Goo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool01000Oomoo`00@goo00<007ooOol0I7oo00<007ooOol00Goo0003Ool30002Ool0
0`00Ool00007Ool30002Ool2000kOol00`00Oomoo`05Ool2000dOol00`00Oomoo`0/Ool20003Ool0
00=oo`03001oo`0000<00003Ool007oo00Ioo`03001oo`00009oo`03001oogoo03Yoo`03001oogoo
00Moo`03001oogoo035oo`03001oogoo02eoo`03001oogoo005oo`000Woo1@0000Aoo`00Ool000Qo
o`80009oo`03001oogoo04Eoo`03001oogoo035oo`03001oogoo02aoo`03001oogoo005oo`0017oo
0`000Woo00<007ooOol027oo00@007ooOol003aoo`03001oogoo00Qoo`03001oogoo035oo`03001o
ogoo02aoo`03001oogoo005oo`000goo00@007ooOol0011oo`03001oogoo03]oo`03001oogoo00Qo
o`03001oogoo05moo`03001oogoo005oo`000goo00@007ooOol0011oo`03001oogoo03]oo`03001o
ogoo00Uoo`03001oogoo02moo`8002eoo`03001oogoo005oo`0017oo0`0047oo0P00?7oo00<007oo
Ool02Woo00<007ooOol0G7oo0P000goo000GOol00`00Oomoo`0kOol00`00Oomoo`0<Ool00`00Oomo
o`0]Ool00`00Oomoo`0[Ool00`00Oomoo`01Ool000=oo`<0015oo`03001oogoo03]oo`03001oogoo
00eoo`03001oogoo02aoo`03001oogoo02]oo`03001oogoo005oo`000goo00<007oo00004Goo00<0
07ooOol0>goo00<007ooOol0?Goo00<007ooOol0:Woo00<007ooOol00Goo0003Ool00`00Ool0000A
Ool00`00Oomoo`0kOol00`00Oomoo`0>Ool00`00Oomoo`0/Ool00`00Oomoo`0ZOol00`00Oomoo`01
Ool0009oo`800003Ool007oo011oo`03001oogoo03]oo`03001oogoo00moo`03001oogoo02]oo`03
001oogoo02Yoo`03001oogoo005oo`005goo00<007ooOol0>goo00<007ooOol047oo0P00:goo00<0
07ooOol0:Woo00<007ooOol00Goo0003Ool3000AOol2001AOol00`00Oomoo`1DOol20003Ool000=o
o`<0015oo`03001oogoo03]oo`8001Aoo`03001oogoo02Qoo`03001oogoo02Uoo`03001oogoo005o
o`001Goo00<007ooOol03goo00<007ooOol0?7oo00<007ooOol04Woo00<007ooOol0E7oo00<007oo
Ool00Goo0003Ool3000AOol00`00Oomoo`1BOol00`00Oomoo`0WOol00`00Oomoo`0YOol00`00Oomo
o`01Ool000=oo`03001oo`00015oo`03001oogoo03aoo`03001oogoo01Aoo`8002Qoo`03001oogoo
02Qoo`03001oogoo005oo`000goo00<007oo00004Goo00<007ooOol0?7oo00<007ooOol05Woo00<0
07ooOol09Goo00<007ooOol0:7oo00<007ooOol00Goo0003Ool00`00Ool0000AOol2001GOol00`00
Oomoo`0TOol00`00Oomoo`0WOol20003Ool0009oo`@0015oo`03001oogoo03aoo`03001oogoo01Qo
o`03001oogoo04ioo`03001oogoo005oo`005goo00<007ooOol0?Goo00<007ooOol0?Woo00<007oo
Ool09goo00<007ooOol00Goo0003Ool3000AOol00`00Oomoo`1HOol00`00Oomoo`1=Ool00`00Oomo
o`01Ool000=oo`03001oogoo015oo`03001oogoo03eoo`03001oogoo01Uoo`03001oogoo029oo`03
001oogoo02Moo`03001oogoo005oo`000goo00<007ooOol04Goo00<007ooOol0?Goo00<007ooOol0
6goo00<007ooOol087oo00<007ooOol09goo00<007ooOol00Goo0002Ool4000AOol00`00Oomoo`1L
Ool00`00Oomoo`0OOol00`00Oomoo`0WOol00`00Oomoo`01Ool000=oo`03001oogoo015oo`8003mo
o`03001oogoo01aoo`03001oogoo01moo`03001oogoo02Eoo`8000=oo`000goo0`004Goo00<007oo
Ool0?Woo00<007ooOol077oo00<007ooOol0B7oo00<007ooOol00Goo0003Ool00`00Ool0000AOol0
0`00Oomoo`1NOol00`00Oomoo`0NOol00`00Oomoo`0VOol00`00Oomoo`01Ool000=oo`03001oo`00
015oo`03001oogoo03ioo`03001oogoo01ioo`03001oogoo04Ioo`03001oogoo005oo`000Woo0P00
00=oo`00Ool047oo00<007ooOol0?goo00<007ooOol07Woo0P007Goo00<007ooOol09Woo00<007oo
Ool00Goo0009Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`0oOol00`00Oomo
o`0POol00`00Oomoo`0KOol00`00Oomoo`0UOol00`00Oomoo`01Ool0009oo`09001oo`00Ool007oo
001oo`0000Moo`03001oo`00009oo`80041oo`03001oogoo021oo`03001oogoo01]oo`03001oogoo
02Aoo`8000=oo`000Woo00T007oo001oo`00Ool007oo00001goo0`000Woo00<007ooOol0?goo00<0
07ooOol08Goo00<007ooOol06Woo00<007ooOol09Goo00<007ooOol00Goo0002Ool02@00Ool007oo
001oo`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`10Ool00`00Oomoo`0QOol00`00Oomoo`11
Ool00`00Oomoo`01Ool0009oo`D0009oo`03001oogoo00Moo`80009oo`03001oogoo041oo`03001o
ogoo029oo`03001oogoo01Qoo`03001oogoo02Eoo`03001oogoo005oo`005goo00<007ooOol0@7oo
00<007ooOol097oo00<007ooOol05goo00<007ooOol097oo00<007ooOol00Goo000GOol00`00Oomo
o`10Ool2000VOol00`00Oomoo`0FOol00`00Oomoo`0TOol00`00Oomoo`01Ool001Moo`03001oogoo
085oo`03001oogoo02Aoo`03001oogoo005oo`005goo0P00@Woo00<007ooOol09Goo00<007ooOol0
>goo0P000goo000GOol00`00Oomoo`11Ool00`00Oomoo`0VOol00`00Oomoo`0DOol00`00Oomoo`0T
Ool00`00Oomoo`01Ool001Moo`03001oogoo049oo`03001oogoo02Ioo`8001Aoo`03001oogoo02Ao
o`03001oogoo005oo`005goo00<007ooOol0@Woo00<007ooOol0:7oo00<007ooOol04Goo00<007oo
Ool097oo00<007ooOol00Goo000GOol00`00Oomoo`12Ool00`00Oomoo`0YOol00`00Oomoo`0@Ool2
000UOol00`00Oomoo`01Ool001Moo`03001oogoo04=oo`03001oogoo02Qoo`03001oogoo015oo`03
001oogoo02=oo`03001oogoo005oo`005goo0P00A7oo00<007ooOol0:Goo00<007ooOol047oo00<0
07ooOol08Woo0P000goo000GOol00`00Oomoo`13Ool00`00Oomoo`0ZOol00`00Oomoo`0?Ool00`00
Oomoo`0SOol00`00Oomoo`01Ool001Moo`03001oogoo04Aoo`03001oogoo02Yoo`03001oogoo03Ao
o`03001oogoo005oo`005goo00<007ooOol0A7oo00<007ooOol0;7oo00<007ooOol037oo00<007oo
Ool08goo00<007ooOol00Goo000GOol00`00Oomoo`15Ool00`00Oomoo`0/Ool00`00Oomoo`0;Ool0
0`00Oomoo`0SOol00`00Oomoo`01Ool001Moo`03001oogoo04Eoo`03001oogoo061oo`03001oogoo
005oo`005goo00<007ooOol0AGoo00<007ooOol0;Goo00<007ooOol02Woo00<007ooOol08goo00<0
07ooOol00Goo000GOol20017Ool00`00Oomoo`0]Ool00`00Oomoo`0:Ool00`00Oomoo`0QOol20003
Ool001Moo`03001oogoo04Ioo`03001oogoo02ioo`8002moo`03001oogoo005oo`005goo00<007oo
Ool0AWoo00<007ooOol0<7oo00<007ooOol01goo00<007ooOol08Woo00<007ooOol00Goo000GOol0
0`00Oomoo`17Ool00`00Oomoo`0`Ool00`00Oomoo`06Ool00`00Oomoo`0ROol00`00Oomoo`01Ool0
01Moo`03001oogoo04Moo`03001oogoo031oo`03001oogoo00Ioo`03001oogoo029oo`03001oogoo
005oo`005goo00<007ooOol0B7oo00<007ooOol0<7oo00<007ooOol01Goo00<007ooOol08Woo00<0
07ooOol00Goo000GOol2001:Ool00`00Oomoo`0`Ool20005Ool00`00Oomoo`0QOol20003Ool001Mo
o`03001oogoo04Uoo`03001oogoo039oo`03001oogoo009oo`03001oogoo029oo`03001oogoo005o
o`005goo00<007ooOol0BGoo00<007ooOol0<goo00<007ooOol09Woo00<007ooOol00Goo000GOol0
0`00Oomoo`1:Ool00`00Oomoo`0cOol01000Oomoo`0097oo00<007ooOol00Goo000GOol00`00Oomo
o`1:Ool00`00Oomoo`0fOol00`00Oomoo`0ROol00`00Oomoo`01Ool001Moo`03001oogoo04]oo`03
001oogoo03=oo`<002Aoo`03001oogoo005oo`002Goo00<007ooOol00Woo00@007ooOomoo`<0009o
o`03001oogoo04aoo`03001oogoo03=oo`03001oogoo02=oo`03001oogoo005oo`0027oo00<007oo
00001goo00<007oo00000Woo0P00CGoo00<007ooOol0=7oo0P008Woo0P000goo0008Ool00`00Ool0
0008Ool01@00Oomoogoo0000Cgoo00<007ooOol0<goo00<007oo00008Woo00<007ooOol00Goo0008
Ool00`00Ool00007Ool00`00Ool00002Ool00`00Oomoo`1=Ool00`00Oomoo`0cOol01000Oomoo`00
8Goo00<007ooOol00Goo0009Ool00`00Oomoo`06Ool30002Ool00`00Oomoo`1>Ool00`00Oomoo`0b
Ool01000Oomoo`008Goo00<007ooOol00Goo000GOol00`00Oomoo`1>Ool00`00Oomoo`0bOol01@00
Oomoogoo000087oo00<007ooOol00Goo000GOol00`00Oomoo`1?Ool00`00Oomoo`0aOol00`00Oomo
o`02Ool2000NOol00`00Oomoo`01Ool001Moo`80051oo`80039oo`03001oogoo00Aoo`03001oogoo
01Yoo`8000=oo`005goo00<007ooOol0D7oo00<007ooOol0<7oo00<007ooOol01Goo00<007ooOol0
6Woo00<007ooOol00Goo000GOol00`00Oomoo`1AOol00`00Oomoo`0_Ool00`00Oomoo`05Ool00`00
Oomoo`0JOol00`00Oomoo`01Ool001Moo`03001oogoo055oo`80031oo`03001oogoo00Ioo`03001o
ogoo01Uoo`03001oogoo005oo`005goo00<007ooOol0DWoo00<007ooOol0;Woo00<007ooOol01goo
00<007ooOol067oo00<007ooOol00Goo000GOol00`00Oomoo`1COol2000]Ool00`00Oomoo`09Ool0
0`00Oomoo`0GOol00`00Oomoo`01Ool001Moo`03001oogoo05Aoo`03001oogoo02]oo`03001oogoo
00]oo`03001oogoo01Eoo`03001oogoo005oo`005goo0P00EGoo0P00;7oo00<007ooOol037oo00<0
07ooOol04goo0P000goo000GOol00`00Oomoo`1FOol00`00Oomoo`0YOol00`00Oomoo`0SOol00`00
Oomoo`01Ool001Moo`03001oogoo05Ioo`03001oogoo02Uoo`03001oogoo00eoo`03001oogoo01=o
o`03001oogoo005oo`005goo00<007ooOol0Egoo00<007ooOol0:7oo00<007ooOol03Woo00<007oo
Ool04Woo00<007ooOol00Goo000GOol00`00Oomoo`1HOol2000WOol00`00Oomoo`0@Ool2000BOol0
0`00Oomoo`01Ool001Moo`03001oogoo05Uoo`03001oogoo02Eoo`03001oogoo019oo`03001oogoo
00moo`03001oogoo005oo`005goo0P00Fgoo00<007ooOol097oo00<007ooOol04goo00<007ooOol0
3Goo0P000goo000GOol00`00Oomoo`1KOol00`00Oomoo`0ROol2000EOol00`00Oomoo`0>Ool00`00
Oomoo`01Ool001Moo`03001oogoo05aoo`03001oogoo025oo`03001oogoo01Eoo`03001oogoo00eo
o`03001oogoo005oo`005goo00<007ooOol0GGoo00<007ooOol087oo00<007ooOol05Woo0P003Goo
00<007ooOol00Goo000GOol00`00Oomoo`1NOol00`00Oomoo`0NOol00`00Oomoo`0IOol00`00Oomo
o`0:Ool00`00Oomoo`01Ool001Moo`03001oogoo05moo`8001ioo`03001oogoo01Yoo`03001oogoo
00Uoo`03001oogoo005oo`005goo00<007ooOol0H7oo0P0077oo00<007ooOol077oo00<007ooOol0
27oo00<007ooOol00Goo000GOol2001ROol2000JOol2000XOol20003Ool001Moo`03001oogoo06=o
o`8001Moo`80021oo`03001oogoo00Moo`03001oogoo005oo`005goo00<007ooOol0I7oo0`005Goo
00<007ooOol087oo00<007ooOol01Woo00<007ooOol00Goo000GOol00`00Oomoo`1VOol2000COol0
0`00Oomoo`0SOol00`00Oomoo`04Ool00`00Oomoo`01Ool001Moo`03001oogoo06Qoo`8000moo`80
02Moo`03001oogoo00=oo`03001oogoo005oo`004Goo0`000goo00<007ooOol0JWoo0`002Woo0`00
:Goo00<007ooOol00Woo00<007ooOol00Goo000BOol00`00Oomoo`02Ool2001^Ool;000/Ool00`00
Oomoo`020003Ool0019oo`03001oogoo009oo`03001oogoo0:Qoo`03001oogoo005oo`004Woo00<0
07ooOol00Woo00<007ooOol0Z7oo00<007ooOol00Goo000AOol20004Ool01@00Oomoogoo000087oo
00<007ooOol07Goo00<007ooOol07Woo00<007ooOol07Goo00<007ooOol07Woo00D007ooOomoo`00
00=oo`005goo[0000goo0000\
\>"],
  ImageRangeCache->{{{0, 197}, {197, 0}} -> {-0.170893, -0.18599, 0.00615251, 
  0.00615251}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComparisonPlot[7/20, 4/5];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147052 0.588614 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01471 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13243 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25015 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36787 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13243 m
1 .13243 L
s
P
p
0 0 .5 r
.001 w
0 .25015 m
1 .25015 L
s
P
p
0 0 .5 r
.001 w
0 .36787 m
1 .36787 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01471 m
.00625 .01471 L
s
P
[(0)] -0.0125 .01471 1 0 0 Minner Mrotshowa
p
.002 w
0 .13243 m
.00625 .13243 L
s
P
[(0.2)] -0.0125 .13243 1 0 0 Minner Mrotshowa
p
.002 w
0 .25015 m
.00625 .25015 L
s
P
[(0.4)] -0.0125 .25015 1 0 0 Minner Mrotshowa
p
.002 w
0 .36787 m
.00625 .36787 L
s
P
[(0.6)] -0.0125 .36787 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03825 m
.00375 .03825 L
s
P
p
.001 w
0 .06179 m
.00375 .06179 L
s
P
p
.001 w
0 .08534 m
.00375 .08534 L
s
P
p
.001 w
0 .10888 m
.00375 .10888 L
s
P
p
.001 w
0 .15597 m
.00375 .15597 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20306 m
.00375 .20306 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32078 m
.00375 .32078 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41496 m
.00375 .41496 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01471 m
1 .01471 L
s
P
p
.002 w
.99375 .13243 m
1 .13243 L
s
P
p
.002 w
.99375 .25015 m
1 .25015 L
s
P
p
.002 w
.99375 .36787 m
1 .36787 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03825 m
1 .03825 L
s
P
p
.001 w
.99625 .06179 m
1 .06179 L
s
P
p
.001 w
.99625 .08534 m
1 .08534 L
s
P
p
.001 w
.99625 .10888 m
1 .10888 L
s
P
p
.001 w
.99625 .15597 m
1 .15597 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20306 m
1 .20306 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32078 m
1 .32078 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41496 m
1 .41496 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .22072 m
.04365 .15055 L
.06349 .08899 L
.07341 .06349 L
.08333 .0426 L
.08829 .03413 L
.09325 .02709 L
.09821 .02157 L
.10069 .0194 L
.10317 .01763 L
.10565 .01627 L
.10689 .01575 L
.10813 .01533 L
.10938 .01502 L
.11062 .01481 L
.11186 .01472 L
.1131 .01472 L
.11434 .01484 L
.11558 .01506 L
.11682 .01539 L
.11806 .01583 L
.12054 .01704 L
.12302 .01867 L
.12798 .02325 L
.13294 .02955 L
.14286 .04717 L
.15278 .07107 L
.1627 .10057 L
.18254 .17271 L
.22222 .3395 L
.24206 .41807 L
.2619 .4856 L
.27183 .51413 L
.28175 .53883 L
.29167 .55955 L
.30159 .57625 L
.31151 .5889 L
.31647 .59373 L
.32143 .59756 L
.32639 .60041 L
.32887 .60147 L
.33135 .60229 L
.33259 .60261 L
.33383 .60287 L
.33507 .60307 L
.33631 .60321 L
.33755 .6033 L
.33879 .60332 L
.34003 .60328 L
.34127 .60319 L
Mistroke
.34251 .60304 L
.34375 .60283 L
.34623 .60224 L
.34871 .60142 L
.35119 .60037 L
.35615 .59761 L
.36111 .59396 L
.37103 .58407 L
.38095 .57086 L
.40079 .535 L
.42063 .48763 L
.46032 .36469 L
.5 .22072 L
.51984 .15055 L
.53968 .08899 L
.5496 .06349 L
.55952 .0426 L
.56448 .03413 L
.56944 .02709 L
.5744 .02157 L
.57688 .0194 L
.57937 .01763 L
.58061 .0169 L
.58185 .01627 L
.58309 .01575 L
.58433 .01533 L
.58557 .01502 L
.58681 .01481 L
.58805 .01472 L
.58929 .01472 L
.59053 .01484 L
.59177 .01506 L
.59301 .01539 L
.59425 .01583 L
.59673 .01704 L
.59921 .01867 L
.60417 .02325 L
.60913 .02955 L
.61905 .04717 L
.62897 .07107 L
.63889 .10057 L
.65873 .17271 L
.69841 .3395 L
.71825 .41807 L
.7381 .4856 L
.74802 .51413 L
.75794 .53883 L
.76786 .55955 L
.77778 .57625 L
.78274 .58308 L
Mistroke
.7877 .5889 L
.79266 .59373 L
.79762 .59756 L
.8001 .59911 L
.80258 .60041 L
.80506 .60147 L
.80754 .60229 L
.80878 .60261 L
.81002 .60287 L
.81126 .60307 L
.8125 .60321 L
.81374 .6033 L
.81498 .60332 L
.81622 .60328 L
.81746 .60319 L
.8187 .60304 L
.81994 .60283 L
.82242 .60224 L
.8249 .60142 L
.82738 .60037 L
.83234 .59761 L
.8373 .59396 L
.84722 .58407 L
.85714 .57086 L
.87698 .535 L
.89683 .48763 L
.93651 .36469 L
.97619 .22072 L
Mfstroke
P
P
p
p
.02 w
.02381 .22072 m
.02505 .22074 L
.02629 .22079 L
.02753 .22088 L
.02877 .221 L
.03001 .22116 L
.03125 .22136 L
.03373 .22185 L
.03621 .22249 L
.03869 .22326 L
.04365 .22523 L
.05357 .2308 L
.06349 .23846 L
.08333 .25951 L
.10317 .28694 L
.14286 .35316 L
.18254 .41938 L
.20238 .44681 L
.2123 .45823 L
.22222 .46785 L
.23214 .47552 L
.2371 .47857 L
.24206 .48108 L
.24702 .48305 L
.2495 .48383 L
.25198 .48446 L
.25446 .48496 L
.2557 .48515 L
.25694 .48531 L
.25818 .48544 L
.25942 .48553 L
.26066 .48558 L
.2619 .4856 L
.26314 .48558 L
.26438 .48553 L
.26562 .48544 L
.26687 .48531 L
.26935 .48496 L
.27183 .48446 L
.27431 .48383 L
.27679 .48305 L
.28175 .48108 L
.29167 .47552 L
.30159 .46785 L
.32143 .44681 L
.34127 .41938 L
.38095 .35316 L
.42063 .28694 L
.44048 .25951 L
.4504 .24809 L
Mistroke
.46032 .23846 L
.47024 .2308 L
.48016 .22523 L
.48512 .22326 L
.4876 .22249 L
.49008 .22185 L
.49256 .22136 L
.4938 .22116 L
.49504 .221 L
.49628 .22088 L
.49752 .22079 L
.49876 .22074 L
.5 .22072 L
.50124 .22074 L
.50248 .22079 L
.50372 .22088 L
.50496 .221 L
.5062 .22116 L
.50744 .22136 L
.50992 .22185 L
.5124 .22249 L
.51488 .22326 L
.51984 .22523 L
.52976 .2308 L
.53968 .23846 L
.55952 .25951 L
.57937 .28694 L
.61905 .35316 L
.65873 .41938 L
.67857 .44681 L
.68849 .45823 L
.69841 .46785 L
.70833 .47552 L
.71329 .47857 L
.71825 .48108 L
.72321 .48305 L
.72569 .48383 L
.72817 .48446 L
.73065 .48496 L
.73189 .48515 L
.73313 .48531 L
.73437 .48544 L
.73562 .48553 L
.73686 .48558 L
.7381 .4856 L
.73934 .48558 L
.74058 .48553 L
.74182 .48544 L
.74306 .48531 L
.74554 .48496 L
Mistroke
.74802 .48446 L
.7505 .48383 L
.75298 .48305 L
.75794 .48108 L
.76786 .47552 L
.77778 .46785 L
.79762 .44681 L
.81746 .41938 L
.85714 .35316 L
.89683 .28694 L
.91667 .25951 L
.93651 .23846 L
.94643 .2308 L
.95139 .22775 L
.95635 .22523 L
.96131 .22326 L
.96379 .22249 L
.96627 .22185 L
.96875 .22136 L
.96999 .22116 L
.97123 .221 L
.97247 .22088 L
.97371 .22079 L
.97495 .22074 L
.97619 .22072 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol007Mo
o`<007]oo`00N7oo00<007ooOol0NWoo001hOol30002Ool01000Ool007oo1@00Kgoo001hOol02000
Oomoo`00Ool007oo0003Ool00`00Oomoo`1_Ool007Qoo`08001oogoo001oo`00Ool000=oo`03001o
ogoo06moo`00Mgoo10000Woo0`000Woo0P00LGoo001mOol00`00Oomoo`1eOol007aoo`8000Eoo`03
001oogoo06moo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol001moo`03001o
ogoo01Yoo`<001]oo`<001aoo`<001eoo`03001oogoo01Uoo`<001aoo`8001moo`007Woo00<007oo
000077oo00<007ooOol06goo00<007ooOol07Goo00<007ooOol06Goo0`007Goo00<007ooOol06Goo
00<007oo00007goo000NOol00`00Ool0000LOol00`00Oomoo`0LOol00`00Oomoo`0KOol00`00Oomo
o`0JOol00`00Ool0000KOol3000KOol3000OOol001ioo`03001oo`0001aoo`03001oogoo01aoo`03
001oogoo01aoo`03001oogoo01Yoo`8001]oo`03001oogoo01]oo`03001oogoo01moo`007goo00<0
07ooOol06Woo0P0077oo0`0077oo0`007Goo00<007ooOol06Goo0`0077oo0P007goo003eOol00?Eo
o`00mGoo003eOol001]oolP0019oo`006goo00<007ooOol00Woo00<007ooOol06goo00<007ooOol0
6goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol0
2goo00<007ooOol047oo000FOol00`00Oomoo`02Ool00`00Oomoo`0@Ool7IcT9Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0@Ool7IcT4Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?
Oomoo`0;Ool00`00Oomoo`0@Ool001Eoo`03001oo`0000=oo`80011oo`UW>@Qoo`0300moogoo01]o
o`0300moogoo01]oo`0300moogoo00moo`UW>@=oo`0300moogoo01]oo`0300moogoo01]oo`0300mo
ogoo00Uoo`<0019oo`005Goo00<007oo00000goo00<007ooOol03Woo2VLi27oo00<03gooOol06goo
00<03gooOol06goo00<03gooOol03Woo2VLi0goo00<03gooOol06goo00<03gooOol06goo00<03goo
Ool02goo00<007ooOol047oo000EOol00`00Ool00003Ool00`00Oomoo`0=Ool6IcT2Ool4IcT7Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0=Ool5IcT3Ool4IcT2Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Ioo`03001oogoo009oo`03001oogoo
00eoo`AW>@Aoo`AW>@Moo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00eoo`AW>@Aoo`AW
>@9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo0P00
3Goo16Li1Woo16Li1Woo00<03gooOol06goo00<03gooOol06goo00<03gooOol037oo16Li1Woo16Li
00=oo`0?Ool077oo00<03gooOol06goo00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0<Ool4
IcT6Ool5IcT5Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0<Ool4IcT6Ool5IcT00`0?
Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00]o
o`AW>@Qoo`AW>@Eoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00]oo`AW>@Qoo`AW>@03
00moogoo01]oo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol0
2goo16Li2Goo16Li17oo00<03gooOol06goo00<03gooOol06goo00<03gooOol02goo16Li2Goo16Li
7Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0:Ool4IcT:
Ool4IcT4Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool4IcT:Ool4IcTMOol00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`8000]oo`AW>@]oo`=W>@Aoo`0300mo
ogoo01]oo`0300moogoo01]oo`0300moogoo00Yoo`AW>@]oo`=W>Aeoo`0300moogoo01]oo`0300mo
ogoo00Yoo`80019oo`006goo00<007ooOol02Woo0fLi37oo16Li0goo00<03gooOol06goo00<03goo
Ool06goo00<03gooOol02Goo16Li37oo16Li77oo00<03gooOol06goo00<03gooOol02goo00<007oo
Ool047oo000KOol00`00Oomoo`09Ool4IcT<Ool4IcT3Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0
0`0?Oomoo`09Ool4IcT<Ool4IcTLOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
01]oo`03001oogoo00Uoo`AW>@eoo`AW>@9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo
00Uoo`=W>@ioo`AW>A]oo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<0
07ooOol02Goo0fLi3Woo16Li0Woo00<03gooOol06goo00<03gooOol06goo00<03gooOol027oo16Li
3Woo16Li6goo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol2000:Ool3IcT?
Ool3IcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`08Ool4IcT?Ool3IcTKOol00`0?
Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol001]oo`03001oogoo00Uoo`=W>@moo`AW>@03Ool03goo
01aoo`0300moogoo01]oo`0300moogoo00Qoo`=W>A1oo`AW>AYoo`0300moogoo01]oo`0300moogoo
00]oo`03001oogoo011oo`006goo00<007ooOol027oo16Li3goo16Li00=oo`0?Ool077oo00<03goo
Ool06goo00<03gooOol01goo16Li47oo16Li6Woo00<03gooOol06goo00<03gooOol02goo00<007oo
Ool047oo000KOol00`00Oomoo`08Ool4IcT@Ool3IcT00goo00moo`0LOol00`0?Oomoo`0KOol00`0?
Oomoo`07Ool4IcT@Ool0100?IcUW>FLi6Woo00<03gooOol06goo00<03gooOol02goo00<007ooOol0
47oo000KOol20009Ool3IcTAOol3IcT00goo00moo`0LOol00`0?Oomoo`0KOol00`0?Oomoo`07Ool3
IcTAOol0100?IcUW>FLi6Woo00<03gooOol06goo00<03gooOol02Woo0P004Woo000KOol00`00Oomo
o`07Ool4IcTAOol4IcT00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`06Ool4IcTAOol00`0?
IcUW>@02IcTIOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`04Ool30009Ool001]oo`03
001oogoo00Moo`AW>A5oo`AW>@0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Ioo`AW>A5o
o`0300mW>FLi009W>AUoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`03001oogoo
00Qoo`001Goo0`004goo00<007ooOol01goo0fLi4goo0fLi00<03gooOol06goo00<03gooOol06goo
00<03gooOol01Woo0fLi4Woo00<03gooIcT00VLi6Goo00<03gooOol06goo00<03gooOol02goo00<0
07ooOol01Goo0`0027oo0006Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000Oomoogoo0`000goo
00<007ooOol01Woo16Li4goo16Li7Goo00<03gooOol06goo00<03gooOol01Goo16Li4Woo00<03goo
IcT00fLi67oo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo00<007oo000027oo0006
Ool30002Ool00`00Ool00008Ool00`00Oomoo`02Ool2000700l4IcTC00l4IcU300l4IcTD00l4IcU2
00l30006Ool40008Ool000Ioo`03001oo`0000<00003Ool007oo00Qoo`05001oogooOol00008Ool3
IcTEOol3IcTMOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool3IcTCOol00`0?Oomoo`03IcTHOol00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo0005Ool5000017oo001o
o`002Goo00D007ooOomoo`0000Moo`AW>AEoo`=W>Aeoo`0300moogoo01]oo`0300moogoo00Aoo`AW
>A=oo`0300moogoo00=W>AQoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`04001o
ogoo0007Ool000Moo`<0009oo`03001oogoo00Ioo`<000=oo`03001oogoo00Eoo`AW>AEoo`AW>Aao
o`0300moogoo01]oo`0300moogoo00Aoo`AW>A=oo`0300moogoo00AW>AMoo`0300moogoo01]oo`03
00moogoo00]oo`03001oogoo00Ioo`<000Moo`001Woo00@007ooOol0015oo`03001oogoo00Eoo`=W
>AIoo`AW>Aaoo`0300moogoo01]oo`0300moogoo00Aoo`=W>AAoo`0300moogoo00AW>AMoo`0300mo
ogoo01]oo`0300moogoo00]oo`03001oogoo011oo`001Woo00@007ooOol0015oo`8000Ioo`=W>AMo
o`=W>Aaoo`0300moogoo01]oo`0300moogoo00Aoo`=W>AAoo`0400moogooOol3IcTGOol00`0?Oomo
o`0KOol00`0?Oomoo`0:Ool20007Ool40007Ool000Moo`<0015oo`03001oogoo00Aoo`AW>AMoo`AW
>A]oo`0300moogoo01]oo`0300moogoo00=oo`AW>AAoo`0400moogooOol4IcTFOol00`0?Oomoo`0K
Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool001]oo`03001oogoo00Aoo`AW>AMo
o`AW>A]oo`0300moogoo01]oo`0300moogoo00=oo`AW>AAoo`0400moogooOol4IcTFOol00`0?Oomo
o`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Ioo`<0019oo`03001oogoo
00Aoo`=W>AUoo`=W>A]oo`0300moogoo01]oo`0300moogoo00=oo`=W>AEoo`0300moogoo009oo`=W
>AIoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001Woo00<0
07oo00004Woo0P0017oo16Li6Goo0fLi6goo00<03gooOol06goo00<03gooOol00Woo16Li5Goo00<0
3gooOol00Woo0fLi5Woo00<03gooOol06goo00<03gooOol02Woo0P0027oo00<007ooOol01goo0006
Ool00`00Ool0000BOol00`00Oomoo`03Ool4IcTIOol4IcTJOol00`0?Oomoo`0KOol00`0?Oomoo`02
Ool4IcTEOol00`0?Oomoo`02Ool4IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05
Ool30008Ool000Eoo`800003Ool007oo015oo`03001oogoo00=oo`=W>AYoo`AW>AYoo`0300moogoo
01]oo`0300moogoo009oo`=W>AIoo`0300moogoo009oo`AW>AEoo`0300moogoo01]oo`0300moogoo
00]oo`03001oogoo00Eoo`<000Qoo`001Woo0`004Woo00<007ooOol00goo0fLi6Woo00@03fLiIcUW
>AYoo`0300moogoo01]oo`0300moogoo009oo`=W>AIoo`0300moogoo00=oo`=W>AEoo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo00Moo`03001oogoo00Ioo`001Woo0`004Woo00<007ooOol0
0Woo16Li6Woo00@03fLiIcUW>AYoo`0300moogoo01]oo`0400moogooOol4IcTFOol00`0?Oomoo`03
Ool3IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Qoo`03001o
ogoo011oo`8000=oo`AW>AYoo`0300mW>FLi009W>AUoo`0300moogoo01]oo`0400moogooOol4IcTF
Ool00`0?Oomoo`03Ool4IcTDOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol000Ioo`<0019o
o`03001oogoo009oo`=W>A]oo`0300mW>FLi009W>AUoo`0300moogoo01]oo`0400moogooOol3IcTG
Ool00`0?Oomoo`03Ool4IcTDOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008
Ool001]oo`04001oogooOol4IcTKOol00`0?OomW>@02IcTIOol00`0?Oomoo`0KOol00`0?Oomoo`04
IcTGOol00`0?Oomoo`04Ool3IcTDOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool2
0008Ool000Ioo`03001oo`00019oo`04001oogooOol7000HOol00`0?OomW>@02IcTIOol00`0?Oomo
o`0JOol;000DOol00`0?Oomoo`04Ool3IcTDOol00`0?Oomoo`0KOol0100?Oomoogoo1`000goo00<0
07ooOol01Goo00<007ooOol027oo0006Ool00`00Ool0000BOol01000Oomoogoo20005goo00<03goo
IcT00fLi67oo00<03gooOol06Goo3@004goo00<03gooOol017oo16Li4goo00<03gooOol06goo00<0
3gooOol020000goo00<007ooOol01Goo0`0027oo0006Ool00`00Ool0000BOol20002Ool:000EOol0
0`0?OomW>@03IcTHOol00`0?Oomoo`0GOolA000AOol00`0?Oomoo`04Ool4IcTCOol00`0?Oomoo`0K
Ool00`0?000000080002Ool2000BOol000Eoo`@0019oo`03001oogoo00Ioo`H001Aoo`0300moogoo
00=W>AQoo`0300moogoo01Ioo`H00003OomW>FLi009W>@9oo`H0011oo`0300moogoo00Eoo`=W>A=o
o`0300moogoo01]oo`H00003OomW>FLi009W>@=oo`03001oogoo00Eoo`<000Qoo`006goo00<007oo
Ool01goo1@0057oo00<03gooOol00fLi67oo00<03gooOol05Goo1P0000<03gooIcT00fLi0goo1P00
3goo00<03gooOol01Goo0fLi4goo00<03gooOol06Woo1P000Woo16Li0goo00<007ooOol01Woo0P00
27oo0006Ool30003Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo00002goo10004goo
00<03gooOol016Li5goo00<03gooOol057oo1@000Woo00<03gooIcT00VLi1Woo1@003Woo00<03goo
Ool01Goo16Li4Woo00<03gooOol06Goo1@0017oo0fLi17oo00<007ooOol01Goo00<007ooOol027oo
0006Ool00`00Oomoo`02Ool00`00Ool00007Ool30003Ool2000:00l5000E00l4IcT]00l5000400l4
IcT700l5000E00l4IcT]00l5000400l4IcT200l30007Ool30008Ool000Ioo`03001oogoo009oo`03
001oo`0000Moo`03001oo`0000=oo`03001oogoo00Yoo`D0015oo`0400moogooOol3IcTGOol00`0?
Oomoo`0BOol50004Ool00`0?IcUW>@02IcT8Ool5000<Ool00`0?Oomoo`06Ool3IcTBOol00`0?Oomo
o`0GOol50005Ool4IcT4Ool00`00Oomoo`04Ool50007Ool000Eoo`@0009oo`03001oo`0000Qoo`80
00=oo`03001oogoo00]oo`@0015oo`0400moogooOol3IcTGOol00`0?Oomoo`0BOol40005Ool0100?
IcUW>FLi2Woo100037oo00<03gooOol01Woo0fLi4Woo00<03gooOol05goo100000<03gooOol00goo
0fLi1Goo00<007ooOol01Woo00<007ooOol01goo0006Ool00`00Oomoo`03Ool00`00Oomoo`08Ool0
1@00Oomoogoo00003Woo100047oo00@03gooOomoo`=W>AMoo`0300moogoo015oo`@000Ioo`0400mW
>FLiIcT;Ool4000;Ool00`0?Oomoo`06Ool3IcTBOol00`0?Oomoo`0FOol400000goo00moo`04Ool3
IcT5Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Ioo`<0019oo`03001oogoo00aoo`D000moo`04
00moogooOol4IcTFOol00`0?Oomoo`0@Ool50006Ool4IcT;Ool5000:Ool00`0?Oomoo`06Ool4IcTA
Ool00`0?Oomoo`0EOol500000goo00moo`03Ool4IcT5Ool00`00Oomoo`05Ool20009Ool000Ioo`03
001oo`00019oo`8000ioo`@000moo`0400moogooOol4IcTFOol00`0?Oomoo`0@Ool40007Ool4IcT<
Ool4000:Ool00`0?Oomoo`06Ool4IcTAOol00`0?Oomoo`0EOol40002Ool00`0?Oomoo`02Ool4IcT4
Ool2000BOol000Ioo`03001oo`00019oo`03001oogoo00ioo`@000ioo`0300moogoo009oo`=W>AIo
o`0300moogoo00moo`@000Qoo`=W>@ioo`@000Uoo`0300moogoo00Moo`=W>A5oo`0300moogoo01Ao
o`@000=oo`0300moogoo009oo`=W>@Ioo`03001oogoo00Ioo`8000Qoo`001Goo0P0000=oo`00Ool0
4Goo00<007ooOol03Woo1@003Goo00<03gooOol00Woo0fLi5Woo00<03gooOol03Woo1@001goo16Li
3Woo1@0027oo00<03gooOol01goo0fLi4Goo00<03gooOol04goo1@000goo00@03gooOomoo`AW>@Io
o`03001oogoo00Eoo`04001oogoo0007Ool001]oo`03001oogoo00moo`@000eoo`0300moogoo009o
o`AW>AEoo`0300moogoo00ioo`@000Qoo`AW>@moo`@000Qoo`0300moogoo00Moo`AW>A1oo`0300mo
ogoo01=oo`@000Aoo`0400moogooOol4IcT6Ool00`00Oomoo`05Ool01000Oomoo`001goo0005Ool0
1@00Ool007oo00004Goo00<007ooOol047oo100037oo00<03gooOol00Woo16Li5Goo00<03gooOol0
3Goo10002Goo0fLi4Goo10001goo00<03gooOol01goo16Li47oo00<03gooOol04Woo10001Goo00@0
3gooOomoo`=W>@Moo`03001oogoo00Ioo`<000Moo`001Goo00D007oo001oo`00015oo`80015oo`D0
00]oo`0300moogoo00=oo`=W>AEoo`0300moogoo00eoo`@000Uoo`=W>A5oo`D000Ioo`0300moogoo
00Qoo`=W>A1oo`0300moogoo015oo`D000Eoo`0400moogooOol3IcT6Ool2000BOol000Eoo`05001o
o`00Ool0000AOol00`00Oomoo`0AOol4000;Ool00`0?Oomoo`03Ool3IcTEOol00`0?Oomoo`0<Ool4
0009Ool4IcTBOol40006Ool00`0?Oomoo`08Ool3IcT@Ool00`0?Oomoo`0AOol40006Ool00`0?Oomo
o`04IcT7Ool00`00Oomoo`05Ool30008Ool000Eoo`D0015oo`03001oogoo019oo`@000Yoo`0300mo
ogoo00=oo`AW>AAoo`0300moogoo00aoo`@000Uoo`AW>A=oo`@000Eoo`0300moogoo00Qoo`AW>@mo
o`0300moogoo011oo`@000Moo`0300moogoo00AW>@Moo`03001oogoo00Eoo`<000Qoo`006goo00<0
07ooOol04Woo10002Woo00<03gooOol00goo16Li57oo00<03gooOol02goo10002Woo0fLi57oo1000
1Goo00<03gooOol027oo16Li3goo00<03gooOol047oo10001goo00<03gooOol00fLi27oo00<007oo
Ool01goo00<007ooOol01Woo000KOol2000DOol40009Ool00`0?Oomoo`04Ool3IcTDOol00`0?Oomo
o`0:Ool50009Ool4IcTEOol40004Ool00`0?Oomoo`09Ool3IcT?Ool00`0?Oomoo`0?Ool40008Ool0
0`0?OomW>@03IcT7Ool20007Ool30008Ool001]oo`03001oogoo01=oo`D000Qoo`0300moogoo00Ao
o`=W>AAoo`0300moogoo00Yoo`@000Yoo`AW>AEoo`D000=oo`0300moogoo00Uoo`=W>@moo`0300mo
ogoo00ioo`D000Qoo`0300moofLi00=W>@Qoo`03001oogoo011oo`006goo00<007ooOol057oo1000
27oo00<03gooOol017oo16Li4goo00<03gooOol02Goo10002goo0fLi00<03gooOol057oo10000goo
00<03gooOol02Goo16Li3Woo00<03gooOol03Woo10002Goo00<03gooIcT00VLi2Goo00<007ooOol0
1Goo10001goo0008Ool00`00Oomoo`0@Ool00`00Oomoo`0EOol40007Ool00`0?Oomoo`04Ool4IcTC
Ool00`0?Oomoo`09Ool4000;Ool3IcT00`0?Oomoo`0EOol40002Ool00`0?Oomoo`09Ool4IcT>Ool0
0`0?Oomoo`0=Ool4000:Ool00`0?OomW>@02IcT9Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Mo
o`03001oogoo015oo`03001oogoo01Eoo`@000Moo`0300moogoo00Eoo`=W>A=oo`0300moogoo00Qo
o`@000]oo`AW>@0300moogoo01Eoo`@0009oo`0300moogoo00Yoo`=W>@ioo`0300moogoo00eoo`@0
00Yoo`0300mW>FLi009W>@Uoo`03001oogoo00Ioo`03001oogoo00Moo`001goo00<007ooOol04Goo
0P005goo10001Woo00<03gooOol01Goo0fLi4goo00<03gooOol027oo10002goo16Li00<03gooOol0
5Woo100000=oo`0?Ool02goo0fLi3Woo00<03gooOol037oo10002goo00<03fLiIcT00VLi27oo0P00
27oo00<007ooOol01goo0007Ool00`00Oomoo`0AOol00`00Oomoo`0FOol50005Ool00`0?Oomoo`05
Ool4IcTBOol00`0?Oomoo`07Ool4000<Ool3IcT00goo00moo`0GOol500000`0?Oomoo`0:Ool4IcT=
Ool00`0?Oomoo`0;Ool5000;Ool0100?IcUW>FLi2Woo00<007ooOol01Woo00<007ooOol01goo0007
Ool00`00Oomoo`0AOol00`00Oomoo`0GOol40005Ool00`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`07
Ool4000;Ool4IcT00goo00moo`0HOol400000`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0;Ool4000<
Ool4IcT:Ool00`00Oomoo`05Ool20009Ool000Qoo`03001oogoo011oo`03001oogoo01Qoo`@000Ao
o`0300moogoo00Ioo`=W>A9oo`0300moogoo00Ioo`@000aoo`AW>@03Ool03goo01Uoo`@000eoo`=W
>@eoo`0300moogoo00Yoo`@000eoo`AW>@Yoo`03001oogoo011oo`001Woo10000Woo00<007ooOol0
0Woo00<007ooOol00Woo0P000goo00<007ooOol067oo1@000goo00<03gooOol01Woo0fLi4Woo00<0
3gooOol01Goo1@0037oo0fLi0Woo00<03gooOol067oo1@0037oo0fLi3Goo00<03gooOol02Goo1@00
3Goo0fLi2goo00<007ooOol047oo0007Ool01`00Oomoogoo001oo`0000Moo`03001oo`0000=oo`80
01X03`@000`03`AW>AT03`@000d03`=W>Ah03`@000`03`AW>AP03`@000h03`=W>@T03`<000Uoo`03
001oogoo00Ioo`001goo00L007ooOomoo`00Ool00007Ool30003Ool00`00Oomoo`0JOol40002Ool0
0`0?Oomoo`06Ool4IcTAOol00`0?Oomoo`04Ool4000=Ool4IcT2Ool00`0?Oomoo`0JOol4000;Ool4
IcT<Ool00`0?Oomoo`08Ool4000>Ool4IcT;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Moo`07
001oogooOol007oo00001goo00<007ooOol00goo00<007ooOol06Woo10000Woo00<03gooOol01goo
0fLi4Goo00<03gooOol017oo10003Goo16Li0Woo00<03gooOol06Woo100037oo0fLi37oo00<03goo
Ool027oo10003Woo16Li2goo00<007ooOol01Woo00<007ooOol01goo0007Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool20003Ool00`00Oomoo`0KOol400000goo00moo`08Ool3IcTAOol00`0?Oomoo`03
Ool4000>Ool3IcT3Ool00`0?Oomoo`0KOol4000;Ool3IcT<Ool00`0?Oomoo`07Ool4000?Ool3IcT<
Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Eoo`D0015oo`8001aoo`D0000300moogoo00Moo`AW
>A1oo`0300moogoo009oo`D000eoo`AW>@=oo`0300moogoo01]oo`D000Yoo`AW>@]oo`0300moogoo
00Ioo`D000ioo`AW>@]oo`8000Qoo`03001oogoo00Moo`001goo00<007ooOol04Goo00<007ooOol0
77oo100000<03gooOol01goo16Li47oo00<03gooOol00Woo10003Woo16Li0goo00<03gooOol06goo
00<03`0000000P002Woo16Li2goo00<03gooOol01Woo10003goo16Li37oo00<007ooOol01goo00<0
07ooOol01Woo0007Ool00`00Oomoo`0AOol00`00Oomoo`0MOol4000:Ool3IcT@Ool0100?Oomoogoo
10003goo0fLi17oo00<03gooOol06goo00<03goo00000`002Woo0fLi2goo00<03gooOol01Goo1000
47oo0fLi3Goo00<007ooOol01Woo0`001goo0006Ool4000AOol00`00Oomoo`0MOol4000:Ool3IcT@
Ool0100?Oomoogoo10003Woo16Li17oo00<03gooOol06goo00<03goo00000`002Woo0fLi2goo00<0
3gooOol01Goo10003goo16Li3Goo00<007ooOol01Goo00@007ooOol000Moo`002Goo00<007ooOol0
3goo00<007ooOol07Woo10002Goo16Li3goo00<03gooOol010003goo16Li17oo00<03gooOol06goo
00<03gooOol010002Goo16Li2Woo00<03gooOol017oo100047oo16Li3Goo00<007ooOol01Goo00@0
07ooOol000Moo`001goo0`004Goo0P007goo1@0027oo16Li3goo00<03goo000010003goo0fLi1Goo
00<03gooOol06goo00<03gooOol01@0027oo16Li2Woo00<03gooOol00goo1@0047oo0fLi00<03goo
Ool02Woo0P0027oo0`001goo0006Ool01000Oomoo`004Goo00<007ooOol07goo10002Goo0fLi3goo
00<03goo00000`003goo16Li1Goo00<03gooOol06goo00@03gooOomoo`@000Uoo`=W>@Yoo`0300mo
ogoo00=oo`@0011oo`AW>@0300moogoo00]oo`03001oogoo00Qoo`03001oogoo00Eoo`001Woo00@0
07ooOol0015oo`03001oogoo021oo`@000Qoo`=W>@moo`0300l000000080011oo`AW>@Eoo`0300mo
ogoo01]oo`0300moogoo009oo`@000Qoo`=W>@Yoo`0300moogoo009oo`@0015oo`AW>@0300moogoo
00]oo`03001oogoo00Eoo`@000Moo`001goo0`004Goo00<007ooOol087oo1@001goo16Li3Woo1@00
47oo0fLi1Woo00<03gooOol06goo00<03gooOol00Woo1@001goo16Li2Goo00@03gooOomoo`D0015o
o`=W>@03Ool03goo00aoo`03001oogoo00Eoo`<000Qoo`001Woo00<007oo00004Woo00<007ooOol0
87oo00<03`0000000`001Woo16Li3Goo1@0047oo16Li1Woo00<03gooOol06goo00<03gooOol00goo
1@001Woo16Li2Goo00<03gooOol01@004Goo16Li00=oo`0?Ool037oo00<007ooOol01goo00<007oo
Ool01Woo0006Ool00`00Ool0000BOol2000QOol00`0?Ool000040006Ool3IcT<Ool5000AOol4IcT6
Ool00`0?Oomoo`0KOol00`0?Oomoo`04Ool50006Ool3IcT9Ool00`0?Ool00004000BOol4IcT00goo
00moo`0;Ool20007Ool30008Ool000Ioo`03001oo`00019oo`03001oogoo021oo`0300moogoo00@0
00Ioo`AW>@]oo`@0019oo`=W>@Moo`0300moogoo01]oo`0300moogoo00Eoo`@000Ioo`=W>@Uoo`03
00moo`0000<001=oo`=W>@9oo`0300moogoo00]oo`03001oogoo011oo`001Woo0`004Woo00<007oo
Ool087oo00@03gooOomoo`@000Eoo`AW>@Yoo`@0019oo`AW>@Moo`0300moogoo01]oo`0300moogoo
00Ioo`@000Eoo`AW>@Qoo`0300l00000008001=oo`AW>@9oo`0300moogoo00]oo`03001oogoo00Ao
o`@000Qoo`001Woo00<007ooOol04Woo00<007ooOol087oo00@03gooOomoo`D000Eoo`=W>@Uoo`D0
019oo`AW>@Moo`0300moogoo01]oo`0300moogoo00Ioo`D000Aoo`AW>@Qoo`D001=oo`AW>@9oo`03
00moogoo00]oo`03001oogoo00Eoo`03001oogoo00Qoo`001Goo10004Woo0P008Goo00<03gooOol0
0Woo1@0017oo16Li1goo1@0000<03gooOol047oo0fLi27oo00<03gooOol06goo00<03gooOol01goo
1@0017oo0fLi1goo1@0057oo0fLi0goo00<03gooOol02Woo0P001goo00<007ooOol027oo0006Ool0
0`00Oomoo`0BOol00`00Oomoo`0POol00`0?Oomoo`03Ool60002Ool4IcT5Ool600000goo00moo`0@
Ool4IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`08Ool60002Ool3IcT5Ool6000DOol4IcT3Ool00`0?
Oomoo`0;Ool00`00Oomoo`04Ool40008Ool000Ioo`03001oogoo019oo`03001oogoo021oo`0300mo
ogoo00Aoo`H0009oo`=W>@=oo`L0009oo`0300moogoo00moo`AW>@Qoo`0300moogoo01]oo`0300mo
ogoo00Uoo`H00004OomW>FLiIcT3Ool7000EOol4IcT3Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
00Eoo`@0019oo`03001oogoo021oo`0300moogoo00Eoo`L000AW>@03Ool0000000D000=oo`0300mo
ogoo00moo`=W>@Uoo`0300moogoo01]oo`0300moogoo00Yoo`L000=W>@03Ool0000000D001Ioo`=W
>@Aoo`0300moogoo00]oo`03001oogoo00Eoo`04001oo`000007Ool000Ioo`8000Aoo`03001oogoo
009oo`04001oogooOol30003Ool00`00Oomoo`0POol00`0?Oomoo`07Ool?0005Ool00`0?Oomoo`0>
Ool4IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`0<Ool>00000goo00moo`0DOol4IcT4Ool00`0?Oomo
o`0;Ool00`00Oomoo`05Ool40007Ool000Qoo`06001oogoo001oo`001goo00<007oo00000goo0P00
;00?3000600?16Li=`0?2`006@0?16Li400?0`001goo0`0027oo0008Ool01P00Oomoo`00Ool000Qo
o`03001oogoo009oo`03001oogoo021oo`0300moogoo00Yoo`T000Qoo`0300moogoo00ioo`=W>@Yo
o`0300moogoo01]oo`0300moogoo00moo`P000Aoo`0300moogoo01=oo`=W>@Eoo`0300moogoo00]o
o`03001oogoo00Eoo`@000Moo`0027oo00H007ooOol007oo0007Ool00`00Ool00003Ool00`00Oomo
o`0POol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`0KOol00`0?Oomo
o`0AOol4IcT6Ool00`0?Oomoo`0BOol4IcT5Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool00`00Ool0
0008Ool000Qoo`05001oogooOol00008Ool30003Ool00`00Oomoo`0POol00`0?Oomoo`0>Ool3IcT:
Ool00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`0BOol3IcT6Ool00`0?Oomoo`0B
Ool4IcT5Ool00`0?Oomoo`0;Ool00`00Oomoo`04Ool200000goo001oo`07Ool000Moo`03001oogoo
015oo`03001oogoo021oo`0300moogoo00ioo`AW>@Uoo`0300moogoo00eoo`=W>@]oo`0300moogoo
01]oo`0300moogoo019oo`AW>@Eoo`0300moogoo015oo`AW>@Ioo`0300moogoo00]oo`03001oogoo
00Moo`03001oogoo00Ioo`006goo0P008Goo00<03gooOol03Woo16Li2Goo00<03gooOol037oo16Li
2goo00<03gooOol06goo00<03gooOol04Woo16Li1Goo00<03gooOol04Goo16Li1Woo00<03gooOol0
2Woo0P002Goo00<007ooOol01Woo000KOol00`00Oomoo`0POol00`0?Oomoo`0?Ool3IcT9Ool00`0?
Oomoo`0<Ool4IcT;Ool00`0?Oomoo`0KOol00`0?Oomoo`0COol3IcT5Ool00`0?Oomoo`0AOol3IcT7
Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool001]oo`03001oogoo021oo`0300mo
ogoo00moo`AW>@Qoo`0300moogoo00aoo`=W>@aoo`0300moogoo01]oo`0300moogoo01=oo`AW>@Ao
o`0300moogoo011oo`AW>@Moo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol087oo
00<03gooOol03goo16Li27oo00<03gooOol02goo16Li37oo00<03gooOol06goo00<03gooOol04goo
16Li17oo00<03gooOol047oo16Li1goo00<03gooOol02goo00<007ooOol047oo000KOol2000QOol0
0`0?Oomoo`0@Ool3IcT8Ool00`0?Oomoo`0;Ool4IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0DOol3
IcT4Ool00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`0:Ool2000BOol001]oo`03001oogoo021oo`03
00moogoo011oo`AW>@Moo`0300moogoo00]oo`=W>@eoo`0300moogoo01]oo`0300moogoo01Aoo`AW
>@=oo`0300moogoo00moo`AW>@Qoo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol0
87oo00<03gooOol047oo16Li1goo00<03gooOol02Woo16Li3Goo00<03gooOol06goo00<03gooOol0
57oo16Li0goo00<03gooOol03Woo16Li2Goo00<03gooOol02goo00<007ooOol047oo000KOol00`00
Oomoo`0POol00`0?Oomoo`0AOol4IcT6Ool00`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0KOol00`0?
Oomoo`0EOol4IcT2Ool00`0?Oomoo`0>Ool4IcT9Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]o
o`03001oogoo021oo`0300moogoo015oo`AW>@Ioo`0300moogoo00Uoo`AW>@ioo`0300moogoo01]o
o`0300moogoo01Eoo`AW>@9oo`0300moogoo00eoo`AW>@Yoo`0300moogoo00]oo`03001oogoo011o
o`006goo0P008Goo00<03gooOol04Woo16Li1Goo00<03gooOol027oo1FLi3Woo00<03gooOol06goo
00<03gooOol05Woo16Li00=oo`0?Ool03Goo1FLi2Woo00<03gooOol02Woo0P004Woo000KOol00`00
Oomoo`0POol00`0?Oomoo`0BOol4IcT5Ool00`0?Oomoo`08Ool4IcT?Ool00`0?Oomoo`0KOol00`0?
Oomoo`0FOol4IcT00goo00moo`0=Ool4IcT;Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03
001oogoo021oo`0300moogoo01=oo`AW>@Aoo`0300moogoo00Moo`AW>A1oo`0300moogoo01]oo`03
00moogoo01Moo`AW>@0300moogoo00]oo`AW>@aoo`0300moogoo00]oo`03001oogoo011oo`006goo
00<007ooOol087oo00<03gooOol04goo1FLi0goo00<03gooOol01goo16Li47oo00<03gooOol06goo
00<03gooOol05goo1FLi3Goo16Li37oo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomo
o`0POol00`0?Oomoo`0DOol4IcT3Ool00`0?Oomoo`06Ool4IcTAOol00`0?Oomoo`0KOol00`0?Oomo
o`0HOol5IcT;Ool4IcT=Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`80025oo`0300moogoo
01Eoo`AW>@9oo`0300moogoo00Eoo`EW>A5oo`0300moogoo01]oo`0300moogoo01Uoo`AW>@Yoo`EW
>@eoo`0300moogoo00Yoo`80019oo`006goo00<007ooOol087oo00<03gooOol05Goo1FLi00=oo`0?
Ool01Goo1FLi4Woo00<03gooOol06goo00<03gooOol06Woo16Li27oo1FLi3Woo00<03gooOol02goo
00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0FOol6IcT4Ool6IcTCOol00`0?Oomo
o`0KOol00`0?Oomoo`0JOol6IcT4Ool6IcT?Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Eoo`<0
00=oo`03001oogoo021oo`0300moogoo01Moo`iW>AAoo`0300moogoo01]oo`0300moogoo01]oo`iW
>A1oo`0300moogoo00]oo`03001oogoo011oo`005Woo00<007ooOol00Woo0P008Goo00<03gooOol0
67oo36Li5Goo00<03gooOol06goo00<03gooOol06goo00<03fLiIcT02VLi4Goo00<03gooOol02Goo
0`004Woo000FOol00`00Oomoo`02Ool00`00Oomoo`0POol00`0?Oomoo`0JOol8IcTGOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`08IcTCOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Io
o`03001oogoo009oo`03001oogoo009oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]o
o`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo00]oo`03001oogoo011o
o`005Goo0P0017oob0004Woo003eOol00001\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.06696, -0.248794, 0.0332155, 
  0.00855343}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!  p0A=1/2, p0B=1/2", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
When p0A=p0B classically it does not matter which Method you use. \
Quantum mechanically, the choice of Method does matter a great deal.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["ComparisonPlot[1/2, 1/2];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147151 0.588604 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13244 m
1 .13244 L
s
P
p
0 0 .5 r
.001 w
0 .25016 m
1 .25016 L
s
P
p
0 0 .5 r
.001 w
0 .36788 m
1 .36788 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .30902 m
.06349 .16187 L
.08333 .10091 L
.09325 .07553 L
.10317 .05414 L
.1131 .03712 L
.12302 .02474 L
.12798 .02037 L
.13046 .01865 L
.13294 .01723 L
.13542 .01613 L
.13666 .0157 L
.1379 .01535 L
.13914 .01507 L
.14038 .01487 L
.14162 .01475 L
.14286 .01472 L
.1441 .01475 L
.14534 .01487 L
.14658 .01507 L
.14782 .01535 L
.1503 .01613 L
.15278 .01723 L
.15526 .01865 L
.15774 .02037 L
.1627 .02474 L
.17262 .03712 L
.18254 .05414 L
.20238 .10091 L
.22222 .16187 L
.2619 .30902 L
.30159 .45617 L
.32143 .51712 L
.34127 .56389 L
.35119 .58092 L
.35615 .5877 L
.36111 .59329 L
.36607 .59766 L
.36855 .59939 L
.37103 .6008 L
.37351 .6019 L
.37475 .60233 L
.37599 .60269 L
.37723 .60296 L
.37847 .60316 L
.37971 .60328 L
.38095 .60332 L
.38219 .60328 L
.38343 .60316 L
.38467 .60296 L
Mistroke
.38591 .60269 L
.38839 .6019 L
.39087 .6008 L
.39335 .59939 L
.39583 .59766 L
.40079 .59329 L
.41071 .58092 L
.42063 .56389 L
.44048 .51712 L
.46032 .45617 L
.5 .30902 L
.53968 .16187 L
.55952 .10091 L
.56944 .07553 L
.57937 .05414 L
.58929 .03712 L
.59425 .03033 L
.59921 .02474 L
.60417 .02037 L
.60665 .01865 L
.60913 .01723 L
.61161 .01613 L
.61285 .0157 L
.61409 .01535 L
.61533 .01507 L
.61657 .01487 L
.61781 .01475 L
.61905 .01472 L
.62029 .01475 L
.62153 .01487 L
.62277 .01507 L
.62401 .01535 L
.62649 .01613 L
.62897 .01723 L
.63145 .01865 L
.63393 .02037 L
.63889 .02474 L
.64881 .03712 L
.65873 .05414 L
.67857 .10091 L
.69841 .16187 L
.7381 .30902 L
.77778 .45617 L
.79762 .51712 L
.80754 .5425 L
.81746 .56389 L
.82738 .58092 L
.83234 .5877 L
.8373 .59329 L
.84226 .59766 L
Mistroke
.84474 .59939 L
.84722 .6008 L
.8497 .6019 L
.85094 .60233 L
.85218 .60269 L
.85342 .60296 L
.85466 .60316 L
.8559 .60328 L
.85714 .60332 L
.85838 .60328 L
.85962 .60316 L
.86086 .60296 L
.8621 .60269 L
.86458 .6019 L
.86706 .6008 L
.86954 .59939 L
.87202 .59766 L
.87698 .59329 L
.8869 .58092 L
.89683 .56389 L
.91667 .51712 L
.93651 .45617 L
.97619 .30902 L
Mfstroke
P
P
p
p
.02 w
.02381 .30902 m
.06349 .30902 L
.10317 .30902 L
.12302 .30902 L
.14286 .30902 L
.15278 .30902 L
.1627 .30902 L
.16766 .30902 L
.17262 .30902 L
.1751 .30902 L
.17758 .30902 L
.17882 .30902 L
.18006 .30902 L
.1813 .30902 L
.18254 .30902 L
.18378 .30902 L
.18502 .30902 L
.18626 .30902 L
.1875 .30902 L
.19246 .30902 L
.20238 .30902 L
.22222 .30902 L
.24206 .30902 L
.25198 .30902 L
.25694 .30902 L
.2619 .30902 L
.26687 .30902 L
.26811 .30902 L
.26935 .30902 L
.27059 .30902 L
.27183 .30902 L
.27307 .30902 L
.27431 .30902 L
.27555 .30902 L
.27679 .30902 L
.27803 .30902 L
.27927 .30902 L
.28051 .30902 L
.28175 .30902 L
.28299 .30902 L
.28423 .30902 L
.28547 .30902 L
.28671 .30902 L
.28795 .30902 L
.28919 .30902 L
.29043 .30902 L
.29167 .30902 L
.29291 .30902 L
.29415 .30902 L
.29663 .30902 L
Mistroke
.29911 .30902 L
.30035 .30902 L
.30159 .30902 L
.30283 .30902 L
.30407 .30902 L
.30655 .30902 L
.31151 .30902 L
.31647 .30902 L
.32143 .30902 L
.34127 .30902 L
.38095 .30902 L
.40079 .30902 L
.42063 .30902 L
.43056 .30902 L
.44048 .30902 L
.44544 .30902 L
.4504 .30902 L
.45536 .30902 L
.4566 .30902 L
.45784 .30902 L
.45908 .30902 L
.46032 .30902 L
.46156 .30902 L
.4628 .30902 L
.46528 .30902 L
.46776 .30902 L
.469 .30902 L
.47024 .30902 L
.47148 .30902 L
.47272 .30902 L
.4752 .30902 L
.47644 .30902 L
.47768 .30902 L
.47892 .30902 L
.48016 .30902 L
.4814 .30902 L
.48264 .30902 L
.48388 .30902 L
.48512 .30902 L
.4876 .30902 L
.49008 .30902 L
.5 .30902 L
.53968 .30902 L
.57937 .30902 L
.59921 .30902 L
.60913 .30902 L
.61409 .30902 L
.61905 .30902 L
.62029 .30902 L
.62153 .30902 L
Mistroke
.62277 .30902 L
.62401 .30902 L
.62649 .30902 L
.62773 .30902 L
.62897 .30902 L
.63889 .30902 L
.64013 .30902 L
.64137 .30902 L
.64261 .30902 L
.64385 .30902 L
.64881 .30902 L
.65129 .30902 L
.65377 .30902 L
.65625 .30902 L
.65749 .30902 L
.65873 .30902 L
.65997 .30902 L
.66121 .30902 L
.66245 .30902 L
.66369 .30902 L
.66493 .30902 L
.66617 .30902 L
.66741 .30902 L
.66865 .30902 L
.67361 .30902 L
.67485 .30902 L
.67609 .30902 L
.67733 .30902 L
.67857 .30902 L
.68105 .30902 L
.68353 .30902 L
.68849 .30902 L
.69097 .30902 L
.69345 .30902 L
.69469 .30902 L
.69593 .30902 L
.69717 .30902 L
.69841 .30902 L
.69965 .30902 L
.70089 .30902 L
.70337 .30902 L
.70833 .30902 L
.71329 .30902 L
.71453 .30902 L
.71577 .30902 L
.71701 .30902 L
.71825 .30902 L
.71949 .30902 L
.72073 .30902 L
.72197 .30902 L
Mistroke
.72321 .30902 L
.72817 .30902 L
.7381 .30902 L
.74306 .30902 L
.74802 .30902 L
.75298 .30902 L
.75422 .30902 L
.75546 .30902 L
.7567 .30902 L
.75794 .30902 L
.75918 .30902 L
.76042 .30902 L
.76166 .30902 L
.7629 .30902 L
.76786 .30902 L
.77034 .30902 L
.77282 .30902 L
.7753 .30902 L
.77654 .30902 L
.77778 .30902 L
.77902 .30902 L
.78026 .30902 L
.78274 .30902 L
.7877 .30902 L
.79266 .30902 L
.79514 .30902 L
.79638 .30902 L
.79762 .30902 L
.79886 .30902 L
.8001 .30902 L
.80134 .30902 L
.80258 .30902 L
.80754 .30902 L
.81746 .30902 L
.8187 .30902 L
.81994 .30902 L
.82242 .30902 L
.82738 .30902 L
.83234 .30902 L
.83358 .30902 L
.83482 .30902 L
.83606 .30902 L
.8373 .30902 L
.83854 .30902 L
.83978 .30902 L
.84102 .30902 L
.84226 .30902 L
.84722 .30902 L
.85714 .30902 L
.87698 .30902 L
Mistroke
.87946 .30902 L
.88194 .30902 L
.88318 .30902 L
.88442 .30902 L
.88566 .30902 L
.8869 .30902 L
.88814 .30902 L
.88938 .30902 L
.89187 .30902 L
.89683 .30902 L
.90179 .30902 L
.90675 .30902 L
.91171 .30902 L
.91295 .30902 L
.91419 .30902 L
.91543 .30902 L
.91667 .30902 L
.91791 .30902 L
.91915 .30902 L
.92039 .30902 L
.92163 .30902 L
.92287 .30902 L
.92411 .30902 L
.92659 .30902 L
.92783 .30902 L
.92907 .30902 L
.93031 .30902 L
.93155 .30902 L
.93403 .30902 L
.93527 .30902 L
.93651 .30902 L
.93775 .30902 L
.93899 .30902 L
.94147 .30902 L
.94643 .30902 L
.94767 .30902 L
.94891 .30902 L
.95015 .30902 L
.95139 .30902 L
.95387 .30902 L
.95511 .30902 L
.95635 .30902 L
.95759 .30902 L
.95883 .30902 L
.96131 .30902 L
.96627 .30902 L
.97619 .30902 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol007Mo
o`<007]oo`00N7oo00<007ooOol0NWoo001hOol30002Ool01000Ool007oo1@00Kgoo001hOol02000
Oomoo`00Ool007oo0003Ool00`00Oomoo`1_Ool007Qoo`08001oogoo001oo`00Ool000=oo`03001o
ogoo06moo`00Mgoo10000Woo0`000Woo0P00LGoo001mOol00`00Oomoo`1eOol007aoo`8000Eoo`03
001oogoo06moo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol001moo`03001o
ogoo01Yoo`<001]oo`<001aoo`<001eoo`03001oogoo01Uoo`<001aoo`8001moo`007Woo00<007oo
000077oo00<007ooOol06goo00<007ooOol07Goo00<007ooOol06Goo0`007Goo00<007ooOol06Goo
00<007oo00007goo000NOol00`00Ool0000LOol00`00Oomoo`0LOol00`00Oomoo`0KOol00`00Oomo
o`0JOol00`00Ool0000KOol3000KOol3000OOol001ioo`03001oo`0001aoo`03001oogoo01aoo`03
001oogoo01aoo`03001oogoo01Yoo`8001]oo`03001oogoo01]oo`03001oogoo01moo`007goo00<0
07ooOol06Woo0P0077oo0`0077oo0`007Goo00<007ooOol06Goo0`0077oo0P007goo003eOol00?Eo
o`00mGoo003eOol001]oolP0019oo`006goo00<007ooOol00Woo00<007ooOol06goo00<007ooOol0
6goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol0
2goo00<007ooOol047oo000FOol00`00Oomoo`02Ool00`00Oomoo`0FOol8IcT2Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0EOol8IcTLOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00
Oomoo`0@Ool001Eoo`03001oo`0000=oo`8001Ioo`UW>@9oo`0300moogoo01]oo`0300moogoo01]o
o`0300moogoo01Eoo`UW>A]oo`0300moogoo01]oo`0300moogoo00Uoo`<0019oo`005Goo00<007oo
00000goo00<007ooOol057oo2fLi00=oo`0?Ool077oo00<03gooOol06goo00<03gooOol057oo2fLi
6Woo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000EOol00`00Ool00003Ool00`00
Oomoo`0COol5IcT3Ool5IcT00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0COol5IcT3Ool5
IcTIOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Ioo`03001oogoo009oo`03
001oogoo019oo`EW>@Eoo`EW>Aeoo`0300moogoo01]oo`0300moogoo019oo`EW>@Aoo`0300mW>FLi
00=W>AQoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo0P004goo16Li1goo
16Li7Goo00<03gooOol06goo00<03gooOol04Woo16Li1Goo00<03gooIcT00fLi67oo00<03gooOol0
6goo00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0AOol4IcT9Ool4IcTLOol00`0?Oomoo`0K
Ool00`0?Oomoo`0AOol4IcT6Ool00`0?Oomoo`04IcTGOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool0
0`00Oomoo`0@Ool001]oo`03001oogoo011oo`EW>@Uoo`EW>A]oo`0300moogoo01]oo`0300moogoo
011oo`EW>@Ioo`0300moogoo00EW>AIoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011o
o`006goo00<007ooOol047oo16Li2goo16Li6goo00<03gooOol06goo00<03gooOol047oo16Li1goo
00@03gooOomoo`AW>AIoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<0
07ooOol03goo16Li3Goo16Li6Woo00<03gooOol06goo00<03gooOol03goo16Li27oo00<03gooOol0
0Woo16Li5Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol2000@Ool4IcT=
Ool4IcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`02Ool4IcTEOol00`0?
Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol001]oo`03001oogoo00moo`=W>@ioo`0400mW>FLiIcTJ
Ool00`0?Oomoo`0KOol00`0?Oomoo`0?Ool3IcT9Ool00`0?Oomoo`03Ool3IcTEOol00`0?Oomoo`0K
Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00ioo`AW>@ioo`0300mW>FLi009W
>AUoo`0300moogoo01]oo`0300moogoo00ioo`AW>@Uoo`0300moogoo00=oo`AW>AAoo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol03Woo16Li3Woo00<03fLiIcT0
0VLi6Goo00<03gooOol06goo00<03gooOol03Woo16Li2Goo00<03gooOol00goo16Li57oo00<03goo
Ool06goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0=Ool4IcT?Ool00`0?OomW
>@03IcTHOol00`0?Oomoo`0KOol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`04Ool4IcTCOol00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`8000ioo`AW>@moo`0300moofLi00=W
>AQoo`0300moogoo01]oo`0300moogoo00eoo`AW>@Yoo`0300moogoo00Aoo`AW>A=oo`0300moogoo
01]oo`0300moogoo00Yoo`80019oo`006goo00<007ooOol03Goo0fLi47oo00<03gooOol00fLi67oo
00<03gooOol06goo00<03gooOol03Goo0fLi2goo00<03gooOol01Goo0fLi4goo00<03gooOol06goo
00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0<Ool4IcT@Ool00`0?Oomoo`04IcTG
Ool00`0?Oomoo`0KOol00`0?Oomoo`0<Ool4IcT;Ool00`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`0K
Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00aoo`AW>A1oo`0300moogoo00AW
>AMoo`0300moogoo01]oo`0300moogoo00aoo`AW>@]oo`0300moogoo00Eoo`AW>A9oo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo011oo`006goo0P003Goo0fLi4Goo00@03gooOomoo`AW>AIo
o`0300moogoo01]oo`0300moogoo00]oo`AW>@aoo`0300moogoo00Ioo`AW>A5oo`0300moogoo01]o
o`0300moogoo00Yoo`80019oo`006goo00<007ooOol02goo16Li4Goo00@03gooOomoo`AW>AIoo`03
00moogoo01]oo`0300moogoo00]oo`AW>@aoo`0300moogoo00Ioo`AW>A5oo`0300moogoo01]oo`03
00moogoo00]oo`03001oogoo00Aoo`<000Uoo`006goo00<007ooOol02goo16Li4Goo00<03gooOol0
0Woo0fLi5Woo00<03gooOol06goo00<03gooOol02goo0fLi3Goo00<03gooOol01goo0fLi4Goo00<0
3gooOol06goo00<03gooOol02goo00<007ooOol01Goo00<007ooOol027oo0005Ool3000COol00`00
Oomoo`0;Ool3IcTBOol00`0?Oomoo`02Ool4IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool4IcT=
Ool00`0?Oomoo`07Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008
Ool000Ioo`03001oogoo00=oo`03001oogoo009oo`04001oogooOol30003Ool00`00Oomoo`0;Ool3
IcTBOol00`0?Oomoo`02Ool4IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool4IcT=Ool00`0?Oomo
o`07Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool00`00Ool00008Ool0
00Ioo`<0009oo`03001oo`0000Qoo`03001oogoo009oo`8000/03`AW>AP03`=W>D003`=W>AT03`=W
>CX03`<000Ioo`@000Qoo`001Woo00<007oo00000`0000=oo`00Ool027oo00D007ooOomoo`0000ao
o`AW>A9oo`0300moogoo00=oo`AW>AAoo`0300moogoo01]oo`0300moogoo00Uoo`AW>@ioo`0300mo
ogoo00Qoo`AW>@moo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`04001oogoo0007
Ool000Eoo`D00004Ool007oo0009Ool01@00Oomoogoo000037oo0fLi4goo00<03gooOol00goo16Li
57oo00<03gooOol06goo00<03gooOol02Goo16Li3Woo00<03gooOol027oo16Li3goo00<03gooOol0
6goo00<03gooOol02goo00<007ooOol01Goo00@007ooOol000Moo`001goo0`000Woo00<007ooOol0
1Woo0`000goo00<007ooOol02Woo0fLi4goo00<03gooOol017oo0fLi57oo00<03gooOol06goo00<0
3gooOol02Goo0fLi3goo00<03gooOol02Goo0fLi3goo00<03gooOol06goo00<03gooOol02goo00<0
07ooOol01Woo0`001goo0006Ool01000Oomoo`004Goo00<007ooOol02Goo16Li4goo00<03gooOol0
17oo16Li4goo00<03gooOol06goo00<03gooOol027oo16Li3goo00<03gooOol02Goo16Li3Woo00<0
3gooOol06goo00<03gooOol02goo00<007ooOol047oo0006Ool01000Oomoo`004Goo0P002Woo16Li
4goo00<03gooOol017oo16Li4goo00<03gooOol06goo00<03gooOol027oo16Li3goo00<03gooOol0
2Goo16Li3Woo00<03gooOol06goo00<03gooOol02Woo0P001goo10001goo0007Ool3000AOol00`00
Oomoo`09Ool3IcTDOol00`0?Oomoo`05Ool3IcTCOol00`0?Oomoo`0KOol00`0?Oomoo`08Ool3IcT@
Ool00`0?Oomoo`0:Ool3IcT>Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00
Oomoo`07Ool001]oo`03001oogoo00Uoo`=W>AAoo`0300moogoo00Eoo`=W>A=oo`0300moogoo01]o
o`0300moogoo00Qoo`=W>A1oo`0300moogoo00Yoo`=W>@ioo`0300moogoo01]oo`0300moogoo00]o
o`03001oogoo00Ioo`03001oogoo00Moo`001Woo0`004Woo00<007ooOol027oo16Li57oo00<03goo
Ool01Goo16Li4Woo00<03gooOol06goo00<03gooOol01goo16Li47oo00<03gooOol02Woo16Li3Goo
00<03gooOol06goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0006Ool00`00Ool0
000BOol20009Ool4IcTDOol00`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`0KOol00`0?Oomoo`07Ool4
IcT@Ool00`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool20008Ool00`00Oomo
o`07Ool000Ioo`03001oo`00019oo`03001oogoo00Qoo`=W>AEoo`0300moogoo00Ioo`=W>A9oo`03
00moogoo01]oo`0300moogoo00Moo`=W>A5oo`0300moogoo00]oo`=W>@eoo`0300moogoo01]oo`03
00moogoo00]oo`03001oogoo00Eoo`<000Qoo`001Goo0P0000=oo`00Ool04Goo00<007ooOol01goo
16Li5Goo00<03gooOol01Woo16Li4Goo00<03gooOol06goo00<03gooOol01Woo16Li4Goo00<03goo
Ool02goo0fLi3Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo0`0027oo0006Ool3
000BOol00`00Oomoo`07Ool4IcTEOol00`0?Oomoo`06Ool4IcTAOol00`0?Oomoo`0KOol00`0?Oomo
o`06Ool4IcTAOol00`0?Oomoo`0;Ool4IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomo
o`07Ool00`00Oomoo`06Ool000Ioo`<0019oo`03001oogoo00Moo`=W>AIoo`0300moogoo00Moo`=W
>A5oo`0300moogoo01]oo`0300moogoo00Ioo`=W>A9oo`0300moogoo00]oo`AW>@aoo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo00Eoo`<000Qoo`0027oo00<007ooOol047oo0P0027oo0fLi
5Woo00<03gooOol01goo0fLi4Goo00<03gooOol06goo00<03gooOol01Woo0fLi4Woo00<03gooOol0
37oo0fLi37oo00<03gooOol06goo00<03gooOol02Woo0P004Woo0006Ool3000BOol00`00Oomoo`06
Ool4IcTFOol00`0?Oomoo`07Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`05Ool4IcTBOol00`0?
Oomoo`0<Ool3IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool001]o
o`03001oogoo00Ioo`AW>AIoo`0300moogoo00Moo`AW>A1oo`0300moogoo01]oo`0300moogoo00Eo
o`AW>A9oo`0300moogoo00aoo`AW>@]oo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Io
o`8000Qoo`001Woo00<007oo00004Woo00<007ooOol01Woo0fLi5goo00<03gooOol027oo0fLi47oo
00<03gooOol06goo00<03gooOol01Goo0fLi4goo00<03gooOol037oo16Li2goo00<03gooOol06goo
00<03gooOol02goo00<007ooOol01Goo00<007ooOol027oo0006Ool00`00Ool0000BOol00`00Oomo
o`06Ool3IcTGOol00`0?Oomoo`08Ool3IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`05Ool3IcTCOol0
0`0?Oomoo`0=Ool3IcT;Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool0
00Ioo`03001oo`00019oo`8000Ioo`AW>AMoo`0300moogoo00Qoo`AW>@moo`0300moogoo01]oo`03
00moogoo00Aoo`AW>A=oo`0300moogoo00eoo`=W>@]oo`0300moogoo01]oo`0300moogoo00Yoo`80
019oo`001Goo10004Woo00<007ooOol01Goo16Li5goo00<03gooOol027oo16Li3goo00<03gooOol0
6goo00<03gooOol017oo16Li4goo00<03gooOol03Goo16Li2Woo00<03gooOol06goo00<03gooOol0
2goo00<007ooOol01Goo0`0027oo000KOol00`00Oomoo`05Ool3IcTHOol00`0?Oomoo`09Ool3IcT?
Ool00`0?Oomoo`0KOol00`0?Oomoo`04Ool3IcTDOol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool20008Ool000Ioo`<000=oo`03001oogoo009oo`03001o
ogoo00=oo`05001oogooOol00006Ool4IcTHOol00`0?Oomoo`09Ool4IcT>Ool00`0?Oomoo`0KOol0
0`0?Oomoo`03Ool4IcTDOol00`0?Oomoo`0>Ool3IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool0
0`00Oomoo`05Ool00`00Oomoo`08Ool000Ioo`03001oogoo009oo`03001oo`0000Moo`<000=oo`80
00D03`AW>B@03`AW>C803`AW>BD03`=W>C@03`<000Moo`<000Qoo`001Woo00<007ooOol00Woo00<0
07oo00001goo00<007oo00000goo00<007ooOol017oo0fLi6Goo00<03gooOol02Woo0fLi3Woo00<0
3gooOol06goo00<03gooOol00goo0fLi5Goo00<03gooOol03Woo0fLi2Woo00<03gooOol06goo00<0
3gooOol02goo00<007ooOol017oo1@001goo0005Ool40002Ool00`00Ool00008Ool20003Ool00`00
Oomoo`04Ool3IcTIOol00`0?Oomoo`0:Ool3IcT>Ool00`0?Oomoo`0KOol00`0?Oomoo`03Ool3IcTE
Ool00`0?Oomoo`0>Ool4IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00
Oomoo`07Ool000Ioo`03001oogoo00=oo`03001oogoo00Qoo`05001oogooOol00005Ool4IcTIOol0
0`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool4IcTEOol00`0?Oomoo`0>Ool4
IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Ioo`<0
019oo`03001oogoo00=oo`AW>AUoo`0300moogoo00Yoo`AW>@eoo`0300moogoo01]oo`0300moogoo
009oo`AW>AEoo`0300moogoo00moo`=W>@Uoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo
00Eoo`8000Uoo`001Woo00<007oo00004Woo0P0017oo0fLi6Woo00<03gooOol02goo0fLi3Goo00<0
3gooOol06goo00<03gooOol00Woo0fLi5Woo00<03gooOol03goo0fLi2Goo00<03gooOol06goo00<0
3gooOol02Woo0P004Woo0006Ool00`00Ool0000BOol00`00Oomoo`03Ool3IcTJOol00`0?Oomoo`0;
Ool3IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool3IcTFOol00`0?Oomoo`0?Ool4IcT8Ool00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool20008Ool000Eoo`800003Ool007oo015oo`03
001oogoo009oo`AW>AYoo`0300moogoo00]oo`AW>@aoo`0300moogoo01]oo`0400moogooOol4IcTF
Ool00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000
Oomoo`001goo000KOol00`00Oomoo`02Ool4IcTJOol00`0?Oomoo`0;Ool4IcT<Ool00`0?Oomoo`0K
Ool0100?Oomoogoo16Li5Woo00<03gooOol047oo0fLi27oo00<03gooOol06goo00<03gooOol02goo
00<007ooOol01Goo00@007ooOol000Moo`001Goo00D007oo001oo`00015oo`03001oogoo009oo`=W
>A]oo`0300moogoo00aoo`=W>@aoo`0300moogoo01]oo`0400moogooOol3IcTGOol00`0?Oomoo`0@
Ool3IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool30007Ool000Eoo`05001o
o`00Ool0000AOol20002Ool4IcTKOol00`0?Oomoo`0<Ool4IcT;Ool00`0?Oomoo`0KOol00`0?Oomo
o`04IcTGOol00`0?Oomoo`0@Ool4IcT7Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol000Eo
o`05001oo`00Ool0000AOol01000Oomoogoo`0000goo00<007ooOol01Goo0`0027oo0005Ool5000A
Ool01000Oomoogoo`0000goo00<007ooOol01Goo0`0027oo000KOol01000Oomoogoo`0000goo00<0
07ooOol01goo00<007ooOol01Woo000KOol2000QOol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`0K
Ool00`0?OomW>@03IcTHOol00`0?Oomoo`0AOol4IcT6Ool00`0?Oomoo`0KOol00`0?Oomoo`04Ool4
IcT2Ool20007Ool30008Ool001]oo`03001oogoo021oo`0300moogoo00eoo`AW>@Yoo`0300moogoo
01]oo`0300moofLi00=W>AQoo`0300moogoo015oo`AW>@Ioo`0300moogoo01]oo`0300moogoo00Ao
o`AW>@=oo`03001oogoo011oo`006goo00<007ooOol087oo00<03gooOol03Woo0fLi2Woo00<03goo
Ool06goo00<03gooIcT00VLi6Goo00<03gooOol04Woo0fLi1Woo00<03gooOol06goo00<03gooOol0
17oo0fLi17oo00<007ooOol01Goo10001goo0008Ool00`00Oomoo`0@Ool00`00Oomoo`0POol00`0?
Oomoo`0>Ool4IcT9Ool00`0?Oomoo`0KOol00`0?IcUW>@02IcTIOol00`0?Oomoo`0BOol4IcT5Ool0
0`0?Oomoo`0KOol00`0?Oomoo`03Ool4IcT4Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Moo`03
001oogoo015oo`03001oogoo021oo`0300moogoo00ioo`AW>@Uoo`0300moogoo01]oo`0300mW>FLi
009W>AUoo`0300moogoo019oo`AW>@Eoo`0300moogoo01]oo`0300moogoo00=oo`AW>@Aoo`03001o
ogoo00Ioo`03001oogoo00Moo`001goo00<007ooOol04Goo0P008Goo00<03gooOol03goo0fLi2Goo
00<03gooOol06goo00@03fLiIcUW>AYoo`0300moogoo01=oo`=W>@Eoo`0300moogoo01]oo`0300mo
ogoo00=oo`=W>@Aoo`8000Qoo`03001oogoo00Moo`001goo00<007ooOol04Goo00<007ooOol087oo
00<03gooOol03goo0fLi2Goo00<03gooOol06goo00@03fLiIcUW>AYoo`0300moogoo01=oo`=W>@Eo
o`0300moogoo01]oo`0300moogoo00=oo`=W>@Eoo`03001oogoo00Ioo`03001oogoo00Moo`001goo
00<007ooOol04Goo00<007ooOol087oo00<03gooOol03goo16Li27oo00<03gooOol06goo16Li6Woo
00<03gooOol04goo16Li17oo00<03gooOol06goo00<03gooOol00Woo16Li1Goo00<007ooOol01Goo
0P002Goo0008Ool00`00Oomoo`0@Ool00`00Oomoo`0POol00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomo
o`0KOol4IcTJOol00`0?Oomoo`0COol4IcT4Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool4IcT5Ool0
0`00Oomoo`0@Ool000Ioo`@0009oo`03001oogoo009oo`03001oogoo009oo`8000=oo`03001oogoo
021oo`0300moogoo011oo`=W>@Qoo`0300moogoo01]oo`=W>A]oo`0300moogoo01Aoo`=W>@Aoo`03
00moogoo01]oo`0300moogoo009oo`=W>@Ioo`03001oogoo011oo`001goo00L007ooOomoo`00Ool0
0007Ool00`00Ool00003Ool2000d00l3IcTV00l3IcTb00l3IcTW00l3IcT400l30009Ool00`00Oomo
o`06Ool000Moo`07001oogooOol007oo00001goo0`000goo00<007ooOol087oo00<03gooOol047oo
16Li1goo00<03gooOol06Woo16Li6goo00<03gooOol057oo16Li0goo00<03gooOol06goo00@03goo
Oomoo`AW>@Ioo`03001oogoo00Ioo`03001oogoo00Moo`001goo00L007ooOomoo`00Ool00007Ool0
0`00Oomoo`03Ool00`00Oomoo`0POol00`0?Oomoo`0@Ool4IcT7Ool00`0?Oomoo`0JOol4IcTKOol0
0`0?Oomoo`0DOol4IcT3Ool00`0?Oomoo`0KOol0100?Oomoogoo16Li1Woo00<007ooOol01Woo00<0
07ooOol01goo0007Ool00`00Oomoo`02Ool00`00Oomoo`07Ool20003Ool00`00Oomoo`0POol00`0?
Oomoo`0AOol3IcT7Ool00`0?Oomoo`0JOol3IcTLOol00`0?Oomoo`0EOol3IcT3Ool00`0?Oomoo`0K
Ool0100?Oomoogoo0fLi1goo00<007ooOol01Woo00<007ooOol01goo0005Ool5000AOol2000QOol0
0`0?Oomoo`0AOol4IcT6Ool00`0?Oomoo`0IOol4IcTLOol00`0?Oomoo`0EOol4IcT2Ool00`0?Oomo
o`0KOol00`0?Oomoo`04IcT6Ool20008Ool00`00Oomoo`07Ool000Moo`03001oogoo015oo`03001o
ogoo021oo`0300moogoo015oo`AW>@Ioo`0300moogoo01Uoo`AW>Aaoo`0300moogoo01Eoo`AW>@9o
o`0300moogoo01]oo`0300moogoo00AW>@Moo`03001oogoo00Moo`03001oogoo00Ioo`001goo00<0
07ooOol04Goo00<007ooOol087oo00<03gooOol04Woo0fLi1Woo00<03gooOol06Goo0fLi7Goo00<0
3gooOol05Woo0fLi0Woo00<03gooOol06goo00<03gooOol00fLi27oo00<007ooOol01Woo0`001goo
0006Ool4000AOol00`00Oomoo`0POol00`0?Oomoo`0BOol3IcT6Ool00`0?Oomoo`0IOol3IcTMOol0
0`0?Oomoo`0FOol3IcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`03IcT8Ool00`00Oomoo`05Ool01000
Oomoo`001goo0009Ool00`00Oomoo`0?Ool00`00Oomoo`0POol00`0?Oomoo`0BOol4IcT5Ool00`0?
Oomoo`0HOol4IcTMOol00`0?Oomoo`0FOol4IcT00goo00moo`0LOol00`0?OomW>@03IcT8Ool00`00
Oomoo`05Ool01000Oomoo`001goo0007Ool3000AOol2000QOol00`0?Oomoo`0BOol4IcT5Ool00`0?
Oomoo`0HOol4IcTMOol00`0?Oomoo`0FOol4IcT00goo00moo`0LOol00`0?OomW>@03IcT7Ool20008
Ool30007Ool000Ioo`04001oogoo000AOol00`00Oomoo`0POol00`0?Oomoo`0COol3IcT5Ool00`0?
Oomoo`0HOol3IcT00`0?Oomoo`0KOol00`0?Oomoo`0GOol3IcT00goo00moo`0LOol00`0?OomW>@02
IcT9Ool00`00Oomoo`08Ool00`00Oomoo`05Ool000Ioo`04001oogoo000AOol00`00Oomoo`0POol0
0`0?Oomoo`0COol3IcT5Ool00`0?Oomoo`0HOol3IcT00`0?Oomoo`0KOol00`0?Oomoo`0GOol3IcT0
0goo00moo`0LOol00`0?OomW>@02IcT9Ool00`00Oomoo`05Ool40007Ool000Moo`<0015oo`03001o
ogoo021oo`0300moogoo01=oo`AW>@Aoo`0300moogoo01Moo`AW>@0300moogoo01]oo`0300moogoo
01Moo`AW>@0300moogoo01]oo`0300mW>FLi009W>@Uoo`03001oogoo00Eoo`<000Qoo`001Woo00<0
07oo00004Woo00<007ooOol087oo00<03gooOol04goo16Li17oo00<03gooOol05goo16Li00<03goo
Ool06goo00<03gooOol05goo16Li00<03gooOol06goo00<03fLiIcT00VLi2Goo00<007ooOol01goo
00<007ooOol01Woo0006Ool00`00Ool0000BOol2000QOol00`0?Oomoo`0DOol3IcT4Ool00`0?Oomo
o`0GOol3IcT00goo00moo`0LOol00`0?Oomoo`0HOol3IcT00`0?Oomoo`0KOol0100?IcUW>FLi2Goo
0P001goo0`0027oo0006Ool00`00Ool0000BOol00`00Oomoo`0POol00`0?Oomoo`0DOol4IcT3Ool0
0`0?Oomoo`0FOol4IcT00goo00moo`0LOol00`0?Oomoo`0HOol4IcTMOol4IcT:Ool00`00Oomoo`0@
Ool000Ioo`<0019oo`03001oogoo021oo`0300moogoo01Aoo`AW>@=oo`0300moogoo01Ioo`AW>@03
Ool03goo01aoo`0300moogoo01Qoo`AW>Aeoo`AW>@Yoo`03001oogoo00Aoo`@000Qoo`001Woo00<0
07ooOol04Woo00<007ooOol087oo00<03gooOol05Goo0fLi0goo00<03gooOol05Woo0fLi0Woo00<0
3gooOol06goo00<03gooOol06Goo0fLi7Goo0fLi2goo00<007ooOol01Goo00<007ooOol027oo0005
Ool4000BOol2000QOol00`0?Oomoo`0EOol4IcT2Ool00`0?Oomoo`0EOol4IcT2Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0IOol4IcTKOol4IcT:Ool20007Ool00`00Oomoo`08Ool000Ioo`03001oogoo019o
o`03001oogoo021oo`0300moogoo01Eoo`AW>@9oo`0300moogoo01Eoo`AW>@9oo`0300moogoo01]o
o`0300moogoo01Uoo`AW>A]oo`AW>@]oo`03001oogoo00Aoo`@000Qoo`001Woo00<007ooOol04Woo
00<007ooOol087oo00<03gooOol05Woo0fLi0Woo00<03gooOol05Goo0fLi0goo00<03gooOol06goo
00<03gooOol06Woo0fLi6goo0fLi37oo00<007ooOol047oo0005Ool4000BOol00`00Oomoo`0POol0
0`0?Oomoo`0FOol4IcT00goo00moo`0EOol4IcT3Ool00`0?Oomoo`0KOol00`0?Oomoo`0JOol4IcTI
Ool4IcT<Ool00`00Oomoo`05Ool01000Ool000001goo0006Ool20004Ool00`00Oomoo`02Ool01000
Oomoogoo0`000goo00<007ooOol087oo00<03gooOol05Woo16Li00=oo`0?Ool05Goo16Li0goo00<0
3gooOol06goo00<03gooOol06Woo16Li6Goo16Li37oo00<007ooOol01Goo10001goo0008Ool01P00
Oomoo`00Ool000Moo`03001oo`0000=oo`8003/03`=W>AP03`=W>D003`=W>AT03`=W>@/03`<000Mo
o`<000Qoo`0027oo00H007ooOol007oo0008Ool00`00Oomoo`02Ool00`00Oomoo`0POol00`0?Oomo
o`0GOol4IcT00`0?Oomoo`0COol4IcT4Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol4IcTGOol4IcT=
Ool00`00Oomoo`05Ool40007Ool000Qoo`06001oogoo001oo`001goo00<007oo00000goo00<007oo
Ool087oo00<03gooOol05goo16Li00<03gooOol04goo16Li17oo00<03gooOol06goo00<03gooOol0
6goo16Li5goo16Li3Goo00<007ooOol01Goo00<007oo000027oo0008Ool01@00Oomoogoo000027oo
0`000goo00<007ooOol087oo00<03gooOol067oo0fLi00<03gooOol04goo0fLi1Goo00<03gooOol0
6goo00<03gooOol06goo00@03fLiIcUW>AMoo`=W>@0300moogoo00]oo`03001oogoo00Aoo`800003
Ool007oo00Moo`001goo00<007ooOol04Goo00<007ooOol087oo00<03gooOol067oo16Li57oo16Li
1Goo00<03gooOol06goo00<03gooOol06goo00<03fLiIcT00VLi5Goo16Li00<03gooOol02goo00<0
07ooOol01goo00<007ooOol01Woo000KOol2000QOol00`0?Oomoo`0HOol4IcTDOol4IcT5Ool00`0?
Oomoo`0KOol00`0?Oomoo`0KOol00`0?IcUW>@02IcTEOol4IcT00`0?Oomoo`0:Ool20009Ool00`00
Oomoo`06Ool001]oo`03001oogoo021oo`0300moogoo01Uoo`=W>AAoo`=W>@Ioo`0300moogoo01]o
o`0300moogoo01]oo`0300moofLi009W>AEoo`=W>@03Ool03goo00aoo`03001oogoo00Ioo`03001o
ogoo00Moo`006goo00<007ooOol087oo00<03gooOol06Goo16Li4Woo16Li1Woo00<03gooOol06goo
00<03gooOol06goo00<03gooIcT00fLi4goo16Li00=oo`0?Ool037oo00<007ooOol047oo000KOol0
0`00Oomoo`0POol00`0?Oomoo`0IOol4IcTBOol4IcT6Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol0
0`0?OomW>@03IcTCOol4IcT00goo00moo`0<Ool00`00Oomoo`0@Ool001]oo`80025oo`0300moogoo
01Yoo`=W>A9oo`=W>@Moo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00=W>A=oo`=W>@9o
o`0300moogoo00Yoo`80019oo`006goo00<007ooOol087oo00<03gooOol06Woo16Li47oo16Li1goo
00<03gooOol06goo00<03gooOol06goo00<03gooOol016Li4Goo16Li0Woo00<03gooOol02goo00<0
07ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0JOol4IcT@Ool4IcT7Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`04IcTAOol4IcT2Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
01]oo`03001oogoo021oo`0300moogoo01]oo`AW>@ioo`AW>@Qoo`0300moogoo01]oo`0300moogoo
01]oo`0400moogooOol4IcT?Ool4IcT3Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001o
ogoo021oo`0300moogoo01]oo`AW>@ioo`AW>@Qoo`0300moogoo01]oo`0300moogoo01]oo`0400mo
ogooOol4IcT?Ool4IcT3Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`80025oo`0300moogoo
01]oo`0400mW>FLiIcT>Ool3IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`02Ool3
IcT?Ool3IcT4Ool00`0?Oomoo`0:Ool2000BOol001]oo`03001oogoo021oo`0300moogoo01]oo`03
00mW>FLi009W>@aoo`AW>@Uoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo009oo`AW>@eo
o`AW>@Aoo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol087oo00<03gooOol06goo
00<03fLiIcT00VLi37oo16Li2Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol00Woo16Li
3Goo16Li17oo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0K
Ool00`0?OomW>@03IcT:Ool4IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`03Ool4
IcT;Ool4IcT5Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo
01]oo`0300moofLi00AW>@Qoo`EW>@Yoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00=o
o`EW>@Uoo`EW>@Eoo`0300moogoo00]oo`03001oogoo011oo`006goo0P008Goo00<03gooOol06goo
00<03gooOol01FLi1goo16Li2goo00<03gooOol06goo00<03gooOol06goo00<03gooOol017oo1FLi
27oo16Li1Woo00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol0100?
Oomoogoo16Li1Woo16Li37oo00<03gooOol06goo00<03gooOol06goo00<03gooOol01Goo16Li1goo
16Li1goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol0
0`0?Oomoo`02Ool5IcT3Ool5IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`06Ool5
IcT3Ool6IcT7Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Eoo`<000=oo`03001oogoo021oo`03
00moogoo01]oo`0300moogoo009oo`aW>@eoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo
00Ioo`eW>@Qoo`0300moogoo00]oo`03001oogoo011oo`005Woo00<007ooOol00Woo0P008Goo00<0
3gooOol06goo00<03gooOol00goo2fLi3Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol0
1goo2fLi2Goo00<03gooOol02Goo0`004Woo000FOol00`00Oomoo`02Ool00`00Oomoo`0POol00`0?
Oomoo`0KOol00`0?Oomoo`04Ool8IcT?Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`09
Ool8IcT:Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]o
o`03001oogoo01]oo`03001oogoo00]oo`03001oogoo011oo`005Goo0P0017oob0004Woo003eOol0
0001\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.06696, -0.248815, 0.0332155, 
  0.00855357}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me! (p0A=0.9, p0B=0.2)", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Sometimes, classical and quantum probabilities can be close \
...\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["ComparisonPlot[0.9, 0.2];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147139 0.588612 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01471 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60333 1 0 0 Minner Mrotsboxa
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13244 m
1 .13244 L
s
P
p
0 0 .5 r
.001 w
0 .25016 m
1 .25016 L
s
P
p
0 0 .5 r
.001 w
0 .36788 m
1 .36788 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01471 m
.00625 .01471 L
s
P
[(0)] -0.0125 .01471 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60333 m
.00625 .60333 L
s
P
[(1)] -0.0125 .60333 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17953 m
.00375 .17953 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29725 m
.00375 .29725 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34434 m
.00375 .34434 L
s
P
p
.001 w
0 .39143 m
.00375 .39143 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46206 m
.00375 .46206 L
s
P
p
.001 w
0 .50915 m
.00375 .50915 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55624 m
.00375 .55624 L
s
P
p
.001 w
0 .57978 m
.00375 .57978 L
s
P
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01471 m
1 .01471 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60333 m
1 .60333 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17953 m
1 .17953 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29725 m
1 .29725 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34434 m
1 .34434 L
s
P
p
.001 w
.99625 .39143 m
1 .39143 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46206 m
1 .46206 L
s
P
p
.001 w
.99625 .50915 m
1 .50915 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55624 m
1 .55624 L
s
P
p
.001 w
.99625 .57978 m
1 .57978 L
s
P
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .54446 m
.06349 .42071 L
.10317 .25456 L
.12302 .17205 L
.14286 .10091 L
.15278 .072 L
.1627 .04853 L
.16766 .03901 L
.17262 .03103 L
.17758 .02462 L
.18006 .02201 L
.18254 .0198 L
.18502 .01799 L
.1875 .01657 L
.18874 .01602 L
.18998 .01556 L
.19122 .0152 L
.19246 .01494 L
.1937 .01478 L
.19494 .01472 L
.19618 .01475 L
.19742 .01488 L
.19866 .01511 L
.1999 .01543 L
.20114 .01585 L
.20238 .01636 L
.20486 .01766 L
.20734 .01934 L
.2123 .02376 L
.21726 .02958 L
.22222 .03673 L
.24206 .07711 L
.2619 .13244 L
.30159 .26706 L
.34127 .40403 L
.36111 .46486 L
.38095 .51713 L
.40079 .55868 L
.41071 .57482 L
.42063 .58757 L
.4256 .59259 L
.43056 .59669 L
.43304 .59838 L
.43552 .59983 L
.438 .60103 L
.44048 .60198 L
.44172 .60236 L
.44296 .60268 L
.4442 .60294 L
.44544 .60313 L
Mistroke
.44668 .60326 L
.44792 .60332 L
.44916 .60332 L
.4504 .60325 L
.45164 .60312 L
.45288 .60292 L
.45536 .60232 L
.4566 .60192 L
.45784 .60145 L
.46032 .60032 L
.46528 .59723 L
.47024 .59305 L
.48016 .58134 L
.49008 .56514 L
.5 .54446 L
.51984 .49022 L
.53968 .42071 L
.57937 .25456 L
.59921 .17205 L
.61905 .10091 L
.62897 .072 L
.63889 .04853 L
.64881 .03103 L
.65377 .02462 L
.65625 .02201 L
.65873 .0198 L
.66121 .01799 L
.66369 .01657 L
.66617 .01556 L
.66741 .0152 L
.66865 .01494 L
.66989 .01478 L
.67113 .01472 L
.67237 .01475 L
.67361 .01488 L
.67485 .01511 L
.67609 .01543 L
.67857 .01636 L
.68105 .01766 L
.68353 .01934 L
.68849 .02376 L
.69345 .02958 L
.69841 .03673 L
.71825 .07711 L
.7381 .13244 L
.77778 .26706 L
.81746 .40403 L
.8373 .46486 L
.85714 .51713 L
.86706 .53937 L
Mistroke
.87698 .55868 L
.8869 .57482 L
.89683 .58757 L
.90179 .59259 L
.90675 .59669 L
.91171 .59983 L
.91419 .60103 L
.91667 .60198 L
.91915 .60268 L
.92039 .60294 L
.92163 .60313 L
.92287 .60326 L
.92411 .60332 L
.92535 .60332 L
.92659 .60325 L
.92783 .60312 L
.92907 .60292 L
.93031 .60265 L
.93155 .60232 L
.93403 .60145 L
.93651 .60032 L
.94147 .59723 L
.94643 .59305 L
.95635 .58134 L
.96627 .56514 L
.97619 .54446 L
Mfstroke
P
P
p
p
.02 w
.02381 .54446 m
.02505 .54444 L
.02629 .54435 L
.02753 .54422 L
.02877 .54402 L
.03001 .54378 L
.03125 .54347 L
.03373 .5427 L
.03621 .54171 L
.03869 .54051 L
.04365 .53744 L
.05357 .52878 L
.06349 .51686 L
.08333 .48412 L
.10317 .44146 L
.14286 .33845 L
.18254 .23544 L
.20238 .19278 L
.2123 .17501 L
.22222 .16004 L
.23214 .14812 L
.2371 .14337 L
.24206 .13946 L
.24702 .13639 L
.2495 .13519 L
.25198 .1342 L
.25446 .13343 L
.2557 .13313 L
.25694 .13288 L
.25818 .13268 L
.25942 .13255 L
.26066 .13246 L
.2619 .13244 L
.26314 .13246 L
.26438 .13255 L
.26562 .13268 L
.26687 .13288 L
.26935 .13343 L
.27183 .1342 L
.27431 .13519 L
.27679 .13639 L
.28175 .13946 L
.29167 .14812 L
.30159 .16004 L
.32143 .19278 L
.34127 .23544 L
.38095 .33845 L
.42063 .44146 L
.44048 .48412 L
.4504 .50189 L
Mistroke
.46032 .51686 L
.47024 .52878 L
.48016 .53744 L
.48512 .54051 L
.4876 .54171 L
.49008 .5427 L
.49256 .54347 L
.4938 .54378 L
.49504 .54402 L
.49628 .54422 L
.49752 .54435 L
.49876 .54444 L
.5 .54446 L
.50124 .54444 L
.50248 .54435 L
.50372 .54422 L
.50496 .54402 L
.5062 .54378 L
.50744 .54347 L
.50992 .5427 L
.5124 .54171 L
.51488 .54051 L
.51984 .53744 L
.52976 .52878 L
.53968 .51686 L
.55952 .48412 L
.57937 .44146 L
.61905 .33845 L
.65873 .23544 L
.67857 .19278 L
.68849 .17501 L
.69841 .16004 L
.70833 .14812 L
.71329 .14337 L
.71825 .13946 L
.72321 .13639 L
.72569 .13519 L
.72817 .1342 L
.73065 .13343 L
.73189 .13313 L
.73313 .13288 L
.73437 .13268 L
.73562 .13255 L
.73686 .13246 L
.7381 .13244 L
.73934 .13246 L
.74058 .13255 L
.74182 .13268 L
.74306 .13288 L
.74554 .13343 L
Mistroke
.74802 .1342 L
.7505 .13519 L
.75298 .13639 L
.75794 .13946 L
.76786 .14812 L
.77778 .16004 L
.79762 .19278 L
.81746 .23544 L
.85714 .33845 L
.89683 .44146 L
.91667 .48412 L
.93651 .51686 L
.94643 .52878 L
.95139 .53353 L
.95635 .53744 L
.96131 .54051 L
.96379 .54171 L
.96627 .5427 L
.96875 .54347 L
.96999 .54378 L
.97123 .54402 L
.97247 .54422 L
.97371 .54435 L
.97495 .54444 L
.97619 .54446 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol007Mo
o`<007]oo`00N7oo00<007ooOol0NWoo001hOol30002Ool01000Ool007oo1@00Kgoo001hOol02000
Oomoo`00Ool007oo0003Ool00`00Oomoo`1_Ool007Qoo`08001oogoo001oo`00Ool000=oo`03001o
ogoo06moo`00Mgoo10000Woo0`000Woo0P00LGoo001mOol00`00Oomoo`1eOol007aoo`8000Eoo`03
001oogoo06moo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol001moo`03001o
ogoo01Yoo`<001]oo`<001aoo`<001eoo`03001oogoo01Uoo`<001aoo`8001moo`007Woo00<007oo
000077oo00<007ooOol06goo00<007ooOol07Goo00<007ooOol06Goo0`007Goo00<007ooOol06Goo
00<007oo00007goo000NOol00`00Ool0000LOol00`00Oomoo`0LOol00`00Oomoo`0KOol00`00Oomo
o`0JOol00`00Ool0000KOol3000KOol3000OOol001ioo`03001oo`0001aoo`03001oogoo01aoo`03
001oogoo01aoo`03001oogoo01Yoo`8001]oo`03001oogoo01]oo`03001oogoo01moo`007goo00<0
07ooOol06Woo0P0077oo0`0077oo0`007Goo00<007ooOol06Goo0`0077oo0P007goo003eOol00?Eo
o`00mGoo003eOol001]oolP0019oo`006goo00<007ooOol00Woo00<007ooOol06goo00<007ooOol0
6goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol0
2goo00<007ooOol047oo000FOol00`00Oomoo`02Ool00`00Oomoo`0POol00`0?IcUW>@05IcTFOol0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`02Ool7IcTBOol00`0?Oomoo`0KOol00`0?Oomo
o`0;Ool00`00Oomoo`0@Ool001Eoo`03001oo`0000=oo`80025oo`UW>AEoo`0300moogoo01]oo`03
00moogoo01]oo`0400moogooOol:IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`09Ool3000BOol001Eo
o`03001oo`0000=oo`03001oogoo01moo`YW>AEoo`0300moogoo01]oo`0300moogoo01]oo`0400mo
ogooOol:IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Eoo`03001oo`00
00=oo`03001oogoo01ioo`EW>@9oo`EW>AAoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo
00EW>@9oo`EW>@moo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`005Woo00<007oo
Ool00Woo00<007ooOol07Goo1FLi17oo1FLi4goo00<03gooOol06goo00<03gooOol06goo00<03goo
Ool016Li17oo1FLi3Woo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol2000N
Ool4IcT6Ool4IcTCOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?OomW>@03IcT6Ool4IcT>Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol001]oo`03001oogoo01aoo`AW>@0300moogoo00Eo
o`AW>A9oo`0300moogoo01]oo`0300moogoo01]oo`0300mW>FLi00=W>@Moo`AW>@eoo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol077oo16Li00<03gooOol01Goo
16Li4Woo00<03gooOol06goo00<03gooOol06goo00<03fLiIcT00VLi27oo16Li3Goo00<03gooOol0
6goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0KOol4IcT00goo00moo`07Ool4
IcTAOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol4IcT:Ool4IcT<Ool00`0?Oomoo`0KOol00`0?Oomo
o`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo01]oo`AW>@03Ool03goo00Moo`AW>A5oo`0300mo
ogoo01]oo`0300moogoo01]oo`AW>@Yoo`AW>@aoo`0300moogoo01]oo`0300moogoo00]oo`03001o
ogoo011oo`006goo0P0077oo0fLi0Woo00<03gooOol01goo16Li47oo00<03gooOol06goo00<03goo
Ool06goo0fLi37oo16Li2goo00<03gooOol06goo00<03gooOol02Woo0P004Woo000KOol00`00Oomo
o`0JOol4IcT2Ool00`0?Oomoo`07Ool4IcT@Ool00`0?Oomoo`0KOol00`0?Oomoo`0JOol4IcT<Ool4
IcT;Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo01Yoo`AW
>@9oo`0300moogoo00Qoo`AW>@moo`0300moogoo01]oo`0300moogoo01Yoo`AW>@eoo`AW>@Yoo`03
00moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol06Goo16Li0goo00<0
3gooOol027oo16Li3goo00<03gooOol06goo00<03gooOol06Goo16Li3Woo16Li2Woo00<03gooOol0
6goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0IOol4IcT3Ool00`0?Oomoo`09
Ool4IcT>Ool00`0?Oomoo`0KOol00`0?Oomoo`0IOol4IcT?Ool3IcT:Ool00`0?Oomoo`0KOol00`0?
Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`8001Yoo`=W>@Aoo`0300moogoo00Uoo`AW>@ioo`0300mo
ogoo01]oo`0300moogoo01Uoo`=W>A1oo`AW>@Uoo`0300moogoo01]oo`0300moogoo00Yoo`80019o
o`006goo00<007ooOol067oo16Li17oo00<03gooOol02Woo0fLi3Woo00<03gooOol06goo00<03goo
Ool067oo16Li47oo16Li2Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol0
0`00Oomoo`0HOol4IcT4Ool00`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0HOol4
IcTAOol3IcT9Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo
01Qoo`=W>@Eoo`0300moogoo00Yoo`AW>@eoo`0300moogoo01]oo`0300moogoo01Qoo`=W>@0300mo
ogoo00moo`AW>@Qoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`006goo0P006Goo
0fLi1Goo00<03gooOol02goo0fLi3Goo00<03gooOol06goo00<03gooOol067oo0fLi00<03gooOol0
3goo16Li27oo00<03gooOol06goo00<03gooOol02Woo0P004Woo000KOol00`00Oomoo`0GOol4IcT5
Ool00`0?Oomoo`0;Ool4IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol4IcT00`0?Oomoo`0@Ool3
IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`04Ool30009Ool001]oo`03001oogoo
01Moo`AW>@Eoo`0300moogoo00]oo`AW>@aoo`0300moogoo01]oo`0300moogoo01Moo`AW>@0300mo
ogoo011oo`=W>@Qoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`03001oogoo00Qo
o`001Goo0`004goo00<007ooOol05goo0fLi1Woo00<03gooOol037oo0fLi37oo00<03gooOol06goo
00<03gooOol05goo0fLi00=oo`0?Ool04Goo16Li1goo00<03gooOol06goo00<03gooOol02goo00<0
07ooOol01Goo0`0027oo0006Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000Oomoogoo0`000goo
00<007ooOol05Woo16Li1Woo00<03gooOol02goo1`002Goo00<03gooOol06goo00<03gooOol05Woo
16Li00=oo`0?Ool04Goo1P001Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo00<0
07oo000027oo0006Ool30002Ool00`00Ool00008Ool00`00Oomoo`02Ool2000G00l4IcTB00l;000n
00l4IcTB00l:000]00l30006Ool40008Ool000Ioo`03001oo`0000<00003Ool007oo00Qoo`05001o
ogooOol0000HOol3IcT7Ool00`0?Oomoo`08Ool=0006Ool00`0?Oomoo`0KOol00`0?Oomoo`0FOol3
IcT2Ool00`0?Oomoo`0=Ool<0002Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool0
1000Oomoo`001goo0005Ool5000017oo001oo`002Goo00D007ooOomoo`0001Qoo`=W>@Moo`0300mo
ogoo00Moo`H0009W>@L000Eoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0300moogoo00ao
o`H0009W>@H00003Ool03goo01aoo`0300moogoo00]oo`03001oogoo00Eoo`04001oogoo0007Ool0
00Moo`<0009oo`03001oogoo00Ioo`<000=oo`03001oogoo01Eoo`AW>@Moo`0300moogoo00Ioo`D0
009oo`AW>@03Ool0000000<000Aoo`0300moogoo01]oo`0300moogoo01Eoo`AW>@9oo`0300moogoo
00]oo`D00003OomW>FLi009W>@03Ool0000000<0000300moogoo01]oo`0300moogoo00]oo`03001o
ogoo00Ioo`<000Moo`001Woo00@007ooOol0015oo`03001oogoo01Eoo`AW>@Moo`0300moogoo00Eo
o`D000Aoo`=W>@9oo`D000=oo`0300moogoo01]oo`0300moogoo01Eoo`AW>@9oo`0300moogoo00Yo
o`D000=oo`=W>@9oo`D001eoo`0300moogoo00]oo`03001oogoo011oo`001Woo00@007ooOol0015o
o`8001Ioo`=W>@Qoo`0300moogoo00Eoo`@000Eoo`AW>@9oo`@000=oo`0300moogoo01]oo`0300mo
ogoo01Eoo`=W>@=oo`0300moogoo00Yoo`@000Aoo`AW>@9oo`@001eoo`0300moogoo00Yoo`8000Mo
o`@000Moo`001goo0`004Goo00<007ooOol057oo16Li27oo00<03gooOol017oo10001Woo16Li0goo
10000Woo00<03gooOol06goo00<03gooOol057oo16Li0goo00<03gooOol02Goo10001Goo16Li0goo
100077oo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo000KOol00`00Oomoo`0DOol4
IcT8Ool00`0?Oomoo`03Ool50007Ool3IcT3Ool40002Ool00`0?Oomoo`0KOol00`0?Oomoo`0DOol4
IcT3Ool00`0?Oomoo`08Ool50006Ool3IcT3Ool4000LOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`07Ool000Ioo`<0019oo`03001oogoo01Aoo`=W>@Uoo`0300moogoo00=oo`@000Qoo`AW
>@=oo`@00003Ool03goo01aoo`0300moogoo01Aoo`=W>@Aoo`0300moogoo00Qoo`@000Moo`AW>@=o
o`@001]oo`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001Woo00<007oo00004Woo
0P005Goo0fLi2Goo00<03gooOol00Woo10002Goo16Li0goo1@0000<03gooOol06goo00<03gooOol0
57oo0fLi17oo00<03gooOol01goo100027oo16Li0goo1@006Woo00<03gooOol02Woo0P0027oo00<0
07ooOol01goo0006Ool00`00Ool0000BOol00`00Oomoo`0COol4IcT9Ool00`0?Oomoo`02Ool4000:
Ool3IcT4Ool400000`0?Oomoo`0KOol00`0?Oomoo`0COol4IcT4Ool00`0?Oomoo`07Ool40009Ool3
IcT4Ool4000JOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Eoo`800003Ool007oo015o
o`03001oogoo01=oo`AW>@Uoo`0400moogooOol4000;Ool3IcT5Ool4000MOol00`0?Oomoo`0COol4
IcT4Ool00`0?Oomoo`06Ool4000:Ool3IcT4Ool00`0?00000002000IOol00`0?Oomoo`0;Ool00`00
Oomoo`05Ool30008Ool000Ioo`<0019oo`03001oogoo01=oo`=W>@Yoo`0400moogooOol4000;Ool4
IcT4Ool4000MOol00`0?Oomoo`0COol3IcT5Ool00`0?Oomoo`06Ool4000:Ool4IcT3Ool00`0?0000
0002000IOol00`0?Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`06Ool000Ioo`<0019oo`03001o
ogoo01=oo`=W>@Yoo`0300moogoo00@000aoo`AW>@Eoo`@001aoo`0300moogoo01=oo`=W>@Eoo`03
00moogoo00Eoo`@000]oo`AW>@=oo`0300moo`0000<001Qoo`0300moogoo00]oo`03001oogoo00Eo
o`<000Qoo`0027oo00<007ooOol047oo0P004goo16Li2Woo00<03gooOol010003Goo0fLi1Goo1000
77oo00<03gooOol04Woo16Li1Goo00<03gooOol01Goo100037oo0fLi0goo00<03goo00000`0067oo
00<03gooOol02Woo0P004Woo0006Ool3000BOol00`00Oomoo`0BOol4IcT:Ool00`0?Ool00003000>
Ool4IcT5Ool4000KOol00`0?Oomoo`0BOol4IcT5Ool00`0?Oomoo`04Ool4000=Ool4IcT2Ool00`0?
Oomoo`04000GOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool001]oo`03001oogoo019oo`=W
>@]oo`0300moo`0000<000ioo`AW>@Eoo`@001]oo`0300moogoo019oo`=W>@Ioo`0300moogoo00Ao
o`@000eoo`AW>@9oo`0300moogoo00@001Moo`0300moogoo00]oo`03001oogoo00Ioo`8000Qoo`00
1Woo00<007oo00004Woo00<007ooOol04Woo0fLi2goo00<03`0000000P0047oo0fLi1Woo10006Woo
00<03gooOol04Woo0fLi1Woo00<03gooOol00goo10003goo0fLi0Woo00@03gooOomoo`@001Ioo`03
00moogoo00]oo`03001oogoo00Eoo`03001oogoo00Qoo`001Woo00<007oo00004Woo00<007ooOol0
4Goo16Li2goo00<03`0000000P0047oo0fLi1Woo10006Woo00<03gooOol04Goo16Li1Woo00<03goo
Ool00goo10003goo0fLi0Woo00@03gooOomoo`@001Ioo`0300moogoo00]oo`03001oogoo00Eoo`<0
00Qoo`001Woo00<007oo00004Woo0P004Woo16Li2goo10004Goo16Li1Goo00<03`0000000P006Goo
00<03gooOol04Goo16Li1Woo00<03gooOol00Woo100047oo16Li00=oo`0?Ool00goo10005Goo00<0
3gooOol02Woo0P004Woo0005Ool4000BOol00`00Oomoo`0AOol3IcT<Ool4000AOol4IcT5Ool00`0?
00000002000IOol00`0?Oomoo`0AOol3IcT7Ool00`0?Oomoo`02Ool4000@Ool4IcT00goo00moo`03
Ool4000EOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool001]oo`03001oogoo015oo`=W>@]o
o`@001=oo`=W>@Eoo`0300moo`0000<001Qoo`0300moogoo015oo`=W>@Moo`0400moogooOol4000B
Ool3IcT00goo00moo`04Ool4000DOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool20008Ool000Ioo`<0
00=oo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol0000BOol4IcT;Ool4000COol4IcT4
Ool00`0?Ool00003000HOol00`0?Oomoo`0@Ool4IcT7Ool0100?Oomoogoo10004Woo16Li00<03goo
Ool00goo100057oo00<03gooOol02goo00<007ooOol01Goo00<007ooOol027oo0006Ool00`00Oomo
o`02Ool00`00Ool00007Ool30003Ool2000A00l4IcT;00l3000D00l4IcT700l3000[00l4IcT;00l3
000C00l4IcT700l3000P00l30007Ool30008Ool000Ioo`03001oogoo009oo`03001oo`0000Moo`03
001oo`0000=oo`03001oogoo011oo`=W>@]oo`@001Eoo`=W>@Aoo`0300moogoo00@001Moo`0300mo
ogoo011oo`=W>@Qoo`0300moogoo00@001Aoo`=W>@0300moogoo00Aoo`@001=oo`0300moogoo00]o
o`03001oogoo00Aoo`D000Moo`001Goo10000Woo00<007oo000027oo0P000goo00<007ooOol047oo
0fLi2goo10005Goo16Li0goo00<03gooOol010005goo00<03gooOol047oo0fLi27oo00<03gooOol0
100057oo16Li1Woo10004goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0006Ool0
0`00Oomoo`03Ool00`00Oomoo`08Ool01@00Oomoogoo00004Goo16Li2goo0`005Woo16Li0goo00@0
3gooOomoo`<001Moo`0300moogoo00moo`AW>@Qoo`0300moogoo00<001Eoo`AW>@Moo`<001=oo`03
00moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001Woo0`004Woo00<007ooOol03goo16Li
2Woo10005goo0fLi0goo00@03gooOomoo`@001Ioo`0300moogoo00moo`AW>@Qoo`0300moo`0000<0
01Ioo`=W>@Moo`@0019oo`0300moogoo00]oo`03001oogoo00Eoo`8000Uoo`001Woo00<007oo0000
4Woo0P0047oo0fLi2goo10005goo0fLi0goo00@03gooOomoo`@001Ioo`0300moogoo00moo`=W>@Uo
o`0300moo`0000<001Ioo`=W>@Moo`@0019oo`0300moogoo00Yoo`80019oo`001Woo00<007oo0000
4Woo00<007ooOol03goo0fLi2Woo100000<03gooOol05Goo16Li0Woo00<03gooOol00Woo10005Goo
00<03gooOol03goo0fLi2Goo00<03`0000000P005goo16Li1goo10004Goo00<03gooOol02goo00<0
07ooOol01Woo0P0027oo0005Ool200000goo001oo`0AOol00`00Oomoo`0?Ool3IcT:Ool400000`0?
Oomoo`0EOol4IcT2Ool00`0?Oomoo`02Ool4000EOol00`0?Oomoo`0>Ool4IcT9Ool00`0?00000002
000GOol4IcT7Ool4000AOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo000KOol0
0`00Oomoo`0>Ool4IcT:Ool300000goo00moo`0GOol3IcT2Ool00`0?Oomoo`03Ool3000EOol00`0?
Oomoo`0>Ool4IcT9Ool0100?000000006Goo0fLi27oo0`004Goo00<03gooOol02goo00<007ooOol0
1Goo00@007ooOol000Moo`001Goo00D007oo001oo`00015oo`03001oogoo00ioo`AW>@Uoo`@00003
Ool03goo01Moo`AW>@03Ool03goo00Aoo`@001Aoo`0300moogoo00ioo`=W>@Yoo`@001Uoo`AW>@Mo
o`@0011oo`0300moogoo00]oo`03001oogoo00Ioo`<000Moo`001Goo00D007oo001oo`00015oo`80
00moo`=W>@Yoo`@00003Ool03goo01Moo`AW>@03Ool03goo00Aoo`@001Aoo`0300moogoo00ioo`=W
>@Yoo`@001Uoo`AW>@Moo`@0011oo`0300moogoo00Yoo`80019oo`001Goo00D007oo001oo`00015o
o`03001oogoo00ioo`=W>@Uoo`@0009oo`0300moogoo01Moo`=W>@03Ool03goo00Eoo`@001=oo`03
00moogoo00eoo`AW>@Uoo`@001]oo`=W>@Qoo`@000moo`0300moogoo00]oo`03001oogoo00Eoo`<0
00Qoo`001Goo1@004Goo00<007ooOol03Woo0fLi2Goo10000Woo00<03gooOol05goo16Li00<03goo
Ool017oo10004goo00<03gooOol03Goo16Li2Goo10006goo16Li1goo10003goo00<03gooOol02goo
00<007ooOol01Goo0`0027oo000KOol00`00Oomoo`0=Ool4IcT9Ool30003Ool00`0?Oomoo`0GOol4
IcT00`0?Oomoo`05Ool3000COol00`0?Oomoo`0=Ool3IcT:Ool3000LOol4IcT8Ool3000?Ool00`0?
Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`06Ool001]oo`8000ioo`AW>@Qoo`@000=oo`0300mo
ogoo01Qoo`=W>@0300moogoo00Eoo`@0019oo`0300moogoo00eoo`=W>@Uoo`@001aoo`0400mW>FLi
IcT8Ool4000>Ool00`0?Oomoo`0:Ool20007Ool30008Ool001]oo`03001oogoo00eoo`=W>@Uoo`@0
00=oo`0300moogoo01Qoo`=W>@0300moogoo00Eoo`@0019oo`0300moogoo00aoo`AW>@Uoo`@001ao
o`0400mW>FLiIcT8Ool4000>Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00eo
o`=W>@Uoo`<000Aoo`0300moogoo01Qoo`AW>@Qoo`<0019oo`0300moogoo00aoo`AW>@Uoo`<001eo
o`0300mW>FLi009W>@Qoo`<000ioo`0300moogoo00]oo`03001oogoo00Eoo`@000Moo`0027oo00<0
07ooOol047oo00<007ooOol037oo16Li27oo100017oo00<03gooOol067oo16Li27oo10004Goo00<0
3gooOol037oo0fLi2Goo10007Goo00<03fLiIcT00VLi27oo10003Goo00<03gooOol02goo00<007oo
Ool01Woo00<007ooOol01goo0007Ool00`00Oomoo`0AOol00`00Oomoo`0<Ool4IcT8Ool40004Ool0
0`0?Oomoo`0IOol3IcT8Ool4000AOol00`0?Oomoo`0<Ool3IcT9Ool4000MOol00`0?OomW>@02IcT8
Ool4000=Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000Moo`03001oogoo015o
o`8000eoo`=W>@Qoo`@000Eoo`0300moogoo01Uoo`AW>@Qoo`@0011oo`0300moogoo00aoo`=W>@Qo
o`@0000300moogoo01]oo`0300moofLi00=W>@Qoo`@000aoo`0300moogoo00Yoo`8000Qoo`03001o
ogoo00Moo`001goo00<007ooOol04Goo00<007ooOol037oo0fLi27oo10001Goo00<03gooOol06Goo
16Li27oo100047oo00<03gooOol02goo16Li27oo100000<03gooOol06goo00<03gooIcT00fLi27oo
100037oo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0007Ool00`00Oomoo`0AOol0
0`00Oomoo`0<Ool3IcT8Ool30006Ool00`0?Oomoo`0JOol3IcT9Ool3000@Ool00`0?Oomoo`0;Ool4
IcT8Ool300000goo00moo`0LOol00`0?Oomoo`03IcT9Ool3000<Ool00`0?Oomoo`0;Ool00`00Oomo
o`05Ool20009Ool000Qoo`03001oogoo011oo`03001oogoo00]oo`AW>@Moo`@000Ioo`0300moogoo
01Yoo`=W>@Uoo`@000moo`0300moogoo00]oo`=W>@Qoo`@00003Ool03goo01aoo`0300moogoo00=W
>@Uoo`@000]oo`0300moogoo00]oo`03001oogoo011oo`001Woo10000Woo00<007ooOol00Woo00<0
07ooOol00Woo0P000goo00<007ooOol02goo16Li1goo10001Woo00<03gooOol06Woo16Li27oo1000
3goo00<03gooOol02goo0fLi27oo100000=oo`0?Ool077oo00<03gooOol016Li27oo10002goo00<0
3gooOol02goo00<007ooOol047oo0007Ool01`00Oomoogoo001oo`0000Moo`03001oo`0000=oo`80
00`03`=W>@L03`@002@03`AW>@T03`<001`03`AW>@L03`@002<03`AW>@T03`@001H03`<000Uoo`03
001oogoo00Ioo`001goo00L007ooOomoo`00Ool00007Ool30003Ool00`00Oomoo`0;Ool3IcT7Ool4
0007Ool00`0?Oomoo`0KOol3IcT9Ool4000>Ool00`0?Oomoo`0:Ool4IcT7Ool40002Ool00`0?Oomo
o`0KOol0100?Oomoogoo0fLi2Goo10002Woo00<03gooOol02goo00<007ooOol01Woo00<007ooOol0
1goo0007Ool01`00Oomoogoo001oo`0000Moo`03001oogoo00=oo`03001oogoo00]oo`=W>@Moo`<0
00Qoo`0300moogoo01]oo`AW>@Qoo`@000ioo`0300moogoo00Yoo`=W>@Qoo`<000=oo`0300moogoo
01]oo`0400moogooOol4IcT9Ool3000:Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07
Ool000Moo`03001oogoo009oo`03001oogoo00Moo`8000=oo`03001oogoo00Yoo`AW>@Ioo`@000Qo
o`0300moogoo01]oo`AW>@Uoo`<000ioo`0300moogoo00Yoo`=W>@Moo`@000=oo`0300moogoo01]o
o`0400moogooOol4IcT9Ool40009Ool00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool0
00Eoo`D0015oo`8000]oo`AW>@Ioo`@000Qoo`0300moogoo01]oo`0400mW>FLiIcT9Ool4000=Ool0
0`0?Oomoo`09Ool4IcT7Ool40003Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool3IcT9Ool40009Ool0
0`0?Oomoo`0:Ool20008Ool00`00Oomoo`07Ool000Moo`03001oogoo015oo`03001oogoo00Yoo`=W
>@Ioo`@000Uoo`0300moogoo01]oo`0300mW>FLi009W>@Qoo`@000eoo`0300moogoo00Uoo`AW>@Io
o`@000Aoo`0300moogoo01]oo`0300moogoo009oo`AW>@Uoo`@000Qoo`0300moogoo00]oo`03001o
ogoo00Moo`03001oogoo00Ioo`001goo00<007ooOol04Goo00<007ooOol02Woo0fLi1Woo10002Goo
00<03gooOol06goo00<03fLiIcT00VLi2Goo0`003Goo00<03gooOol02Goo0fLi1goo100017oo00<0
3gooOol06goo00<03gooOol00Woo16Li2Goo100027oo00<03gooOol02goo00<007ooOol01Woo0`00
1goo0006Ool4000AOol00`00Oomoo`0:Ool3IcT6Ool3000:Ool00`0?Oomoo`0KOol00`0?OomW>@02
IcT9Ool4000<Ool00`0?Oomoo`09Ool3IcT7Ool30005Ool00`0?Oomoo`0KOol00`0?Oomoo`03Ool3
IcT:Ool30008Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo0009Ool00`00Oomo
o`0?Ool00`00Oomoo`09Ool4IcT5Ool4000:Ool00`0?Oomoo`0KOol00`0?OomW>@03IcT8Ool4000<
Ool00`0?Oomoo`08Ool4IcT6Ool40005Ool00`0?Oomoo`0KOol00`0?Oomoo`03Ool4IcT9Ool40007
Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo0007Ool3000AOol2000:Ool4IcT5
Ool4000:Ool00`0?Oomoo`0KOol00`0?OomW>@03IcT9Ool3000<Ool00`0?Oomoo`08Ool4IcT6Ool4
0005Ool00`0?Oomoo`0KOol00`0?Oomoo`03Ool4IcT9Ool40007Ool00`0?Oomoo`0:Ool20008Ool3
0007Ool000Ioo`04001oogoo000AOol00`00Oomoo`09Ool3IcT5Ool4000;Ool00`0?Oomoo`0KOol0
0`0?Oomoo`03IcT9Ool4000;Ool00`0?Oomoo`08Ool3IcT6Ool40006Ool00`0?Oomoo`0KOol00`0?
Oomoo`04Ool3IcT:Ool40006Ool00`0?Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`05Ool000Io
o`04001oogoo000AOol00`00Oomoo`09Ool3IcT5Ool4000;Ool00`0?Oomoo`0KOol00`0?Oomoo`04
IcT8Ool4000;Ool00`0?Oomoo`08Ool3IcT6Ool40006Ool00`0?Oomoo`0KOol00`0?Oomoo`04Ool4
IcT9Ool40006Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool40007Ool000Moo`<0015oo`03001oogoo
00Qoo`AW>@Eoo`<000aoo`0300moogoo01]oo`0300moogoo00AW>@Uoo`<000]oo`0300moogoo00Mo
o`AW>@Ioo`<000Moo`0300moogoo01]oo`0300moogoo00Aoo`AW>@Yoo`<000Ioo`0300moogoo00]o
o`03001oogoo00Eoo`<000Qoo`001Woo00<007oo00004Woo00<007ooOol027oo16Li17oo100037oo
00<03gooOol06goo00@03gooOomoo`=W>@Uoo`@000Yoo`0300moogoo00Moo`AW>@Eoo`@000Moo`03
00moogoo01]oo`0300moogoo00Eoo`=W>@Yoo`@000Eoo`0300moogoo00]oo`03001oogoo00Moo`03
001oogoo00Ioo`001Woo00<007oo00004Woo0P002Goo0fLi1Goo100037oo00<03gooOol06goo00@0
3gooOomoo`AW>@Qoo`@000Yoo`0300moogoo00Moo`=W>@Ioo`@000Moo`0300moogoo01]oo`0300mo
ogoo00Eoo`AW>@Uoo`@000Eoo`0300moogoo00Yoo`8000Moo`<000Qoo`001Woo00<007oo00004Woo
00<007ooOol01goo16Li17oo10003Goo00<03gooOol06goo00@03gooOomoo`AW>@Uoo`@000Uoo`03
00moogoo00Ioo`AW>@Eoo`@000Qoo`0300moogoo01]oo`0300moogoo00Eoo`AW>@Yoo`@000Aoo`03
00moogoo00]oo`03001oogoo011oo`001Woo0`004Woo00<007ooOol01goo16Li17oo10003Goo00<0
3gooOol06goo00<03gooOol00Woo0fLi2Goo10002Goo00<03gooOol01Woo16Li1Goo100027oo00<0
3gooOol06goo00<03gooOol01Woo0fLi2Woo100017oo00<03gooOol02goo00<007ooOol017oo1000
27oo0006Ool00`00Oomoo`0BOol00`00Oomoo`07Ool3IcT4Ool4000>Ool00`0?Oomoo`0KOol00`0?
Oomoo`02Ool4IcT9Ool40008Ool00`0?Oomoo`06Ool3IcT5Ool40009Ool00`0?Oomoo`0KOol00`0?
Oomoo`06Ool4IcT:Ool40003Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`08Ool000Eo
o`@0019oo`8000Moo`AW>@Aoo`@000ioo`0300moogoo01]oo`0300moogoo009oo`AW>@Uoo`@000Qo
o`0300moogoo00Ioo`=W>@Eoo`@000Uoo`0300moogoo01]oo`0300moogoo00Ioo`AW>@Yoo`@000=o
o`0300moogoo00Yoo`8000Moo`03001oogoo00Qoo`001Woo00<007ooOol04Woo00<007ooOol01Woo
16Li17oo0`003goo00<03gooOol06goo00<03gooOol00goo0fLi2Woo0`0027oo00<03gooOol01Goo
16Li1Goo0`002Woo00<03gooOol06goo00<03gooOol01goo0fLi2goo0`000goo00<03gooOol02goo
00<007ooOol017oo100027oo0006Ool00`00Oomoo`0BOol00`00Oomoo`06Ool3IcT4Ool4000?Ool0
0`0?Oomoo`0KOol00`0?Oomoo`03Ool4IcT9Ool40007Ool00`0?Oomoo`05Ool4IcT4Ool4000:Ool0
0`0?Oomoo`0KOol00`0?Oomoo`07Ool4IcT:Ool40002Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
00Eoo`@0019oo`03001oogoo00Eoo`AW>@Aoo`@000moo`0300moogoo01]oo`0300moogoo00=oo`AW
>@Uoo`@000Moo`0300moogoo00Eoo`=W>@Eoo`@000Yoo`0300moogoo01]oo`0300moogoo00Moo`AW
>@Yoo`@0009oo`0300moogoo00]oo`03001oogoo00Eoo`04001oo`000007Ool000Ioo`8000Aoo`03
001oogoo009oo`04001oogooOol30003Ool00`00Oomoo`05Ool4IcT3Ool4000@Ool00`0?Oomoo`0K
Ool00`0?Oomoo`04Ool3IcT:Ool40006Ool00`0?Oomoo`04Ool4IcT4Ool4000;Ool00`0?Oomoo`0K
Ool00`0?Oomoo`08Ool3IcT;Ool400000goo00moo`0<Ool00`00Oomoo`05Ool40007Ool000Qoo`06
001oogoo001oo`001goo00<007oo00000goo0P001P0?0fLi100?1000=@0?16Li2@0?10003@0?16Li
100?1000=00?16Li2P0?10003@0?0`001goo0`0027oo0008Ool01P00Oomoo`00Ool000Qoo`03001o
ogoo009oo`03001oogoo00Aoo`AW>@=oo`@0015oo`0300moogoo01]oo`0300moogoo00Aoo`AW>@Yo
o`@000Eoo`0300moogoo00Aoo`=W>@Aoo`@000aoo`0300moogoo01]oo`0300moogoo00Qoo`AW>@]o
o`@0000300moogoo00]oo`03001oogoo00Eoo`@000Moo`0027oo00H007ooOol007oo0007Ool00`00
Ool00003Ool00`00Oomoo`04Ool4IcT3Ool4000AOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool4IcT9
Ool50004Ool00`0?Oomoo`03Ool4IcT3Ool5000<Ool00`0?Oomoo`0KOol00`0?Oomoo`09Ool4IcT:
Ool5000=Ool00`00Oomoo`05Ool00`00Ool00008Ool000Qoo`05001oogooOol00008Ool30003Ool0
0`00Oomoo`04Ool3IcT3Ool4000BOol00`0?Oomoo`0KOol00`0?Oomoo`05Ool4IcT:Ool40004Ool0
0`0?Oomoo`03Ool4IcT3Ool4000=Ool00`0?Oomoo`0KOol00`0?Oomoo`09Ool4IcT;Ool4000=Ool0
0`00Oomoo`04Ool200000goo001oo`07Ool000Moo`03001oogoo015oo`03001oogoo00=oo`AW>@=o
o`@0019oo`0300moogoo01]oo`0300moogoo00Ioo`=W>@]oo`@000=oo`0300moogoo00=oo`=W>@=o
o`@000ioo`0300moogoo01]oo`0300moogoo00Yoo`=W>@aoo`@000aoo`03001oogoo00Moo`03001o
ogoo00Ioo`006goo0P0017oo16Li0Woo10004goo00<03gooOol06goo00<03gooOol01Woo16Li2Woo
1@000Woo00<03gooOol00Woo16Li0Woo1@003Woo00<03gooOol06goo00<03gooOol02Woo16Li2goo
1@002Woo0P002Goo00<007ooOol01Woo000KOol00`00Oomoo`03Ool3IcT3Ool4000COol00`0?Oomo
o`0KOol00`0?Oomoo`06Ool4IcT;Ool40002Ool00`0?Oomoo`02Ool4IcT2Ool4000?Ool00`0?Oomo
o`0KOol00`0?Oomoo`0:Ool4IcT<Ool4000;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool001]oo`03
001oogoo009oo`AW>@9oo`@001Aoo`0300moogoo01]oo`0300moogoo00Moo`AW>@]oo`@00003Ool0
3goo00=oo`=W>@9oo`@0011oo`0300moogoo01]oo`0300moogoo00]oo`AW>@aoo`@000Yoo`03001o
ogoo011oo`006goo00<007ooOol00Woo16Li1P0057oo00<03gooOol06goo00<03gooOol01goo16Li
2goo1P000goo16Li1P0047oo00<03gooOol06goo00<03gooOol02goo16Li37oo1@002Goo00<007oo
Ool047oo000KOol20003Ool3IcT6000EOol00`0?Oomoo`0KOol00`0?Oomoo`08Ool4IcT;Ool60002
Ool3IcT6000AOol00`0?Oomoo`0KOol00`0?Oomoo`0<Ool3IcT<Ool00`0?000000040006Ool2000B
Ool001]oo`04001oogooOol2IcT7000FOol00`0?Oomoo`0KOol00`0?Oomoo`08Ool4IcT<Ool70000
0fLi00000005000BOol00`0?Oomoo`0KOol00`0?Oomoo`0<Ool4IcT;Ool00`0?Ool000060005Ool0
0`00Oomoo`0@Ool001]oo`04001oogooOol7000HOol00`0?Oomoo`0KOol00`0?Oomoo`09Ool3IcT>
Ool;000DOol00`0?Oomoo`0KOol00`0?Oomoo`0<Ool4IcT;Ool00`0?Oomoo`080003Ool00`00Oomo
o`0@Ool001]oo`04001oogooOol6000IOol00`0?Oomoo`0KOol00`0?Oomoo`09Ool4IcT>Ool9000E
Ool00`0?Oomoo`0KOol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`02Ool60003Ool00`00Oomoo`0@
Ool001]oo`04001oogooOol4000KOol00`0?Oomoo`0KOol00`0?Oomoo`09Ool4IcT>Ool00`0?Ool0
0005000FOol00`0?Oomoo`0KOol00`0?Oomoo`0=Ool4IcT:Ool00`0?Oomoo`03Ool50003Ool00`00
Oomoo`0@Ool001]oo`80025oo`0300moogoo01]oo`0300moogoo00Yoo`AW>@eoo`0300moofLi00=W
>AQoo`0300moogoo01]oo`0300moogoo00ioo`AW>@Uoo`0300moogoo00Aoo`AW>@9oo`80019oo`00
6goo00<007ooOol087oo00<03gooOol06goo00<03gooOol02Woo16Li3Goo00<03fLiIcT00VLi6Goo
00<03gooOol06goo00<03gooOol03Woo16Li2Goo00<03gooOol00goo16Li17oo00<007ooOol047oo
000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool4IcT<Ool00`0?IcUW>@02IcTI
Ool00`0?Oomoo`0KOol00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`03Ool4IcT4Ool00`00Oomoo`0@
Ool001]oo`03001oogoo021oo`0300moogoo01]oo`0300moogoo00]oo`AW>@aoo`AW>AYoo`0300mo
ogoo01]oo`0300moogoo00moo`EW>@Moo`0300moogoo009oo`AW>@Eoo`03001oogoo011oo`006goo
00<007ooOol087oo00<03gooOol06goo00<03gooOol037oo16Li2Woo1FLi6Woo00<03gooOol06goo
00<03gooOol047oo1FLi1Woo00@03gooOomoo`EW>@Eoo`03001oogoo011oo`006goo0P008Goo00<0
3gooOol06goo00<03gooOol037oo1FLi27oo1FLi6goo00<03gooOol06goo00<03gooOol04Goo1FLi
1Goo00<03gooOol01FLi1Goo0P004Woo000KOol00`00Oomoo`0POol00`0?Oomoo`0KOol00`0?Oomo
o`0=Ool5IcT6Ool5IcTLOol00`0?Oomoo`0KOol00`0?Oomoo`0BOol5IcT4Ool00`0?OomW>@04IcT7
Ool00`00Oomoo`0@Ool001]oo`03001oogoo021oo`0300moogoo01]oo`0300moogoo00ioo`EW>@Ao
o`EW>Aeoo`0300moogoo01]oo`0300moogoo01=oo`EW>@=oo`0300mW>FLi00=W>@Qoo`03001oogoo
011oo`005Goo0`000goo00<007ooOol087oo00<03gooOol06goo00<03gooOol03goo36Li00<03goo
Ool06goo00<03gooOol06goo00<03gooOol057oo36Li2Goo00<007ooOol047oo000FOol00`00Oomo
o`02Ool2000QOol00`0?Oomoo`0KOol00`0?Oomoo`0@Ool:IcT00goo00moo`0LOol00`0?Oomoo`0K
Ool00`0?Oomoo`0EOol:IcT8Ool3000BOol001Ioo`03001oogoo009oo`03001oogoo021oo`0300mo
ogoo01]oo`0300moogoo015oo`QW>@9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Io
o`QW>@]oo`03001oogoo011oo`005Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol06goo
00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo
00<007ooOol02goo00<007ooOol047oo000EOol20004Ooo8000BOol00?Eoo`00\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.06703, -0.248813, 0.033216, 
  0.0085536}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me! (p0A=1.0, p0B=0.9)", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The quantum probability is not always the larger one as the \
interference effect may be destructive.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["ComparisonPlot[1,0.9];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0146472 0.588672 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01465 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13238 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25012 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36785 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .48558 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13238 m
1 .13238 L
s
P
p
0 0 .5 r
.001 w
0 .25012 m
1 .25012 L
s
P
p
0 0 .5 r
.001 w
0 .36785 m
1 .36785 L
s
P
p
0 0 .5 r
.001 w
0 .48558 m
1 .48558 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01465 m
.00625 .01465 L
s
P
[(0)] -0.0125 .01465 1 0 0 Minner Mrotshowa
p
.002 w
0 .13238 m
.00625 .13238 L
s
P
[(0.2)] -0.0125 .13238 1 0 0 Minner Mrotshowa
p
.002 w
0 .25012 m
.00625 .25012 L
s
P
[(0.4)] -0.0125 .25012 1 0 0 Minner Mrotshowa
p
.002 w
0 .36785 m
.00625 .36785 L
s
P
[(0.6)] -0.0125 .36785 1 0 0 Minner Mrotshowa
p
.002 w
0 .48558 m
.00625 .48558 L
s
P
[(0.8)] -0.0125 .48558 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03819 m
.00375 .03819 L
s
P
p
.001 w
0 .06174 m
.00375 .06174 L
s
P
p
.001 w
0 .08529 m
.00375 .08529 L
s
P
p
.001 w
0 .10883 m
.00375 .10883 L
s
P
p
.001 w
0 .15593 m
.00375 .15593 L
s
P
p
.001 w
0 .17948 m
.00375 .17948 L
s
P
p
.001 w
0 .20302 m
.00375 .20302 L
s
P
p
.001 w
0 .22657 m
.00375 .22657 L
s
P
p
.001 w
0 .27366 m
.00375 .27366 L
s
P
p
.001 w
0 .29721 m
.00375 .29721 L
s
P
p
.001 w
0 .32076 m
.00375 .32076 L
s
P
p
.001 w
0 .3443 m
.00375 .3443 L
s
P
p
.001 w
0 .3914 m
.00375 .3914 L
s
P
p
.001 w
0 .41494 m
.00375 .41494 L
s
P
p
.001 w
0 .43849 m
.00375 .43849 L
s
P
p
.001 w
0 .46204 m
.00375 .46204 L
s
P
p
.001 w
0 .50913 m
.00375 .50913 L
s
P
p
.001 w
0 .53268 m
.00375 .53268 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \\(light\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01465 m
1 .01465 L
s
P
p
.002 w
.99375 .13238 m
1 .13238 L
s
P
p
.002 w
.99375 .25012 m
1 .25012 L
s
P
p
.002 w
.99375 .36785 m
1 .36785 L
s
P
p
.002 w
.99375 .48558 m
1 .48558 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03819 m
1 .03819 L
s
P
p
.001 w
.99625 .06174 m
1 .06174 L
s
P
p
.001 w
.99625 .08529 m
1 .08529 L
s
P
p
.001 w
.99625 .10883 m
1 .10883 L
s
P
p
.001 w
.99625 .15593 m
1 .15593 L
s
P
p
.001 w
.99625 .17948 m
1 .17948 L
s
P
p
.001 w
.99625 .20302 m
1 .20302 L
s
P
p
.001 w
.99625 .22657 m
1 .22657 L
s
P
p
.001 w
.99625 .27366 m
1 .27366 L
s
P
p
.001 w
.99625 .29721 m
1 .29721 L
s
P
p
.001 w
.99625 .32076 m
1 .32076 L
s
P
p
.001 w
.99625 .3443 m
1 .3443 L
s
P
p
.001 w
.99625 .3914 m
1 .3914 L
s
P
p
.001 w
.99625 .41494 m
1 .41494 L
s
P
p
.001 w
.99625 .43849 m
1 .43849 L
s
P
p
.001 w
.99625 .46204 m
1 .46204 L
s
P
p
.001 w
.99625 .50913 m
1 .50913 L
s
P
p
.001 w
.99625 .53268 m
1 .53268 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \\(dark\\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .60332 m
.02505 .60331 L
.02629 .6033 L
.02753 .60328 L
.02877 .60325 L
.03001 .60321 L
.03125 .60316 L
.03373 .60303 L
.03621 .60285 L
.03869 .60262 L
.04117 .60234 L
.04365 .60199 L
.04861 .60107 L
.05357 .5998 L
.05853 .59809 L
.06349 .59582 L
.06845 .59283 L
.07341 .58892 L
.07837 .58381 L
.08333 .57713 L
.08829 .56835 L
.09325 .55676 L
.09821 .54138 L
.10317 .52083 L
.10813 .49326 L
.1131 .45623 L
.11806 .40686 L
.12302 .3425 L
.13294 .17272 L
.13542 .12826 L
.1379 .08767 L
.14038 .05396 L
.14162 .04053 L
.14286 .02975 L
.1441 .02181 L
.14534 .01679 L
.14658 .01472 L
.14782 .01551 L
.14906 .01901 L
.1503 .02501 L
.15278 .04344 L
.15526 .0684 L
.15774 .09752 L
.1627 .16034 L
.17262 .27387 L
.18254 .35586 L
.1875 .38653 L
.19246 .41189 L
.20238 .45068 L
.2123 .47838 L
Mistroke
.22222 .49883 L
.23214 .51442 L
.24206 .52662 L
.25198 .53642 L
.2619 .54445 L
.28175 .55686 L
.30159 .56607 L
.32143 .57325 L
.34127 .57908 L
.38095 .58821 L
.42063 .59524 L
.44048 .59816 L
.46032 .60064 L
.47024 .60168 L
.48016 .60251 L
.48512 .60284 L
.4876 .60298 L
.49008 .60309 L
.49256 .60319 L
.4938 .60323 L
.49504 .60326 L
.49628 .60329 L
.49752 .6033 L
.49876 .60332 L
.5 .60332 L
.50124 .60331 L
.50248 .6033 L
.50372 .60328 L
.50496 .60325 L
.5062 .60321 L
.50744 .60316 L
.50992 .60303 L
.5124 .60285 L
.51488 .60262 L
.51736 .60234 L
.51984 .60199 L
.5248 .60107 L
.52976 .5998 L
.53472 .59809 L
.53968 .59582 L
.54464 .59283 L
.5496 .58892 L
.55456 .58381 L
.55952 .57713 L
.56448 .56835 L
.56944 .55676 L
.5744 .54138 L
.57937 .52083 L
.58433 .49326 L
.58929 .45623 L
Mistroke
.59425 .40686 L
.59921 .3425 L
.60913 .17272 L
.61409 .08767 L
.61657 .05396 L
.61781 .04053 L
.61905 .02975 L
.62029 .02181 L
.62153 .01679 L
.62277 .01472 L
.62401 .01551 L
.62525 .01901 L
.62649 .02501 L
.62773 .03325 L
.62897 .04344 L
.63889 .16034 L
.64881 .27387 L
.65377 .3187 L
.65873 .35586 L
.66369 .38653 L
.66865 .41189 L
.67857 .45068 L
.68849 .47838 L
.69841 .49883 L
.70833 .51442 L
.71825 .52662 L
.72817 .53642 L
.7381 .54445 L
.75794 .55686 L
.77778 .56607 L
.79762 .57325 L
.81746 .57908 L
.85714 .58821 L
.89683 .59524 L
.91667 .59816 L
.93651 .60064 L
.94643 .60168 L
.95139 .60212 L
.95635 .60251 L
.96131 .60284 L
.96379 .60298 L
.96627 .60309 L
.96875 .60319 L
.96999 .60323 L
.97123 .60326 L
.97247 .60329 L
.97371 .6033 L
.97495 .60332 L
.97619 .60332 L
Mfstroke
P
P
p
p
.02 w
.02381 .60332 m
.02505 .60331 L
.02629 .6033 L
.02753 .60328 L
.02877 .60326 L
.03001 .60322 L
.03125 .60318 L
.03373 .60307 L
.03621 .60293 L
.03869 .60275 L
.04365 .60232 L
.05357 .60108 L
.06349 .59938 L
.08333 .5947 L
.10317 .5886 L
.14286 .57389 L
.18254 .55917 L
.20238 .55307 L
.2123 .55053 L
.22222 .5484 L
.23214 .54669 L
.2371 .54601 L
.24206 .54545 L
.24702 .54502 L
.2495 .54484 L
.25198 .5447 L
.25446 .54459 L
.2557 .54455 L
.25694 .54451 L
.25818 .54449 L
.25942 .54447 L
.26066 .54446 L
.2619 .54445 L
.26314 .54446 L
.26438 .54447 L
.26562 .54449 L
.26687 .54451 L
.26935 .54459 L
.27183 .5447 L
.27431 .54484 L
.27679 .54502 L
.28175 .54545 L
.29167 .54669 L
.30159 .5484 L
.32143 .55307 L
.34127 .55917 L
.38095 .57389 L
.42063 .5886 L
.44048 .5947 L
.4504 .59724 L
Mistroke
.46032 .59938 L
.47024 .60108 L
.48016 .60232 L
.48512 .60275 L
.4876 .60293 L
.49008 .60307 L
.49256 .60318 L
.4938 .60322 L
.49504 .60326 L
.49628 .60328 L
.49752 .6033 L
.49876 .60331 L
.5 .60332 L
.50124 .60331 L
.50248 .6033 L
.50372 .60328 L
.50496 .60326 L
.5062 .60322 L
.50744 .60318 L
.50992 .60307 L
.5124 .60293 L
.51488 .60275 L
.51984 .60232 L
.52976 .60108 L
.53968 .59938 L
.55952 .5947 L
.57937 .5886 L
.61905 .57389 L
.65873 .55917 L
.67857 .55307 L
.68849 .55053 L
.69841 .5484 L
.70833 .54669 L
.71329 .54601 L
.71825 .54545 L
.72321 .54502 L
.72569 .54484 L
.72817 .5447 L
.73065 .54459 L
.73189 .54455 L
.73313 .54451 L
.73437 .54449 L
.73562 .54447 L
.73686 .54446 L
.7381 .54445 L
.73934 .54446 L
.74058 .54447 L
.74182 .54449 L
.74306 .54451 L
.74554 .54459 L
Mistroke
.74802 .5447 L
.7505 .54484 L
.75298 .54502 L
.75794 .54545 L
.76786 .54669 L
.77778 .5484 L
.79762 .55307 L
.81746 .55917 L
.85714 .57389 L
.89683 .5886 L
.91667 .5947 L
.93651 .59938 L
.94643 .60108 L
.95139 .60176 L
.95635 .60232 L
.96131 .60275 L
.96379 .60293 L
.96627 .60307 L
.96875 .60318 L
.96999 .60322 L
.97123 .60326 L
.97247 .60328 L
.97371 .6033 L
.97495 .60331 L
.97619 .60332 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{245, 151},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e0000Ua000`40O003h00OmGoo003eOol007Mo
o`<007]oo`00N7oo00<007ooOol0NWoo001hOol30002Ool01000Ool007oo1@00Kgoo001hOol02000
Oomoo`00Ool007oo0003Ool00`00Oomoo`1_Ool007Qoo`08001oogoo001oo`00Ool000=oo`03001o
ogoo06moo`00Mgoo10000Woo0`000Woo0P00LGoo001mOol00`00Oomoo`1eOol007aoo`8000Eoo`03
001oogoo06moo`00mGoo003eOol00?Eoo`00mGoo003eOol00?Eoo`00mGoo003eOol001moo`03001o
ogoo01Yoo`<001]oo`<001aoo`<001eoo`03001oogoo01Uoo`<001aoo`8001moo`007Woo00<007oo
000077oo00<007ooOol06goo00<007ooOol07Goo00<007ooOol06Goo0`007Goo00<007ooOol06Goo
00<007oo00007goo000NOol00`00Ool0000LOol00`00Oomoo`0LOol00`00Oomoo`0KOol00`00Oomo
o`0JOol00`00Ool0000KOol3000KOol3000OOol001ioo`03001oo`0001aoo`03001oogoo01aoo`03
001oogoo01aoo`03001oogoo01Yoo`8001]oo`03001oogoo01]oo`03001oogoo01moo`007goo00<0
07ooOol06Woo0P0077oo0`0077oo0`007Goo00<007ooOol06Goo0`0077oo0P007goo003eOol00?Eo
o`00mGoo003eOol001]oolP0019oo`006goo00<007ooOol00Woo00<007ooOol06goo00<007ooOol0
6goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol0
2goo00<007ooOol047oo000FOol00`00Oomoo`02Ool00`00Oomoo`0IOol4IcT3Ool00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0HOol4IcTMOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00
Oomoo`0@Ool001Eoo`03001oo`0000=oo`8001Yoo`AW>@=oo`0300moogoo01]oo`0300moogoo01]o
o`0300moogoo01Qoo`AW>Aeoo`0300moogoo01]oo`0300moogoo00Uoo`<0019oo`005Goo00<007oo
00000goo00<007ooOol06Goo16Li0goo00<03gooOol06goo00<03gooOol06goo00<03gooOol067oo
16Li7Goo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000EOol00`00Ool00003Ool0
0`00Oomoo`0HOol5IcT3Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0HOol5IcTLOol0
0`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001Ioo`03001oogoo009oo`03001oogoo
01Qoo`EW>@=oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Qoo`EW>Aaoo`0300moogoo
01]oo`0300moogoo00]oo`03001oogoo011oo`006goo0P006Goo1FLi0goo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol067oo1FLi77oo00<03gooOol06goo00<03gooOol02Woo0P004Woo000K
Ool00`00Oomoo`0HOol5IcT3Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0HOol5IcTL
Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo01Qoo`EW>@=o
o`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Moo`IW>Aaoo`0300moogoo01]oo`0300mo
ogoo00]oo`03001oogoo011oo`006goo00<007ooOol067oo1VLi0Woo00<03gooOol06goo00<03goo
Ool06goo00<03gooOol05goo1VLi77oo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo
000KOol00`00Oomoo`0HOol6IcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0GOol6
IcTLOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`8001Uoo`IW>@9oo`03
00moogoo01]oo`0300moogoo01]oo`0300moogoo01Moo`IW>Aaoo`0300moogoo01]oo`0300moogoo
00Yoo`80019oo`006goo00<007ooOol05goo1fLi0Woo00<03gooOol06goo00<03gooOol06goo00<0
3gooOol05goo1VLi77oo00<03gooOol06goo00<03gooOol02goo00<007ooOol047oo000KOol00`00
Oomoo`0GOol7IcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0GOol7IcTKOol00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo01Moo`=W>@04OomW>FLi
IcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0GOol7IcTKOol00`0?Oomoo`0KOol0
0`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo01Moo`=W>@04OomW>FLiIcT2Ool00`0?
Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0GOol3IcT017ooIcUW>FLi6goo00<03gooOol06goo
00<03gooOol02goo00<007ooOol047oo000KOol2000HOol3IcT017ooIcUW>FLi0Woo00<03gooOol0
6goo00<03gooOol06goo00<03gooOol05goo0fLi00AoofLiIcUW>A]oo`0300moogoo01]oo`0300mo
ogoo00Yoo`80019oo`006goo00<007ooOol05goo0fLi00AoofLiIcUW>@9oo`0300moogoo01]oo`03
00moogoo01]oo`0300moogoo01Moo`=W>@04OomW>FLiIcTKOol00`0?Oomoo`0KOol00`0?Oomoo`0;
Ool00`00Oomoo`0@Ool001]oo`03001oogoo01Moo`=W>@04OomW>FLiIcT2Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?Oomoo`0GOol3IcT017ooIcUW>FLi6goo00<03gooOol06goo00<03gooOol0
2goo00<007ooOol047oo000KOol00`00Oomoo`0GOol3IcT017ooIcUW>FLi0Woo00<03gooOol06goo
00<03gooOol06goo00<03gooOol05goo0fLi00AoofLiIcUW>A]oo`0300moogoo01]oo`0300moogoo
00]oo`03001oogoo011oo`006goo0P0067oo0fLi00AoofLiIcUW>@9oo`0300moogoo01]oo`0300mo
ogoo01]oo`0300moogoo01Moo`=W>@04OomW>FLiIcTKOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool2
000BOol001]oo`03001oogoo01Moo`=W>@04OomW>FLiIcT2Ool00`0?Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0GOol3IcT017ooIcUW>FLi6goo00<03gooOol06goo00<03gooOol02goo00<007oo
Ool017oo0`002Goo000KOol00`00Oomoo`0GOol3IcT017ooIcUW>FLi0Woo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol05goo0fLi00AoofLiIcUW>A]oo`0300moogoo01]oo`0300moogoo00]o
o`03001oogoo00Eoo`03001oogoo00Qoo`001Goo0`004goo00<007ooOol05goo0fLi00AoofLiIcUW
>@9oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Moo`=W>@04OomW>FLiIcTKOol00`0?
Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Ioo`03001oogoo00=oo`03001o
ogoo009oo`04001oogooOol30003Ool00`00Oomoo`0GOol3IcT00gooIcUW>@02IcT00goo00moo`0L
Ool00`0?Oomoo`0KOol00`0?Oomoo`0FOol4IcT017ooIcUW>FLi6goo00<03gooOol06goo00<03goo
Ool02goo00<007ooOol01Goo00<007oo000027oo0006Ool30002Ool00`00Ool00008Ool00`00Oomo
o`02Ool2000H00l3IcT00`0?IcUW>@02IcUF00l4IcT00`0?IcUW>@02IcU400l30006Ool40008Ool0
00Ioo`03001oo`0000<00003Ool007oo00Qoo`05001oogooOol0000IOol3IcT2Ool3IcT00goo00mo
o`0LOol00`0?Oomoo`0KOol00`0?Oomoo`0FOol3IcT2Ool4IcTJOol00`0?Oomoo`0KOol00`0?Oomo
o`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo0005Ool5000017oo001oo`002Goo00D007ooOomo
o`0001Uoo`=W>@9oo`=W>@03Ool03goo01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`04
00mW>FLiIcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`001goo
0007Ool30002Ool00`00Oomoo`06Ool30003Ool00`00Oomoo`0FOol4IcT2Ool3IcT00goo00moo`0L
Ool00`0?Oomoo`0KOol00`0?Oomoo`0FOol3IcT2Ool0100?IcUW>FLi6Woo00<03gooOol06goo00<0
3gooOol02goo00<007ooOol01Woo0`001goo0006Ool01000Oomoo`004Goo00<007ooOol05Woo16Li
0Woo0fLi00=oo`0?Ool077oo00<03gooOol06goo00<03gooOol05Woo0fLi0Woo00@03fLiIcUW>AYo
o`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`001Woo00@007ooOol0015oo`8001Mo
o`=W>@=oo`=W>@03Ool03goo01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0400mW>FLi
IcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool20007Ool40007Ool000Moo`<0015oo`03001oogoo
01Ioo`=W>@=oo`=W>@03Ool03goo01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0400mW
>FLiIcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`07Ool001]o
o`03001oogoo01Ioo`=W>@=oo`=W>@03Ool03goo01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W
>@9oo`0400mW>FLiIcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`07Ool000Ioo`<0019oo`03001oogoo01Ioo`=W>@=oo`=W>@03Ool03goo01aoo`0300moogoo01]o
o`0300moogoo01Ioo`=W>@9oo`0400mW>FLiIcTJOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00
Oomoo`06Ool00`00Oomoo`07Ool000Ioo`03001oo`00019oo`8001Moo`=W>@=oo`=W>@03Ool03goo
01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0400mW>FLiIcTJOol00`0?Oomoo`0KOol0
0`0?Oomoo`0:Ool20008Ool00`00Oomoo`07Ool000Ioo`03001oo`00019oo`03001oogoo01Ioo`=W
>@=oo`=W>@03Ool03goo01aoo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0400mW>FLiIcTJ
Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Eoo`800003Ool007oo
015oo`03001oogoo01Ioo`=W>@=oo`AW>@0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Io
o`=W>@9oo`0300mW>FLi009W>AUoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`<0
00Qoo`001Woo0`004Woo00<007ooOol05Woo0fLi0goo16Li00<03gooOol06goo00<03gooOol06goo
00<03gooOol05Woo0fLi0Woo00<03fLiIcT00VLi6Goo00<03gooOol06goo00<03gooOol02goo00<0
07ooOol01goo00<007ooOol01Woo0006Ool3000BOol00`00Oomoo`0FOol3IcT4Ool3IcT00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0FOol3IcT2Ool00`0?OomW>@02IcTIOol00`0?Oomoo`0K
Ool00`0?Oomoo`0;Ool00`00Oomoo`05Ool30008Ool000Qoo`03001oogoo011oo`8001Moo`=W>@Ao
o`=W>@0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Ioo`=W>@9oo`0300moofLi009W>AUo
o`0300moogoo01]oo`0300moogoo00Yoo`80019oo`001Woo0`004Woo00<007ooOol05Woo0fLi17oo
0fLi00<03gooOol06goo00<03gooOol06goo00<03gooOol05Woo0fLi0Woo00<03gooIcT00VLi6Goo
00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo0`0027oo000KOol00`00Oomoo`0EOol4
IcT4Ool3IcT00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0EOol4IcT2Ool00`0?OomW>@02
IcTIOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06Ool20008Ool000Ioo`03001oo`00
019oo`03001oogoo01Eoo`AW>@Aoo`=W>@0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Eo
o`AW>@9oo`0300moofLi009W>AUoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`03
001oogoo00Qoo`001Woo00<007oo00004Woo00<007ooOol05Goo0fLi1Goo0fLi00<03gooOol06goo
00<03gooOol06goo00<03gooOol05Goo0fLi0goo00<03gooIcT00VLi6Goo00<03gooOol06goo00<0
3gooOol02goo00<007ooOol01Goo0`0027oo0006Ool00`00Ool0000BOol2000FOol3IcT5Ool3IcT0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0EOol3IcT3Ool00`0?OomW>@02IcTIOol00`0?
Oomoo`0KOol00`0?Oomoo`0:Ool2000BOol000Eoo`@0019oo`03001oogoo01Eoo`=W>@Eoo`=W>@03
00moogoo01]oo`0300moogoo01]oo`0300moogoo01Eoo`=W>@=oo`0300moofLi009W>AUoo`0300mo
ogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`<000Qoo`006goo00<007ooOol05Goo0fLi1Goo
0fLi00<03gooOol06goo00<03gooOol06goo00<03gooOol05Goo0fLi0goo00<03gooIcT00VLi6Goo
00<03gooOol06goo00<03gooOol02goo00<007ooOol01Woo0P0027oo0006Ool30003Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool01@00Oomoogoo00005goo0fLi1Goo16Li7Goo00<03gooOol06goo00<0
3gooOol05Goo0fLi0goo00<03gooIcT00fLi67oo00<03gooOol06goo00<03gooOol02goo00<007oo
Ool01Goo00<007ooOol027oo0006Ool00`00Oomoo`02Ool00`00Ool00007Ool30003Ool2000F00l3
IcT500l4IcUC00l3IcT500l4IcU200l30007Ool30008Ool000Ioo`03001oogoo009oo`03001oo`00
00Moo`03001oo`0000=oo`03001oogoo01Eoo`=W>@Ioo`=W>Aeoo`0300moogoo01]oo`0300moogoo
01Eoo`=W>@=oo`0300moogoo00=W>AQoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Ao
o`D000Moo`001Goo10000Woo00<007oo000027oo0P000goo00<007ooOol05Goo0fLi1Woo0fLi7Goo
00<03gooOol06goo00<03gooOol05Goo0fLi0goo00<03gooOol00fLi67oo00<03gooOol06goo00<0
3gooOol02goo00<007ooOol01Woo00<007ooOol01goo0006Ool00`00Oomoo`03Ool00`00Oomoo`08
Ool01@00Oomoogoo00005goo0fLi1Woo0fLi7Goo00<03gooOol06goo00<03gooOol05Goo0fLi0goo
00<03gooOol00fLi67oo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol0
1goo0006Ool3000BOol00`00Oomoo`0EOol3IcT6Ool3IcTMOol00`0?Oomoo`0KOol00`0?Oomoo`0E
Ool3IcT3Ool00`0?Oomoo`03IcTHOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool2
0009Ool000Ioo`03001oo`00019oo`8001Ioo`=W>@Ioo`=W>Aeoo`0300moogoo01]oo`0300moogoo
01Eoo`=W>@=oo`0300moogoo00=W>AQoo`0300moogoo01]oo`0300moogoo00Yoo`80019oo`001Woo
00<007oo00004Woo00<007ooOol05Goo0fLi1Woo0fLi7Goo00<03gooOol06goo00<03gooOol05Goo
0fLi0goo00<03gooOol00fLi67oo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Woo0P00
27oo0005Ool200000goo001oo`0AOol00`00Oomoo`0EOol3IcT6Ool3IcTMOol00`0?Oomoo`0KOol0
0`0?Oomoo`0EOol3IcT3Ool00`0?Oomoo`03IcTHOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00
Oomoo`05Ool01000Oomoo`001goo000KOol00`00Oomoo`0EOol3IcT6Ool3IcTMOol00`0?Oomoo`0K
Ool00`0?Oomoo`0EOol3IcT3Ool00`0?Oomoo`03IcTHOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool0
0`00Oomoo`05Ool01000Oomoo`001goo0005Ool01@00Ool007oo00004Goo00<007ooOol05Goo0fLi
1Woo16Li77oo00<03gooOol06goo00<03gooOol05Goo0fLi0goo00<03gooOol016Li5goo00<03goo
Ool06goo00<03gooOol02goo00<007ooOol01Woo0`001goo0005Ool01@00Ool007oo00004Goo0P00
5Goo16Li1Woo16Li77oo00<03gooOol06goo00<03gooOol057oo16Li0goo00<03gooOol016Li5goo
00<03gooOol06goo00<03gooOol02Woo0P004Woo0005Ool01@00Ool007oo00004Goo00<007ooOol0
57oo16Li1goo0fLi77oo00<03gooOol06goo00<03gooOol057oo16Li0goo00@03gooOomoo`=W>AMo
o`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`<000Qoo`001Goo1@004Goo00<007oo
Ool057oo0fLi27oo0fLi77oo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`=W
>AMoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Eoo`<000Qoo`006goo00<007ooOol0
57oo0fLi27oo0fLi77oo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`=W>AMo
o`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Moo`03001oogoo00Ioo`006goo0P005Goo
0fLi27oo0fLi77oo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`=W>AMoo`03
00moogoo01]oo`0300moogoo00Yoo`8000Moo`<000Qoo`006goo00<007ooOol057oo0fLi27oo0fLi
77oo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`=W>AMoo`0300moogoo01]o
o`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol057oo0fLi27oo0fLi77oo00<03goo
Ool06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`=W>AMoo`0300moogoo01]oo`0300moogoo
00]oo`03001oogoo00Eoo`@000Moo`0027oo00<007ooOol047oo00<007ooOol057oo0fLi27oo16Li
6goo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`AW>AIoo`0300moogoo01]o
o`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001goo00<007ooOol04Goo00<007oo
Ool057oo0fLi27oo16Li6goo00<03gooOol06goo00<03gooOol057oo0fLi17oo00@03gooOomoo`AW
>AIoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001goo00<0
07ooOol04Goo0P005Goo0fLi2Goo0fLi6goo00<03gooOol06goo00<03gooOol057oo0fLi17oo00<0
3gooOol00Woo0fLi5Woo00<03gooOol06goo00<03gooOol02Woo0P0027oo00<007ooOol01goo0007
Ool00`00Oomoo`0AOol00`00Oomoo`0DOol3IcT9Ool3IcTKOol00`0?Oomoo`0KOol00`0?Oomoo`0D
Ool3IcT4Ool00`0?Oomoo`02Ool3IcTFOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`06
Ool00`00Oomoo`07Ool000Moo`03001oogoo015oo`03001oogoo01Aoo`=W>@Uoo`=W>A]oo`0300mo
ogoo01]oo`0300moogoo01Aoo`=W>@Aoo`0300moogoo009oo`=W>AIoo`0300moogoo01]oo`0300mo
ogoo00]oo`03001oogoo00Eoo`8000Uoo`0027oo00<007ooOol047oo00<007ooOol057oo0fLi2Goo
0fLi6goo00<03gooOol06goo00<03gooOol057oo0fLi17oo00<03gooOol00Woo0fLi5Woo00<03goo
Ool06goo00<03gooOol02goo00<007ooOol047oo0006Ool40002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool20003Ool00`00Oomoo`0DOol3IcT9Ool3IcTKOol00`0?Oomoo`0KOol00`0?Oomoo`0DOol3
IcT4Ool00`0?Oomoo`02Ool3IcTFOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool0
00Moo`07001oogooOol007oo00001goo00<007oo00000goo0P005@0?0fLi2@0?16LiC`0?0fLi2@0?
16Li?`0?0`002Goo00<007ooOol01Woo0007Ool01`00Oomoogoo001oo`0000Moo`<000=oo`03001o
ogoo01=oo`AW>@Uoo`AW>AYoo`0300moogoo01]oo`0300moogoo01=oo`AW>@Aoo`0300moogoo009o
o`AW>AEoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Ioo`03001oogoo00Moo`001goo
00L007ooOomoo`00Ool00007Ool00`00Oomoo`03Ool00`00Oomoo`0COol4IcT9Ool0100?IcUW>FLi
6Woo00<03gooOol06goo00<03gooOol04goo16Li17oo00<03gooOol00goo0fLi5Goo00<03gooOol0
6goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo0007Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool20003Ool00`00Oomoo`0COol3IcT:Ool0100?IcUW>FLi6Woo00<03gooOol06goo00<0
3gooOol04goo0fLi1Goo00<03gooOol00goo0fLi5Goo00<03gooOol06goo00<03gooOol02goo00<0
07ooOol01Woo00<007ooOol01goo0005Ool5000AOol2000DOol3IcT:Ool0100?IcUW>FLi6Woo00<0
3gooOol06goo00<03gooOol04goo0fLi1Goo00<03gooOol00goo0fLi5Goo00<03gooOol06goo00<0
3gooOol02Woo0P0027oo00<007ooOol01goo0007Ool00`00Oomoo`0AOol00`00Oomoo`0COol3IcT:
Ool00`0?IcUW>@02IcTIOol00`0?Oomoo`0KOol00`0?Oomoo`0COol3IcT5Ool00`0?Oomoo`03Ool4
IcTDOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`06Ool000Moo`03
001oogoo015oo`03001oogoo01=oo`=W>@Yoo`0300mW>FLi009W>AUoo`0300moogoo01]oo`0300mo
ogoo01=oo`=W>@Eoo`0300moogoo00=oo`AW>AAoo`0300moogoo01]oo`0300moogoo00]oo`03001o
ogoo00Ioo`<000Moo`001Woo10004Goo00<007ooOol04goo0fLi2Woo00<03gooIcT00VLi6Goo00<0
3gooOol06goo00<03gooOol04goo0fLi1Goo00<03gooOol017oo0fLi57oo00<03gooOol06goo00<0
3gooOol02goo00<007ooOol01Goo00@007ooOol000Moo`002Goo00<007ooOol03goo00<007ooOol0
4goo0fLi2Woo00<03gooIcT00VLi6Goo00<03gooOol06goo00<03gooOol04goo0fLi1Goo00<03goo
Ool017oo0fLi57oo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo00@007ooOol000Mo
o`001goo0`004Goo0P0057oo0fLi2Woo00<03gooIcT00VLi6Goo00<03gooOol06goo00<03gooOol0
4goo0fLi1Goo00<03gooOol017oo0fLi57oo00<03gooOol06goo00<03gooOol02Woo0P0027oo0`00
1goo0006Ool01000Oomoo`004Goo00<007ooOol04goo0fLi2Woo00<03gooIcT00fLi67oo00<03goo
Ool06goo00<03gooOol04goo0fLi1Goo00<03gooOol017oo16Li4goo00<03gooOol06goo00<03goo
Ool02goo00<007ooOol027oo00<007ooOol01Goo0006Ool01000Oomoo`004Goo00<007ooOol04goo
0fLi2Woo00<03gooIcT00fLi67oo00<03gooOol06goo00<03gooOol04goo0fLi1Goo00<03gooOol0
17oo16Li4goo00<03gooOol06goo00<03gooOol02goo00<007ooOol01Goo10001goo0007Ool3000A
Ool00`00Oomoo`0BOol4IcT:Ool00`0?Oomoo`03IcTHOol00`0?Oomoo`0KOol00`0?Oomoo`0BOol4
IcT5Ool00`0?Oomoo`05Ool3IcTCOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool3
0008Ool000Ioo`03001oo`00019oo`03001oogoo019oo`AW>@Yoo`0300moogoo00=W>AQoo`0300mo
ogoo01]oo`0300moogoo019oo`AW>@Eoo`0300moogoo00Eoo`=W>A=oo`0300moogoo01]oo`0300mo
ogoo00]oo`03001oogoo00Moo`03001oogoo00Ioo`001Woo00<007oo00004Woo0P004goo0fLi2goo
00<03gooOol016Li5goo00<03gooOol06goo00<03gooOol04Woo0fLi1Woo00<03gooOol01Goo16Li
4Woo00<03gooOol06goo00<03gooOol02Woo0P001goo0`0027oo0006Ool00`00Ool0000BOol00`00
Oomoo`0BOol3IcT;Ool00`0?Oomoo`04IcTGOol00`0?Oomoo`0KOol00`0?Oomoo`0BOol3IcT6Ool0
0`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool000Ioo`<0
019oo`03001oogoo019oo`=W>@]oo`0400moogooOol3IcTGOol00`0?Oomoo`0KOol00`0?Oomoo`0B
Ool3IcT6Ool00`0?Oomoo`06Ool3IcTBOol00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`04
Ool40008Ool000Ioo`03001oogoo019oo`03001oogoo019oo`=W>@]oo`0400moogooOol4IcTFOol0
0`0?Oomoo`0KOol00`0?Oomoo`0BOol3IcT6Ool00`0?Oomoo`06Ool4IcTAOol00`0?Oomoo`0KOol0
0`0?Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`08Ool000Eoo`@0019oo`8001=oo`=W>@]oo`04
00moogooOol4IcTFOol00`0?Oomoo`0KOol00`0?Oomoo`0BOol3IcT6Ool00`0?Oomoo`06Ool4IcTA
Ool00`0?Oomoo`0KOol00`0?Oomoo`0:Ool20007Ool00`00Oomoo`08Ool000Ioo`03001oogoo019o
o`03001oogoo019oo`=W>@]oo`0300moogoo009oo`=W>AIoo`0300moogoo01]oo`0300moogoo019o
o`=W>@Ioo`0300moogoo00Moo`=W>A5oo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo00Ao
o`@000Qoo`001Woo00<007ooOol04Woo00<007ooOol04Woo0fLi2goo00<03gooOol00Woo16Li5Goo
00<03gooOol06goo00<03gooOol04Woo0fLi1Woo00<03gooOol01goo16Li47oo00<03gooOol06goo
00<03gooOol02goo00<007ooOol047oo0005Ool4000BOol00`00Oomoo`0AOol4IcT;Ool00`0?Oomo
o`02Ool4IcTEOol00`0?Oomoo`0KOol00`0?Oomoo`0AOol4IcT6Ool00`0?Oomoo`07Ool4IcT@Ool0
0`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`05Ool01000Ool000001goo0006Ool20004Ool0
0`00Oomoo`02Ool01000Oomoogoo0`000goo00<007ooOol04Goo16Li2goo00<03gooOol00goo0fLi
5Goo00<03gooOol06goo00<03gooOol04Goo16Li1Woo00<03gooOol027oo0fLi47oo00<03gooOol0
6goo00<03gooOol02goo00<007ooOol01Goo10001goo0008Ool01P00Oomoo`00Ool000Moo`03001o
o`0000=oo`8001803`=W>A803`AW>DH03`=W>A803`AW>CT03`<000Moo`<000Qoo`0027oo00H007oo
Ool007oo0008Ool00`00Oomoo`02Ool00`00Oomoo`0AOol3IcT<Ool00`0?Oomoo`03Ool4IcTDOol0
0`0?Oomoo`0KOol00`0?Oomoo`0AOol3IcT7Ool00`0?Oomoo`08Ool4IcT?Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0;Ool00`00Oomoo`05Ool40007Ool000Qoo`06001oogoo001oo`001goo00<007oo0000
0goo00<007ooOol04Goo0fLi37oo00<03gooOol017oo16Li4goo00<03gooOol06goo00<03gooOol0
4Goo0fLi1goo00<03gooOol02Goo16Li3Woo00<03gooOol06goo00<03gooOol02goo00<007ooOol0
1Goo00<007oo000027oo0008Ool01@00Oomoogoo000027oo0`000goo00<007ooOol04Goo0fLi37oo
00<03gooOol017oo16Li4goo00<03gooOol06goo00<03gooOol04Goo0fLi1goo00<03gooOol02Goo
16Li3Woo00<03gooOol06goo00<03gooOol02goo00<007ooOol017oo0P0000=oo`00Ool01goo0007
Ool00`00Oomoo`0AOol00`00Oomoo`0@Ool4IcT<Ool00`0?Oomoo`05Ool4IcTBOol00`0?Oomoo`0K
Ool00`0?Oomoo`0@Ool4IcT7Ool00`0?Oomoo`0:Ool4IcT=Ool00`0?Oomoo`0KOol00`0?Oomoo`0;
Ool00`00Oomoo`07Ool00`00Oomoo`06Ool001]oo`80015oo`AW>@aoo`0300moogoo00Eoo`EW>A5o
o`0300moogoo01]oo`0300moogoo011oo`AW>@Moo`0300moogoo00Yoo`EW>@aoo`0300moogoo01]o
o`0300moogoo00Yoo`8000Uoo`03001oogoo00Ioo`006goo00<007ooOol047oo0fLi3Goo00<03goo
Ool01Woo1FLi47oo00<03gooOol06goo00<03gooOol047oo0fLi27oo00<03gooOol02goo1FLi2goo
00<03gooOol06goo00<03gooOol02goo00<007ooOol01Woo00<007ooOol01goo000KOol00`00Oomo
o`0@Ool3IcT=Ool00`0?Oomoo`07Ool5IcT?Ool00`0?Oomoo`0KOol00`0?Oomoo`0@Ool3IcT8Ool0
0`0?Oomoo`0<Ool5IcT:Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03
001oogoo011oo`=W>@eoo`0300moogoo00Qoo`EW>@ioo`0300moogoo01]oo`0300moogoo011oo`=W
>@Qoo`0300moogoo00eoo`EW>@Uoo`0300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`00
6goo0P0047oo16Li3Goo00<03gooOol02Goo1FLi3Goo00<03gooOol06goo00<03gooOol03goo16Li
27oo00<03gooOol03Woo1FLi27oo00<03gooOol06goo00<03gooOol02Woo0P004Woo000KOol00`00
Oomoo`0?Ool4IcT=Ool00`0?Oomoo`0:Ool5IcT<Ool00`0?Oomoo`0KOol00`0?Oomoo`0?Ool4IcT8
Ool00`0?Oomoo`0?Ool4IcT8Ool00`0?Oomoo`0KOol00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]o
o`03001oogoo00moo`=W>@ioo`0300moogoo00Iooa4000Aoo`0300moogoo01]oo`0300moogoo00mo
o`=W>@Uoo`0300moogoo00]ooa00000300moogoo01]oo`0300moogoo00]oo`03001oogoo011oo`00
6goo00<007ooOol03Woo16Li3Woo00<03gooOol00Woo600000=oo`0?Ool077oo00<03gooOol03Woo
16Li2Goo00<03gooOol01goo5`006goo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomo
o`0>Ool4IcT>Ool00`0?Ool0000N000KOol00`0?Oomoo`0>Ool4IcT9Ool00`0?Oomoo`04OolN000G
Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`8000moo`=W>@ioo``000Moo`IW>@`001Qoo`03
00moogoo00ioo`=W>@Yoo`0400moogooOol<0006Ool6IcT<000DOol00`0?Oomoo`0:Ool2000BOol0
01]oo`03001oogoo00eoo`AW>@]oo`/000eoo`MW>@`001Eoo`0300moogoo00eoo`AW>@Yoo`0300l0
000000T000aoo`MW>@`0015oo`0300moogoo00]oo`03001oogoo011oo`006goo00<007ooOol03Goo
16Li27oo2`004Woo26Li00<03`0000002@004Woo00<03gooOol03Goo16Li27oo2`004Goo26Li00=o
o`0000002@003Woo00<03gooOol02goo00<007ooOol047oo000KOol00`00Oomoo`0<Ool4IcT7Ool:
000GOol9IcT00goo00000008000@Ool00`0?Oomoo`0<Ool4IcT7Ool:000FOol9IcT00goo00000008
000<Ool00`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00aoo`AW>@Aoo`X0009oo`03
00moogoo01Moo`]W>@X000eoo`0300moogoo00aoo`AW>@Aoo`X001]oo`]W>@X000Uoo`0300moogoo
00]oo`03001oogoo011oo`006goo0P0037oo16Li0Woo2P001Goo00<03gooOol06Goo36Li2@002goo
00<03gooOol02goo16Li0Woo2P0000<03gooOol06goo00<03gooIcT02fLi2P001Woo00<03gooOol0
2Woo0P004Woo000KOol00`00Oomoo`09Ool5IcT;0007Ool00`0?Oomoo`0KOol00`0?IcUW>@09IcT:
0008Ool00`0?Oomoo`09Ool5IcT;0002Ool00`0?Oomoo`0KOol00`0?Oomoo`02Ool;IcT;0003Ool0
0`0?Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00Qoo`=W>@/000Yoo`0300moogoo01]o
o`0300moogoo00Aoo`QW>@`000=oo`0300moogoo00Moo`=W>@`000Eoo`0300moogoo01]oo`0300mo
ogoo00Qoo`QW>@`000eoo`03001oogoo011oo`005Goo0`000goo00@007ooOomooa8000eoo`0300mo
ogoo01]oo`0300moogoo00Yoo`AW>B<000Qoo`0300moogoo01]oo`0300moogoo00ioo`EW>A<000=o
o`03001oogoo011oo`005Woo00<007ooOol00Woo0P000Woo3`0047oo00<03gooOol06goo00<03goo
Ool03Goo16Li7@002goo00<03gooOol06goo00<03gooOol04Woo16Li400000Aoo`000000019oo`00
5Woo00<007ooOol00Woo00@007ooOomoo``001=oo`0300moogoo01]oo`0300moogoo01Eoo`03IcT0
0000018000moo`0300moogoo01]oo`0300moogoo01Yoo``000=oo`03001oogoo011oo`005Woo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol06goo00<007ooOol06goo00<007ooOol06goo00<0
07ooOol06goo00<007ooOol06goo00<007ooOol06goo00<007ooOol02goo00<007ooOol047oo000E
Ool20004Ooo8000BOol00?Eoo`00\
\>"],
  ImageRangeCache->{{{0, 244}, {150, 0}} -> {-1.06696, -0.248671, 0.0332155, 
  0.00855258}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me! (p0A=1.0, p0B=0.9)", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["PhaseDiagram[1,0.9];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.97619 .97619 Mdot
.97618 .97618 Mdot
.97615 .97615 Mdot
.9761 .9761 Mdot
.97604 .97603 Mdot
.97595 .97593 Mdot
.97585 .9758 Mdot
.97572 .97565 Mdot
.97558 .97547 Mdot
.97542 .97526 Mdot
.97524 .97502 Mdot
.97504 .97474 Mdot
.97483 .97443 Mdot
.97459 .97407 Mdot
.97434 .97368 Mdot
.97406 .97324 Mdot
.97377 .97274 Mdot
.97346 .9722 Mdot
.97314 .97161 Mdot
.97279 .97095 Mdot
.97243 .97023 Mdot
.97205 .96944 Mdot
.97165 .96858 Mdot
.97124 .96764 Mdot
.97081 .96661 Mdot
.97036 .9655 Mdot
.9699 .96428 Mdot
.96941 .96296 Mdot
.96892 .96153 Mdot
.9684 .95997 Mdot
.96787 .95828 Mdot
.96733 .95644 Mdot
.96677 .95445 Mdot
.96619 .95229 Mdot
.9656 .94994 Mdot
.96499 .94739 Mdot
.96437 .94463 Mdot
.96374 .94163 Mdot
.96309 .93837 Mdot
.96242 .93483 Mdot
.96175 .93098 Mdot
.96106 .9268 Mdot
.96036 .92225 Mdot
.95964 .9173 Mdot
.95891 .91191 Mdot
.95817 .90604 Mdot
.95742 .89965 Mdot
.95666 .89267 Mdot
.95588 .88506 Mdot
.9551 .87675 Mdot
.9543 .86767 Mdot
.95349 .85774 Mdot
.95268 .84689 Mdot
.95185 .83502 Mdot
.95102 .82203 Mdot
.95017 .80781 Mdot
.94932 .79225 Mdot
.94846 .77521 Mdot
.94759 .75658 Mdot
.94671 .73621 Mdot
.94583 .71396 Mdot
.94494 .68969 Mdot
.94404 .66327 Mdot
.94313 .63459 Mdot
.94222 .60354 Mdot
.94131 .57007 Mdot
.94039 .53418 Mdot
.93946 .49593 Mdot
.93854 .45549 Mdot
.9376 .41312 Mdot
.93667 .36923 Mdot
.93573 .32439 Mdot
.93478 .27931 Mdot
.93384 .23488 Mdot
.93289 .19209 Mdot
.93194 .15205 Mdot
.93099 .11588 Mdot
.93004 .08463 Mdot
.92909 .05925 Mdot
.92813 .04044 Mdot
.92718 .02862 Mdot
.92623 .02391 Mdot
.92528 .02612 Mdot
.92433 .03478 Mdot
.92338 .0492 Mdot
.92244 .06855 Mdot
.92149 .09193 Mdot
.92055 .11844 Mdot
.91962 .14721 Mdot
.91868 .17747 Mdot
.91775 .20855 Mdot
.91683 .23988 Mdot
.91591 .27099 Mdot
.91499 .30155 Mdot
.91408 .33128 Mdot
.91318 .35998 Mdot
.91228 .38754 Mdot
.91139 .41387 Mdot
.9105 .43894 Mdot
.90962 .46273 Mdot
.90875 .48527 Mdot
.90789 .50657 Mdot
.90704 .5267 Mdot
.90619 .54568 Mdot
.90536 .56359 Mdot
.90453 .58047 Mdot
.90371 .59639 Mdot
.90291 .6114 Mdot
.90211 .62556 Mdot
.90132 .63892 Mdot
.90055 .65153 Mdot
.89978 .66345 Mdot
.89903 .6747 Mdot
.89829 .68535 Mdot
.89756 .69543 Mdot
.89684 .70498 Mdot
.89614 .71403 Mdot
.89545 .72261 Mdot
.89477 .73076 Mdot
.89411 .7385 Mdot
.89346 .74586 Mdot
.89282 .75287 Mdot
.8922 .75954 Mdot
.89159 .7659 Mdot
.891 .77197 Mdot
.89042 .77776 Mdot
.88986 .78329 Mdot
.88931 .78858 Mdot
.88878 .79365 Mdot
.88827 .79849 Mdot
.88777 .80313 Mdot
.88728 .80759 Mdot
.88682 .81186 Mdot
.88637 .81596 Mdot
.88594 .8199 Mdot
.88552 .82369 Mdot
.88512 .82733 Mdot
.88474 .83084 Mdot
.88438 .83422 Mdot
.88403 .83748 Mdot
.8837 .84062 Mdot
.88339 .84365 Mdot
.8831 .84658 Mdot
.88283 .8494 Mdot
.88257 .85214 Mdot
.88234 .85478 Mdot
.88212 .85733 Mdot
.88192 .85981 Mdot
.88174 .86221 Mdot
.88157 .86453 Mdot
.88143 .86678 Mdot
.8813 .86897 Mdot
.8812 .87109 Mdot
.88111 .87314 Mdot
.88104 .87514 Mdot
.88099 .87708 Mdot
.88096 .87897 Mdot
.88095 .88081 Mdot
.88096 .88259 Mdot
.88099 .88433 Mdot
.88103 .88603 Mdot
.8811 .88768 Mdot
.88118 .88928 Mdot
.88129 .89085 Mdot
.88141 .89238 Mdot
.88155 .89387 Mdot
.88171 .89532 Mdot
.88189 .89674 Mdot
.88208 .89813 Mdot
.8823 .89948 Mdot
.88253 .90081 Mdot
.88279 .9021 Mdot
.88306 .90337 Mdot
.88335 .90461 Mdot
.88365 .90582 Mdot
.88398 .907 Mdot
.88432 .90816 Mdot
.88468 .9093 Mdot
.88506 .91041 Mdot
.88546 .91151 Mdot
.88587 .91258 Mdot
.8863 .91362 Mdot
.88675 .91465 Mdot
.88721 .91566 Mdot
.88769 .91665 Mdot
.88819 .91762 Mdot
.8887 .91858 Mdot
.88923 .91952 Mdot
.88977 .92044 Mdot
.89033 .92134 Mdot
.89091 .92223 Mdot
.8915 .9231 Mdot
.8921 .92396 Mdot
.89272 .92481 Mdot
.89336 .92564 Mdot
.894 .92645 Mdot
.89467 .92726 Mdot
.89534 .92805 Mdot
.89603 .92883 Mdot
.89673 .9296 Mdot
.89745 .93035 Mdot
.89817 .9311 Mdot
.89891 .93183 Mdot
.89966 .93256 Mdot
.90043 .93327 Mdot
.9012 .93397 Mdot
.90198 .93467 Mdot
.90278 .93535 Mdot
.90358 .93602 Mdot
.9044 .93669 Mdot
.90523 .93735 Mdot
.90606 .93799 Mdot
.9069 .93863 Mdot
.90776 .93926 Mdot
.90862 .93989 Mdot
.90949 .9405 Mdot
.91036 .94111 Mdot
.91125 .94171 Mdot
.91214 .94231 Mdot
.91303 .94289 Mdot
.91394 .94347 Mdot
.91485 .94405 Mdot
.91576 .94461 Mdot
.91668 .94517 Mdot
.9176 .94573 Mdot
.91853 .94628 Mdot
.91947 .94682 Mdot
.9204 .94735 Mdot
.92134 .94788 Mdot
.92229 .94841 Mdot
.92323 .94893 Mdot
.92418 .94944 Mdot
.92513 .94995 Mdot
.92608 .95046 Mdot
.92703 .95096 Mdot
.92798 .95145 Mdot
.92893 .95194 Mdot
.92989 .95242 Mdot
.93084 .9529 Mdot
.93179 .95338 Mdot
.93274 .95385 Mdot
.93369 .95432 Mdot
.93463 .95478 Mdot
.93558 .95524 Mdot
.93652 .95569 Mdot
.93745 .95614 Mdot
.93839 .95659 Mdot
.93932 .95703 Mdot
.94024 .95747 Mdot
.94116 .9579 Mdot
.94208 .95833 Mdot
.94299 .95875 Mdot
.94389 .95918 Mdot
.94479 .9596 Mdot
.94569 .96001 Mdot
.94657 .96042 Mdot
.94745 .96083 Mdot
.94832 .96123 Mdot
.94918 .96163 Mdot
.95004 .96203 Mdot
.95088 .96242 Mdot
.95172 .96281 Mdot
.95255 .9632 Mdot
.95336 .96358 Mdot
.95417 .96396 Mdot
.95497 .96433 Mdot
.95576 .9647 Mdot
.95653 .96507 Mdot
.9573 .96544 Mdot
.95805 .9658 Mdot
.95879 .96615 Mdot
.95952 .96651 Mdot
.96024 .96686 Mdot
.96095 .9672 Mdot
.96164 .96754 Mdot
.96232 .96788 Mdot
.96298 .96821 Mdot
.96363 .96854 Mdot
.96427 .96887 Mdot
.96489 .96919 Mdot
.9655 .96951 Mdot
.9661 .96982 Mdot
.96668 .97013 Mdot
.96724 .97043 Mdot
.96779 .97073 Mdot
.96832 .97102 Mdot
.96884 .97131 Mdot
.96934 .97159 Mdot
.96982 .97187 Mdot
.97029 .97214 Mdot
.97074 .97241 Mdot
.97117 .97267 Mdot
.97159 .97292 Mdot
.97199 .97317 Mdot
.97237 .97341 Mdot
.97274 .97364 Mdot
.97308 .97387 Mdot
.97341 .97409 Mdot
.97373 .9743 Mdot
.97402 .9745 Mdot
.97429 .97469 Mdot
.97455 .97488 Mdot
.97479 .97505 Mdot
.97501 .97521 Mdot
.97521 .97537 Mdot
.97539 .97551 Mdot
.97556 .97564 Mdot
.9757 .97576 Mdot
.97583 .97587 Mdot
.97594 .97596 Mdot
.97603 .97604 Mdot
.9761 .9761 Mdot
.97615 .97615 Mdot
.97618 .97618 Mdot
.97619 .97619 Mdot
.97618 .97618 Mdot
.97616 .97616 Mdot
.97611 .97611 Mdot
.97605 .97604 Mdot
.97597 .97594 Mdot
.97587 .97583 Mdot
.97575 .97568 Mdot
.97561 .9755 Mdot
.97545 .9753 Mdot
.97527 .97506 Mdot
.97508 .97479 Mdot
.97486 .97448 Mdot
.97463 .97413 Mdot
.97438 .97374 Mdot
.97411 .97331 Mdot
.97382 .97283 Mdot
.97351 .97229 Mdot
.97319 .9717 Mdot
.97285 .97106 Mdot
.97249 .97035 Mdot
.97211 .96957 Mdot
.97172 .96872 Mdot
.97131 .96779 Mdot
.97088 .96678 Mdot
.97043 .96568 Mdot
.96997 .96448 Mdot
.96949 .96318 Mdot
.969 .96176 Mdot
.96849 .96023 Mdot
.96796 .95856 Mdot
.96742 .95674 Mdot
.96686 .95478 Mdot
.96628 .95264 Mdot
.96569 .95033 Mdot
.96509 .94781 Mdot
.96447 .94508 Mdot
.96384 .94212 Mdot
.96319 .9389 Mdot
.96253 .93541 Mdot
.96186 .93162 Mdot
.96117 .92749 Mdot
.96047 .923 Mdot
.95975 .91812 Mdot
.95903 .9128 Mdot
.95829 .90701 Mdot
.95754 .9007 Mdot
.95678 .89382 Mdot
.95601 .88632 Mdot
.95522 .87812 Mdot
.95443 .86917 Mdot
.95362 .85938 Mdot
.95281 .84869 Mdot
.95198 .83698 Mdot
.95115 .82418 Mdot
.95031 .81016 Mdot
.94945 .79482 Mdot
.94859 .77803 Mdot
.94773 .75966 Mdot
.94685 .73958 Mdot
.94597 .71763 Mdot
.94508 .6937 Mdot
.94418 .66763 Mdot
.94328 .63931 Mdot
.94237 .60864 Mdot
.94146 .57556 Mdot
.94054 .54006 Mdot
.93961 .50218 Mdot
.93868 .46207 Mdot
.93775 .41998 Mdot
.93681 .3763 Mdot
.93587 .33157 Mdot
.93493 .28647 Mdot
.93399 .24187 Mdot
.93304 .19875 Mdot
.93209 .1582 Mdot
.93114 .12133 Mdot
.93019 .08924 Mdot
.92924 .06287 Mdot
.92828 .04297 Mdot
.92733 .03003 Mdot
.92638 .02419 Mdot
.92543 .02532 Mdot
.92448 .03299 Mdot
.92353 .04655 Mdot
.92259 .06517 Mdot
.92164 .08797 Mdot
.9207 .11404 Mdot
.91976 .14251 Mdot
.91883 .17258 Mdot
.9179 .20357 Mdot
.91697 .23489 Mdot
.91605 .26607 Mdot
.91514 .29673 Mdot
.91423 .32661 Mdot
.91332 .35549 Mdot
.91242 .38323 Mdot
.91153 .40976 Mdot
.91064 .43503 Mdot
.90976 .45903 Mdot
.90889 .48176 Mdot
.90803 .50326 Mdot
.90717 .52357 Mdot
.90633 .54273 Mdot
.90549 .56081 Mdot
.90466 .57785 Mdot
.90384 .59392 Mdot
.90303 .60907 Mdot
.90224 .62336 Mdot
.90145 .63685 Mdot
.90067 .64957 Mdot
.8999 .66159 Mdot
.89915 .67295 Mdot
.89841 .6837 Mdot
.89768 .69386 Mdot
.89696 .70349 Mdot
.89625 .71262 Mdot
.89556 .72127 Mdot
.89488 .72949 Mdot
.89421 .73729 Mdot
.89356 .74472 Mdot
.89292 .75178 Mdot
.8923 .7585 Mdot
.89169 .76491 Mdot
.89109 .77102 Mdot
.89051 .77686 Mdot
.88995 .78243 Mdot
.8894 .78776 Mdot
.88887 .79285 Mdot
.88835 .79773 Mdot
.88785 .80241 Mdot
.88736 .80689 Mdot
.88689 .81119 Mdot
.88644 .81532 Mdot
.886 .81928 Mdot
.88559 .8231 Mdot
.88518 .82676 Mdot
.8848 .83029 Mdot
.88443 .83369 Mdot
.88409 .83697 Mdot
.88375 .84013 Mdot
.88344 .84317 Mdot
.88315 .84612 Mdot
.88287 .84896 Mdot
.88261 .85171 Mdot
.88237 .85436 Mdot
.88215 .85693 Mdot
.88195 .85942 Mdot
.88176 .86183 Mdot
.8816 .86416 Mdot
.88145 .86643 Mdot
.88132 .86862 Mdot
.88121 .87075 Mdot
.88112 .87282 Mdot
.88105 .87483 Mdot
.881 .87678 Mdot
.88097 .87867 Mdot
.88095 .88052 Mdot
.88096 .88231 Mdot
.88098 .88406 Mdot
.88102 .88576 Mdot
.88109 .88742 Mdot
.88117 .88903 Mdot
.88127 .8906 Mdot
.88139 .89214 Mdot
.88152 .89363 Mdot
.88168 .89509 Mdot
.88186 .89652 Mdot
.88205 .89791 Mdot
.88226 .89927 Mdot
.88249 .9006 Mdot
.88274 .9019 Mdot
.88301 .90317 Mdot
.8833 .90441 Mdot
.8836 .90563 Mdot
.88393 .90682 Mdot
.88427 .90798 Mdot
.88462 .90912 Mdot
.885 .91024 Mdot
.88539 .91133 Mdot
.8858 .91241 Mdot
.88623 .91346 Mdot
.88667 .91449 Mdot
.88713 .9155 Mdot
.88761 .9165 Mdot
.88811 .91747 Mdot
.88862 .91843 Mdot
.88914 .91937 Mdot
.88968 .92029 Mdot
.89024 .9212 Mdot
.89081 .92209 Mdot
.8914 .92296 Mdot
.892 .92383 Mdot
.89262 .92467 Mdot
.89325 .92551 Mdot
.8939 .92633 Mdot
.89456 .92713 Mdot
.89523 .92793 Mdot
.89592 .92871 Mdot
.89662 .92948 Mdot
.89733 .93023 Mdot
.89806 .93098 Mdot
.89879 .93172 Mdot
.89954 .93244 Mdot
.9003 .93316 Mdot
.90107 .93386 Mdot
.90186 .93456 Mdot
.90265 .93524 Mdot
.90346 .93592 Mdot
.90427 .93658 Mdot
.90509 .93724 Mdot
.90593 .93789 Mdot
.90677 .93853 Mdot
.90762 .93916 Mdot
.90848 .93979 Mdot
.90935 .94041 Mdot
.91022 .94102 Mdot
.9111 .94162 Mdot
.91199 .94221 Mdot
.91289 .9428 Mdot
.91379 .94338 Mdot
.9147 .94396 Mdot
.91561 .94452 Mdot
.91653 .94508 Mdot
.91746 .94564 Mdot
.91839 .94619 Mdot
.91932 .94673 Mdot
.92025 .94727 Mdot
.92119 .9478 Mdot
.92214 .94833 Mdot
.92308 .94885 Mdot
.92403 .94936 Mdot
.92498 .94987 Mdot
.92593 .95038 Mdot
.92688 .95088 Mdot
.92783 .95137 Mdot
.92878 .95186 Mdot
.92973 .95235 Mdot
.93069 .95283 Mdot
.93164 .9533 Mdot
.93259 .95378 Mdot
.93354 .95424 Mdot
.93448 .95471 Mdot
.93542 .95516 Mdot
.93637 .95562 Mdot
.9373 .95607 Mdot
.93824 .95652 Mdot
.93917 .95696 Mdot
.9401 .9574 Mdot
.94102 .95783 Mdot
.94193 .95826 Mdot
.94285 .95869 Mdot
.94375 .95911 Mdot
.94465 .95953 Mdot
.94554 .95994 Mdot
.94643 .96036 Mdot
.94731 .96076 Mdot
.94818 .96117 Mdot
.94904 .96157 Mdot
.9499 .96197 Mdot
.95075 .96236 Mdot
.95159 .96275 Mdot
.95242 .96314 Mdot
.95323 .96352 Mdot
.95404 .9639 Mdot
.95484 .96427 Mdot
.95563 .96465 Mdot
.95641 .96501 Mdot
.95718 .96538 Mdot
.95793 .96574 Mdot
.95868 .9661 Mdot
.95941 .96645 Mdot
.96013 .9668 Mdot
.96084 .96715 Mdot
.96153 .96749 Mdot
.96221 .96783 Mdot
.96288 .96816 Mdot
.96353 .96849 Mdot
.96417 .96882 Mdot
.9648 .96914 Mdot
.96541 .96946 Mdot
.966 .96977 Mdot
.96658 .97008 Mdot
.96715 .97038 Mdot
.9677 .97068 Mdot
.96824 .97097 Mdot
.96875 .97126 Mdot
.96926 .97155 Mdot
.96974 .97183 Mdot
.97021 .9721 Mdot
.97067 .97236 Mdot
.97111 .97263 Mdot
.97152 .97288 Mdot
.97193 .97313 Mdot
.97231 .97337 Mdot
.97268 .9736 Mdot
.97303 .97383 Mdot
.97336 .97405 Mdot
.97368 .97426 Mdot
.97397 .97447 Mdot
.97425 .97466 Mdot
.97451 .97485 Mdot
.97475 .97502 Mdot
.97498 .97519 Mdot
.97518 .97534 Mdot
.97537 .97549 Mdot
.97553 .97562 Mdot
.97568 .97574 Mdot
.97581 .97585 Mdot
.97592 .97595 Mdot
.97601 .97603 Mdot
.97609 .97609 Mdot
.97614 .97614 Mdot
.97617 .97617 Mdot
.97619 .97619 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{201, 201},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000390000bA000`40O003h00ObGoo0039Ool00<Uo
o`00bGoo001FOol30004Ool20002Ool70002Ool30002Ool300000goo000000030002Ool2000017oo
000000000Woo1000@goo001GOol00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol00`000goo
0P000goo0P000goo00D007ooOomoo`00009oo`@000=oo`03001oogoo04=oo`00Egoo0`000Woo00@0
07ooOol0009oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`03Ool01@00Oomoogoo0000
0Woo00@007ooOol000=oo`03001oogoo04=oo`00Egoo00<007oo00000goo0`000Woo00<007ooOol0
0`000Woo0`000Woo0`000Woo0P0017oo1P000goo00<007ooOol0@goo001FOol40008Ool00`00Oomo
o`0NOol00`00Oomoo`13Ool0065oo`80019oo`03001oogoo00Yoo`8004Eoo`00bGoo0039Ool00<Uo
o`00bGoo0039Ool00<Uoo`00bGoo0039Ool001]oo`03001oogoo01Uoo`03001oogoo009oo`04001o
ogooOol3000EOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0COol00`00Oomoo`02Ool0
0`00Oomoo`02Ool2000EOol00`00Oomoo`02Ool01000Oomoogoo0`006Goo0`001goo000JOol00`00
Ool0000IOol00`00Ool00008Ool00`00Oomoo`0COol00`00Ool00007Ool3000DOol00`00Ool00007
Ool00`00Ool0000DOol00`00Ool00007Ool00`00Ool0000JOol00`00Oomoo`06Ool001Yoo`03001o
o`0001Uoo`03001oo`0000Uoo`03001oogoo019oo`03001oo`0000Moo`03001oo`0001Aoo`03001o
o`0000Moo`<001Aoo`03001oo`0000Qoo`03001oogoo01Uoo`03001oogoo00Ioo`006Woo00<007oo
00006Goo00<007oo00002Goo00<007ooOol04Woo00<007oo000027oo0P0057oo00<007oo00001goo
00<007ooOol057oo00<007oo00001goo00<007oo00006Woo00<007ooOol01Woo000KOol00`00Oomo
o`0IOol00`00Oomoo`06Ool3000EOol00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`07Ool2
000EOol00`00Oomoo`06Ool3000IOol20008Ool00<Uoo`00bGoo0039Ool00<Uoo`005goo[`000goo
000GOol01@00Oomoogoo000087oo00<007ooOol07goo00<007ooOol07Woo00<007ooOol07Woo00<0
07ooOol07Woo00D007ooOomoo`0000=oo`005goo00<007ooOol0Zgoo00<007ooOol00Goo000BOol0
0`00Oomoo`02Ool00`00Oomoo`2[Ool00`00Oomoo`01Ool0015oo`03001oo`0000=oo`80009oo`80
09]oo`03001oogoo00Uoo`8000=oo`004Goo00<007oo00000goo00<007ooOol00goo00<007ooOol0
V7oo00<007ooOol02Woo00<007ooOol00Goo000AOol00`00Ool00003Ool00`00Oomoo`04Ool00`00
Oomoo`2GOol00`00Oomoo`0:Ool00`00Oomoo`01Ool0019oo`03001oogoo009oo`03001oogoo00Eo
o`03001oogoo09Ioo`03001oogoo00Yoo`03001oogoo005oo`005goo00<007ooOol0WGoo00<007oo
Ool02goo00<007ooOol00Goo000GOol00`00Oomoo`06Ool00`00Oomoo`2ROol00`00Oomoo`01Ool0
01Moo`8000Qoo`03001oogoo09Aoo`03001oogoo00Uoo`8000=oo`005goo00<007ooOol02Goo00<0
07ooOol0TGoo0P0037oo00<007ooOol00Goo000GOol00`00Oomoo`0:Ool00`00Oomoo`2@Ool00`00
Oomoo`0;Ool00`00Oomoo`01Ool001Moo`03001oogoo0:]oo`03001oogoo005oo`005goo00<007oo
Ool02goo00<007ooOol0WGoo00<007ooOol00Goo000GOol00`00Oomoo`0<Ool00`00Oomoo`2>Ool0
0`00Ool0000;Ool00`00Oomoo`01Ool001Moo`03001oogoo00ioo`03001oogoo08aoo`03001oogoo
00]oo`03001oogoo005oo`005goo0P0047oo00<007ooOol0V7oo0P000goo000GOol00`00Oomoo`2[
Ool00`00Oomoo`01Ool001Moo`03001oogoo011oo`03001oogoo09Qoo`03001oogoo005oo`005goo
00<007ooOol04Goo00<007ooOol0RGoo00<007oo00002goo00<007ooOol00Goo000GOol00`00Oomo
o`0COol00`00Oomoo`29Ool00`00Oomoo`09Ool00`00Oomoo`01Ool001Moo`03001oogoo01Aoo`03
001oogoo09Aoo`03001oogoo005oo`005goo00<007ooOol05Goo00<007ooOol0Tgoo00<007ooOol0
0Goo000GOol2000GOol00`00Oomoo`2AOol20003Ool001Moo`03001oogoo01Ioo`03001oogoo08Ao
o`03001oogoo00]oo`03001oogoo005oo`005goo00<007ooOol05goo0P00QWoo00<007ooOol02Goo
00<007ooOol00Goo000GOol00`00Oomoo`0IOol00`00Oomoo`23Ool00`00Oomoo`09Ool00`00Oomo
o`01Ool001Moo`03001oogoo01Yoo`03001oogoo08ioo`03001oogoo005oo`005goo00<007ooOol0
6Woo00<007ooOol0SWoo00<007ooOol00Goo000GOol2000LOol00`00Oomoo`1oOol00`00Oomoo`0:
Ool20003Ool001Moo`03001oogoo01aoo`8007moo`03001oogoo00]oo`03001oogoo005oo`005goo
00<007ooOol07Woo00<007ooOol0RWoo00<007ooOol00Goo000GOol00`00Oomoo`0OOol00`00Oomo
o`1mOol00`00Oomoo`09Ool00`00Oomoo`01Ool001Moo`03001oogoo01moo`03001oogoo07eoo`03
001oogoo00Uoo`03001oogoo005oo`005goo00<007ooOol087oo00<007ooOol0NGoo00<007ooOol0
37oo00<007ooOol00Goo0009Ool00`00Oomoo`02Ool01000Oomoogoo0`000Woo00<007ooOol08Goo
00<007ooOol0N7oo00<007ooOol037oo00<007ooOol00Goo0008Ool00`00Ool00008Ool01000Oomo
ogoo0P008goo00<007ooOol0QGoo0P000goo0008Ool00`00Ool00009Ool01000Oomoo`009Woo00<0
07ooOol0Q7oo00<007ooOol00Goo0008Ool00`00Ool00009Ool01000Oomoo`009goo00<007ooOol0
Pgoo00<007ooOol00Goo0009Ool00`00Oomoo`06Ool30002Ool00`00Oomoo`2[Ool00`00Oomoo`01
Ool001Moo`03001oogoo02Ioo`03001oogoo07=oo`04001oogoo000;Ool00`00Oomoo`01Ool001Mo
o`03001oogoo02Moo`03001oogoo079oo`04001oogoo000;Ool00`00Oomoo`01Ool001Moo`8002Yo
o`03001oogoo07ioo`8000=oo`005goo00<007ooOol0:Woo00<007ooOol0OWoo00<007ooOol00Goo
000GOol00`00Oomoo`2[Ool00`00Oomoo`01Ool001Moo`03001oogoo02]oo`03001oogoo06ioo`03
001oogoo00aoo`03001oogoo005oo`005goo00<007ooOol0;7oo00<007ooOol0KGoo00<007ooOol0
37oo00<007ooOol00Goo000GOol00`00Oomoo`0^Ool00`00Oomoo`1^Ool00`00Oomoo`09Ool00`00
Oomoo`01Ool001Moo`03001oogoo02moo`03001oogoo07Uoo`03001oogoo005oo`005goo0P00<Goo
00<007ooOol0K7oo00<007ooOol027oo0P000goo000GOol00`00Oomoo`0`Ool00`00Oomoo`1YOol0
0`00Oomoo`0<Ool00`00Oomoo`01Ool001Moo`03001oogoo035oo`03001oogoo06Qoo`03001oogoo
00aoo`03001oogoo005oo`005goo00<007ooOol0<Woo0P00Mgoo00<007ooOol00Goo000GOol00`00
Oomoo`0dOol00`00Oomoo`1dOol00`00Oomoo`01Ool001Moo`03001oogoo03Eoo`03001oogoo07=o
o`03001oogoo005oo`005goo00<007ooOol0=Goo00<007ooOol0J7oo00<007ooOol027oo00<007oo
Ool00Goo000GOol2000gOol00`00Oomoo`1SOol01@00Oomoogoo00002Goo0P000goo000GOol00`00
Oomoo`0gOol00`00Oomoo`1aOol00`00Oomoo`01Ool001Moo`03001oogoo03Qoo`80075oo`03001o
ogoo005oo`005goo00<007ooOol0>Woo00<007ooOol0KWoo00<007ooOol00Goo000GOol00`00Oomo
o`0jOol00`00Oomoo`1^Ool00`00Oomoo`01Ool001Moo`03001oogoo03]oo`03001oogoo05ioo`03
001oogoo00aoo`03001oogoo005oo`005goo0P00?Goo00<007ooOol0Jgoo0P000goo000GOol00`00
Oomoo`0mOol00`00Oomoo`1POol00`00Oomoo`08Ool00`00Oomoo`01Ool001Moo`03001oogoo03mo
o`03001oogoo05ioo`03001oogoo00Qoo`03001oogoo005oo`005goo00<007ooOol0?goo0P00FWoo
00<007ooOol03Goo00<007ooOol00Goo000GOol00`00Oomoo`2KOol00`00Oomoo`0=Ool00`00Oomo
o`01Ool001Moo`03001oogoo045oo`03001oogoo06Moo`03001oogoo005oo`000Woo0`0017oo00<0
07ooOol00Woo00<007ooOol00goo00@007ooOol004Aoo`03001oogoo06Ioo`03001oogoo005oo`00
0goo00<007ooOol00Woo00<007oo00001goo0`000Woo0P00AGoo00<007ooOol0Hgoo0P000goo0003
Ool600000goo001oo`06Ool00`00Ool00002Ool00`00Oomoo`15Ool00`00Oomoo`1COol00`00Oomo
o`0=Ool00`00Oomoo`01Ool000=oo`08001oo`00001oo`00Ool000Qoo`80009oo`03001oogoo09]o
o`03001oogoo009oo`03001oogoo00Qoo`03001oogoo005oo`000Woo1@000Woo00<007ooOol027oo
00@007ooOol004Qoo`03001oogoo05Moo`03001oogoo00Qoo`03001oogoo005oo`000goo00@007oo
Ool0011oo`03001oogoo04Moo`03001oogoo065oo`03001oogoo005oo`000goo00@007ooOol0011o
o`03001oogoo04Uoo`03001oogoo04moo`03001oogoo00eoo`03001oogoo005oo`0017oo0`0047oo
00<007ooOol0BWoo00<007ooOol0CWoo00<007ooOol03Goo00<007ooOol00Goo000GOol2001<Ool0
0`00Oomoo`1LOol20003Ool000=oo`<0015oo`03001oogoo04]oo`03001oogoo05eoo`03001oogoo
005oo`000goo00<007oo00004Goo00<007ooOol0C7oo00<007ooOol0DGoo00<007ooOol027oo00<0
07ooOol00Goo0003Ool00`00Ool0000AOol00`00Oomoo`1=Ool2001<Ool00`00Oomoo`02Ool00`00
Oomoo`08Ool00`00Oomoo`01Ool0009oo`800003Ool007oo011oo`03001oogoo04moo`03001oogoo
05Uoo`03001oogoo005oo`005goo00<007ooOol0D7oo00<007ooOol0F7oo00<007ooOol00Goo0003
Ool3000AOol2001AOol00`00Oomoo`1GOol20003Ool000=oo`<0015oo`03001oogoo055oo`03001o
ogoo04Moo`03001oogoo00eoo`03001oogoo005oo`001Goo00<007ooOol03goo00<007ooOol0DWoo
0P00Egoo00<007ooOol00Goo0003Ool3000AOol00`00Oomoo`1DOol00`00Oomoo`19Ool00`00Oomo
o`08Ool00`00Oomoo`01Ool001Moo`03001oogoo05Eoo`03001oogoo04=oo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo005oo`000goo00<007oo00004Goo00<007ooOol0EGoo00<007ooOol0
@goo00<007ooOol03Goo00<007ooOol00Goo0003Ool00`00Ool0000AOol00`00Oomoo`1FOol00`00
Oomoo`1BOol00`00Oomoo`01Ool000=oo`03001oo`00015oo`8005Qoo`80055oo`8000=oo`000Woo
10004Goo00<007ooOol0FGoo00<007ooOol0?goo00<007ooOol03Goo00<007ooOol00Goo000GOol0
0`00Oomoo`1JOol00`00Oomoo`1>Ool00`00Oomoo`01Ool000=oo`<0015oo`03001oogoo05]oo`03
001oogoo049oo`03001oogoo00Qoo`03001oogoo005oo`000goo00<007ooOol04Goo00<007ooOol0
VWoo00<007ooOol00goo00<007ooOol027oo00<007ooOol00Goo0003Ool00`00Oomoo`0AOol00`00
Oomoo`1LOol00`00Oomoo`0kOol00`00Oomoo`0>Ool00`00Oomoo`01Ool0009oo`@0015oo`8005io
o`03001oogoo04Yoo`8000=oo`000goo0`004Goo00<007ooOol0Ggoo00<007ooOol0>7oo00<007oo
Ool03Woo00<007ooOol00Goo0003Ool00`00Ool0000AOol00`00Oomoo`1POol00`00Oomoo`0gOol0
0`00Oomoo`0>Ool00`00Oomoo`01Ool000=oo`03001oo`00015oo`03001oogoo0:5oo`03001oogoo
00Moo`03001oogoo005oo`000Woo0P0000=oo`00Ool047oo00<007ooOol0HGoo0P00=goo00<007oo
Ool017oo00<007ooOol01goo00<007ooOol00Goo000GOol00`00Oomoo`1ROol00`00Oomoo`0eOol0
0`00Oomoo`0>Ool00`00Oomoo`01Ool0009oo`05001oo`00Ool00002Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool20002Ool00`00Oomoo`1TOol00`00Oomoo`14Ool00`00Oomoo`01Ool0009oo`09001o
o`00Ool007oo001oo`0000Moo`03001oo`00009oo`8006Ioo`03001oogoo039oo`03001oogoo00eo
o`8000=oo`000Woo00T007oo001oo`00Ool007oo00001goo0`000Woo00<007ooOol0Zgoo00<007oo
Ool00Goo0002Ool5000017oo001oo`001goo00<007ooOol00Woo00<007ooOol0IWoo00<007ooOol0
>7oo00<007ooOol01goo00<007ooOol00Goo0009Ool00`00Oomoo`07Ool20002Ool00`00Oomoo`1W
Ool00`00Oomoo`0`Ool00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`01Ool001Moo`03001o
ogoo06Qoo`80045oo`03001oogoo005oo`005goo00<007ooOol0JWoo00<007ooOol0;Goo00<007oo
Ool03Woo00<007ooOol00Goo000GOol00`00Oomoo`1[Ool00`00Oomoo`0mOol00`00Oomoo`01Ool0
01Moo`8006aoo`03001oogoo02aoo`03001oogoo00Aoo`03001oogoo00Ioo`8000=oo`005goo00<0
07ooOol0K7oo00<007ooOol0:goo00<007ooOol017oo00<007ooOol01goo00<007ooOol00Goo000G
Ool00`00Oomoo`1]Ool2000lOol00`00Oomoo`01Ool001Moo`03001oogoo06moo`03001oogoo02Mo
o`03001oogoo00moo`03001oogoo005oo`005goo00<007ooOol0L7oo00<007ooOol0>7oo00<007oo
Ool00Goo000GOol00`00Oomoo`1`Ool00`00Oomoo`0VOol00`00Oomoo`05Ool00`00Oomoo`07Ool0
0`00Oomoo`01Ool001Moo`80079oo`03001oogoo02eoo`03001oogoo00Ioo`8000=oo`005goo00<0
07ooOol0LWoo0P009Goo00<007ooOol03goo00<007ooOol00Goo000GOol00`00Oomoo`1dOol00`00
Oomoo`0dOol00`00Oomoo`01Ool001Moo`03001oogoo07Eoo`03001oogoo025oo`03001oogoo00mo
o`03001oogoo005oo`005goo00<007ooOol0MWoo00<007ooOol087oo00<007ooOol01Goo00<007oo
Ool01goo00<007ooOol00Goo000GOol00`00Oomoo`2IOol00`00Oomoo`0?Ool00`00Oomoo`01Ool0
01Moo`03001oogoo07Moo`03001oogoo01moo`03001oogoo00moo`03001oogoo005oo`005goo0P00
NGoo00<007ooOol0;goo0P000goo000GOol00`00Oomoo`1jOol00`00Oomoo`0LOol00`00Oomoo`05
Ool00`00Oomoo`07Ool00`00Oomoo`01Ool001Moo`03001oogoo07]oo`03001oogoo01]oo`03001o
ogoo00moo`03001oogoo005oo`005goo00<007ooOol0Zgoo00<007ooOol00Goo000GOol00`00Oomo
o`1lOol00`00Oomoo`0IOol00`00Oomoo`0@Ool00`00Oomoo`01Ool001Moo`03001oogoo07eoo`03
001oogoo01Qoo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo005oo`005goo0P00P7oo00<0
07ooOol05Woo00<007ooOol03goo0P000goo000GOol00`00Oomoo`20Ool00`00Oomoo`0EOol00`00
Oomoo`0@Ool00`00Oomoo`01Ool001Moo`03001oogoo09Qoo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo005oo`005goo00<007ooOol0PGoo00<007ooOol057oo00<007ooOol01goo00<007oo
Ool01Woo00<007ooOol00Goo000GOol00`00Oomoo`22Ool00`00Oomoo`0COol00`00Oomoo`0@Ool0
0`00Oomoo`01Ool001Moo`03001oogoo08=oo`03001oogoo019oo`03001oogoo00Moo`03001oogoo
00Ioo`03001oogoo005oo`002Goo00<007ooOol00Woo00@007ooOomoo`<0009oo`03001oogoo08Ao
o`80019oo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo005oo`0027oo00<007oo00001goo
00<007oo00000Woo0P00Qgoo00<007ooOol03goo00<007ooOol03goo0P000goo0008Ool00`00Ool0
0008Ool01@00Oomoogoo0000R7oo00<007ooOol03Woo00<007ooOol027oo00<007ooOol01Woo00<0
07ooOol00Goo0008Ool00`00Ool00007Ool00`00Ool00002Ool00`00Oomoo`27Ool00`00Oomoo`0=
Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`01Ool000Uoo`03001oogoo00Ioo`<0009o
o`03001oogoo08Qoo`8000eoo`03001oogoo015oo`03001oogoo005oo`005goo00<007ooOol0RWoo
00<007ooOol02Woo00<007ooOol027oo00<007ooOol01Woo00<007ooOol00Goo000GOol00`00Oomo
o`2;Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`01Ool001Moo`03
001oogoo08]oo`03001oogoo00Uoo`03001oogoo015oo`03001oogoo005oo`005goo0P00SGoo00<0
07ooOol027oo00<007ooOol027oo00<007ooOol01Goo0P000goo000GOol00`00Oomoo`2=Ool20008
Ool00`00Oomoo`0AOol00`00Oomoo`01Ool001Moo`03001oogoo08moo`03001oogoo00Eoo`03001o
ogoo00Qoo`03001oogoo00Ioo`03001oogoo005oo`005goo00<007ooOol0T7oo00<007ooOol00goo
0P004goo00<007ooOol00Goo000GOol00`00Oomoo`2AOol00`00Oomoo`02Ool00`00Oomoo`09Ool2
0007Ool00`00Oomoo`01Ool001Moo`03001oogoo09Ioo`03001oogoo019oo`03001oogoo005oo`00
5goo0P00Tgoo00D007ooOomoo`0000aoo`03001oogoo00Aoo`8000=oo`005goo00<007ooOol0Tgoo
00@007ooOol001Aoo`03001oogoo005oo`005goo00<007ooOol0UGoo0P0037oo00<007ooOol01Goo
00<007ooOol00Goo000GOol00`00Oomoo`2FOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00Oomo
o`01Ool001Moo`03001oogoo09Ioo`03001oogoo019oo`03001oogoo005oo`005goo00<007ooOol0
UWoo0P002goo00<007ooOol01Goo00<007ooOol00Goo000GOol00`00Oomoo`2FOol00`00Ool0000:
Ool00`00Oomoo`05Ool00`00Oomoo`01Ool001Moo`8009Moo`05001oogooOol00008Ool00`00Oomo
o`04Ool20003Ool001Moo`03001oogoo09Ioo`8000=oo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo005oo`005goo00<007ooOol0Ugoo00<007ooOol02Woo00<007ooOol017oo00<007ooOol0
0Goo000GOol00`00Oomoo`2GOol00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`01Ool001Moo`03001oogoo09Moo`8000Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo005oo`005goo00<007ooOol0V7oo0P0017oo0P0017oo00<007ooOol017oo00<007ooOol00Goo
000GOol00`00Oomoo`2IOol20005Ool01@00Oomoogoo00001Woo00<007ooOol00Goo000GOol2002K
Ool20005Ool01000Oomoo`001Goo0P000goo000GOol00`00Oomoo`2LOol20003Ool01@00Oomoogoo
00001Goo00<007ooOol00Goo000GOol00`00Oomoo`2MOol30002Ool01000Oomoo`001Goo00<007oo
Ool00Goo000GOol00`00Oomoo`2OOol3000017oo000000001Goo00<007ooOol00Goo000GOol00`00
Oomoo`2QOol300000goo001oo`04Ool00`00Oomoo`01Ool0015oo`<000=oo`03001oogoo0:=oo`@0
00Aoo`03001oogoo005oo`004Woo00<007ooOol00Woo0P00YWoo0`000Woo0P000goo000BOol00`00
Oomoo`02Ool00`00Oomoo`2[Ool00`00Oomoo`01Ool0019oo`03001oogoo009oo`03001oogoo0:]o
o`03001oogoo005oo`004Goo0P0017oo00D007ooOomoo`00021oo`03001oogoo01moo`03001oogoo
01ioo`03001oogoo01ioo`03001oogoo01ioo`05001oogooOol00003Ool001Moojl000=oo`00\
\>"],
  ImageRangeCache->{{{0, 200}, {200, 0}} -> {-0.168489, -0.183211, 
  0.00604633, 0.00604633}}]
}, Open  ]],

Cell["PhaseDiagram[0.75, 0.25]", "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Code for interference analysis in here ...", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Converting between p and phi", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ProbabilityToAngle[p_]:= ArcCos[Sqrt[p]]
AngleToProbability[phi_]:= Cos[phi]^2\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pclassical", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Pclassical[phi_, p0A_, p0B_]:=
\tExpand[Cos[phi]^2 p0A + Sin[phi]^2 p0B, Trig->True]
\t
Pclassical::usage =
\t\"Pclassical[phi, p0A, p0B] gives the probability of a classical \\
\tcomputer picking a 0 using either Method A or Method B.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pquantum", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Pquantum[phi_, p0A_, p0B_]:=
\tModule[{a0,b0,a1,b1,norm},
\t\ta0 = Sqrt[p0A];  a1 = Sqrt[1-p0A];
\t\tb0 = -Sqrt[p0B]; b1 = Sqrt[1-p0B];
\t\tnorm = Sqrt[Abs[(Cos[phi] a0 + Sin[phi] b0)]^2 +
\t\t            Abs[(Cos[phi] a1 + Sin[phi] b1)]^2];
\t\t(Abs[(Cos[phi] a0 + Sin[phi] b0)/norm]^2) // SimplifyAbs // Chop
\t]

Pquantum::usage =
\t\"Pquantum[phi, p0A, p0B] gives the probability of a quantum \\
\tcomputer picking a 0 using both Method A or Method B in quantum \\
\tparallel. Note that both computational pathways are pursued. The \\
\tfinal answer is arrived as as the outcome from the interference \\
\tbetween these computational pathways.\";
\t
(* A valid simplification for Abs[x]^2 iff x is real,
   In our case, x is guaranteed to be real.
*)
SimplifyAbs[expr_]:=
\tExpandAll[expr //. Abs[x_]^2 :> x^2, Trig->True]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparison of Pclassical and Pquantum versus phi", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ComparisonPlot[p0A_, p0B_]:=
\tPlot[{Pquantum[phi, p0A, p0B],
\t      Pclassical[phi, p0A, p0B]}, {phi, 0, N[2 Pi]},
\t     PlotStyle->{{Thickness[0.02], GrayLevel[0.8]}, 
\t                 {Thickness[0.02]}},
\t     Frame->True,
\t     FrameLabel->{\"phi\", \"Pquantum (light)\", \"\", \"Pclassical \
(dark)\"},
\t     GridLines->Automatic,
\t     PlotRange->All
\t]/;Which[Not[NumberQ[N[p0A]] && NumberQ[N[p0B]]],
\t         \t(Message[ComparisonPlot::nonnumeric]; Abort[]),
\t         (N[p0A]<0 || N[p0A]>1) || (N[p0B]<0 || N[p0B]>1),
             \t(Message[ComparisonPlot::nonprobability]; Abort[]),
             True, 
            \tTrue
            ]
\t
ComparisonPlot::usage =
\t\"ComparisonPlot[p0A, p0B] creates a plot that allows you to compare \\
\tPclassical (dark) and Pquantum (light) as the angle phi changes \\
\tfrom 0 to 2 Pi.\";
\t
ComparisonPlot::nonprobability =
\t\"Sorry p0A and p0B must both be real numbers in the range \\
\t0 <= p0A, p0B <= 1 as they are supposed to be probabilities.\";
\t
ComparisonPlot::nonnumeric =
\t\"Sorry p0A and p0B must both be real numbers in the range \\
\t0 <= p0A, p0B <= 1. Your inputs are not both numbers.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Region where Quantum Probability exceeds Classical Probability\
\>",
   "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
PhaseDiagram[p0A_, p0B_]:=
\tModule[{data, plot1, plot2},
\t\tdata = Table[{Pclassical[N[phi], N[p0A], N[p0B]],
                      Pquantum[N[phi], N[p0A], N[p0B]]}, {phi, 0, 2 Pi, \
0.01}];
        plot1 = ListPlot[data, 
                         Frame->True,
                         FrameLabel->{\"Pclassical\", \"Pquantum\"},
                         Axes->False,
                         AspectRatio->Automatic,
                         PlotRange->{All,All},
                         DisplayFunction->Identity];
        plot2 = Plot[x,{x,0,1},
                     PlotStyle->Dashing[{0.01, 0.01}],
                     DisplayFunction->Identity];
        Show[plot1, plot2, DisplayFunction:>$DisplayFunction]
    ]/;Which[Not[NumberQ[N[p0A]] && NumberQ[N[p0B]]],
\t         \t(Message[PhaseDiagram::nonnumeric]; Abort[]),
\t         (N[p0A]<0 || N[p0A]>1) || (N[p0B]<0 || N[p0B]>1),
             \t(Message[PhaseDiagram::nonprobability]; Abort[]),
             True, 
            \tTrue
            ]
    
PhaseDiagram::usage =
\t\"PhaseDiagram[p0A, p0B] displays corresponding pairs of values \\
\tfor Pclassical and Pquantum. The line at 45 degrees indicates where \\
\tboth probabilities are equal. In the region above this line \\
\tPquantum > Pclassical and in the region below the 45 degree line \\
\tPquantum < Pclassical.\";

PhaseDiagram::nonprobability =
\t\"Sorry p0A and p0B must both be real numbers in the range \\
\t0 <= p0A, p0B <= 1 as they are supposed to be probabilities.\";

PhaseDiagram::nonnumeric =
\t\"Sorry p0A and p0B must both be real numbers in the range \\
\t0 <= p0A, p0B <= 1. Your inputs are not both numbers.\";\t\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{44, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 157, 6, 174, "Title",
  Evaluatable->False],
Cell[1891, 59, 108, 3, 53, "Subsubtitle",
  Evaluatable->False],
Cell[2002, 64, 100, 3, 25, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2127, 71, 102, 3, 50, "Section",
  Evaluatable->False],
Cell[2232, 76, 905, 19, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3174, 100, 110, 3, 50, "Section",
  Evaluatable->False],
Cell[3287, 105, 1015, 20, 238, "Text",
  Evaluatable->False],
Cell[4305, 127, 344, 8, 116, "Input"],
Cell[4652, 137, 168, 6, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[4857, 148, 89, 2, 50, "Section",
  Evaluatable->False],
Cell[4949, 152, 1015, 18, 190, "Text",
  Evaluatable->False],
Cell[5967, 172, 211, 7, 25, "Input"],
Cell[6181, 181, 402, 9, 94, "Text",
  Evaluatable->False],
Cell[6586, 192, 233, 7, 25, "Input"],
Cell[6822, 201, 1113, 19, 222, "Text",
  Evaluatable->False],
Cell[7938, 222, 234, 7, 25, "Input"],

Cell[CellGroupData[{
Cell[8197, 233, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[8280, 237, 113, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8418, 243, 170, 6, 64, "Input"],
Cell[8591, 251, 24428, 801, 159, 8539, 599, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33068, 1058, 73, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[33144, 1062, 191, 5, 46, "Text",
  Evaluatable->False],
Cell[33338, 1069, 273, 10, 38, "Input"],
Cell[33614, 1081, 274, 10, 38, "Input"],
Cell[33891, 1093, 1592, 25, 318, "Text",
  Evaluatable->False],
Cell[35486, 1120, 226, 7, 25, "Input"],
Cell[35715, 1129, 318, 7, 62, "Text",
  Evaluatable->False],
Cell[36036, 1138, 233, 7, 25, "Input"],
Cell[36272, 1147, 87, 2, 30, "Text",
  Evaluatable->False],
Cell[36362, 1151, 297, 10, 38, "Input"],
Cell[36662, 1163, 328, 7, 62, "Text",
  Evaluatable->False],
Cell[36993, 1172, 170, 6, 67, "Input"],
Cell[37166, 1180, 69, 2, 30, "Text",
  Evaluatable->False],
Cell[37238, 1184, 375, 15, 103, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37662, 1205, 151, 5, 68, "Section",
  Evaluatable->False],
Cell[37816, 1212, 650, 13, 142, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[38491, 1229, 103, 2, 46, "Subsection",
  Evaluatable->False],
Cell[38597, 1233, 210, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[38832, 1243, 54, 1, 25, "Input"],
Cell[38889, 1246, 156, 2, 52, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39082, 1253, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[39187, 1259, 80, 1, 25, "Input"],
Cell[39270, 1262, 61, 1, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39392, 1270, 99, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[39516, 1276, 52, 1, 25, "Input"],
Cell[39571, 1279, 337, 5, 97, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39945, 1289, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[40028, 1293, 315, 7, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[40368, 1304, 78, 1, 25, "Input"],
Cell[40449, 1307, 80, 1, 40, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40578, 1314, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[40661, 1318, 216, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[40902, 1328, 58, 1, 25, "Input"],
Cell[40963, 1331, 187, 3, 52, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41187, 1339, 68, 1, 25, "Input"],
Cell[41258, 1342, 39047, 1232, 159, 14836, 927, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80354, 2580, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[80437, 2584, 136, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[80598, 2593, 56, 1, 25, "Input"],
Cell[80657, 2596, 325, 5, 97, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81019, 2606, 66, 1, 25, "Input"],
Cell[81088, 2609, 34602, 1309, 204, 18982, 1110, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115739, 3924, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[115822, 3928, 357, 7, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[116204, 3939, 63, 1, 25, "Input"],
Cell[116270, 3942, 32692, 1562, 204, 18077, 1376, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[148999, 5509, 65, 1, 25, "Input"],
Cell[149067, 5512, 34567, 1438, 159, 11567, 1149, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183683, 6956, 98, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[183784, 6960, 224, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[184033, 6970, 79, 1, 25, "Input"],
Cell[184115, 6973, 144, 2, 58, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[184296, 6980, 81, 1, 25, "Input"],
Cell[184380, 6983, 66, 1, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[184483, 6989, 67, 1, 25, "Input"],
Cell[184553, 6992, 33771, 1575, 206, 18080, 1376, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[218361, 8572, 69, 1, 25, "Input"],
Cell[218433, 8575, 34398, 1429, 159, 11406, 1140, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[252880, 10010, 98, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[252981, 10014, 211, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[253217, 10024, 68, 1, 25, "Input"],
Cell[253288, 10027, 34964, 1532, 159, 13300, 1259, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[288301, 11565, 99, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[288403, 11569, 137, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[288565, 11578, 68, 1, 25, "Input"],
Cell[288636, 11581, 35210, 1437, 159, 11382, 1138, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[323895, 13024, 99, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[323997, 13028, 173, 5, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[324195, 13037, 65, 1, 25, "Input"],
Cell[324263, 13040, 33593, 1436, 159, 11743, 1161, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[357905, 14482, 99, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[358029, 14488, 63, 1, 25, "Input"],
Cell[358095, 14491, 31981, 1552, 209, 18100, 1376, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[390091, 16046, 67, 1, 25, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[390219, 16054, 109, 2, 50, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[390353, 16060, 101, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[390457, 16064, 157, 5, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[390651, 16074, 83, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[390737, 16078, 317, 9, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[391091, 16092, 81, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[391175, 16096, 905, 24, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[392117, 16125, 121, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[392241, 16129, 1249, 33, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[393527, 16167, 146, 5, 70, "Subsubsection",
  Evaluatable->False],
Cell[393676, 16174, 1735, 41, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

